/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.appclear;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class DBLoader {
    private Vector sqlStatements = new Vector();

    public void load(String[] args) {
        if (args == null || args.length != 2) {
            this.exitWithError("Usage: java com.sap.engine.tools.appclear.DBLoader <properties-file> <sql-file>\n    <properties-file>    -    contains rdbms.driver, rdbms.url,\n                              rdbms.user and rdbms.password\n    <sql-file>           -    contains sql queries to execute");
        }
        String jdbcPropsFileName = args[0];
        String sqlFileName = args[1];
        String[] props = this.loadJDBCProperties(jdbcPropsFileName);
        Class<?> drv = null;
        Connection con = null;
        Statement stmt = null;
        RandomAccessFile sqlFile = null;
        try {
            drv = Class.forName(props[0]);
            con = DriverManager.getConnection(props[1], props[2], props[3]);
        }
        catch (ClassNotFoundException cnfex) {
            this.exitWithError("Could not load JDBC driver: " + props[0], cnfex);
        }
        catch (SQLException sqlex) {
            this.exitWithError("Could not create connection to the database!", sqlex);
        }
        try {
            stmt = con.createStatement();
        }
        catch (SQLException sqlex) {
            this.exitWithError("Could not create a statement!", sqlex);
        }
        try {
            sqlFile = new RandomAccessFile(sqlFileName, "r");
        }
        catch (FileNotFoundException fnfex) {
            this.exitWithError("Could not find sql statements file: " + sqlFileName, fnfex);
        }
        String line = null;
        StringBuffer query = new StringBuffer();
        try {
            while ((line = sqlFile.readLine()) != null) {
                if ((line = line.trim()).startsWith("//")) {
                    this.addQuery(query);
                    continue;
                }
                if (this.isCommentLine(line) || line.equals("")) continue;
                if (line.indexOf(";") != -1) {
                    query.append(line.substring(0, line.indexOf(";")));
                    this.addQuery(query);
                    continue;
                }
                query.append(line);
            }
            this.addQuery(query);
        }
        catch (IOException ioex) {
            this.exitWithError("Exception while reading sql statements file: " + sqlFileName, ioex);
        }
        String sqlQuery = null;
        int i = 0;
        while (i < this.sqlStatements.size()) {
            try {
                sqlQuery = (String)this.sqlStatements.elementAt(i);
                stmt.execute(sqlQuery);
            }
            catch (SQLException sqlex) {
                if (!sqlQuery.toLowerCase().startsWith("drop")) {
                    this.exitWithError("Could not execute query: " + sqlQuery + "      " + i, sqlex);
                }
                this.log("Could not execute drop statement: " + sqlex);
            }
            ++i;
        }
        try {
            stmt.close();
            con.close();
        }
        catch (SQLException sqlex) {
            this.exitWithError("Could not close JDBC connection!", sqlex);
        }
    }

    public void addQuery(StringBuffer query) {
        String sqlString = query.toString().trim();
        if (sqlString.toLowerCase().startsWith("create")) {
            int onIndex;
            String sPostfix = sqlString.substring("create".length(), sqlString.indexOf("(")).trim();
            if (sPostfix.toLowerCase().startsWith("unique")) {
                sPostfix = sPostfix.substring("unique".length()).trim();
            }
            if ((onIndex = sPostfix.indexOf(" on ")) != -1) {
                sPostfix = sPostfix.substring(0, onIndex).trim();
            }
            String dropString = "drop " + sPostfix;
            this.sqlStatements.insertElementAt(dropString, 0);
        }
        this.sqlStatements.addElement(sqlString);
        query.setLength(0);
    }

    public boolean isCommentLine(String line) {
        return line.startsWith("--") || line.startsWith("//");
    }

    private String[] loadJDBCProperties(String file) {
        String[] array = new String[4];
        try {
            FileInputStream in = new FileInputStream(file);
            Properties props = new Properties();
            props.load(in);
            ((InputStream)in).close();
            array[0] = "com.sap.sql.jdbc.direct.DirectDriver";
            array[1] = props.getProperty("rdbms.url").trim();
            array[2] = props.getProperty("rdbms.user").trim();
            array[3] = props.getProperty("rdbms.password").trim();
        }
        catch (IOException ioex) {
            this.exitWithError("Could not load JDBC properties file!", ioex);
        }
        return array;
    }

    public void executeQuery(String query, Statement stmt) {
        if (query.toLowerCase().startsWith("drop")) {
            try {
                stmt.execute(query);
            }
            catch (SQLException sqlex) {}
        } else {
            try {
                stmt.execute(query);
            }
            catch (SQLException sqlex) {
                this.exitWithError("Could not execute the query: " + query, sqlex);
            }
        }
    }

    private void exitWithError(String message) {
        this.exitWithError(message, null);
    }

    private void exitWithError(String message, Throwable thr) {
        this.log(message);
        if (thr != null) {
            thr.printStackTrace();
        }
        System.exit(1);
    }

    private void log(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        DBLoader loader = new DBLoader();
        loader.load(args);
    }
}

