/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.analyseIt.support;

import com.sap.engine.tools.analyseIt.support.RemoteTool;
import com.sap.engine.tools.analyseIt.support.VisualConfigFrame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;

public class SupportTool
extends Socket {
    private static byte[] crlf_bytes = new byte[]{13, 10};
    private static String crlf = new String(crlf_bytes);
    private static String host;
    private static int port;
    private static String engType;
    private OutputStream telnetOut = this.getOutputStream();
    private InputStream telnetIn = this.getInputStream();
    private static String user;
    private static String password;
    private static String leechHost;
    private static String leechDir;
    private static int leechPort;
    private static boolean leech;
    private static boolean alone;
    private static boolean cluster;
    private static boolean complete;
    private int size = 8192;
    static SupportTool st;
    int[] ids = null;
    static String rootDir;

    public SupportTool() throws Exception {
        super(host, port);
    }

    public void write(String s) {
        try {
            this.telnetOut.write(s.getBytes());
            this.telnetOut.write(crlf_bytes);
            this.telnetOut.flush();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean doLogin() {
        String temp = "";
        try {
            boolean end = false;
            boolean counter = false;
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            this.write(user);
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            this.write(password);
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public char[] run(String cmd) throws Exception {
        char[] buf = new char[this.size];
        int i = 0;
        try {
            System.out.print(cmd + ", ");
            this.telnetOut.write(cmd.getBytes());
            this.telnetOut.write(crlf_bytes);
            this.telnetOut.flush();
            Thread.sleep(1000L);
            boolean end = false;
            char s__ = '.';
            char s_ = '.';
            char s = '.';
            char cr = crlf.charAt(0);
            char lf = crlf.charAt(1);
            while (!end) {
                s__ = s_;
                s_ = s;
                s = (char)this.telnetIn.read();
                if (s == '>' && (s_ == cr && s__ == lf || s__ == cr && s_ == lf)) {
                    end = true;
                }
                Thread.sleep(1L);
                buf[i] = s;
                ++i;
            }
        }
        catch (IOException io_ex2) {
            io_ex2.printStackTrace();
        }
        char[] result = new char[i];
        System.arraycopy(buf, 0, result, 0, result.length);
        return result;
    }

    public void writeResult(String outDir, String outFile, char[] data) {
        try {
            new File(outDir).mkdirs();
            FileWriter fout = new FileWriter(outDir + outFile + ".txt");
            fout.write(data);
            fout.flush();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void start() throws Exception {
        RemoteTool online = null;
        try {
            String outDir = "support" + File.separatorChar + "online_analyse" + File.separatorChar;
            new File(outDir).mkdirs();
            online = new RemoteTool(host, port, user, password);
            SupportTool.dump("Connection accepted. Starting online process...");
            if (alone) {
                System.out.println("Executing online commands on alone: ");
                String aloneOutDir = outDir + "alone" + File.separatorChar;
                int i = 0;
                while (i < online.getGrCount()) {
                    try {
                        online.runGroup(i, aloneOutDir);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (cluster) {
                System.out.println("Executing online commands on dispatcher: ");
                String dispOutDir = outDir + "dispatcher" + File.separatorChar;
                online.runGroup(0, dispOutDir);
                online.runGroup(10, dispOutDir);
                this.ids = online.getClusterIds();
                int lastElement = -1;
                int i = 1;
                while (i < this.ids.length) {
                    System.out.println("\nJUMP TO ELEMENT : " + this.ids[i]);
                    lastElement = this.ids[i];
                    System.out.println("Executing online commands: ");
                    online.write("JUMP " + this.ids[i]);
                    String clElOutDir = outDir + "element_" + this.ids[i] + File.separatorChar;
                    int j = 0;
                    while (j < online.getGrCount()) {
                        online.runGroup(j, clElOutDir);
                        ++j;
                    }
                    System.out.println("\nElement " + this.ids[i] + " done.");
                    ++i;
                }
                if (RemoteTool.logClusterId != lastElement) {
                    online.write("JUMP " + RemoteTool.logClusterId);
                }
                online.getLogs("log -cluster all -last 100", outDir);
                System.out.println("Online cluster analysing complete.");
            }
        }
        catch (Exception e) {
            SupportTool.dump("Connection failed.");
        }
        SupportTool.dump("  Online process finished.");
        int i = 0;
        while (i < this.ids.length) {
            online.write("JUMP " + this.ids[i]);
            if (leech) {
                System.out.println("Expecting to leech data file from element " + this.ids[i] + " ...");
                String leechDir = "support" + File.separatorChar + rootDir + File.separatorChar;
                new File(leechDir).mkdirs();
                Thread leecher = new Thread(new LeechThread(leechDir + "analysed_" + this.ids[i]));
                leecher.start();
                online.write("ANALYSE -engtype " + engType + " -leech " + leechHost + " " + leechPort);
                Thread thread = leecher;
                synchronized (thread) {
                    leecher.wait();
                }
            } else {
                online.write("ANALYSE -engtype " + engType);
            }
            if (!complete) {
                System.out.println("Sorry, there is no response from the SAP Engine...");
                System.out.println("Analysing fails...");
            }
            ++i;
        }
    }

    private static void error(String msg) {
        System.out.println("FATAL ERROR : " + msg);
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            VisualConfigFrame ml = new VisualConfigFrame();
            ml.run();
            host = ml.getHost();
            port = ml.getPort();
            user = ml.getUser();
            password = ml.getPassword();
            engType = ml.getEngType();
            if (engType.equals("all")) {
                alone = true;
                cluster = true;
            } else if (engType.equals("alone")) {
                alone = true;
                cluster = false;
            } else {
                alone = false;
                cluster = true;
            }
            leechHost = ml.getLeechHost();
            leechPort = ml.getLeechPort();
            leech = ml.leech();
            rootDir = ml.getRootDir();
            st = new SupportTool();
            st.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void dump(String s) {
        System.out.println(s);
    }

    static {
        complete = false;
        st = null;
    }

    public static class LeechThread
    implements Runnable {
        ServerSocket ss;
        Socket s;
        String fName;

        public LeechThread(String fName) {
            this.fName = fName;
            try {
                this.ss = new ServerSocket(leechPort);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private byte[] readFromStream(InputStream is, int cnt) throws Exception {
            byte[] temp = new byte[cnt];
            int read = 0;
            while (read < cnt) {
                int r = is.read();
                if (r > -1) {
                    temp[read] = (byte)r;
                    ++read;
                    continue;
                }
                if ((byte)read != -1) continue;
                throw new Exception("STREAM CLOSED !!!");
            }
            return temp;
        }

        public void run() {
            boolean end = false;
            InputStream is = null;
            try {
                while (!end) {
                    this.s = this.ss.accept();
                    is = this.s.getInputStream();
                    byte[] handshake = this.readFromStream(is, 3);
                    String nwn = new String(handshake);
                    if (!nwn.equals("NWN")) continue;
                    System.out.println("Leeching started !");
                    end = true;
                }
                byte[] b = this.readFromStream(is, 8);
                int INTFLAG = 255;
                int ri = b[0] & INTFLAG | (b[1] & INTFLAG) << 8 | (b[2] & INTFLAG) << 16 | b[3] << 24;
                int li = b[4] & INTFLAG | (b[5] & INTFLAG) << 8 | (b[6] & INTFLAG) << 16 | b[7] << 24;
                long length = (long)li << 32 | (long)ri & 0xFFFFFFFFL;
                this.fName = this.fName + "_" + this.s.getInetAddress().getHostName() + ".zip";
                RandomAccessFile raf = new RandomAccessFile(new File(this.fName), "rw");
                long read = 0L;
                byte[] buf = new byte[1024];
                while (read < length) {
                    int r = is.read(buf);
                    if (r > 0) {
                        raf.write(buf, 0, r);
                        System.out.print(".");
                        read += (long)r;
                        continue;
                    }
                    if ((byte)r != -1) continue;
                    throw new Exception("STREAM CLOSED !!!!");
                }
                System.out.println();
                raf.close();
                is.close();
                this.s.close();
                this.ss.close();
                SupportTool.dump("Leeching complete. File downloaded and saved.");
                complete = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LeechThread leechThread = this;
            synchronized (leechThread) {
                this.notifyAll();
            }
        }
    }
}

