/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.analyseIt.support;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RemoteTool
extends Socket {
    private static byte[] crlf_bytes = new byte[]{13, 10};
    private static String crlf = new String(crlf_bytes);
    private int rPort;
    private OutputStream telnetOut;
    private InputStream telnetIn;
    private String user;
    private String pass;
    private boolean isLogged = false;
    private String propFileName;
    private int noEcho = 254;
    private int size = 131072;
    public String[] admin = new String[]{"ADMIN", "INFO", "LL", "LSC", "LSM", "LSP", "LSS", "LST", "MSC", "VERSION -MORE"};
    public String[] http = new String[]{"HTTP", "ALIAS", "HOST"};
    public String[] dbms = new String[]{"DBMS", "GET_REPLICATION_INFO", "GET_STATISTICS"};
    public String[] servlet_jsp = new String[]{"SERVLET_JSP", "HTTPSESSIONS"};
    public String[] users = new String[]{"USERS", "USERS"};
    public String[] login = new String[]{"LOGIN", "EXPIRATION", "LOGGEDUSERS", "SESSIONS", "USERLIMIT"};
    public String[] deploy = new String[]{"DEPLOY", "LISTAPP"};
    public String[] dbpool = new String[]{"DBPOOL", "GET_DRIVERS", "GET_DS"};
    public String[] jms = new String[]{"JMS", "SHOW"};
    public String[] naming = new String[]{"NAMING", "ATTR", "LSN", "LSR", "MENV"};
    public String[] system = new String[]{"SYSTEM", "PS"};
    public String[] appclient = new String[]{"APPCLIENT", "LISTCLIENTS"};
    public Object[] groups = new Object[]{this.admin, this.http, this.dbms, this.servlet_jsp, this.users, this.login, this.deploy, this.dbpool, this.jms, this.naming, this.system, this.appclient};
    public static int logClusterId = -1;

    public RemoteTool(String host, int port0, String user0, String pass0) throws Exception {
        super(host, port0);
        this.rPort = port0;
        this.user = user0;
        this.pass = pass0;
        this.telnetOut = this.getOutputStream();
        this.telnetIn = this.getInputStream();
    }

    public int getGrCount() {
        return this.groups.length;
    }

    public void write(String s) {
        try {
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            this.telnetOut.write(s.getBytes());
            this.telnetOut.write(crlf_bytes);
            this.telnetOut.flush();
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean doLogin() {
        String temp = "";
        try {
            boolean end = false;
            boolean counter = false;
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            this.write(this.user);
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            this.write(this.pass);
            while (this.telnetIn.available() != 0) {
                this.telnetIn.read();
            }
            System.out.println("Logged to the system. Leeching info...");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public char[] run(String cmd) throws Exception {
        int i;
        char[] buf;
        block6: {
            buf = new char[this.size];
            i = 0;
            try {
                if (!this.isLogged) {
                    this.isLogged = this.doLogin();
                }
                if (this.isLogged) {
                    System.out.print(cmd + ", ");
                    this.telnetOut.write(cmd.getBytes());
                    this.telnetOut.write(crlf_bytes);
                    this.telnetOut.flush();
                    Thread.sleep(1000L);
                    boolean end = false;
                    char s__ = '.';
                    char s_ = '.';
                    char s = '.';
                    char cr = crlf.charAt(0);
                    char lf = crlf.charAt(1);
                    while (!end) {
                        s__ = s_;
                        s_ = s;
                        s = (char)this.telnetIn.read();
                        if (s == '>' && (s_ == cr && s__ == lf || s__ == cr && s_ == lf)) {
                            end = true;
                        }
                        Thread.sleep(1L);
                        buf[i] = s;
                        ++i;
                    }
                    break block6;
                }
                throw new Exception("LOGIN FAILED !");
            }
            catch (IOException io_ex2) {
                io_ex2.printStackTrace();
            }
        }
        char[] result = new char[i];
        System.arraycopy(buf, 0, result, 0, result.length);
        return result;
    }

    public void writeResult(String outDir, String outFile, char[] data) {
        try {
            new File(outDir).mkdirs();
            FileWriter fout = new FileWriter(outDir + outFile + ".txt");
            fout.write(data);
            fout.flush();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runGroup(int nmb, String outDir) throws Exception {
        String[] group = (String[])this.groups[nmb];
        String fname = outDir + group[0] + File.separatorChar;
        char[] buf = new char[this.size];
        System.out.println();
        this.run("ADD " + group[0]);
        int i = 1;
        while (i < group.length) {
            buf = this.run(group[i]);
            if (buf != null) {
                this.writeResult(fname, group[i], buf);
            }
            ++i;
        }
    }

    public void getLogs(String cmdLine, String outDir) throws Exception {
        String fname = outDir + "last_logs" + File.separatorChar;
        char[] buf = new char[this.size];
        buf = this.run(cmdLine);
        if (buf != null) {
            this.writeResult(fname, "logs", buf);
        }
    }

    public int[] getClusterIds() throws Exception {
        String data = new String(this.run("LSC"));
        int[] temp = new int[256];
        int cnt = 0;
        int i = 0;
        while (i < 2) {
            data = data.substring(data.indexOf("\n") + 2, data.length());
            ++i;
        }
        while (data.length() > 10) {
            String line = data.substring(0, data.indexOf("\n"));
            if (line.indexOf("server") != -1 || line.indexOf("dispatcher") != -1) {
                temp[cnt] = Integer.parseInt(line.substring(0, 4));
                if (logClusterId == -1 && line.indexOf("server") != -1) {
                    logClusterId = temp[cnt];
                }
                ++cnt;
            }
            data = data.substring(data.indexOf("\n") + 2, data.length());
        }
        int[] result = new int[cnt];
        System.arraycopy(temp, 0, result, 0, cnt);
        return result;
    }
}

