/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.analyseIt;

import com.sap.engine.tools.analyseIt.InfoObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

public class OfflineAnalyser {
    private static Hashtable stored = new Hashtable();
    private static String tempDirName;
    private static boolean leech;
    static Vector vec;
    static String[] dispManagers;
    static String[] dispServices;
    static String[] servManagers;
    static String[] servServices;
    static String[] aloneManagers;
    static String[] aloneServices;
    private static boolean newLine;
    static boolean cluster;
    static boolean alone;
    static long time;
    static char sep;
    static String copy;
    static String dirCmd;
    static String cmdCmd;
    static String offlineDirName;

    private static void makeJarFromDir(String jarName, String[] dirNames) throws IOException {
        File jarFile = null;
        jarFile = jarName.lastIndexOf(File.separatorChar) > 0 ? new File(jarName.substring(0, jarName.lastIndexOf(File.separatorChar))) : new File(jarName);
        jarName = jarName + ".zip";
        int i = 0;
        while (i < dirNames.length) {
            OfflineAnalyser.listDir(dirNames[i], vec);
            ++i;
        }
        stored.put(jarName, vec);
    }

    private static void listDir(String dirName, Vector allFiles) {
        if (dirName == null || dirName == "") {
            return;
        }
        File directory = new File(dirName);
        if (!directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            InfoObject info = null;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Object str = null;
                    Object str1 = null;
                    OfflineAnalyser.recursivePack(files[i].getAbsolutePath(), "", allFiles);
                } else {
                    long time = files[i].lastModified();
                    info = new InfoObject(OfflineAnalyser.getEntryName(files[i], ""), files[i].getAbsolutePath());
                    allFiles.addElement(info);
                }
                ++i;
            }
        }
    }

    private static String getEntryName(File file, String packName) {
        String tempName = file.getName();
        tempName = (packName.trim().equals("") ? "" : packName + "\\") + tempName;
        return tempName;
    }

    private static void recursivePack(String dirName, String packageName, Vector files) {
        InfoObject info = null;
        File f = new File(dirName);
        if (f.isDirectory()) {
            File[] dirFiles = f.listFiles();
            if (dirFiles != null) {
                int i = 0;
                while (i < dirFiles.length) {
                    if (dirFiles[i].isDirectory()) {
                        OfflineAnalyser.recursivePack(dirFiles[i].getAbsolutePath(), (packageName.equals("") ? "" : packageName + "\\") + f.getName(), files);
                    } else {
                        info = new InfoObject(OfflineAnalyser.getEntryName(dirFiles[i], (packageName.equals("") ? "" : packageName + "\\") + f.getName()), dirFiles[i].getAbsolutePath());
                        files.addElement(info);
                    }
                    ++i;
                }
            }
        } else {
            info = new InfoObject(packageName.equals("") ? f.getName() : packageName + "\\" + f.getName(), f.getAbsolutePath());
            files.addElement(info);
        }
    }

    public static void archivate() throws Exception {
        Enumeration names = stored.keys();
        String jarName = "";
        Vector tempVec = null;
        while (names.hasMoreElements()) {
            jarName = (String)names.nextElement();
            tempVec = (Vector)stored.get(jarName);
            if (tempVec.size() <= 0) continue;
            OfflineAnalyser.writeZipFile(jarName, tempVec);
            stored.remove(jarName);
            tempVec.clear();
            System.gc();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeZipFile(String jarName, Vector infos) throws IOException {
        block14: {
            block13: {
                fos = null;
                bos = null;
                zip = null;
                try {
                    try {
                        fos = new FileOutputStream(jarName);
                        bos = new BufferedOutputStream(fos);
                        zip = new JarOutputStream(bos);
                        zip.setMethod(8);
                        zip.setLevel(9);
                        if (infos.size() == 0) {
                            var8_5 = null;
                            break block13;
                        }
                        fileObjects = infos.elements();
                        infoObj = null;
                        while (true) {
                            if (!fileObjects.hasMoreElements()) {
                                zip.flush();
                                zip.finish();
                                zip.close();
                                bos.close();
                                fos.close();
                                break block14;
                            }
                            infoObj = (InfoObject)fileObjects.nextElement();
                            if (infoObj == null) continue;
                            OfflineAnalyser.copyJFile((JarOutputStream)zip, infoObj.getEntryName(), infoObj.getFilePath());
                        }
                    }
                    catch (ZipException ze) {
                        ze.printStackTrace();
                        var8_7 = null;
                        try {
                            zip.flush();
                            zip.finish();
                            zip.close();
                            bos.close();
                            fos.close();
                            return;
                        }
                        catch (Exception exx) {
                            return;
                        }
                    }
                }
                catch (Throwable var7_16) {
                    var8_8 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 166->192)] { 
lbl46:
                    // 1 sources

                    zip.flush();
                    zip.finish();
                    zip.close();
                    bos.close();
                    fos.close();
                    throw var7_16;
lbl52:
                    // 1 sources

                    catch (Exception exx) {
                        // empty catch block
                    }
                    throw var7_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 166->192)] { 
lbl57:
            // 1 sources

            zip.flush();
            zip.finish();
            zip.close();
            bos.close();
            fos.close();
            return;
lbl63:
            // 1 sources

            catch (Exception exx) {
                // empty catch block
            }
            return;
        }
        var8_6 = null;
        try {}
        catch (Exception exx) {}
        zip.flush();
        zip.finish();
        zip.close();
        bos.close();
        fos.close();
        return;
    }

    private static void copyJFile(JarOutputStream zip, String entryName, String filePath) throws IOException {
        Object zFile = null;
        JarEntry entry = null;
        int result = 0;
        byte[] fileEntry = null;
        FileInputStream inStream = null;
        BufferedInputStream in = null;
        inStream = new FileInputStream(filePath);
        in = new BufferedInputStream(inStream);
        fileEntry = new byte[in.available()];
        result = in.read(fileEntry, 0, fileEntry.length);
        in.close();
        ((InputStream)inStream).close();
        if (result == -1) {
            return;
        }
        entry = new JarEntry(entryName.replace('\\', '/'));
        entry.setMethod(8);
        if (fileEntry != null) {
            entry.setSize(fileEntry.length);
            CRC32 crc = new CRC32();
            crc.update(fileEntry);
            entry.setCrc(crc.getValue());
            try {
                zip.putNextEntry(entry);
                if (fileEntry.length > 0) {
                    zip.write(fileEntry, 0, fileEntry.length);
                    OfflineAnalyser.addDirEntries(zip, entryName);
                }
                zip.closeEntry();
            }
            catch (ZipException z) {
                zip.closeEntry();
            }
        }
    }

    private static void addDirEntries(JarOutputStream jos, String jarEntryName) throws IOException {
        int ind = jarEntryName.indexOf(47);
        String dir = "";
        JarEntry jentry = null;
        while (ind >= 0) {
            dir = dir + jarEntryName.substring(0, ind + 1);
            jarEntryName = jarEntryName.substring(ind + 1);
            ind = jarEntryName.indexOf(47);
            jentry = new JarEntry(dir);
            jentry.setSize(0L);
            try {
                jos.putNextEntry(jentry);
                jos.closeEntry();
            }
            catch (ZipException z) {
                jos.closeEntry();
            }
        }
    }

    private static void execute(String command) {
        try {
            Runtime.getRuntime().exec(cmdCmd + command);
            Thread.sleep(10L);
            System.out.print(".");
            newLine = false;
        }
        catch (Exception e) {
            OfflineAnalyser.dump("Error while collecting data !!!");
            e.printStackTrace();
        }
    }

    private static String getDirName() {
        String u;
        String s4;
        Long time = new Long(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        String s3 = s4 = (u = "_");
        String s2 = s4;
        String s1 = s4;
        if (month < 10) {
            s1 = u + "0";
        }
        if (day < 10) {
            s2 = u + "0";
        }
        s3 = hour < 10 ? "_at" + u + "0" : "_at" + u;
        if (min < 10) {
            s4 = u + "0";
        }
        return "analysed_on_" + year + s1 + month + s2 + day + s3 + hour + s4 + min;
    }

    public static void usage() {
        OfflineAnalyser.dump("USAGE OfflineAnalyser -[KEY]");
        OfflineAnalyser.dump("\t\tKEY : [-all] - obtains alone and cluster files");
        OfflineAnalyser.dump("\t\tKEY : [-alone] - obtains alone files");
        OfflineAnalyser.dump("\t\tKEY : [-cluster] - obtains cluster files");
        System.exit(0);
    }

    private static void collect(String element) {
        String[] services;
        String[] managers;
        String root = ".." + sep + ".." + sep + "cluster" + sep + element + sep;
        if (element.startsWith("server")) {
            OfflineAnalyser.dump("Collecting from cluster element '" + element + "' ...");
            managers = servManagers;
            services = servServices;
        } else if (element.startsWith("dispatcher")) {
            OfflineAnalyser.dump("Collecting from cluster element '" + element + "' ...");
            managers = dispManagers;
            services = dispServices;
        } else {
            managers = aloneManagers;
            services = aloneServices;
            root = ".." + sep + ".." + sep + element + sep;
        }
        String dir = offlineDirName + element + sep;
        String manDir = dir + "managers" + sep;
        String serDir = dir + "services" + sep;
        String manLogDir = dir + "managers" + sep + "log" + sep;
        String serLogDir = dir + "services" + sep + "log" + sep;
        String manSetDir = manDir + "settings" + sep;
        String manRoot = root + "managers" + sep;
        String manLogRoot = root + "managers" + sep + "log" + sep;
        String serLogRoot = root + "services" + sep + "log" + sep + "work" + sep;
        new File(serDir).mkdirs();
        new File(manSetDir).mkdirs();
        new File(manLogDir).mkdirs();
        new File(serLogDir).mkdirs();
        OfflineAnalyser.execute(copy + root + "managers" + sep + "version.txt " + manDir);
        OfflineAnalyser.execute(copy + root + "managers" + sep + "library.txt " + manDir);
        OfflineAnalyser.execute(copy + root + "managers" + sep + "reference.txt " + manDir);
        OfflineAnalyser.execute(dirCmd + root + "system-lib >> " + dir + "system-lib.txt");
        OfflineAnalyser.execute(dirCmd + root + "additional-lib >> " + dir + "additional-lib.txt");
        OfflineAnalyser.execute(dirCmd + root + "lib >> " + dir + "lib.txt");
        int i = 0;
        while (i < managers.length) {
            OfflineAnalyser.execute(copy + root + "managers" + sep + "settings" + sep + managers[i] + " " + manSetDir);
            ++i;
        }
        int i2 = 0;
        while (i2 < services.length) {
            String serSetDir = serDir + services[i2] + sep;
            new File(serSetDir).mkdirs();
            OfflineAnalyser.execute(copy + root + "services" + sep + services[i2] + sep + "properties. " + serSetDir + "properties.");
            OfflineAnalyser.execute(copy + root + "services" + sep + services[i2] + sep + "runtime.xml " + serSetDir + "runtime.xml");
            OfflineAnalyser.execute(copy + root + "services" + sep + services[i2] + sep + "provider.xml " + serSetDir + "provider.xml");
            ++i2;
        }
        OfflineAnalyser.execute(copy + root + "managers" + sep + "framework.properties " + manDir);
        OfflineAnalyser.execute(copy + root + "go.bat " + dir);
        OfflineAnalyser.execute("netstat -a -e -s -r >> " + dir + "netstat.txt");
        String clRoot = manRoot + "console_logs" + sep;
        String clDir = manDir + "console_logs" + sep;
        new File(clDir).mkdirs();
        OfflineAnalyser.execute(copy + clRoot + "error.log" + " " + clDir);
        OfflineAnalyser.execute(copy + clRoot + "output.log" + " " + clDir);
        OfflineAnalyser.execute(copy + root + "cmdline.properties " + dir);
        OfflineAnalyser.execute(copy + manLogRoot + "error.log " + manLogDir);
        OfflineAnalyser.execute(copy + manLogRoot + "emergency.log " + manLogDir);
        OfflineAnalyser.execute(copy + manLogRoot + "warning.log " + manLogDir);
        OfflineAnalyser.execute(copy + manLogRoot + "info.log " + manLogDir);
        File logDir = new File(serLogRoot);
        File[] files = logDir.listFiles();
        int i3 = 0;
        while (i3 < files.length) {
            String fName = files[i3].getName();
            if (fName.endsWith("log")) {
                OfflineAnalyser.execute(copy + serLogRoot + fName + " " + dir);
            }
            ++i3;
        }
        OfflineAnalyser.dump("  Element '" + element + "' complete.");
    }

    public static void main(String[] args) {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            copy = "copy ";
            dirCmd = "dir ";
            cmdCmd = "CMD /C ";
        } else {
            copy = "cp ";
            dirCmd = "ls ";
            cmdCmd = "";
        }
        String leechHost = null;
        int leechPort = -1;
        time = System.currentTimeMillis();
        if (args == null || args.length == 0) {
            cluster = true;
            alone = false;
            leech = false;
        } else if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-cluster")) {
                    cluster = true;
                    alone = false;
                } else if (args[i].equals("-alone")) {
                    cluster = false;
                    alone = true;
                } else if (args[i].equals("-all")) {
                    cluster = true;
                    alone = true;
                } else if (args[i].equals("-leech")) {
                    leech = true;
                    leechHost = args[i + 1];
                    leechPort = Integer.parseInt(args[i + 2]);
                }
                ++i;
            }
        } else {
            OfflineAnalyser.usage();
        }
        tempDirName = OfflineAnalyser.getDirName() + sep;
        try {
            OfflineAnalyser.dump("Obtaining offline information...");
            OfflineAnalyser.dump("Output directory : " + tempDirName);
            offlineDirName = tempDirName + "offline_analyse" + sep;
            new File(offlineDirName).mkdirs();
            if (cluster) {
                OfflineAnalyser.dump("Collecting CLUSTER data...");
                OfflineAnalyser.collect("dispatcher");
                OfflineAnalyser.collect("server");
                int clElement = 2;
                String root = ".." + sep + ".." + sep + "cluster" + sep + "dispatcher";
                while (new File(root + clElement).exists()) {
                    OfflineAnalyser.collect("dispatcher" + clElement);
                    ++clElement;
                }
                clElement = 2;
                root = ".." + sep + ".." + sep + "cluster" + sep + "server";
                while (new File(root + clElement).exists()) {
                    OfflineAnalyser.collect("server" + clElement);
                    ++clElement;
                }
                OfflineAnalyser.dump("Cluster data collected.");
            }
            if (alone) {
                OfflineAnalyser.dump("Collecting ALONE data...");
                OfflineAnalyser.collect("alone");
            }
            OfflineAnalyser.dump("Offline information collected. Prepare to compress data...");
            Thread.sleep(3000L);
            OfflineAnalyser.dump("Compressing...");
            OfflineAnalyser.makeJarFromDir("lastAnalyse", new String[]{tempDirName});
            OfflineAnalyser.archivate();
            int sec = (int)((System.currentTimeMillis() - time) / 1000L);
            int min = 0;
            if (sec > 59) {
                min = sec / 60;
                sec -= min * 60;
            }
            if (min > 0) {
                OfflineAnalyser.dump("  All done for " + min + " min and " + sec + " seconds.");
            } else {
                OfflineAnalyser.dump("  All done for " + sec + " seconds.");
            }
            OfflineAnalyser.dump("Result file : lastAnalyse.zip created.");
            if (leech) {
                OfflineAnalyser.dump(" Sending file ... ");
                try {
                    Socket s = new Socket(leechHost, leechPort);
                    OfflineAnalyser.sendFile(s);
                    OfflineAnalyser.dump(" File sent.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            OfflineAnalyser.dump("Unexpected error occured !!!");
            e.printStackTrace();
        }
    }

    private static void sendFile(Socket s) throws Exception {
        OutputStream os = s.getOutputStream();
        char sep = File.separatorChar;
        String fileToLeech = ".." + sep + ".." + sep + "tools" + sep + "analyseIt" + sep + "lastAnalyse.zip";
        RandomAccessFile raf = new RandomAccessFile(new File(fileToLeech), "rw");
        long read = 0L;
        long length = raf.length();
        os.write("NWN".getBytes());
        os.flush();
        byte[] b = new byte[]{(byte)length, (byte)(length >> 8), (byte)(length >> 16), (byte)(length >> 24), (byte)(length >> 32), (byte)(length >> 40), (byte)(length >> 48), (byte)(length >> 56)};
        os.write(b);
        os.flush();
        byte[] buf = new byte[1024];
        while (read < length) {
            int r = raf.read(buf);
            read += (long)r;
            os.write(buf, 0, r);
            os.flush();
        }
        os.close();
        raf.close();
    }

    public static void dump(String s) {
        try {
            if (!newLine) {
                System.out.println();
                newLine = true;
            }
            System.out.println(s);
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        leech = false;
        vec = new Vector();
        dispManagers = new String[]{"ClassLoaderManager.properties", "ClusterManager.properties", "ConnectionsManipulator.properties", "IpVerificationManager.properties", "LockManager.properties", "LogManager.properties", "MemoryManager.properties", "PolicyManager.properties", "PoolManager.properties", "PortsManager.properties", "R3StartupManager.properties", "ServiceManager.properties", "ThreadManager.properties", "TimeoutManager.properties"};
        dispServices = new String[]{"admin", "http", "httptunneling", "iiop", "jms", "keystore", "log", "monitor", "p4", "r3startup", "security", "shell", "ssl", "telnet"};
        servManagers = new String[]{"ClassLoaderManager.properties", "ClusterManager.properties", "ConnectionsManipulator.properties", "default_library.txt", "IpVerificationManager.properties", "LockManager.properties", "LogManager.properties", "MemoryManager.properties", "PolicyManager.properties", "PoolManager.properties", "PortsManager.properties", "R3StartupManager.properties", "ServiceManager.properties", "SwapManager.properties", "SystemThreadManager.properties", "ThreadManager.properties", "TimeoutManager.properties"};
        servServices = new String[]{"admin", "appclient", "connector", "dbms", "dbpool", "deploy", "ejb", "file", "log", "http", "iiop", "javamail", "jms", "jmsconnector", "keystore", "monitor", "naming", "p4", "rfcengine", "security", "servlet_jsp", "shell", "ssl", "telnet", "ts", "webservices"};
        aloneManagers = new String[]{"ClassLoaderManager.properties", "ClassLoaderManager.properties.default", "ClusterManager.properties", "ClusterManager.properties.default", "ConnectionsManipulator.properties", "ConnectionsManipulator.properties.default", "DispatcherThreadManager.properties", "DispatcherThreadManager.properties.defaul", "IpVerificationManager.properties", "IpVerificationManager.properties.default", "LockManager.properties", "LockManager.properties.default", "LogManager.properties", "LogManager.properties.default", "MemoryManager.properties", "MemoryManager.properties.default", "PolicyManager.properties", "PolicyManager.properties.default", "PoolManager.properties", "PoolManager.properties.default", "PortsManager.properties", "PortsManager.properties.default", "ServiceManager1.properties", "ServiceManager1.properties.default", "ServiceManager2.properties", "ServiceManager2.properties.default", "SwapManager.properties", "SwapManager.properties.default", "SystemThreadManager.properties", "SystemThreadManager.properties.default", "ThreadManager.properties", "ThreadManager.properties.default", "TimeoutManager.properties", "TimeoutManager.properties.default"};
        aloneServices = new String[]{"admin", "appclient", "connector", "dbms", "dbpool", "deploy", "ejb", "file", "http", "httptunneling", "iiop", "javamail", "jms", "jmsconnector", "keystore", "log", "monitor", "naming", "p4", "rfcengine", "security", "servlet_jsp", "shell", "ssl", "telnet", "ts", "webservices"};
        newLine = false;
        time = 0L;
        sep = File.separatorChar;
    }
}

