/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore.search;

import com.sap.engine.interfaces.security.userstore.context.SearchAttribute;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.services.userstore.UserContextImpl;
import com.sap.engine.services.userstore.search.SearchUtil;
import java.util.Iterator;

public class UserSearchResultImpl
implements SearchResult {
    private int state = 2;
    private int index = 0;
    private Iterator iterator = null;
    private Object next = null;
    private UserContextImpl context = null;
    private int searchResultSize = 0;
    private boolean searchByName = false;
    private boolean searchByParent = false;
    private SearchAttribute nameAttribute = null;
    private SearchAttribute parentAttribute = null;
    private boolean searchLocked = false;

    public UserSearchResultImpl(UserContextImpl context, Iterator attributes, int searchResultSize) {
        this.context = context;
        this.searchResultSize = searchResultSize;
        this.iterator = context.engineListUsers();
        SearchAttribute attribute = null;
        while (attributes.hasNext()) {
            attribute = (SearchAttribute)attributes.next();
            if (attribute.getAttributeName().equals("user.name")) {
                this.searchByName = true;
                this.nameAttribute = attribute;
                continue;
            }
            if (attribute.getAttributeName().equals("user.parentgroup")) {
                this.searchByParent = true;
                this.parentAttribute = attribute;
                continue;
            }
            if (!attribute.getAttributeName().equals("user.locked")) continue;
            this.searchLocked = attribute.getAttributeValue().equals("true");
        }
    }

    public boolean hasNext() {
        if (this.iterator == null || this.index == this.searchResultSize) {
            if (this.state != 1) {
                this.state = this.findNext() != null ? 4 : 0;
            }
            return false;
        }
        try {
            this.next = this.findNext();
            boolean bl = this.next != null;
            Object var3_2 = null;
            if (this.next == null && this.searchResultSize < 0 && this.state != 1) {
                this.state = 2;
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (this.next != null || this.searchResultSize >= 0 || this.state == 1) break block5;
                this.state = 2;
            }
            throw throwable;
        }
    }

    public Object next() {
        if (this.iterator == null || this.index == this.searchResultSize) {
            if (this.state != 1) {
                this.state = this.findNext() != null ? 4 : 0;
            }
            return null;
        }
        if (this.next != null) {
            ++this.index;
            return this.next;
        }
        try {
            this.next = this.findNext();
            if (this.next != null) {
                ++this.index;
            }
            Object object = this.next;
            Object var3_2 = null;
            if (this.next == null && this.searchResultSize < 0 && this.state != 1) {
                this.state = 2;
            }
            return object;
        }
        catch (Throwable throwable) {
            block7: {
                Object var3_3 = null;
                if (this.next != null || this.searchResultSize >= 0 || this.state == 1) break block7;
                this.state = 2;
            }
            throw throwable;
        }
    }

    public void remove() {
    }

    private Object findNext() {
        String node = null;
        while (this.iterator.hasNext()) {
            node = (String)this.iterator.next();
            if (this.searchLocked) {
                try {
                    if ((Integer)this.context.engineGetUserInfo(node).engineReadUserProperty(12) == 0 || !this.isMatching(node)) continue;
                    return node;
                }
                catch (SecurityException se) {
                    this.state = 1;
                }
                continue;
            }
            if (!this.isMatching(node)) continue;
            return node;
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    private boolean isMatching(String node) {
        boolean isMatching = true;
        if (this.searchByName) {
            isMatching = this.matchByNameAttribute(node);
        }
        if (this.searchByParent) {
            isMatching = isMatching && this.matchByParentAttribute(node);
        }
        return isMatching;
    }

    private boolean matchByNameAttribute(String node) {
        int operator = this.nameAttribute.getOperator();
        Object attributeValue = this.nameAttribute.getAttributeValue();
        switch (operator) {
            case 0: {
                return node.equals(attributeValue);
            }
            case 1: {
                return SearchUtil.isLike((String)attributeValue, node);
            }
        }
        return false;
    }

    private boolean matchByParentAttribute(String node) {
        int operator = this.parentAttribute.getOperator();
        Object attributeValue = this.parentAttribute.getAttributeValue();
        Iterator parents = null;
        String parent = null;
        try {
            parents = this.context.engineGetParentGroups(node);
        }
        catch (Exception _) {
            this.state = 1;
        }
        while (parents != null && parents.hasNext()) {
            parent = (String)parents.next();
            switch (operator) {
                case 0: {
                    if (!parent.equals(attributeValue)) break;
                    return true;
                }
                case 1: {
                    if (!SearchUtil.isLike((String)attributeValue, parent)) break;
                    return true;
                }
            }
        }
        return false;
    }
}

