/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore.search;

import com.sap.engine.interfaces.security.userstore.context.SearchAttribute;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.services.userstore.GroupContextImpl;
import com.sap.engine.services.userstore.search.SearchUtil;
import java.util.Iterator;

public class GroupSearchResultImpl
implements SearchResult {
    private int state = 2;
    int index = 0;
    Iterator iterator = null;
    Object next = null;
    GroupContextImpl context = null;
    private int searchResultSize = 0;
    private boolean searchByName = false;
    private boolean searchByParent = false;
    private boolean searchByChildGroup = false;
    private boolean searchByChildUser = false;
    private SearchAttribute nameAttribute = null;
    private SearchAttribute parentAttribute = null;
    private SearchAttribute childGroupAttribute = null;
    private SearchAttribute childUserAttribute = null;

    public GroupSearchResultImpl(GroupContextImpl context, Iterator attributes, int searchResultSize) {
        this.context = context;
        this.searchResultSize = searchResultSize;
        this.iterator = context.engineListGroups();
        SearchAttribute attribute = null;
        while (attributes.hasNext()) {
            attribute = (SearchAttribute)attributes.next();
            if (attribute.getAttributeName().equals("group.name")) {
                this.searchByName = true;
                this.nameAttribute = attribute;
                continue;
            }
            if (attribute.getAttributeName().equals("group.parentgroup")) {
                this.searchByParent = true;
                this.parentAttribute = attribute;
                continue;
            }
            if (attribute.getAttributeName().equals("group.childgroup")) {
                this.searchByChildGroup = true;
                this.childGroupAttribute = attribute;
                continue;
            }
            if (!attribute.getAttributeName().equals("group.childuser")) continue;
            this.searchByChildUser = true;
            this.childUserAttribute = attribute;
        }
    }

    public boolean hasNext() {
        if (this.iterator == null || this.index == this.searchResultSize) {
            if (this.state != 1) {
                this.state = this.findNext() != null ? 4 : 0;
            }
            return false;
        }
        try {
            this.next = this.findNext();
            boolean bl = this.next != null;
            Object var3_2 = null;
            if (this.next == null && this.searchResultSize < 0 && this.state != 1) {
                this.state = 2;
            }
            return bl;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (this.next != null || this.searchResultSize >= 0 || this.state == 1) break block5;
                this.state = 2;
            }
            throw throwable;
        }
    }

    public Object next() {
        if (this.iterator == null || this.index == this.searchResultSize) {
            if (this.state != 1) {
                this.state = this.findNext() != null ? 4 : 0;
            }
            return null;
        }
        if (this.next != null) {
            ++this.index;
            return this.next;
        }
        try {
            this.next = this.findNext();
            if (this.next != null) {
                ++this.index;
            }
            Object object = this.next;
            Object var3_2 = null;
            if (this.next == null && this.searchResultSize < 0 && this.state != 1) {
                this.state = 2;
            }
            return object;
        }
        catch (Throwable throwable) {
            block7: {
                Object var3_3 = null;
                if (this.next != null || this.searchResultSize >= 0 || this.state == 1) break block7;
                this.state = 2;
            }
            throw throwable;
        }
    }

    public void remove() {
    }

    public int getState() {
        return this.state;
    }

    private Object findNext() {
        String node = null;
        while (this.iterator.hasNext()) {
            node = (String)this.iterator.next();
            if (!this.isMatching(node)) continue;
            return node;
        }
        return null;
    }

    private boolean isMatching(String node) {
        boolean isMatching = true;
        if (this.searchByName) {
            isMatching = this.matchByNameAttribute(node);
        }
        if (this.searchByParent) {
            boolean bl = isMatching = isMatching && this.matchByOtherAttribute(node, this.parentAttribute, "group.parentgroup");
        }
        if (this.searchByChildGroup) {
            boolean bl = isMatching = isMatching && this.matchByOtherAttribute(node, this.childGroupAttribute, "group.childgroup");
        }
        if (this.searchByChildUser) {
            isMatching = isMatching && this.matchByOtherAttribute(node, this.childUserAttribute, "group.childuser");
        }
        return isMatching;
    }

    private boolean matchByNameAttribute(String node) {
        int operator = this.nameAttribute.getOperator();
        Object attributeValue = this.nameAttribute.getAttributeValue();
        switch (operator) {
            case 0: {
                return node.equals(attributeValue);
            }
            case 1: {
                return SearchUtil.isLike((String)attributeValue, node);
            }
        }
        return false;
    }

    private boolean matchByOtherAttribute(String node, SearchAttribute attribute, String type) {
        String subnode;
        Iterator subNodes;
        Object attributeValue;
        int operator;
        block9: {
            operator = attribute.getOperator();
            attributeValue = attribute.getAttributeValue();
            subNodes = null;
            subnode = null;
            try {
                if (type.equals("group.parentgroup")) {
                    subNodes = this.context.engineGetParentGroups(node);
                    break block9;
                }
                if (type.equals("group.childgroup")) {
                    subNodes = this.context.engineGetChildGroups(node);
                    break block9;
                }
                subNodes = this.context.engineGetUsersOfGroup(node);
            }
            catch (Exception _) {
                this.state = 1;
            }
        }
        while (subNodes != null && subNodes.hasNext()) {
            subnode = (String)subNodes.next();
            switch (operator) {
                case 0: {
                    if (!subnode.equals(attributeValue)) break;
                    return true;
                }
                case 1: {
                    if (!SearchUtil.isLike((String)attributeValue, subnode)) break;
                    return true;
                }
            }
        }
        return false;
    }
}

