/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore.filter;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.engine.services.userstore.filter.FilterPasswordImpl;
import com.sap.engine.services.userstore.filter.FilterUsernameImpl;

public class FilterStorage {
    public static final String FILTER_CONFIG_PATH = "filter";
    public static final String USER_FILTER_CONFIG_PATH = "filter/username";
    public static final String PASSWORD_FILTER_CONFIG_PATH = "filter/password";
    public static final String CASE_SENSITIVITY_PROP = "CASE_SENSITIVITY";
    public static final String DIGITS_USAGE_PROP = "DIGITS_USAGE";
    public static final String MAXIMUM_LENGTH_PROP = "MAXIMUM_LENGTH";
    public static final String MINIMUM_LENGTH_PROP = "MINIMUM_LENGTH";
    public static final String SPACES_USAGE_PROP = "SPACES_USAGE";

    public FilterUsername getFilterUsername(Configuration configuration) {
        try {
            return new FilterUsernameImpl(configuration, false);
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_1001", ex);
        }
    }

    public FilterPassword getFilterPassword(Configuration configuration) {
        try {
            return new FilterPasswordImpl(configuration, false);
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_1002", ex);
        }
    }

    public void setFilterPassword(FilterPassword filter, Configuration configuration) {
        try {
            configuration.modifyConfigEntry(CASE_SENSITIVITY_PROP, new Integer(filter.getRestriction(0)));
            configuration.modifyConfigEntry(DIGITS_USAGE_PROP, new Integer(filter.getRestriction(1)));
            configuration.modifyConfigEntry(MAXIMUM_LENGTH_PROP, new Integer(filter.getRestriction(2)));
            configuration.modifyConfigEntry(MINIMUM_LENGTH_PROP, new Integer(filter.getRestriction(3)));
            configuration.modifyConfigEntry(SPACES_USAGE_PROP, new Integer(filter.getRestriction(4)));
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_1003", ex);
        }
    }

    public void setFilterUsername(FilterUsername filter, Configuration configuration) {
        try {
            configuration.modifyConfigEntry(CASE_SENSITIVITY_PROP, new Integer(filter.getRestriction(0)));
            configuration.modifyConfigEntry(DIGITS_USAGE_PROP, new Integer(filter.getRestriction(1)));
            configuration.modifyConfigEntry(MAXIMUM_LENGTH_PROP, new Integer(filter.getRestriction(2)));
            configuration.modifyConfigEntry(MINIMUM_LENGTH_PROP, new Integer(filter.getRestriction(3)));
            configuration.modifyConfigEntry(SPACES_USAGE_PROP, new Integer(filter.getRestriction(4)));
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_1004", ex);
        }
    }
}

