/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore.filter;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import java.util.Random;

public class FilterPasswordImpl
implements FilterPassword {
    private int case_sensitivity = 0;
    private int digits_usage = 0;
    private int maximum_length = 20;
    private int minimum_length = 0;
    private int spaces_allowed = 0;

    public FilterPasswordImpl() {
    }

    public FilterPasswordImpl(Configuration configuration, boolean writeAccess) throws Exception {
        if (writeAccess) {
            configuration.addConfigEntry("CASE_SENSITIVITY", new Integer(this.case_sensitivity));
            configuration.addConfigEntry("DIGITS_USAGE", new Integer(this.digits_usage));
            configuration.addConfigEntry("MAXIMUM_LENGTH", new Integer(this.maximum_length));
            configuration.addConfigEntry("MINIMUM_LENGTH", new Integer(this.minimum_length));
            configuration.addConfigEntry("SPACES_USAGE", new Integer(this.spaces_allowed));
        } else {
            this.case_sensitivity = (Integer)configuration.getConfigEntry("CASE_SENSITIVITY");
            this.digits_usage = (Integer)configuration.getConfigEntry("DIGITS_USAGE");
            this.maximum_length = (Integer)configuration.getConfigEntry("MAXIMUM_LENGTH");
            this.minimum_length = (Integer)configuration.getConfigEntry("MINIMUM_LENGTH");
            this.spaces_allowed = (Integer)configuration.getConfigEntry("SPACES_USAGE");
        }
    }

    public FilterPassword deserialize(byte[] data) {
        FilterPasswordImpl filter = new FilterPasswordImpl();
        int i = 0;
        while (i < 5) {
            filter.setRestriction(i, data[i]);
            ++i;
        }
        return filter;
    }

    public boolean filterPassword(char[] password) {
        int i;
        boolean isOK;
        int i2;
        if (password == null || password.length > this.maximum_length || password.length < this.minimum_length) {
            return false;
        }
        if (this.digits_usage == 1) {
            i2 = 0;
            while (i2 < password.length) {
                if (Character.isDigit(password[i2])) {
                    return false;
                }
                ++i2;
            }
        } else if (this.digits_usage == 3) {
            isOK = false;
            i = 0;
            while (i < password.length) {
                if (Character.isDigit(password[i])) {
                    isOK = true;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                return false;
            }
        }
        if (this.spaces_allowed == 1) {
            i2 = 0;
            while (i2 < password.length) {
                if (Character.isWhitespace(password[i2])) {
                    return false;
                }
                ++i2;
            }
        } else if (this.spaces_allowed == 3) {
            isOK = false;
            i = 0;
            while (i < password.length) {
                if (Character.isWhitespace(password[i])) {
                    isOK = true;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                return false;
            }
        }
        return true;
    }

    public char[] generatePassword() {
        int length;
        Random rand = new Random();
        int a = 97;
        int no = 48;
        while ((length = rand.nextInt(this.maximum_length)) < this.minimum_length) {
        }
        char[] ch = new char[length];
        int pos1 = -1;
        int pos2 = -1;
        if (this.digits_usage == 3) {
            pos1 = rand.nextInt(length - 1);
            ch[pos1] = (char)(rand.nextInt(10) + no);
        }
        if (this.spaces_allowed == 3) {
            while ((pos2 = rand.nextInt(length - 1)) != pos1) {
                ch[pos2] = 32;
            }
        }
        int i = 0;
        while (i < length) {
            if (i != pos1 && i != pos2) {
                ch[i] = (char)(rand.nextInt(25) + a);
            }
            ++i;
        }
        return ch;
    }

    public int getRestriction(int restriction) {
        switch (restriction) {
            case 0: {
                return this.case_sensitivity;
            }
            case 1: {
                return this.digits_usage;
            }
            case 2: {
                return this.maximum_length;
            }
            case 3: {
                return this.minimum_length;
            }
            case 4: {
                return this.spaces_allowed;
            }
        }
        return -1;
    }

    public byte[] serialize() {
        return new byte[]{(byte)this.case_sensitivity, (byte)this.digits_usage, (byte)this.maximum_length, (byte)this.minimum_length, (byte)this.spaces_allowed};
    }

    public void setRestriction(int restriction, int usage) {
        switch (restriction) {
            case 0: {
                if (usage < 0 || usage > 4) break;
                this.case_sensitivity = usage;
                break;
            }
            case 1: {
                if (usage < 0 || usage > 4) break;
                this.digits_usage = usage;
                break;
            }
            case 2: {
                if (usage > 255 || usage < this.minimum_length) break;
                this.maximum_length = usage;
                break;
            }
            case 3: {
                if (usage < 0 || usage > this.maximum_length) break;
                this.minimum_length = usage;
                break;
            }
            case 4: {
                if (usage < 0 || usage > 4) break;
                this.spaces_allowed = usage;
            }
        }
    }

    public String[] getRestrictionsInfo() {
        return new String[]{"case_sensitive", "digits_usage", "maximum_length", "minimum_length", "spaces_usage"};
    }

    public String[] getUsageInfo() {
        return new String[]{"usage_allowed", "usage_forbidden", "usage_ignored", "usage_mandatory"};
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        FilterPassword filter = null;
        try {
            filter = (FilterPassword)obj;
        }
        catch (Exception e) {
            return false;
        }
        int i = 0;
        while (i < 5) {
            if (filter.getRestriction(i) != this.getRestriction(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

