/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.log.Logger;
import com.sap.engine.interfaces.security.AuthorizationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerWrapper;
import com.sap.engine.services.userstore.ContainerEventListenerImpl;
import com.sap.engine.services.userstore.HandlerPool;
import com.sap.engine.services.userstore.SecurityModificationContext;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.engine.services.userstore.exceptions.UserstoreResourceAccessor;
import com.sap.engine.services.userstore.exceptions.UserstoreServiceException;
import com.sap.engine.services.userstore.exceptions.UserstoreServiceRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Properties;

public class UserStoreServiceFrame
implements ApplicationServiceFrame {
    public static final String ROLE_NAME = "find_alias";
    private static ApplicationServiceContext serviceContext = null;
    private static Logger log = null;
    private static Properties serviceProperties = null;
    private static KeystoreManagerWrapper keystore = null;
    private static boolean keystoreInitialized = false;
    private static boolean category_location = false;
    private static LockingContext lockingContext = null;
    private static ServerInternalLocking internalLock = null;
    private static Object lockObject = new Object();
    public static final String USERSTORE_CATEGORY = "/System/Security";
    public static final String USERSTORE_LOCATION = "com.sap.engine.services.userstore";

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        UserStoreServiceFrame.serviceContext = serviceContext;
        lockingContext = serviceContext.getCoreContext().getLockingContext();
        try {
            internalLock = lockingContext.createServerInternalLocking("$service.userstore", "Synchronization For Userstore Write Operations");
        }
        catch (TechnicalLockException tle) {
            UserstoreServiceException sse = new UserstoreServiceException("userstore_0002", (Throwable)((Object)tle));
            sse.log();
            throw sse;
        }
        try {
            new UserstoreResourceAccessor().init(Category.getCategory((String)USERSTORE_CATEGORY), Location.getLocation((String)USERSTORE_LOCATION));
            serviceProperties = serviceContext.getServiceState().getProperties();
            int mask = 228;
            HashSet<String> names = new HashSet<String>(2);
            names.add("keystore");
            names.add("log");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, new ContainerEventListenerImpl());
            HandlerPool.configHandlerFactory = serviceContext.getCoreContext().getConfigurationHandlerFactory();
            serviceContext.getCoreContext().getThreadSystem().registerContextObject("security_modification", new SecurityModificationContext());
        }
        catch (Exception e) {
            UserstoreServiceException use = new UserstoreServiceException("userstore_0000", (Throwable)e);
            use.log();
            throw use;
        }
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return false;
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("security");
    }

    static KeystoreManagerWrapper getKeystoreInterface() {
        if (keystore != null && !keystoreInitialized) {
            UserStoreServiceFrame.initKeystore();
            keystoreInitialized = true;
        }
        return keystore;
    }

    static void setKeystore(KeystoreManagerWrapper keystore) {
        UserStoreServiceFrame.keystore = keystore;
    }

    public static Properties getServiceProperties() {
        return serviceProperties;
    }

    public void stop() throws ServiceRuntimeException {
        try {
            serviceContext.getCoreContext().getThreadSystem().unregisterContextObject("security_modification");
            UserStoreServiceFrame.logNotice("Service userstore stopped OK");
        }
        catch (Exception e) {
            UserstoreServiceRuntimeException usre = new UserstoreServiceRuntimeException("userstore_0001", (Throwable)e);
            usre.log();
            throw usre;
        }
    }

    public static synchronized void setLogger(Logger logger) {
        log = logger;
    }

    public static void logNotice(String message) {
        if (category_location) {
            UserstoreResourceAccessor.category.logT(300, UserstoreResourceAccessor.location, message);
        } else if (SystemProperties.getBoolean("debug")) {
            System.out.println("[userstore][INFO]: " + message);
        }
    }

    public static void logWarning(String message, Throwable t) {
        if (category_location) {
            if (message != null) {
                UserstoreResourceAccessor.category.log(400, UserstoreResourceAccessor.location, (Object)message);
            }
            if (UserstoreResourceAccessor.location != null) {
                UserstoreResourceAccessor.location.catching(t);
            }
        } else if (SystemProperties.getBoolean("debug")) {
            System.out.println("[userstore][WARNING]: " + message);
            t.printStackTrace();
        }
    }

    public static void logError(String message, Throwable t) {
        if (category_location) {
            if (message != null) {
                UserstoreResourceAccessor.category.log(500, UserstoreResourceAccessor.location, (Object)message);
            }
            if (UserstoreResourceAccessor.location != null) {
                UserstoreResourceAccessor.location.catching(t);
            }
        } else if (SystemProperties.getBoolean("debug")) {
            System.out.println("[userstore][ERROR]: " + message);
            t.printStackTrace();
        }
    }

    public static void logError(String message) {
        if (category_location) {
            UserstoreResourceAccessor.category.logT(500, UserstoreResourceAccessor.location, message);
            log.log((byte)5, message);
        } else if (SystemProperties.getBoolean("debug")) {
            System.out.println("[userstore][ERROR]: " + message);
        }
    }

    public static void useCategory_LocationLogging(boolean flag) {
        category_location = flag && UserstoreResourceAccessor.category != null;
    }

    static void lock(String name) throws SecurityException {
        long beginTime = System.currentTimeMillis();
        while (System.currentTimeMillis() <= beginTime + 60000L) {
            try {
                internalLock.lock("$service.userstore", "userstore_" + name + "_lock", 'X');
                return;
            }
            catch (Exception e) {
                Object object = lockObject;
                synchronized (object) {
                    try {
                        lockObject.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        throw new BaseSecurityException("userstore_0003", ex);
                    }
                }
            }
        }
        throw new BaseSecurityException("userstore_0003");
    }

    static void releaseLock(String name) {
        try {
            internalLock.unlock("$service.userstore", "userstore_" + name + "_lock", 'X');
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to release lock <$service.userstore>.", e);
        }
    }

    private static void initKeystore() {
        try {
            AuthorizationContext authorization;
            SecurityRole role;
            if (!keystore.existKeystoreView("DBMS_User_Store")) {
                keystore.createKeystoreView("DBMS_User_Store", new Properties());
            }
            if ((role = (authorization = UserStoreServiceFrame.getSecurityContext().getPolicyConfigurationContext("keystore-view.DBMS_User_Store").getAuthorizationContext()).getSecurityRoleContext().getSecurityRole(ROLE_NAME)) == null) {
                authorization.getSecurityRoleContext().addSecurityRoleReference(ROLE_NAME, "SAP-J2EE-Engine", "all");
                ResourceAccessControlHandle views_actions = authorization.getSecurityResourceContext().getResourceAccessControlHandle("view-actions");
                views_actions.grantSecurityRole(ROLE_NAME, "FIND_ALIAS", "ALL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UserStoreServiceFrame.logError("Error in initializing 'DBMS_User_Store' keystore view.", e);
        }
    }
}

