/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.lib.security.Principal;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerWrapper;
import com.sap.engine.services.userstore.UserContextImpl;
import com.sap.engine.services.userstore.UserStoreServiceFrame;
import com.sap.engine.services.userstore.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.exception.IBaseException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class UserInfoImpl
implements UserInfoSpi {
    public static final String PASSWORD = "password";
    public static final String CREATE_DATE = "PROPERTY_CREATE_DATE";
    public static final String MODIFY_DATE = "PROPERTY_MODIFY_DATE";
    public static final String FAILED_LOGON_COUNT = "PROPERTY_FAILED_LOGON_COUNT";
    public static final String LAST_FAILED_LOGON_DATE = "PROPERTY_LAST_FAILED_LOGON_DATE";
    public static final String SUCCESSFUL_LOGON_COUNT = "PROPERTY_SUCCESSFUL_LOGON_COUNT";
    public static final String LAST_SUCCESSFUL_LOGON_DATE = "PROPERTY_LAST_SUCCESSFUL_LOGON_DATE";
    public static final String VALID_FROM_DATE = "PROPERTY_VALID_FROM_DATE";
    public static final String VALID_TO_DATE = "PROPERTY_VALID_TO_DATE";
    public static final String LAST_CHANGED_PASSWORD_DATE = "PROPERTY_LAST_CHANGED_PASSWORD_DATE";
    public static final String FORCE_TO_CHANGE_PASSWORD = "PROPERTY_FORCE_TO_CHANGE_PASSWORD";
    public static final String LOCK_STATUS = "PROPERTY_LOCK_STATUS";
    protected static final String SEPARATOR = "_";
    private final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private byte[] password = null;
    private long[] property = new long[11];
    private int lockStatus = 0;
    private java.security.Principal principal = null;
    private UserContextImpl userContext = null;
    static long defaultExpiration = -1L;

    UserInfoImpl(Configuration config, boolean writeAccess) throws Exception {
        String path = config.getPath();
        this.principal = new Principal(path.substring(path.lastIndexOf(47) + 1));
        if (writeAccess) {
            this.property[0] = Calendar.getInstance().getTime().getTime();
            config.addConfigEntry(CREATE_DATE, new Long(this.property[0]));
            this.property[1] = Calendar.getInstance().getTime().getTime();
            config.addConfigEntry(MODIFY_DATE, new Long(this.property[1]));
            this.property[4] = 0L;
            config.addConfigEntry(SUCCESSFUL_LOGON_COUNT, new Long(this.property[4]));
            this.property[2] = 0L;
            config.addConfigEntry(FAILED_LOGON_COUNT, new Long(this.property[2]));
            this.property[10] = defaultExpiration;
            config.addConfigEntry(FORCE_TO_CHANGE_PASSWORD, new Long(this.property[10]));
            this.lockStatus = 0;
            config.addConfigEntry(LOCK_STATUS, new Integer(this.lockStatus));
        } else {
            this.password = (byte[])(config.existsConfigEntry(PASSWORD) ? (byte[])config.getConfigEntry(PASSWORD) : null);
            this.setProperty(CREATE_DATE, 1, config);
            this.setProperty(MODIFY_DATE, 2, config);
            this.setProperty(FAILED_LOGON_COUNT, 3, config);
            this.setProperty(LAST_FAILED_LOGON_DATE, 4, config);
            this.setProperty(SUCCESSFUL_LOGON_COUNT, 5, config);
            this.setProperty(LAST_SUCCESSFUL_LOGON_DATE, 6, config);
            this.setProperty(VALID_FROM_DATE, 7, config);
            this.setProperty(VALID_TO_DATE, 8, config);
            this.setProperty(LAST_CHANGED_PASSWORD_DATE, 10, config);
            this.setProperty(FORCE_TO_CHANGE_PASSWORD, 11, config);
            if (config.existsConfigEntry(LOCK_STATUS)) {
                this.lockStatus = (Integer)config.getConfigEntry(LOCK_STATUS);
            }
        }
    }

    private void setProperty(String propName, int propIndex, Configuration config) throws Exception {
        if (config.existsConfigEntry(propName)) {
            this.property[propIndex - 1] = (Long)config.getConfigEntry(propName);
        }
    }

    public java.security.Principal engineGetPrincipal() {
        return this.principal;
    }

    public String engineGetName() {
        return this.principal.getName();
    }

    public Iterator engineGetParentGroups() throws SecurityException {
        return this.userContext.engineGetParentGroups(this.principal.getName());
    }

    public X509Certificate[] engineGetCertificates() throws SecurityException {
        Vector<Certificate> certs = new Vector<Certificate>();
        try {
            KeystoreManagerWrapper keystore = UserStoreServiceFrame.getKeystoreInterface();
            if (keystore.existKeystoreView("DBMS_User_Store")) {
                KeyStore store = keystore.getKeystore("DBMS_User_Store");
                int size = store.size();
                int i = 0;
                while (i < size) {
                    String alias = this.principal.getName() + SEPARATOR + i;
                    Certificate certificate = store.getCertificate(alias);
                    if (certificate == null) break;
                    certs.add(certificate);
                    ++i;
                }
            }
            if (certs.size() > 0) {
                return certs.toArray(this.NO_CERTIFICATES);
            }
            return this.NO_CERTIFICATES;
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("userstore_0900", 400, (Throwable)e);
            bse.log();
            throw bse;
        }
    }

    public void engineSetPassword(char[] newPassword) throws SecurityException {
        this.engineWriteUserProperty(9, newPassword);
    }

    public void engineSetPassword(char[] oldPassword, char[] newPassword) throws SecurityException {
        if (!this.engineCheckPassword(oldPassword)) {
            throw new BaseSecurityException("userstore_0901");
        }
        ConfigurationHandler handler = null;
        Configuration configuration = null;
        if (newPassword != null) {
            handler = this.userContext.factory.getConfigurationHandler();
            try {
                try {
                    configuration = this.userContext.factory.getConfiguration("filter/password", false, handler);
                    if (!this.userContext.filterStorage.getFilterPassword(configuration).filterPassword(newPassword)) {
                        throw new BaseSecurityException("userstore_0902");
                    }
                    Object var8_5 = null;
                }
                catch (SecurityException e) {
                    if (e instanceof IBaseException) {
                        throw e;
                    }
                    throw new BaseSecurityException("userstore_0903", e);
                }
                catch (Exception e) {
                    throw new BaseSecurityException("userstore_0904", e);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                this.userContext.factory.close(configuration, handler);
                throw throwable;
            }
            this.userContext.factory.close(configuration, handler);
            char[] targetpassword = newPassword;
            byte[] tocompare = new byte[targetpassword.length];
            int i = 0;
            while (i < tocompare.length) {
                tocompare[i] = (byte)targetpassword[i];
                ++i;
            }
            this.password = this.userContext.encode(tocompare);
        } else {
            this.password = null;
        }
        this.property[9] = System.currentTimeMillis();
        handler = this.userContext.factory.getConfigurationHandler();
        configuration = null;
        UserStoreServiceFrame.lock(this.userContext.getLocker() + "users");
        try {
            try {
                configuration = this.userContext.factory.getConfiguration("users/" + this.engineGetName(), true, handler);
                if (this.password == null) {
                    if (configuration.existsConfigEntry(PASSWORD)) {
                        configuration.deleteConfigEntry(PASSWORD);
                    }
                } else if (configuration.existsConfigEntry(PASSWORD)) {
                    configuration.modifyConfigEntry(PASSWORD, this.password);
                } else {
                    configuration.addConfigEntry(PASSWORD, this.password);
                }
                configuration.modifyConfigEntry(LAST_CHANGED_PASSWORD_DATE, new Long(this.property[9]));
                this.userContext.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.userContext.factory.rollback(configuration, handler);
                throw new BaseSecurityException("userstore_0930", new Object[]{this.engineGetName()}, (Throwable)e);
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            UserStoreServiceFrame.releaseLock(this.userContext.getLocker() + "users");
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.userContext.getLocker() + "users");
    }

    public void engineSetCertificates(X509Certificate[] certificates) throws SecurityException {
        try {
            KeystoreManagerWrapper keystore = UserStoreServiceFrame.getKeystoreInterface();
            if (!keystore.existKeystoreView("DBMS_User_Store")) {
                keystore.createKeystoreView("DBMS_User_Store", new Properties());
            }
            X509Certificate[] certs = this.engineGetCertificates();
            KeyStore store = keystore.getKeystore("DBMS_User_Store");
            int i = 0;
            while (i < certificates.length) {
                int j = 0;
                while (j < certs.length) {
                    if (certs[j].equals(certificates[i])) break;
                    ++j;
                }
                if (j >= certs.length) {
                    Enumeration<String> aliases = store.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        Certificate cert = store.getCertificate(alias);
                        if (cert == null || !(cert instanceof X509Certificate) || !cert.equals(certificates[i])) continue;
                        throw new BaseSecurityException("userstore_0905");
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < certs.length) {
                store.deleteEntry(store.getCertificateAlias(certs[i2]));
                ++i2;
            }
            int i3 = 0;
            int j = 0;
            while (i3 < certificates.length) {
                if (certificates[i3] != null) {
                    store.setCertificateEntry(this.principal.getName() + SEPARATOR + j, certificates[i3]);
                    ++j;
                }
                ++i3;
            }
        }
        catch (SecurityException e) {
            UserStoreServiceFrame.logWarning("Cannot asign cerificate to user " + this.principal.getName(), e);
            if (e instanceof IBaseException) {
                throw e;
            }
            throw new BaseSecurityException("userstore_0906", new Object[]{this.principal.getName()}, (Throwable)e);
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("userstore_0907", 400, new Object[]{this.principal.getName()}, e);
            bse.log();
            throw bse;
        }
    }

    public Object engineReadUserProperty(int userProperty) throws SecurityException {
        if (this.userContext == null) {
            return null;
        }
        switch (userProperty) {
            case 9: {
                if (this.password == null) {
                    return null;
                }
                try {
                    byte[] read = this.userContext.decode(this.password);
                    char[] decodedPassword = new char[read.length];
                    int i = 0;
                    while (i < read.length) {
                        decodedPassword[i] = (char)read[i];
                        ++i;
                    }
                    return decodedPassword;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 11: {
                if (this.property[10] == -1L) {
                    this.property[10] = 315360000000L;
                }
                return new Long(this.property[10]);
            }
            case 10: {
                long time = this.property[9];
                if (time == 0L) {
                    return null;
                }
                Date date = new Date(time);
                return date;
            }
            case 1: {
                long time = this.property[0];
                if (time == 0L) {
                    return null;
                }
                Date date = new Date(time);
                return date;
            }
            case 2: {
                long time = this.property[1];
                if (time == 0L) {
                    return null;
                }
                Date date = new Date(time);
                return date;
            }
            case 4: {
                long time = this.property[3];
                if (time == 0L) {
                    return null;
                }
                Date date = new Date(time);
                return date;
            }
            case 6: {
                long time = this.property[5];
                if (time == 0L) {
                    return null;
                }
                Date date = new Date(time);
                return date;
            }
            case 5: {
                int count = (int)this.property[4];
                return new Integer(count);
            }
            case 3: {
                int count = (int)this.property[2];
                return new Integer(count);
            }
            case 12: {
                return new Integer(this.lockStatus);
            }
        }
        return this.readUnknownProperty(userProperty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineWriteUserProperty(int userProperty, Object value) throws SecurityException {
        ConfigurationHandler handler = this.userContext.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.userContext.getLocker() + "users");
        try {
            try {
                configuration = this.userContext.factory.getConfiguration("users/" + this.engineGetName(), true, handler);
                if (userProperty == 9) {
                    if (value != null) {
                        if (!(value instanceof char[])) {
                            throw new BaseSecurityException("userstore_0908");
                        }
                        ConfigurationHandler handlerToFilter = this.userContext.factory.getConfigurationHandler();
                        Configuration filterContainer = null;
                        try {
                            try {
                                filterContainer = this.userContext.factory.getConfiguration("filter/password", false, handlerToFilter);
                                if (!this.userContext.filterStorage.getFilterPassword(filterContainer).filterPassword((char[])value)) {
                                    throw new BaseSecurityException("userstore_0909");
                                }
                                Object var9_11 = null;
                            }
                            catch (Exception e) {
                                if (!(e instanceof BaseSecurityException)) throw new BaseSecurityException("userstore_0910", e);
                                throw (SecurityException)e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            this.userContext.factory.close(filterContainer, handlerToFilter);
                            throw throwable;
                        }
                        this.userContext.factory.close(filterContainer, handlerToFilter);
                        char[] targetpassword = (char[])value;
                        byte[] tocompare = new byte[targetpassword.length];
                        int i = 0;
                        while (i < tocompare.length) {
                            tocompare[i] = (byte)targetpassword[i];
                            ++i;
                        }
                        this.password = this.userContext.encode(tocompare);
                        if (configuration.existsConfigEntry(PASSWORD)) {
                            configuration.modifyConfigEntry(PASSWORD, this.password);
                        } else {
                            configuration.addConfigEntry(PASSWORD, this.password);
                        }
                    } else {
                        this.password = null;
                        if (configuration.existsConfigEntry(PASSWORD)) {
                            configuration.deleteConfigEntry(PASSWORD);
                        }
                    }
                    this.property[9] = 0L;
                    if (configuration.existsConfigEntry(LAST_CHANGED_PASSWORD_DATE)) {
                        configuration.modifyConfigEntry(LAST_CHANGED_PASSWORD_DATE, new Long(this.property[9]));
                    } else {
                        configuration.addConfigEntry(LAST_CHANGED_PASSWORD_DATE, new Long(this.property[9]));
                    }
                } else if (userProperty == 11) {
                    long expiration = -1L;
                    if (value instanceof Long) {
                        expiration = (Long)value;
                    } else {
                        if (!(value instanceof String)) throw new BaseSecurityException("userstore_0911");
                        expiration = Long.parseLong((String)value);
                    }
                    if (expiration < -1L) {
                        throw new BaseSecurityException("userstore_0912");
                    }
                    this.property[10] = expiration;
                    if (configuration.existsConfigEntry(FORCE_TO_CHANGE_PASSWORD)) {
                        configuration.modifyConfigEntry(FORCE_TO_CHANGE_PASSWORD, new Long(this.property[10]));
                    } else {
                        configuration.addConfigEntry(FORCE_TO_CHANGE_PASSWORD, new Long(this.property[10]));
                    }
                } else if (userProperty == 3 || userProperty == 5) {
                    if (!(value instanceof Integer)) throw new BaseIllegalArgumentException("userstore_0913", new Object[]{new Integer(userProperty)});
                    this.property[userProperty - 1] = ((Integer)value).intValue();
                    configuration.modifyConfigEntry(userProperty == 3 ? FAILED_LOGON_COUNT : SUCCESSFUL_LOGON_COUNT, new Long(this.property[userProperty - 1]));
                } else if (userProperty == 4 || userProperty == 6) {
                    if (!(value instanceof Date)) throw new BaseIllegalArgumentException("userstore_0914", new Object[]{new Integer(userProperty)});
                    this.property[userProperty - 1] = ((Date)value).getTime();
                    if (configuration.existsConfigEntry(userProperty == 4 ? LAST_FAILED_LOGON_DATE : LAST_SUCCESSFUL_LOGON_DATE)) {
                        configuration.modifyConfigEntry(userProperty == 4 ? LAST_FAILED_LOGON_DATE : LAST_SUCCESSFUL_LOGON_DATE, new Long(this.property[userProperty - 1]));
                    } else {
                        configuration.addConfigEntry(userProperty == 4 ? LAST_FAILED_LOGON_DATE : LAST_SUCCESSFUL_LOGON_DATE, new Long(this.property[userProperty - 1]));
                    }
                } else if (userProperty == 12) {
                    if (!(value instanceof Integer)) throw new BaseIllegalArgumentException("userstore_0919");
                    if ((Integer)value < 0 || (Integer)value > 2) {
                        throw new BaseIllegalArgumentException("userstore_0920");
                    }
                    int lock = (Integer)value;
                    if (lock != this.lockStatus) {
                        this.lockStatus = lock;
                        if (this.lockStatus == 0) {
                            this.property[2] = 0L;
                        }
                        configuration.modifyConfigEntry(LOCK_STATUS, value);
                    }
                } else {
                    String propEntry = "" + userProperty;
                    if (configuration.existsConfigEntry(propEntry)) {
                        configuration.modifyConfigEntry(propEntry, value.toString());
                    } else {
                        configuration.addConfigEntry(propEntry, value.toString());
                    }
                }
                this.userContext.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.userContext.factory.rollback(configuration, handler);
                if (!(e instanceof BaseSecurityException)) throw new BaseSecurityException("userstore_0931", e);
                throw (BaseSecurityException)e;
            }
            Object var11_18 = null;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            UserStoreServiceFrame.releaseLock(this.userContext.getLocker() + "users");
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.userContext.getLocker() + "users");
    }

    public boolean engineCheckUserProperty(int userProperty, Object value) throws SecurityException {
        if (userProperty == 9) {
            try {
                char[] targetpassword = (char[])value;
                byte[] tocompare = new byte[targetpassword.length];
                int i = 0;
                while (i < tocompare.length) {
                    tocompare[i] = (byte)targetpassword[i];
                    ++i;
                }
                return this.userContext.equals(this.password, this.userContext.encode(tocompare));
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new BaseSecurityException("userstore_0918");
    }

    public boolean engineCheckPassword(char[] targetPassword) throws SecurityException {
        if (this.password == null && targetPassword == null) {
            return true;
        }
        try {
            byte[] tocompare = new byte[targetPassword.length];
            int i = 0;
            while (i < tocompare.length) {
                tocompare[i] = (byte)targetPassword[i];
                ++i;
            }
            return this.userContext.equals(this.password, this.userContext.encode(tocompare));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void setUserContext(UserContextImpl userContext) {
        this.userContext = userContext;
    }

    public String toString() {
        String result = "User ID:      " + this.engineGetName();
        result = result + "\nParent Groups: ";
        Iterator parents = this.engineGetParentGroups();
        while (parents.hasNext()) {
            result = result + (String)parents.next();
            if (!parents.hasNext()) continue;
            result = result + "\n               ";
        }
        result = result + "\n";
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readUnknownProperty(int userProperty) {
        ConfigurationHandler handler = null;
        Configuration configuration = null;
        boolean exception = true;
        do {
            Object var8_7;
            Object object;
            try {
                try {
                    handler = this.userContext.factory.getConfigurationHandler();
                    configuration = this.userContext.factory.getConfiguration("users/" + this.engineGetName(), false, handler);
                    object = configuration.getConfigEntry("" + userProperty);
                    var8_7 = null;
                }
                catch (InconsistentReadException ire) {
                    var8_7 = null;
                    this.userContext.factory.close(configuration, handler);
                    continue;
                }
                catch (Exception e) {
                    UserStoreServiceFrame.logWarning("Cannot read \"" + this.engineGetName() + "\" user's property [" + userProperty + "].", e);
                    var8_7 = null;
                    this.userContext.factory.close(configuration, handler);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.userContext.factory.close(configuration, handler);
                throw throwable;
            }
            this.userContext.factory.close(configuration, handler);
            return object;
        } while (exception);
        return null;
    }
}

