/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.interfaces.security.CryptographyContext;
import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.UserListener;
import com.sap.engine.interfaces.security.userstore.spi.FilterPassword;
import com.sap.engine.interfaces.security.userstore.spi.FilterUsername;
import com.sap.engine.interfaces.security.userstore.spi.UserContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.UserInfoSpi;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.userstore.ConfigurationFactory;
import com.sap.engine.services.userstore.PropertiesParser;
import com.sap.engine.services.userstore.TreeManager;
import com.sap.engine.services.userstore.UserInfoImpl;
import com.sap.engine.services.userstore.UserStoreServiceFrame;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.engine.services.userstore.filter.FilterPasswordImpl;
import com.sap.engine.services.userstore.filter.FilterStorage;
import com.sap.engine.services.userstore.filter.FilterUsernameImpl;
import com.sap.engine.services.userstore.search.SearchFilterImpl;
import com.sap.engine.services.userstore.search.UserSearchResultImpl;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class UserContextImpl
implements UserContextSpi {
    public static final int PROPERTY_PASSWORD = 9;
    protected ConfigurationFactory factory = new ConfigurationFactory();
    protected TreeManager treeManager = new TreeManager(this.factory);
    protected FilterStorage filterStorage = new FilterStorage();
    public static final String USERS_CONFIG_PATH = "users";
    public static final String CONFIG_PATH = "configuration.path";
    private String configPath = null;
    private String locker = "";
    private MessageDigest digest = null;
    private CryptographyContext crypt = null;
    protected boolean retrievePasswords = false;
    protected int lock_after_invalid_attempts = 3;
    private String anonymousUserName = null;
    static /* synthetic */ Class class$com$sap$engine$lib$security$Principal;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public void setLocker(String lock) {
        this.locker = lock != null && lock.length() > 0 ? lock : "";
    }

    public String getLocker() {
        return this.locker;
    }

    public synchronized void enginePropertiesChanged(Properties newProps) {
        String propPassword = newProps.getProperty("RETRIEVE_PASSWORDS");
        if (propPassword != null) {
            this.retrievePasswords = propPassword.equals("true");
        }
        try {
            this.lock_after_invalid_attempts = Integer.parseInt(newProps.getProperty("LOCK_AFTER_INVALID_ATTEMPTS"));
        }
        catch (Exception _) {
            this.lock_after_invalid_attempts = 3;
        }
        String expirationPasswords = newProps.getProperty("EXPIRATION_PASSWORDS");
        try {
            UserInfoImpl.defaultExpiration = Long.parseLong(expirationPasswords);
        }
        catch (Exception ex) {
            UserInfoImpl.defaultExpiration = -1L;
        }
        this.configPath = newProps.getProperty(CONFIG_PATH);
        if (this.configPath != null && this.configPath.length() > 0) {
            this.factory.setPath(this.configPath);
        }
        this.anonymousUserName = newProps.getProperty("anonymous-user");
        String[][] users = (String[][])PropertiesParser.parseUsersAndGroups(newProps).elementAt(0);
        ConfigurationHandler configHandler = this.factory.getConfigurationHandler();
        Configuration rootConfiguration = null;
        this.setLocker(this.configPath);
        UserStoreServiceFrame.lock(this.locker);
        UserStoreServiceFrame.lock(this.locker + USERS_CONFIG_PATH);
        try {
            try {
                rootConfiguration = this.factory.createRootConfiguration(configHandler);
                rootConfiguration.createSubConfiguration(USERS_CONFIG_PATH);
                Configuration filterConfiguration = rootConfiguration.createSubConfiguration("filter");
                new FilterUsernameImpl(filterConfiguration.createSubConfiguration("filter/username".substring("filter/username".indexOf("/") + 1)), true);
                new FilterPasswordImpl(filterConfiguration.createSubConfiguration("filter/password".substring("filter/password".indexOf("/") + 1)), true);
                this.setInitialUsers(users, rootConfiguration);
                this.factory.commit(rootConfiguration, configHandler);
            }
            catch (NameAlreadyExistsException _) {
                this.factory.rollback(rootConfiguration, configHandler);
                Object var11_12 = null;
                UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
                UserStoreServiceFrame.releaseLock(this.locker);
                return;
            }
            catch (Exception e) {
                this.factory.rollback(rootConfiguration, configHandler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0821", e);
                bse.log();
                throw bse;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
            UserStoreServiceFrame.releaseLock(this.locker);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
        UserStoreServiceFrame.releaseLock(this.locker);
    }

    private void setInitialUsers(String[][] users, Configuration config) throws Exception {
        this.factory.setTransactionAttribute(config);
        try {
            int i = 0;
            while (i < users.length) {
                block11: {
                    try {
                        this.engineGetUserInfo(users[i][0]);
                    }
                    catch (SecurityException se) {
                        UserInfoSpi spi = null;
                        try {
                            spi = this.engineCreateUser(users[i][0]);
                            spi.engineWriteUserProperty(9, users[i][1].toCharArray());
                        }
                        catch (Exception e) {
                            UserStoreServiceFrame.logWarning("Cannot create user \"" + users[i][0] + "\".", e);
                        }
                        if (spi == null || users[i][3] == null || !users[i][3].equals("true")) break block11;
                        try {
                            spi.engineWriteUserProperty(12, new Integer(2));
                        }
                        catch (SecurityException e) {
                            throw new BaseSecurityException("userstore_0817", new Object[]{users[i][0]}, (Throwable)e);
                        }
                    }
                }
                ++i;
            }
            Object var8_8 = null;
            this.factory.setTransactionAttribute(null);
            if (this.configPath != null && this.configPath.length() > 0) {
                this.factory.setPath(this.configPath);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.factory.setTransactionAttribute(null);
            if (this.configPath != null && this.configPath.length() > 0) {
                this.factory.setPath(this.configPath);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetParentGroups(String userName) throws SecurityException {
        ConfigurationHandler handler = null;
        Configuration configuration = null;
        boolean exception = true;
        do {
            Object var8_7;
            Iterator iterator;
            try {
                try {
                    handler = this.factory.getConfigurationHandler();
                    configuration = this.factory.getConfiguration("users/" + userName, false, handler);
                    iterator = this.treeManager.getParents(userName, configuration);
                    var8_7 = null;
                }
                catch (InconsistentReadException ire) {
                    var8_7 = null;
                    this.factory.close(configuration, handler);
                    continue;
                }
                catch (Exception e) {
                    throw new BaseSecurityException("userstore_0800", e);
                }
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.factory.close(configuration, handler);
                throw throwable;
            }
            this.factory.close(configuration, handler);
            return iterator;
        } while (exception);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListUsers() throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration(USERS_CONFIG_PATH, false, handler);
                iterator = configuration.getAllSubConfigurations().keySet().iterator();
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0801", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    public SearchResult engineSearchUsers(SearchFilter filter) throws SecurityException {
        int resultSize = filter.getMaxSearchResultSize();
        Iterator attributes = filter.getSearchAttributes();
        if (attributes.hasNext()) {
            return new UserSearchResultImpl(this, attributes, resultSize);
        }
        throw new BaseSecurityException("userstore_2000");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListRootUsers() {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration(USERS_CONFIG_PATH, false, handler);
                iterator = this.treeManager.listRoots(configuration);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0802", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInfoSpi engineGetUserInfo(String userName) throws SecurityException {
        ConfigurationHandler handler = null;
        Configuration configuration = null;
        boolean exception = true;
        do {
            Object var8_7;
            UserInfoImpl userInfoImpl;
            try {
                try {
                    handler = this.factory.getConfigurationHandler();
                    configuration = this.factory.getConfiguration("users/" + userName, false, handler);
                    UserInfoImpl info = new UserInfoImpl(configuration, false);
                    info.setUserContext(this);
                    userInfoImpl = info;
                    var8_7 = null;
                }
                catch (InconsistentReadException ire) {
                    var8_7 = null;
                    this.factory.close(configuration, handler);
                    continue;
                }
                catch (Exception e) {
                    throw new BaseSecurityException("userstore_0803", e);
                }
            }
            catch (Throwable throwable) {
                var8_7 = null;
                this.factory.close(configuration, handler);
                throw throwable;
            }
            this.factory.close(configuration, handler);
            return userInfoImpl;
        } while (exception);
        return null;
    }

    public UserInfoSpi engineGetUserInfo(X509Certificate cert) throws SecurityException {
        String alias = null;
        try {
            alias = UserStoreServiceFrame.getKeystoreInterface().findAlias("DBMS_User_Store", new KeyStoreEntry(cert));
        }
        catch (Exception e) {
            BaseSecurityException bse = new BaseSecurityException("userstore_0805", new Object[]{"DBMS_User_Store"}, (Throwable)e);
            throw bse;
        }
        if (alias != null) {
            return this.engineGetUserInfo(alias.substring(0, alias.lastIndexOf("_")));
        }
        throw new BaseSecurityException("userstore_0804");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInfoSpi engineCreateUser(String userName) throws SecurityException {
        UserInfoImpl userInfoImpl;
        Configuration configuration;
        ConfigurationHandler handler;
        block10: {
            block9: {
                handler = this.factory.getConfigurationHandler();
                configuration = null;
                try {
                    try {
                        configuration = this.factory.getConfiguration("filter/username", false, handler);
                        if (!this.filterStorage.getFilterUsername(configuration).filterUsername(userName)) {
                            throw new BaseSecurityException("userstore_0806", new Object[]{userName});
                        }
                        userInfoImpl = null;
                        break block9;
                    }
                    catch (NameNotFoundException e) {
                        UserStoreServiceFrame.logError("No configuration of user name filter found!");
                        userInfoImpl = null;
                        this.factory.close(configuration, handler);
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.factory.close(configuration, handler);
                    throw throwable;
                }
            }
            this.factory.close(configuration, handler);
        }
        handler = this.factory.getConfigurationHandler();
        UserStoreServiceFrame.lock(this.locker + USERS_CONFIG_PATH);
        try {
            try {
                configuration = this.factory.getConfiguration(USERS_CONFIG_PATH, true, handler);
                Configuration userConfiguration = configuration.createSubConfiguration(userName);
                UserInfoImpl info = new UserInfoImpl(userConfiguration, true);
                this.treeManager.createUser(userName, true, userConfiguration);
                this.factory.commit(configuration, handler);
                info.setUserContext(this);
                UserStoreServiceFrame.logNotice("User \"" + userName + "\" created successfully.");
                userInfoImpl = info;
                Object var8_12 = null;
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0807", 400, new Object[]{userName}, e);
                bse.log();
                throw bse;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
        return userInfoImpl;
    }

    public void engineDeleteUser(String userName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + USERS_CONFIG_PATH);
        UserStoreServiceFrame.lock(this.locker + "groups");
        try {
            try {
                this.engineGetUserInfo(userName).engineSetCertificates(new X509Certificate[0]);
                configuration = this.factory.getConfiguration("users/" + userName, true, handler);
                Iterator parents = this.treeManager.getParents(userName, configuration);
                this.treeManager.ungroupUser(userName, true, parents, handler);
                configuration.deleteConfiguration();
                this.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0808", 400, new Object[]{userName}, e);
                bse.log();
                throw bse;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            UserStoreServiceFrame.releaseLock(this.locker + "groups");
            UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + "groups");
        UserStoreServiceFrame.releaseLock(this.locker + USERS_CONFIG_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilterUsername engineGetFilterUsername() throws SecurityException {
        FilterUsername filterUsername;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("filter/username", false, handler);
                filterUsername = this.filterStorage.getFilterUsername(configuration);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0809", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return filterUsername;
    }

    public void engineSetFilterUsername(FilterUsername filterUsername) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            configuration = this.factory.getConfiguration("filter/username", true, handler);
            this.filterStorage.setFilterUsername(filterUsername, configuration);
            this.factory.commit(configuration, handler);
            UserStoreServiceFrame.logNotice("FilterUsername stored successfully.");
        }
        catch (Exception e) {
            this.factory.rollback(configuration, handler);
            BaseSecurityException bse = new BaseSecurityException("userstore_0810", e);
            bse.log();
            throw bse;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilterPassword engineGetFilterPassword() throws SecurityException {
        FilterPassword filterPassword;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("filter/password", false, handler);
                filterPassword = this.filterStorage.getFilterPassword(configuration);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0811", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return filterPassword;
    }

    public void engineSetFilterPassword(FilterPassword filterPassword) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            configuration = this.factory.getConfiguration("filter/password", true, handler);
            this.filterStorage.setFilterPassword(filterPassword, configuration);
            this.factory.commit(configuration, handler);
            UserStoreServiceFrame.logNotice("FilterPassword saved successfully.");
        }
        catch (Exception e) {
            this.factory.rollback(configuration, handler);
            BaseSecurityException bse = new BaseSecurityException("userstore_0812", e);
            bse.log();
            throw bse;
        }
    }

    public boolean engineIsUserPropertySupported(int userProperty, int operation) throws SecurityException {
        switch (userProperty) {
            case 1: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 2: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 3: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 4: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 5: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 6: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 7: {
                return false;
            }
            case 8: {
                return false;
            }
            case 9: {
                if (operation == 2 || operation == 3) {
                    return true;
                }
                return this.retrievePasswords;
            }
            case 10: {
                return operation == 1 || operation == 3 || operation == 2;
            }
            case 11: {
                return true;
            }
            case 12: {
                return operation == 1 || operation == 2;
            }
        }
        return true;
    }

    public void engineRegisterListener(UserListener userListener, int modifier) throws SecurityException {
        throw new BaseSecurityException("userstore_0813");
    }

    public void engineUnregisterListener(UserListener userlistener) throws SecurityException {
        throw new BaseSecurityException("userstore_0814");
    }

    public boolean engineIsSubjectRetrievalSupported() {
        return true;
    }

    public long engineFillSubject(UserInfoSpi user, Subject subject) throws SecurityException {
        if (this.retrievePasswords) {
            ((UserInfoImpl)user).setUserContext(this);
            char[] password = (char[])user.engineReadUserProperty(9);
            PasswordCredential credential = new PasswordCredential(user.engineGetName(), password);
            subject.getPrivateCredentials().add(credential);
        }
        subject.getPrincipals().add(user.engineGetPrincipal());
        return Long.MAX_VALUE;
    }

    public void engineEmptySubject(Subject subject) throws SecurityException {
        try {
            Iterator principals = subject.getPrincipals(class$com$sap$engine$lib$security$Principal == null ? (class$com$sap$engine$lib$security$Principal = UserContextImpl.class$("com.sap.engine.lib.security.Principal")) : class$com$sap$engine$lib$security$Principal).iterator();
            while (principals.hasNext()) {
                principals.next();
                principals.remove();
            }
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to remove credentials from subject", e);
        }
        try {
            Iterator privateCredentials = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = UserContextImpl.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential).iterator();
            while (privateCredentials.hasNext()) {
                privateCredentials.next();
                privateCredentials.remove();
            }
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to remove credentials from subject", e);
        }
    }

    public int engineGetLockAfterInvalidAttempts() {
        return this.lock_after_invalid_attempts;
    }

    public boolean engineIsInEmergencyMode() {
        return false;
    }

    public boolean engineIsEmergencyUser(String userName) {
        return false;
    }

    public String engineGetEmergencyUserName() {
        return null;
    }

    public SearchFilter engineGetSearchFilter() {
        return new SearchFilterImpl();
    }

    public void engineRefresh(String userName) {
    }

    public String engineGetAnonymousUserName() {
        if (this.anonymousUserName == null || this.anonymousUserName.trim().equals("")) {
            throw new BaseSecurityException("userstore_2001");
        }
        return this.anonymousUserName;
    }

    protected byte[] encode(byte[] toencode) {
        if (this.retrievePasswords) {
            try {
                if (this.crypt == null) {
                    this.crypt = UserStoreServiceFrame.getSecurityContext().getCryptographyContext();
                }
                Cipher encodeCipher = this.crypt.getCipher(1);
                return encodeCipher.doFinal(toencode);
            }
            catch (Exception e) {
                return UserContextImpl.symmetricEncode(toencode, (byte)toencode.length);
            }
        }
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException se) {
                return toencode;
            }
        }
        MessageDigest messageDigest = this.digest;
        synchronized (messageDigest) {
            byte[] byArray = this.digest.digest(toencode);
            return byArray;
        }
    }

    protected byte[] decode(byte[] todecode) {
        if (this.retrievePasswords) {
            try {
                if (this.crypt == null) {
                    this.crypt = UserStoreServiceFrame.getSecurityContext().getCryptographyContext();
                }
                Cipher decodeCipher = this.crypt.getCipher(2);
                return decodeCipher.doFinal(todecode);
            }
            catch (Exception e) {
                return UserContextImpl.symmetricDecode(todecode, (byte)todecode.length);
            }
        }
        throw new BaseSecurityException("userstore_0816");
    }

    protected boolean equals(byte[] arr1, byte[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null && arr2 != null || arr1 != null && arr2 == null || arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] != arr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] symmetricEncode(byte[] toencode, byte key) {
        byte[] result = new byte[toencode.length];
        int i = 0;
        while (i < toencode.length) {
            result[i] = (byte)(key ^ toencode[i]);
            key = result[i];
            ++i;
        }
        return result;
    }

    private static byte[] symmetricDecode(byte[] todecode, byte key) {
        byte[] result = new byte[todecode.length];
        int i = 0;
        while (i < todecode.length) {
            result[i] = (byte)(key ^ todecode[i]);
            key = todecode[i];
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

