/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.services.userstore.ConfigurationFactory;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class TreeManager {
    public static final String PARENT_GROUPS_CONTAINER = "parent.groups";
    public static final String CHILD_GROUPS_CONTAINER = "child.groups";
    public static final String CHILD_USERS_CONTAINER = "child.users";
    private ConfigurationFactory factory = null;

    public TreeManager(ConfigurationFactory factory) {
        this.factory = factory;
    }

    public void createUser(String user, boolean isUser, Configuration config) throws Exception {
        config.createSubConfiguration(PARENT_GROUPS_CONTAINER);
        if (!isUser) {
            config.createSubConfiguration(CHILD_GROUPS_CONTAINER);
            config.createSubConfiguration(CHILD_USERS_CONTAINER);
        }
    }

    public Iterator getChildUsers(String node, Configuration config) throws Exception {
        return config.getSubConfiguration(CHILD_USERS_CONTAINER).getAllConfigEntries().keySet().iterator();
    }

    public Iterator getChildGroups(String node, Configuration config) throws Exception {
        return config.getSubConfiguration(CHILD_GROUPS_CONTAINER).getAllConfigEntries().keySet().iterator();
    }

    public Iterator listRoots(Configuration config) throws Exception {
        Vector<String> roots = new Vector<String>();
        String[] allNodes = config.getAllSubConfigurationNames();
        int i = 0;
        while (i < allNodes.length) {
            if (!this.getParents(allNodes[i], config.getSubConfiguration(allNodes[i])).hasNext()) {
                roots.addElement(allNodes[i]);
            }
            ++i;
        }
        return ((AbstractList)roots).iterator();
    }

    public Iterator getParents(String node, Configuration config) throws Exception {
        return config.getSubConfiguration(PARENT_GROUPS_CONTAINER).getAllConfigEntries().keySet().iterator();
    }

    public void groupUser(String user, boolean isUser, String parent, ConfigurationHandler handler) throws Exception {
        if (!isUser) {
            this.checkCycle(user, parent);
        }
        String path = "groups/" + parent + "/" + (isUser ? CHILD_USERS_CONTAINER : CHILD_GROUPS_CONTAINER);
        this.factory.getConfiguration(path, true, handler).addConfigEntry(user, "");
        path = (isUser ? "users" : "groups") + "/" + user + "/" + PARENT_GROUPS_CONTAINER;
        this.factory.getConfiguration(path, true, handler).addConfigEntry(parent, "");
    }

    public void ungroupUser(String user, boolean isUser, String parent, ConfigurationHandler handler) throws Exception {
        String path = "groups/" + parent + "/" + (isUser ? CHILD_USERS_CONTAINER : CHILD_GROUPS_CONTAINER);
        this.factory.getConfiguration(path, true, handler).deleteConfigEntry(user);
        path = (isUser ? "users" : "groups") + "/" + user + "/" + PARENT_GROUPS_CONTAINER;
        this.factory.getConfiguration(path, true, handler).deleteConfigEntry(parent);
    }

    public void ungroupUser(String user, boolean isUser, Iterator parents, ConfigurationHandler handler) throws Exception {
        String path = null;
        while (parents.hasNext()) {
            path = "groups/" + parents.next() + "/" + (isUser ? CHILD_USERS_CONTAINER : CHILD_GROUPS_CONTAINER);
            this.factory.getConfiguration(path, true, handler).deleteConfigEntry(user);
        }
    }

    private void checkCycle(String child, String parent) throws Exception {
        if (child.equals(parent)) {
            throw new Exception("Cycle found!");
        }
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration config = null;
        String[] parents = null;
        try {
            config = this.factory.getConfiguration("groups/" + parent + "/" + PARENT_GROUPS_CONTAINER, false, handler);
            parents = config.getAllConfigEntryNames();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.factory.close(config, handler);
            throw throwable;
        }
        this.factory.close(config, handler);
        if (parents != null) {
            int i = 0;
            while (i < parents.length) {
                this.checkCycle(child, parents[i]);
                ++i;
            }
        }
    }
}

