/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.interfaces.security.userstore.spi.GroupInfoSpi;
import com.sap.engine.services.userstore.GroupContextImpl;
import java.util.Iterator;

public class GroupInfoImpl
implements GroupInfoSpi {
    private String name = null;
    private GroupContextImpl groupContext = null;

    public GroupInfoImpl(Configuration config) {
        String path = config.getPath();
        this.name = path.substring(path.lastIndexOf(47) + 1);
    }

    public String engineGetName() {
        return this.name;
    }

    public Iterator engineGetParentGroups() {
        return this.groupContext.engineGetParentGroups(this.name);
    }

    public Iterator engineGetChildGroups() {
        return this.groupContext.engineGetChildGroups(this.name);
    }

    public Iterator engineGetUsersInGroup() {
        return this.groupContext.engineGetUsersOfGroup(this.name);
    }

    public String toString() {
        String result = "Group ID:      " + this.engineGetName();
        result = result + "\nUsers:         ";
        Iterator users = this.engineGetUsersInGroup();
        while (users.hasNext()) {
            result = result + (String)users.next();
            if (!users.hasNext()) continue;
            result = result + "\n               ";
        }
        result = result + "\nChild Groups:  ";
        Iterator children = this.engineGetChildGroups();
        while (children.hasNext()) {
            result = result + (String)children.next();
            if (!children.hasNext()) continue;
            result = result + "\n               ";
        }
        result = result + "\nParent Groups: ";
        Iterator parents = this.engineGetParentGroups();
        while (parents.hasNext()) {
            result = result + (String)parents.next();
            if (!parents.hasNext()) continue;
            result = result + "\n               ";
        }
        result = result + "\n";
        return result;
    }

    protected void setGroupContext(GroupContextImpl groupContext) {
        this.groupContext = groupContext;
    }
}

