/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.interfaces.security.userstore.context.SearchResult;
import com.sap.engine.interfaces.security.userstore.listener.GroupListener;
import com.sap.engine.interfaces.security.userstore.spi.GroupContextSpi;
import com.sap.engine.interfaces.security.userstore.spi.GroupInfoSpi;
import com.sap.engine.services.userstore.ConfigurationFactory;
import com.sap.engine.services.userstore.GroupInfoImpl;
import com.sap.engine.services.userstore.PropertiesParser;
import com.sap.engine.services.userstore.TreeManager;
import com.sap.engine.services.userstore.UserStoreServiceFrame;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.engine.services.userstore.search.GroupSearchResultImpl;
import com.sap.engine.services.userstore.search.SearchFilterImpl;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class GroupContextImpl
implements GroupContextSpi {
    private ConfigurationFactory factory = new ConfigurationFactory();
    private TreeManager treeManager = new TreeManager(this.factory);
    public static final String GROUPS_CONFIG_PATH = "groups";
    public static final String CONFIG_PATH = "configuration.path";
    private String configPath = null;
    private String locker = "";

    public void setLocker(String lock) {
        this.locker = lock != null && lock.length() > 0 ? lock : "";
    }

    public String getLocker() {
        return this.locker;
    }

    public synchronized void enginePropertiesChanged(Properties newProps) {
        this.configPath = newProps.getProperty(CONFIG_PATH);
        if (this.configPath != null && this.configPath.length() > 0) {
            this.factory.setPath(this.configPath);
        }
        Vector users_and_groups = PropertiesParser.parseUsersAndGroups(newProps);
        ConfigurationHandler configHandler = this.factory.getConfigurationHandler();
        Configuration rootConfiguration = null;
        this.setLocker(this.configPath);
        UserStoreServiceFrame.lock(this.locker);
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        try {
            try {
                rootConfiguration = this.factory.createRootConfiguration(configHandler);
                rootConfiguration.createSubConfiguration(GROUPS_CONFIG_PATH);
                this.setInitialGroups((String[][])users_and_groups.elementAt(0), (String[][])users_and_groups.elementAt(1), rootConfiguration);
                this.factory.commit(rootConfiguration, configHandler);
            }
            catch (NameAlreadyExistsException _) {
                this.factory.rollback(rootConfiguration, configHandler);
                Object var9_6 = null;
                UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
                UserStoreServiceFrame.releaseLock(this.locker);
                return;
            }
            catch (Exception e) {
                this.factory.rollback(rootConfiguration, configHandler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0551", e);
                bse.log();
                throw bse;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            UserStoreServiceFrame.releaseLock(this.locker);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
        UserStoreServiceFrame.releaseLock(this.locker);
    }

    private void setInitialGroups(String[][] users, String[][] groups, Configuration config) {
        this.factory.setTransactionAttribute(config);
        try {
            try {
                int i = 0;
                while (i < groups.length) {
                    try {
                        this.engineGetGroupInfo(groups[i][1]);
                    }
                    catch (SecurityException se) {
                        this.engineCreateGroup(groups[i][1]);
                    }
                    try {
                        this.engineGetGroupInfo(groups[i][0]);
                    }
                    catch (SecurityException e) {
                        this.engineCreateGroup(groups[i][0]);
                    }
                    this.engineAddGroupToParent(groups[i][0], groups[i][1]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < users.length) {
                    this.engineAddUserToGroup(users[i2][0], users[i2][2]);
                    ++i2;
                }
            }
            catch (Exception e) {
                Object var7_11 = null;
                this.factory.setTransactionAttribute(null);
                if (this.configPath != null && this.configPath.length() > 0) {
                    this.factory.setPath(this.configPath);
                }
                return;
            }
            Object var7_10 = null;
            this.factory.setTransactionAttribute(null);
            if (this.configPath != null && this.configPath.length() > 0) {
                this.factory.setPath(this.configPath);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.factory.setTransactionAttribute(null);
            if (this.configPath != null && this.configPath.length() > 0) {
                this.factory.setPath(this.configPath);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListGroups() throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration(GROUPS_CONFIG_PATH, false, handler);
                iterator = configuration.getAllSubConfigurations().keySet().iterator();
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0500", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    public SearchResult engineSearchGroups(SearchFilter filter) throws SecurityException {
        int resultSize = filter.getMaxSearchResultSize();
        Iterator attributes = filter.getSearchAttributes();
        if (attributes.hasNext()) {
            return new GroupSearchResultImpl(this, attributes, resultSize);
        }
        throw new BaseSecurityException("userstore_2000");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupInfoSpi engineGetGroupInfo(String groupName) throws SecurityException {
        GroupInfoImpl groupInfoImpl;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("groups/" + groupName, false, handler);
                GroupInfoImpl info = new GroupInfoImpl(configuration);
                info.setGroupContext(this);
                groupInfoImpl = info;
                Object var7_7 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0503", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return groupInfoImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupInfoSpi engineCreateGroup(String groupName) throws SecurityException {
        GroupInfoImpl groupInfoImpl;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        try {
            try {
                configuration = this.factory.getConfiguration(GROUPS_CONFIG_PATH, true, handler);
                Configuration groupConfiguration = configuration.createSubConfiguration(groupName);
                this.treeManager.createUser(groupName, false, groupConfiguration);
                GroupInfoImpl info = new GroupInfoImpl(groupConfiguration);
                info.setGroupContext(this);
                this.factory.commit(configuration, handler);
                UserStoreServiceFrame.logNotice("Group \"" + groupName + "\" created successfully.");
                groupInfoImpl = info;
                Object var8_9 = null;
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0506", 400, new Object[]{groupName}, e);
                bse.log();
                throw bse;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
        return groupInfoImpl;
    }

    public void engineDeleteGroup(String groupName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        try {
            try {
                configuration = this.factory.getConfiguration("groups/" + groupName, true, handler);
                if (this.treeManager.getChildUsers(groupName, configuration).hasNext() || this.treeManager.getChildGroups(groupName, configuration).hasNext()) {
                    throw new BaseSecurityException("userstore_0537");
                }
                Iterator parents = this.treeManager.getParents(groupName, configuration);
                this.treeManager.ungroupUser(groupName, false, parents, handler);
                configuration.deleteConfiguration();
                this.factory.commit(configuration, handler);
                UserStoreServiceFrame.logNotice("Group \"" + groupName + "\" deleted successfully.");
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                BaseSecurityException bse = new BaseSecurityException("userstore_0507", 400, new Object[]{groupName}, e);
                bse.log();
                throw bse;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
    }

    public void engineAddGroupToParent(String groupName, String parentName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        try {
            try {
                this.treeManager.groupUser(groupName, false, parentName, handler);
                this.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                throw new BaseSecurityException("userstore_0510", e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
    }

    public void engineRemoveGroupFromParent(String groupName, String parentName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        try {
            try {
                this.treeManager.ungroupUser(groupName, false, parentName, handler);
                this.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                throw new BaseSecurityException("userstore_0513", e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetChildGroups(String groupName) throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("groups/" + groupName, false, handler);
                iterator = this.treeManager.getChildGroups(groupName, configuration);
                Object var7_6 = null;
            }
            catch (Exception e) {
                BaseSecurityException bse = new BaseSecurityException("userstore_0516", e);
                bse.log();
                throw bse;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetParentGroups(String groupName) throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("groups/" + groupName, false, handler);
                iterator = this.treeManager.getParents(groupName, configuration);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0519", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    public void engineAddUserToGroup(String userName, String groupName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        UserStoreServiceFrame.lock(this.locker + "users");
        try {
            try {
                this.treeManager.groupUser(userName, true, groupName, handler);
                this.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                throw new BaseSecurityException("userstore_0522", e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            UserStoreServiceFrame.releaseLock(this.locker + "users");
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + "users");
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
    }

    public void engineRemoveUserFromGroup(String userName, String groupName) throws SecurityException {
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        UserStoreServiceFrame.lock(this.locker + GROUPS_CONFIG_PATH);
        UserStoreServiceFrame.lock(this.locker + "users");
        try {
            try {
                this.treeManager.ungroupUser(userName, true, groupName, handler);
                this.factory.commit(configuration, handler);
            }
            catch (Exception e) {
                this.factory.rollback(configuration, handler);
                throw new BaseSecurityException("userstore_0525", e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            UserStoreServiceFrame.releaseLock(this.locker + "users");
            UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
            throw throwable;
        }
        UserStoreServiceFrame.releaseLock(this.locker + "users");
        UserStoreServiceFrame.releaseLock(this.locker + GROUPS_CONFIG_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetUsersOfGroup(String groupName) throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("groups/" + groupName, false, handler);
                iterator = this.treeManager.getChildUsers(groupName, configuration);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0528", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineListRootGroups() {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration(GROUPS_CONFIG_PATH, false, handler);
                iterator = this.treeManager.listRoots(configuration);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0531", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator engineGetGroupsOfUser(String userName) throws SecurityException {
        Iterator iterator;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        Configuration configuration = null;
        try {
            try {
                configuration = this.factory.getConfiguration("users/" + userName, false, handler);
                iterator = this.treeManager.getParents(userName, configuration);
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new BaseSecurityException("userstore_0534", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.factory.close(configuration, handler);
            throw throwable;
        }
        this.factory.close(configuration, handler);
        return iterator;
    }

    public void registerListener(GroupListener groupListener, int modifier) throws SecurityException {
        throw new RuntimeException("RegisterListener not supported.");
    }

    public void unregisterListener(GroupListener groupListener) throws SecurityException {
        throw new RuntimeException("UnregisterListener not supported.");
    }

    public SearchFilter engineGetSearchFilter() {
        return new SearchFilterImpl();
    }

    public void engineRefresh(String groupName) {
    }
}

