/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.services.userstore.HandlerPool;
import com.sap.engine.services.userstore.UserContextImpl;
import com.sap.engine.services.userstore.UserStoreServiceFrame;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;
import com.sap.engine.services.userstore.filter.FilterPasswordImpl;
import com.sap.engine.services.userstore.filter.FilterUsernameImpl;
import java.util.Properties;

public class ConnectorContextImpl
extends UserContextImpl {
    public ConnectorContextImpl() {
    }

    public ConnectorContextImpl(Configuration configuration) {
        this();
        if (configuration != null) {
            this.factory.setTransactionAttribute(configuration);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void enginePropertiesChanged(Properties newProps) {
        String userstoreName = newProps.getProperty("CONNECTOR");
        this.retrievePasswords = true;
        ConfigurationHandler handler = this.factory.getConfigurationHandler();
        if (this.factory.getTransactionAttribute() != null && this.factory.getTransactionAttribute().isValid()) {
            Configuration userstoreConfig = null;
            this.setLocker(userstoreName);
            UserStoreServiceFrame.lock(this.getLocker());
            UserStoreServiceFrame.lock(this.getLocker() + "users");
            try {
                try {
                    userstoreConfig = this.factory.createRootConfiguration(handler);
                    userstoreConfig.createSubConfiguration("users");
                    Configuration filterConfiguration = userstoreConfig.createSubConfiguration("filter");
                    new FilterUsernameImpl(filterConfiguration.createSubConfiguration("filter/username".substring("filter/username".indexOf("/") + 1)), true);
                    new FilterPasswordImpl(filterConfiguration.createSubConfiguration("filter/password".substring("filter/password".indexOf("/") + 1)), true);
                }
                catch (Exception e) {
                    throw new BaseSecurityException("userstore_0200", e);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                HandlerPool.freeHandler(handler);
                UserStoreServiceFrame.releaseLock(this.getLocker() + "users");
                UserStoreServiceFrame.releaseLock(this.getLocker());
                throw throwable;
            }
            HandlerPool.freeHandler(handler);
            UserStoreServiceFrame.releaseLock(this.getLocker() + "users");
            UserStoreServiceFrame.releaseLock(this.getLocker());
            return;
        }
        this.factory.initializeConfigurationPath(userstoreName);
    }

    public void registerConnectorConfigurationListener(ConfigurationChangedListener listener) {
        this.factory.registerConnectorConfigurationListener(listener);
    }

    public void unregisterConnectorConfigurationListener(ConfigurationChangedListener listener) {
        this.factory.unregisterConnectorConfigurationListener(listener);
    }

    public void unregisterConnectorConfigurationListener(ConfigurationChangedListener listener, Configuration transactionAttribute) {
        this.factory.unregisterConnectorConfigurationListener(listener, transactionAttribute);
    }

    public void setTransactionAttribute(Configuration configuration) {
        if (configuration != null) {
            this.factory.setTransactionAttribute(configuration);
        }
    }
}

