/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.userstore;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.services.userstore.HandlerPool;
import com.sap.engine.services.userstore.UserStoreServiceFrame;
import com.sap.engine.services.userstore.exceptions.BaseSecurityException;

class ConfigurationFactory {
    public static final String ROOT_CONTAINER_NAME = "userstore";
    public static String SECURITY_CONFIGURATIONS_PATH = "security/configurations";
    private Configuration applicationConfiguration = null;
    protected String configPath = "";

    public void setTransactionAttribute(Configuration config) {
        try {
            this.applicationConfiguration = config;
            if (config != null) {
                this.configPath = config.getPath();
                if (!this.configPath.endsWith("/")) {
                    this.configPath = this.configPath + "/";
                }
            } else {
                this.configPath = "";
            }
        }
        catch (Exception e) {
            throw new BaseSecurityException("userstore_0100", e);
        }
    }

    public Configuration getTransactionAttribute() {
        return this.applicationConfiguration;
    }

    public void setPath(String path) {
        this.configPath = path;
    }

    /*
     * Loose catch block
     */
    public void initializeConfigurationPath(String alias) {
        block7: {
            ConfigurationHandler configHandler = HandlerPool.getFreeHandler();
            Configuration config = configHandler.openConfiguration(SECURITY_CONFIGURATIONS_PATH, 0);
            this.configPath = (String)config.getConfigEntry(alias);
            Object var5_5 = null;
            try {
                configHandler.closeAllConfigurations();
                HandlerPool.freeHandler(configHandler);
            }
            catch (Exception ex) {
                UserStoreServiceFrame.logError("Unable to close configuration handler", ex);
            }
            break block7;
            {
                catch (Exception e) {
                    throw new BaseSecurityException("userstore_0101", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    configHandler.closeAllConfigurations();
                    HandlerPool.freeHandler(configHandler);
                }
                catch (Exception ex) {
                    UserStoreServiceFrame.logError("Unable to close configuration handler", ex);
                }
                throw throwable;
            }
        }
    }

    public ConfigurationHandler getConfigurationHandler() {
        return HandlerPool.getFreeHandler();
    }

    public Configuration createRootConfiguration(ConfigurationHandler configHandler) throws Exception {
        Configuration rootConfig = null;
        try {
            if (this.applicationConfiguration != null && this.applicationConfiguration.isValid()) {
                if (this.applicationConfiguration.existsSubConfiguration(ROOT_CONTAINER_NAME)) {
                    return this.applicationConfiguration.getSubConfiguration(ROOT_CONTAINER_NAME);
                }
                return this.applicationConfiguration.createSubConfiguration(ROOT_CONTAINER_NAME);
            }
            rootConfig = this.configPath.length() != 0 ? ((rootConfig = configHandler.openConfiguration(this.configPath, 1)).existsSubConfiguration(ROOT_CONTAINER_NAME) ? rootConfig.getSubConfiguration(ROOT_CONTAINER_NAME) : rootConfig.createSubConfiguration(ROOT_CONTAINER_NAME)) : (this.contain(configHandler.getAllRootNames(), ROOT_CONTAINER_NAME) ? configHandler.openConfiguration(ROOT_CONTAINER_NAME, 1) : configHandler.createRootConfiguration(ROOT_CONTAINER_NAME));
        }
        catch (Exception e) {
            throw new BaseSecurityException("userstore_0102", e);
        }
        return rootConfig;
    }

    public Configuration getRootConfiguration(ConfigurationHandler configHandler) throws Exception {
        try {
            if (this.applicationConfiguration != null && this.applicationConfiguration.isValid()) {
                return this.applicationConfiguration.getSubConfiguration(ROOT_CONTAINER_NAME);
            }
            if (this.configPath.length() > 0 && !this.configPath.endsWith("/")) {
                this.configPath = this.configPath + "/";
            }
            Configuration rootConfig = configHandler.openConfiguration(this.configPath + ROOT_CONTAINER_NAME, 1);
            return rootConfig;
        }
        catch (ConfigurationException e) {
            throw new BaseSecurityException("userstore_0103", (Throwable)((Object)e));
        }
    }

    protected Configuration getConfiguration(String innerConfiguration, boolean update, ConfigurationHandler handler) throws NameNotFoundException, SecurityException {
        Configuration activeContainer = null;
        try {
            if (this.applicationConfiguration != null && this.applicationConfiguration.isValid()) {
                if (this.applicationConfiguration.getPath().endsWith(ROOT_CONTAINER_NAME)) {
                    return this.applicationConfiguration.getSubConfiguration(innerConfiguration);
                }
                return this.applicationConfiguration.getSubConfiguration("userstore/" + innerConfiguration);
            }
            if (this.configPath.length() > 0 && !this.configPath.endsWith("/")) {
                this.configPath = this.configPath + "/";
            }
            activeContainer = update ? handler.openConfiguration(this.configPath + ROOT_CONTAINER_NAME + '/' + innerConfiguration, 1) : handler.openConfiguration(this.configPath + ROOT_CONTAINER_NAME + '/' + innerConfiguration, 0);
            return activeContainer;
        }
        catch (NameNotFoundException nnfe) {
            throw nnfe;
        }
        catch (Exception e) {
            throw new BaseSecurityException("userstore_0104", new Object[]{innerConfiguration}, (Throwable)e);
        }
    }

    protected void commit(Configuration config, ConfigurationHandler handler) throws SecurityException {
        try {
            if (config != null && config == this.applicationConfiguration) {
                return;
            }
            if (handler != null) {
                handler.commit();
                handler.closeAllConfigurations();
                HandlerPool.freeHandler(handler);
            }
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_0106", ex);
        }
    }

    protected void rollback(Configuration config, ConfigurationHandler handler) throws SecurityException {
        try {
            if (config != null && config == this.applicationConfiguration) {
                return;
            }
            if (handler != null) {
                handler.rollback();
                handler.closeAllConfigurations();
                HandlerPool.freeHandler(handler);
            }
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_0107", ex);
        }
    }

    protected void close(Configuration config, ConfigurationHandler handler) throws SecurityException {
        try {
            if (config != null && config == this.applicationConfiguration) {
                return;
            }
            if (handler != null) {
                handler.closeAllConfigurations();
                HandlerPool.freeHandler(handler);
            }
        }
        catch (Exception ex) {
            throw new BaseSecurityException("userstore_0108", ex);
        }
    }

    public void registerConnectorConfigurationListener(ConfigurationChangedListener listener) {
        ConfigurationHandler handler = HandlerPool.getFreeHandler();
        handler.addConfigurationChangedListener(listener, this.configPath + ROOT_CONTAINER_NAME, 1);
        try {
            handler.closeAllConfigurations();
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to close configuration handler", e);
        }
    }

    public void unregisterConnectorConfigurationListener(ConfigurationChangedListener listener) {
        ConfigurationHandler handler = HandlerPool.getFreeHandler();
        handler.removeConfigurationChangedListener(listener, this.configPath + ROOT_CONTAINER_NAME);
        try {
            handler.closeAllConfigurations();
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to close configuration handler", e);
        }
    }

    public void unregisterConnectorConfigurationListener(ConfigurationChangedListener listener, Configuration transactionAttribute) {
        try {
            this.setTransactionAttribute(transactionAttribute);
            ConfigurationHandler handler = HandlerPool.getFreeHandler();
            handler.removeConfigurationChangedListener(listener, this.configPath + ROOT_CONTAINER_NAME);
            try {
                Configuration config = this.getRootConfiguration(handler);
                config.deleteConfiguration();
                handler.commit();
                handler.closeAllConfigurations();
            }
            catch (Exception e) {
                handler.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            UserStoreServiceFrame.logError("Unable to close configuration handler", e);
        }
    }

    private boolean contain(String[] arr, String sbj) {
        if (arr == null || arr.length == 0) {
            return false;
        }
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(sbj)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

