/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.transaction;

import com.sap.engine.services.ts.TransactionContextObject;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.transaction.TxDemarcationException;
import com.sap.engine.services.ts.transaction.TxDuplicateOIDRegistrationException;
import com.sap.engine.services.ts.transaction.TxException;
import com.sap.engine.services.ts.transaction.TxLevelSynchronizations;
import com.sap.engine.services.ts.transaction.TxRollbackException;
import com.sap.engine.services.ts.transaction.TxSynchronizationException;
import com.sap.engine.services.ts.transaction.TxTicketImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.transaction.TransactionTicket;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public final class TxManager {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$transaction$TxManager == null ? (class$com$sap$engine$services$ts$transaction$TxManager = TxManager.class$("com.sap.engine.services.ts.transaction.TxManager")) : class$com$sap$engine$services$ts$transaction$TxManager));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private static UserTransaction utx = null;
    private static TransactionManager jtaTxMgr = null;
    static /* synthetic */ Class class$com$sap$engine$services$ts$transaction$TxManager;

    private TxManager() {
    }

    public static TransactionTicket required() throws TxException, TxRollbackException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.required()");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        Transaction tx = null;
        boolean started = false;
        try {
            switch (jtaTxMgr.getStatus()) {
                case 0: {
                    tx = jtaTxMgr.getTransaction();
                    started = false;
                    break;
                }
                case 6: {
                    utx.begin();
                    tx = jtaTxMgr.getTransaction();
                    started = true;
                    break;
                }
                case 1: {
                    throw new TxRollbackException();
                }
                default: {
                    throw new TxException("ts_0057");
                }
            }
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0054");
            }
            throw new TxException("ts_0054");
        }
        catch (NotSupportedException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0054");
            }
            throw new TxException("ts_0054");
        }
        TxManager.addTxSynchronizationLevel(tx);
        TxTicketImpl result = new TxTicketImpl(tx, started);
        TxManager.getTransactionContextObject().getTicketStack().push(result);
        return result;
    }

    public static TransactionTicket requiresNew() throws TxException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.requiresNew()");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        Transaction suspendedTransaction = null;
        try {
            if (jtaTxMgr.getStatus() != 6 && jtaTxMgr.getStatus() != 5) {
                suspendedTransaction = jtaTxMgr.suspend();
            }
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0049");
            }
            throw new TxException("ts_0049", e);
        }
        Transaction tx = null;
        try {
            utx.begin();
            tx = jtaTxMgr.getTransaction();
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0048");
            }
            throw new TxException("ts_0048");
        }
        catch (NotSupportedException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0048");
            }
            throw new TxException("ts_0048");
        }
        TxManager.addTxSynchronizationLevel(tx);
        TxTicketImpl result = new TxTicketImpl(tx, suspendedTransaction);
        TxManager.getTransactionContextObject().getTicketStack().push(result);
        return result;
    }

    public static void commitLevel(TransactionTicket ticket) throws TxException, TxDemarcationException, TxRollbackException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.commitLevel(" + ticket + ")");
        }
        if (ticket == null) {
            throw new TxException("ts_0064");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        TransactionContextObject txContextObject = TxManager.getTransactionContextObject();
        if (txContextObject.getTicketStack().isEmpty() || ticket != (TransactionTicket)txContextObject.getTicketStack().peek()) {
            throw new TxDemarcationException();
        }
        Transaction tx = null;
        try {
            tx = jtaTxMgr.getTransaction();
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0055");
            }
            throw new TxException("ts_0055");
        }
        if (tx != ((TxTicketImpl)ticket).getActiveTransaction()) {
            throw new TxDemarcationException();
        }
        try {
            if (ticket.wasStarted()) {
                try {
                    utx.commit();
                }
                catch (RollbackException e) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.log(500, LOCATION, (Object)"ts_0060");
                    }
                    throw new TxRollbackException();
                }
                catch (HeuristicRollbackException e) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.log(500, LOCATION, (Object)"ts_0060");
                    }
                    throw new TxRollbackException();
                }
                catch (HeuristicMixedException e) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.log(500, LOCATION, (Object)"ts_0051");
                    }
                    throw new TxException("ts_0051", e);
                }
                catch (SystemException e) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.log(500, LOCATION, (Object)"ts_0051");
                    }
                    throw new TxException("ts_0051", e);
                }
            }
            Object var8_8 = null;
            ((TxTicketImpl)ticket).setCompleted();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((TxTicketImpl)ticket).setCompleted();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void leaveLevel(TransactionTicket ticket) throws TxException, TxDemarcationException, TxRollbackException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.leaveLevel(" + ticket + ")");
        }
        if (ticket == null) {
            throw new TxException("ts_0064");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        TransactionContextObject txContextObject = TxManager.getTransactionContextObject();
        if (txContextObject.getTicketStack().isEmpty() || ticket != (TransactionTicket)txContextObject.getTicketStack().peek()) {
            throw new TxDemarcationException();
        }
        txContextObject.getTicketStack().pop();
        txContextObject.getSynchronizationsStack().pop();
        if (ticket.wasStarted()) {
            Transaction suspendedTransaction2;
            try {
                if (!((TxTicketImpl)ticket).wasCompleted()) {
                    try {
                        utx.rollback();
                    }
                    catch (SystemException e) {
                        if (!CATEGORY.beLogged(500)) throw new TxRollbackException();
                        CATEGORY.log(500, LOCATION, (Object)"ts_0052");
                        throw new TxRollbackException();
                    }
                }
                Object var4_3 = null;
                suspendedTransaction2 = ((TxTicketImpl)ticket).getSuspendedTransaction();
                if (suspendedTransaction2 == null) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Transaction suspendedTransaction2 = ((TxTicketImpl)ticket).getSuspendedTransaction();
                if (suspendedTransaction2 == null) throw throwable;
                try {
                    jtaTxMgr.resume(suspendedTransaction2);
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    throw new TxDemarcationException();
                }
                catch (InvalidTransactionException e) {
                    throw new TxDemarcationException();
                }
                catch (SystemException e) {
                    if (!CATEGORY.beLogged(500)) throw new TxException("ts_0050", e);
                    CATEGORY.log(500, LOCATION, (Object)"ts_0050");
                    throw new TxException("ts_0050", e);
                }
            }
            try {
                jtaTxMgr.resume(suspendedTransaction2);
                return;
            }
            catch (IllegalStateException e) {
                throw new TxDemarcationException();
            }
            catch (InvalidTransactionException e) {
                throw new TxDemarcationException();
            }
            catch (SystemException e) {
                if (!CATEGORY.beLogged(500)) throw new TxException("ts_0050", e);
                CATEGORY.log(500, LOCATION, (Object)"ts_0050");
                throw new TxException("ts_0050", e);
            }
        }
        if (((TxTicketImpl)ticket).wasCompleted()) return;
        TxManager.setRollbackOnly();
    }

    public static void setRollbackOnly() throws TxException, TxDemarcationException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.setRollbackOnly()");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            jtaTxMgr.setRollbackOnly();
        }
        catch (IllegalStateException ex) {
            throw new TxDemarcationException();
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0053");
            }
            throw new TxException("ts_0053", e);
        }
    }

    public static void registerSynchronization(String sid, Synchronization sync) throws TxException, TxDemarcationException, TxRollbackException, TxDuplicateOIDRegistrationException, TxSynchronizationException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.registerSynchronization(" + sid + "," + sync + ")");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            switch (jtaTxMgr.getStatus()) {
                case 0: {
                    break;
                }
                case 6: {
                    throw new TxDemarcationException();
                }
                case 1: {
                    throw new TxRollbackException();
                }
                default: {
                    throw new TxException("ts_0057");
                }
            }
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0054");
            }
            throw new TxException("ts_0054");
        }
        if (TxManager.getTransactionContextObject().getSynchronizationsStack().isEmpty()) {
            throw new TxDemarcationException();
        }
        TxLevelSynchronizations txSync = (TxLevelSynchronizations)TxManager.getTransactionContextObject().getSynchronizationsStack().peek();
        txSync.addSynchronization(sid, sync);
    }

    public static Synchronization getRegisteredSynchronization(String sid) throws TxException, TxDemarcationException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.getRegisteredSynchronization(" + sid + ")");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        if (TxManager.getTransactionContextObject().getSynchronizationsStack().isEmpty()) {
            throw new TxDemarcationException();
        }
        TxLevelSynchronizations txSync = (TxLevelSynchronizations)TxManager.getTransactionContextObject().getSynchronizationsStack().peek();
        return txSync.getSynchronization(sid);
    }

    public static boolean isTxActive() throws TxException {
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            if (jtaTxMgr.getStatus() == 0) {
                return true;
            }
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0054");
            }
            throw new TxException("ts_0054", e);
        }
        return false;
    }

    public static boolean isTxMarkedRollback() throws TxException {
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            if (jtaTxMgr.getStatus() == 1) {
                return true;
            }
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0054");
            }
            throw new TxException("ts_0054", e);
        }
        return false;
    }

    private static boolean isTxAlive() throws TxException {
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            int status = jtaTxMgr.getStatus();
            if (status != 9 || status != 4 || status != 6 || status != 1) {
                return true;
            }
        }
        catch (SystemException e) {
            throw new TxException("ts_0054", e);
        }
        return false;
    }

    private static void addTxSynchronizationLevel(Transaction tx) throws TxException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.addTxSynchronizationLevel(" + tx + ")");
        }
        if (jtaTxMgr == null) {
            throw new TxException("ts_0063");
        }
        try {
            TxLevelSynchronizations txLevelSync = new TxLevelSynchronizations(tx);
            TxManager.getTransactionContextObject().getSynchronizationsStack().push(txLevelSync);
        }
        catch (RuntimeException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0056");
            }
            throw new TxException("ts_0056", e);
        }
    }

    public static void setTransactionManager(TransactionManager _tm) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.setTransactionManager(" + _tm + ")");
        }
        jtaTxMgr = _tm;
    }

    private static TransactionContextObject getTransactionContextObject() {
        TransactionContextObject obj = null;
        try {
            obj = TransactionServiceFrame.getTransactionContextObject();
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "" + obj + " TxManager.getTransactionContextObject()");
            }
            return obj;
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static int getStatus() throws TxException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.getStatus()");
        }
        try {
            return jtaTxMgr.getStatus();
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0022");
            }
            throw new TxException("ts_0022");
        }
    }

    public static void setUserTransaction(UserTransaction tx) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxManager.setUserTransaction(" + tx + ")");
        }
        utx = tx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

