/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.transaction;

import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.transaction.TxDuplicateOIDRegistrationException;
import com.sap.engine.services.ts.transaction.TxException;
import com.sap.engine.services.ts.transaction.TxSynchronizationException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class TxLevelSynchronizations {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$transaction$TxLevelSynchronizations == null ? (class$com$sap$engine$services$ts$transaction$TxLevelSynchronizations = TxLevelSynchronizations.class$("com.sap.engine.services.ts.transaction.TxLevelSynchronizations")) : class$com$sap$engine$services$ts$transaction$TxLevelSynchronizations));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private Transaction tx;
    private TreeMap registeredSynchronizations;
    static /* synthetic */ Class class$com$sap$engine$services$ts$transaction$TxLevelSynchronizations;

    public TxLevelSynchronizations(Transaction tx) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxLevelSynchronizations.TxLevelSynchronizations(" + tx + ")");
        }
        this.tx = tx;
        this.registeredSynchronizations = new TreeMap();
    }

    public Synchronization getSynchronization(String sid) {
        Synchronization sync = (Synchronization)this.registeredSynchronizations.get(sid);
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "" + sync + " TxLevelSynchronizations.getSynchronization(" + sid + ")");
        }
        return sync;
    }

    public void addSynchronization(String sid, Synchronization sync) throws TxException, TxDuplicateOIDRegistrationException, TxSynchronizationException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TxLevelSynchronizations.addSynchronization(" + sid + "," + sync + ")");
        }
        try {
            Stack syncStack = TransactionServiceFrame.getTransactionContextObject().getSynchronizationsStack();
            Iterator iter = ((AbstractList)syncStack).iterator();
            while (iter.hasNext()) {
                TxLevelSynchronizations tempSync = (TxLevelSynchronizations)iter.next();
                if (tempSync.registeredSynchronizations.containsValue(sync)) {
                    throw new TxDuplicateOIDRegistrationException();
                }
                if (!tempSync.registeredSynchronizations.containsKey(sid)) continue;
                throw new TxSynchronizationException();
            }
            this.registeredSynchronizations.put(sid, sync);
            this.tx.registerSynchronization(sync);
        }
        catch (RollbackException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)"ts_0052");
            }
            throw new TxException("ts_0052");
        }
        catch (SystemException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.log(500, LOCATION, (Object)e.toString());
            }
            throw new RuntimeException(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

