/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jts.ots.PortableInterceptor;

import com.sap.engine.services.ts.Log;
import com.sap.engine.services.ts.jts.TransactionServiceImpl;
import com.sap.tc.logging.Location;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerJTSInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ServerJTSInterceptor == null ? (class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ServerJTSInterceptor = ServerJTSInterceptor.class$("com.sap.engine.services.ts.jts.ots.PortableInterceptor.ServerJTSInterceptor")) : class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ServerJTSInterceptor));
    public String name = null;
    private Receiver receiver = TransactionServiceImpl.getReceiver();
    private Codec codec = null;
    private int jtsId = 0;
    private static int idCounter = 0;
    private static Object syncObj = new Object();
    static /* synthetic */ Class class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ServerJTSInterceptor;

    public ServerJTSInterceptor(Codec codec) {
        this.codec = codec;
        this.name = "jts";
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo sri) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "ServerJTSInterceptor.receive_request_service_contexts({0})", new Object[]{Log.objectToString(sri)});
        }
        if (this.receiver != null) {
            Object object = syncObj;
            synchronized (object) {
                this.jtsId = idCounter++;
            }
            ServiceContext sc = null;
            try {
                sc = sri.get_request_service_context(0);
            }
            catch (BAD_PARAM ex) {
                // empty catch block
            }
            if (sc != null) {
                Any any = null;
                try {
                    TypeCode typeCode = PropagationContextHelper.type();
                    any = this.codec.decode_value(sc.context_data, typeCode);
                }
                catch (TypeMismatch e) {
                    if (LOCATION.beLogged(500)) {
                        LOCATION.traceThrowableT(500, "ServerJTSInterceptor.receive_request_service_contexts", (Throwable)e);
                    }
                    throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
                }
                catch (FormatMismatch e) {
                    if (LOCATION.beLogged(500)) {
                        LOCATION.traceThrowableT(500, "ServerJTSInterceptor.receive_request_service_contexts", (Throwable)e);
                    }
                    throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
                }
                PropagationContext prContext = PropagationContextHelper.extract((Any)any);
                this.receiver.received_request(this.jtsId, prContext);
            }
        }
    }

    public void receive_request(ServerRequestInfo sri) {
    }

    public void send_reply(ServerRequestInfo sri) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "ServerJTSInterceptor.send_reply({0})", new Object[]{Log.objectToString(sri)});
        }
        if (this.receiver != null) {
            PropagationContextHolder prContext = new PropagationContextHolder();
            this.receiver.sending_reply(sri.request_id(), prContext);
            if (prContext.value != null) {
                Any any = ORB.init().create_any();
                PropagationContextHelper.insert((Any)any, (PropagationContext)prContext.value);
                byte[] ctxData = null;
                try {
                    ctxData = this.codec.encode_value(any);
                }
                catch (InvalidTypeForEncoding e) {
                    if (LOCATION.beLogged(500)) {
                        LOCATION.traceThrowableT(500, "ServerJTSInterceptor.send_reply", (Throwable)e);
                    }
                    throw new INTERNAL(e.toString());
                }
                ServiceContext sc = new ServiceContext(0, ctxData);
                sri.add_reply_service_context(sc, false);
            }
        }
    }

    public void send_exception(ServerRequestInfo sri) {
    }

    public void send_other(ServerRequestInfo sri) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

