/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jts.ots.PortableInterceptor;

import com.sap.engine.services.ts.Log;
import com.sap.engine.services.ts.jts.TransactionServiceImpl;
import com.sap.engine.services.ts.jts.ots.PortableInterceptor.EnvironmentImpl;
import com.sap.tc.logging.Location;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public class ClientJTSInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ClientJTSInterceptor == null ? (class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ClientJTSInterceptor = ClientJTSInterceptor.class$("com.sap.engine.services.ts.jts.ots.PortableInterceptor.ClientJTSInterceptor")) : class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ClientJTSInterceptor));
    public String name = null;
    private Sender sender = TransactionServiceImpl.getSender();
    private Codec codec = null;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jts$ots$PortableInterceptor$ClientJTSInterceptor;

    public ClientJTSInterceptor(Codec codec) {
        this.codec = codec;
        this.name = "jts";
    }

    public String name() {
        return this.name;
    }

    public void send_request(ClientRequestInfo cri) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "ClientJTSInterceptor.send_request({0})", new Object[]{Log.objectToString(cri)});
        }
        if (this.sender != null) {
            PropagationContextHolder prContext = new PropagationContextHolder();
            this.sender.sending_request(cri.request_id(), prContext);
            if (prContext.value != null) {
                Any any = ORB.init().create_any();
                PropagationContextHelper.insert((Any)any, (PropagationContext)prContext.value);
                byte[] ctxData = null;
                try {
                    ctxData = this.codec.encode_value(any);
                }
                catch (InvalidTypeForEncoding e) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.traceThrowableT(100, "Unexpected exception", (Throwable)e);
                    }
                    throw new INTERNAL(e.toString());
                }
                ServiceContext sc = new ServiceContext(0, ctxData);
                cri.add_request_service_context(sc, false);
            }
        }
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo cri) {
    }

    public void receive_reply(ClientRequestInfo cri) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "ClientJTSInterceptor.receive_reply({0})", new Object[]{Log.objectToString(cri)});
        }
        ServiceContext sc = null;
        try {
            sc = cri.get_reply_service_context(0);
        }
        catch (BAD_PARAM ex) {
            // empty catch block
        }
        if (this.sender != null && sc != null) {
            Any any = null;
            try {
                TypeCode typeCode = PropagationContextHelper.type();
                any = this.codec.decode_value(sc.context_data, typeCode);
            }
            catch (TypeMismatch e) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_reply", (Throwable)e);
                }
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            catch (FormatMismatch e) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_reply", (Throwable)e);
                }
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            PropagationContext prContext = PropagationContextHelper.extract((Any)any);
            try {
                this.sender.received_reply(cri.request_id(), prContext, (Environment)new EnvironmentImpl());
            }
            catch (WrongTransaction ex) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_reply", (Throwable)ex);
                }
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_YES);
            }
        }
    }

    public void receive_exception(ClientRequestInfo cri) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "ClientJTSInterceptor.receive_exception({0})", new Object[]{Log.objectToString(cri)});
        }
        ServiceContext sc = null;
        try {
            sc = cri.get_reply_service_context(0);
        }
        catch (BAD_PARAM ex) {
            // empty catch block
        }
        if (this.sender != null && sc != null) {
            Any any = null;
            try {
                TypeCode typeCode = PropagationContextHelper.type();
                any = this.codec.decode_value(sc.context_data, typeCode);
            }
            catch (TypeMismatch e) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_exception", (Throwable)e);
                }
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            catch (FormatMismatch e) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_exception", (Throwable)e);
                }
                throw new INTERNAL(0, CompletionStatus.COMPLETED_YES);
            }
            PropagationContext prContext = PropagationContextHelper.extract((Any)any);
            EnvironmentImpl env = new EnvironmentImpl();
            String repId = cri.received_exception_id();
            SystemException exception = null;
            CompletionStatus completionStatus = null;
            if (repId.startsWith("IDL:omg.org/CORBA/")) {
                exception = new SystemException("", 0, CompletionStatus.COMPLETED_MAYBE){};
                Any any_ex = cri.received_exception();
                InputStream strm = any_ex.create_input_stream();
                strm.read_string();
                int minorCode = strm.read_long();
                completionStatus = CompletionStatus.from_int((int)strm.read_long());
                if (repId.equals("IDL:omg.org/CORBA/UNKNOWN:1.0") && minorCode == 1) {
                    exception = null;
                }
            }
            if (exception == null) {
                completionStatus = CompletionStatus.COMPLETED_YES;
            }
            env.exception((Exception)((Object)exception));
            try {
                this.sender.received_reply(cri.request_id(), prContext, (Environment)env);
            }
            catch (WrongTransaction ex) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "ClientJTSInterceptor.receive_exception", (Throwable)ex);
                }
                throw new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_YES);
            }
        }
    }

    public void receive_other(ClientRequestInfo cri) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

