/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jts.ots;

import com.sap.engine.interfaces.transaction.LocalTxProvider;
import com.sap.engine.interfaces.transaction.TransactionExtension;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.ts.Log;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.Util;
import com.sap.engine.services.ts.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ts.exceptions.BaseSystemException;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ResourceImpl;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.SynchronizationJTAWrapper;
import com.sap.tc.logging.Location;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.otid_t;

public class OTSTransaction
implements TransactionExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jts$ots$OTSTransaction == null ? (class$com$sap$engine$services$ts$jts$ots$OTSTransaction = OTSTransaction.class$("com.sap.engine.services.ts.jts.ots.OTSTransaction")) : class$com$sap$engine$services$ts$jts$ots$OTSTransaction));
    private String txToString;
    private byte[] tidBytes = null;
    private ResourceImpl omgResource = null;
    public PropagationContext pgContext = null;
    private Terminator terminator = null;
    private Coordinator coordinator = null;
    private otid_t otid = null;
    private int status = 0;
    private Vector syns = new Vector();
    private Object[] txToObjectArray;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jts$ots$OTSTransaction;

    public OTSTransaction(PropagationContext pgContextParam) {
        this.pgContext = pgContextParam;
        if (this.pgContext.current == null) {
            LOCATION.logT(500, "OTSTransaction object in transaction service is created with null \"current\" in the PropagationContext.");
            throw new BaseIllegalStateException("ts_0041");
        }
        this.terminator = this.pgContext.current.term;
        this.coordinator = this.pgContext.current.coord;
        this.otid = this.pgContext.current.otid;
        this.tidBytes = new byte[this.otid.tid.length];
        int i = 0;
        while (i < this.otid.tid.length) {
            this.tidBytes[i] = this.otid.tid[i];
            ++i;
        }
        this.status = 0;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        block5: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0}.commit", this.toObjectArray());
            }
            this.status = 3;
            try {
                this.terminator.commit(false);
            }
            catch (HeuristicMixed hm) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)hm);
                }
            }
            catch (HeuristicHazard hh) {
                if (!LOCATION.beLogged(500)) break block5;
                LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)hh);
            }
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0}.delistResource({1}, {2})", new Object[]{this.toString(), Log.objectToString(xaRes), Integer.toString(flag)});
        }
        return this.omgResource.delistResource(xaRes, flag);
    }

    public boolean enlistResource(XAResource xaRes) {
        block4: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0}.enlistResource({1})", new Object[]{this.toString(), Log.objectToString(xaRes)});
            }
            if (this.omgResource == null) {
                this.omgResource = new ResourceImpl(this.tidBytes, this);
                try {
                    boolean res = this.omgResource.enlistResource(xaRes);
                    this.coordinator.register_resource((Resource)this.omgResource);
                    return res;
                }
                catch (Inactive i) {
                    if (!LOCATION.beLogged(500)) break block4;
                    LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)i);
                }
            }
        }
        return this.omgResource.enlistResource(xaRes);
    }

    public int getStatus() {
        if (this.status == 4 || this.status == 3) {
            return 6;
        }
        return this.status;
    }

    public void registerSynchronization(javax.transaction.Synchronization sync) {
        block5: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0}.registerSynchronization({1})", new Object[]{this.toString(), Log.objectToString(sync)});
            }
            try {
                SynchronizationJTAWrapper synchWrap = new SynchronizationJTAWrapper(sync);
                this.syns.add(synchWrap);
                this.coordinator.register_synchronization((Synchronization)synchWrap);
            }
            catch (Inactive i) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)i);
                }
            }
            catch (SynchronizationUnavailable su) {
                if (!LOCATION.beLogged(500)) break block5;
                LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)su);
            }
        }
    }

    public void rollback() {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0}.rollback", this.toObjectArray());
        }
        this.status = 4;
        this.terminator.rollback();
    }

    public void setRollbackOnly() {
        block3: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0}.setRollbackOnly", this.toObjectArray());
            }
            this.status = 1;
            try {
                this.coordinator.rollback_only();
            }
            catch (Inactive i) {
                if (!LOCATION.beLogged(500)) break block3;
                LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)i);
            }
        }
    }

    public boolean isEmpty() {
        return this.omgResource == null || this.omgResource.getLocalResource() == null;
    }

    public void enlistLocalResource(LocalTxProvider localRef) throws SystemException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0}.enlistLocalResource({1})", new Object[]{this.toString(), Log.objectToString(localRef)});
        }
        if (TransactionServiceFrame.enableLocalResourceInOTS) {
            if (this.omgResource == null) {
                this.omgResource = new ResourceImpl(this.tidBytes, this);
            }
            this.omgResource.enlistLocalResource(localRef);
            try {
                this.coordinator.register_resource((Resource)this.omgResource);
            }
            catch (Inactive i) {
                if (LOCATION.beLogged(500)) {
                    LOCATION.traceThrowableT(500, "{0}", this.toObjectArray(), (Throwable)i);
                }
                throw new SystemException(i.getMessage());
            }
        } else {
            LOCATION.logT(500, "{0} enlisting local resources in OTS transaction is not alowed. Check {1} property of Transaction Service.", new Object[]{this.toString(), "ENABLE_LOCAL_RESOURCE_IN_OTS"});
            throw new BaseSystemException("ts_0026", "ENABLE_LOCAL_RESOURCE_IN_OTS");
        }
    }

    public LocalTxProvider getLocalResource() {
        if (this.omgResource != null) {
            return this.omgResource.getLocalResource();
        }
        return null;
    }

    public boolean isAlive() {
        return this.status != 6 && this.status != 3 && this.status != 4 && this.status != 5;
    }

    public long getID() {
        return Convert.byteArrToLong(this.tidBytes, 8);
    }

    public otid_t get_otid() {
        return this.otid;
    }

    public byte[] getTIDbytes() {
        return this.tidBytes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OTSTransaction) {
            return Util.compareByteArr(((OTSTransaction)obj).tidBytes, this.tidBytes);
        }
        return false;
    }

    public int hashCode() {
        CRC32 crc = new CRC32();
        crc.update(this.tidBytes);
        return (int)crc.getValue();
    }

    public Vector getSynchronizations() {
        return this.syns;
    }

    public String toString() {
        if (this.txToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SAP J2EE Engine OTS Transaction : [");
            int i = 8;
            while (i < this.tidBytes.length) {
                buffer.append(Integer.toHexString(this.tidBytes[i]));
                ++i;
            }
            buffer.append("]");
            this.txToString = buffer.toString();
        }
        return this.txToString;
    }

    private Object[] toObjectArray() {
        if (this.txToObjectArray == null) {
            this.txToObjectArray = new Object[1];
            this.txToObjectArray[0] = this.toString();
        }
        return this.txToObjectArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

