/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jts.ots.CosTransactions.impl;

import com.sap.engine.interfaces.transaction.LocalTxProvider;
import com.sap.engine.interfaces.transaction.SynchronizationExtension;
import com.sap.engine.services.ts.Log;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ts.exceptions.BaseSystemException;
import com.sap.engine.services.ts.jta.impl.RMMap;
import com.sap.engine.services.ts.jta.impl.ResourceList;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ResourceImplBase;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.SynchronizationJTAWrapper;
import com.sap.engine.services.ts.jts.ots.OTSTransaction;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;

public class ResourceImpl
extends ResourceImplBase {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ResourceImpl == null ? (class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ResourceImpl = ResourceImpl.class$("com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ResourceImpl")) : class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ResourceImpl));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private RMMap rmMap = null;
    private byte[] tidBytes = new byte[16];
    private int status = 0;
    private LocalTxProvider localResourceReference = null;
    private LocalTransaction localTX = null;
    private OTSTransaction otsTx = null;
    private String txToString;
    private Object[] txToObjectArray;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ResourceImpl;

    public ResourceImpl(byte[] _tidBytes, OTSTransaction ots_Tx) {
        this.tidBytes = _tidBytes;
        this.otsTx = ots_Tx;
    }

    public void enlistLocalResource(LocalTxProvider localRef) throws SystemException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .enlistLocalResource({1})", new Object[]{this.toString(), ResourceImpl.objectToString(localRef)});
        }
        if (this.localResourceReference != null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0} local resource is already enlisted into Transaction ( {1} ), second enlistLocalResource is not possible.", new Object[]{this.toString(), ResourceImpl.objectToString(this.localResourceReference)});
            }
            throw new BaseSystemException("ts_0035", this.toString());
        }
        this.localResourceReference = localRef;
        this.localTX = (LocalTransaction)this.localResourceReference.getLocalTransaction();
        try {
            this.localTX.begin();
        }
        catch (RuntimeException e) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.logThrowableT(500, LOCATION, "{0} couldn't start local transaction .", this.toObjectArray(), (Throwable)e);
            }
            throw new BaseSystemException("ts_0038", this.toString(), (Throwable)e);
        }
        catch (ResourceException e) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "{0} couldn't start local transaction.", this.toObjectArray(), (Throwable)e);
            }
            throw new BaseSystemException("ts_0038", this.toString(), (Throwable)e);
        }
    }

    public LocalTxProvider getLocalResource() {
        if (!TransactionServiceFrame.enableLocalResourceInOTS) {
            return null;
        }
        return this.localResourceReference;
    }

    public boolean enlistResource(XAResource xaRes) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .enlistResource({1})", new Object[]{this.toString(), Log.objectToString(xaRes)});
        }
        if (this.rmMap == null) {
            this.rmMap = new RMMap();
        }
        int i = 0;
        while (i < this.rmMap.getRMCount()) {
            ResourceList resourceList = this.rmMap.getResources(i);
            boolean isSameRm = false;
            try {
                isSameRm = resourceList.isSameRM(xaRes);
            }
            catch (RuntimeException re) {
                if (CATEGORY.beLogged(400)) {
                    CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa isSameRM.", this.toObjectArray(), (Throwable)re);
                }
                return false;
            }
            catch (XAException xae) {
                if (LOCATION.beLogged(100)) {
                    LOCATION.traceThrowableT(100, "{0} exception in xa isSameRM.", this.toObjectArray(), (Throwable)xae);
                }
                return false;
            }
            if (isSameRm) {
                try {
                    xaRes.start(resourceList.getXid(), 0x200000);
                }
                catch (RuntimeException re) {
                    if (CATEGORY.beLogged(400)) {
                        CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa start.", this.toObjectArray(), (Throwable)re);
                    }
                    return false;
                }
                catch (XAException xae) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.traceThrowableT(100, "{0} exception in xa start.", this.toObjectArray(), (Throwable)xae);
                    }
                    return false;
                }
                resourceList.add(xaRes);
                return true;
            }
            ++i;
        }
        Xid xid = this.rmMap.getNewXID(this.tidBytes);
        try {
            xaRes.start(xid, 0);
        }
        catch (RuntimeException re) {
            if (CATEGORY.beLogged(400)) {
                CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa start.", this.toObjectArray(), (Throwable)re);
            }
            return false;
        }
        catch (XAException xae) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "{0} exception in xa start.", this.toObjectArray(), (Throwable)xae);
            }
            return false;
        }
        this.rmMap.addNewResourceManager((Object)xaRes, xid);
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .delistResource({1}, {2})", new Object[]{this.toString(), Log.objectToString(xaRes), Integer.toString(flag)});
        }
        if (this.rmMap != null) {
            int i = 0;
            while (i < this.rmMap.getRMCount()) {
                ResourceList resourceList = this.rmMap.getResources(i);
                boolean isSameRm = false;
                try {
                    isSameRm = resourceList.isSameRM(xaRes);
                }
                catch (RuntimeException re) {
                    if (CATEGORY.beLogged(400)) {
                        CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa isSameRM.", this.toObjectArray(), (Throwable)re);
                    }
                    throw new BaseIllegalStateException("ts_0037", re);
                }
                catch (XAException xae) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.traceThrowableT(100, "{0} exception in xa isSameRM.", this.toObjectArray(), (Throwable)xae);
                    }
                    throw new BaseIllegalStateException("ts_0037", xae);
                }
                if (isSameRm) {
                    if (resourceList.isMarked()) {
                        if (LOCATION.beLogged(100)) {
                            LOCATION.logT(100, "{0} delistResource resource manager exists but XAResource was not found.", this.toObjectArray());
                        }
                        throw new BaseIllegalStateException("ts_0010");
                    }
                    int j = 0;
                    while (j < resourceList.xaCount()) {
                        if (resourceList.getResource(j) == xaRes) {
                            resourceList.deleteResource(j);
                            try {
                                xaRes.end(resourceList.getXid(), flag);
                                return true;
                            }
                            catch (RuntimeException re) {
                                if (CATEGORY.beLogged(400)) {
                                    CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa end.", this.toObjectArray(), (Throwable)re);
                                }
                                throw new BaseIllegalStateException("ts_0036", re);
                            }
                            catch (XAException xae) {
                                if (LOCATION.beLogged(100)) {
                                    LOCATION.traceThrowableT(100, "{0} exception in xa end.", this.toObjectArray(), (Throwable)xae);
                                }
                                throw new BaseIllegalStateException("ts_0036", xae);
                            }
                        }
                        ++j;
                    }
                    throw new BaseIllegalStateException("ts_0010");
                }
                ++i;
            }
        }
        throw new BaseIllegalStateException("ts_0011");
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .prepare()", this.toObjectArray());
        }
        boolean fatalStatus = false;
        boolean xaReadOnly = true;
        if (this.rmMap != null) {
            int i = 0;
            while (i < this.rmMap.getRMCount() && !fatalStatus) {
                try {
                    int prepareStatus = this.rmMap.getResources(i).prepare();
                    boolean bl = fatalStatus = prepareStatus != 0 && prepareStatus != 3;
                    if (xaReadOnly && prepareStatus != 3) {
                        xaReadOnly = false;
                    }
                    fatalStatus = prepareStatus != 0 && prepareStatus != 3;
                }
                catch (RuntimeException re) {
                    if (CATEGORY.beLogged(400)) {
                        CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa prepare.", this.toObjectArray(), (Throwable)re);
                    }
                    return Vote.VoteRollback;
                }
                catch (XAException xaE) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.traceThrowableT(100, "{0} exception xa prepare.", this.toObjectArray(), (Throwable)xaE);
                    }
                    return Vote.VoteRollback;
                }
                ++i;
            }
        }
        if (fatalStatus) {
            throw new HeuristicMixed("SAP J2EE ENGINE | TRANSACTION SERVICE | detected a Resource Manager ERROR | TRANSACTION [{0}] WAS ROLLED BACK: In prepare phase of two phase commit protocol one or more XAResource returned unspecified in the JTA1.0.1 specification prepare status! Check the Resource Manager!");
        }
        if (xaReadOnly) {
            return Vote.VoteReadOnly;
        }
        return Vote.VoteCommit;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .rollback()", this.toObjectArray());
        }
        if (this.status != 7) {
            Enumeration enumeration = this.otsTx.getSynchronizations().elements();
            while (enumeration.hasMoreElements()) {
                Object synch = enumeration.nextElement();
                if (!(synch instanceof SynchronizationExtension)) continue;
                try {
                    ((SynchronizationJTAWrapper)((Object)synch)).beforeRollback();
                }
                catch (RuntimeException re) {
                    if (!CATEGORY.beLogged(400)) continue;
                    CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in beforeRollback.", this.toObjectArray(), (Throwable)re);
                }
            }
        }
        this.status = 9;
        Throwable exception = null;
        try {
            if (this.localTX != null) {
                try {
                    this.localTX.rollback();
                }
                catch (RuntimeException re) {
                    if (CATEGORY.beLogged(400)) {
                        CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in local resource rollback.", this.toObjectArray(), (Throwable)re);
                    }
                    exception = re;
                }
                catch (ResourceException re) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.traceThrowableT(100, "{0} exception in local resource rollback.", this.toObjectArray(), (Throwable)re);
                    }
                    exception = re;
                }
            }
            if (this.rmMap != null) {
                int rmIndex = 0;
                while (rmIndex < this.rmMap.getRMCount()) {
                    try {
                        this.rmMap.getResources(rmIndex).rollback();
                    }
                    catch (RuntimeException re) {
                        if (CATEGORY.beLogged(400)) {
                            CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa resource rollback.", this.toObjectArray(), (Throwable)re);
                        }
                        exception = re;
                    }
                    catch (XAException xae) {
                        if (LOCATION.beLogged(100)) {
                            LOCATION.traceThrowableT(100, "{0} exception in xa resource rollback.", this.toObjectArray(), (Throwable)xae);
                        }
                        exception = xae;
                    }
                    ++rmIndex;
                }
            }
            Object var6_10 = null;
            this.status = 4;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.status = 4;
            throw throwable;
        }
        if (exception != null) {
            throw new HeuristicMixed("Exception in rollback : " + exception.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .commit()", this.toObjectArray());
        }
        this.status = 8;
        Throwable exception = null;
        try {
            block16: {
                try {
                    if (this.localTX != null && TransactionServiceFrame.enableLocalResourceInOTS) {
                        this.localTX.commit();
                    }
                    if (this.rmMap == null) break block16;
                    int i = 0;
                    while (i < this.rmMap.getRMCount()) {
                        try {
                            this.rmMap.getResources(i).commitTwoPhase();
                        }
                        catch (RuntimeException re) {
                            if (CATEGORY.beLogged(500)) {
                                CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)re);
                            }
                            exception = re;
                        }
                        catch (XAException xaE) {
                            if (CATEGORY.beLogged(500)) {
                                CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)xaE);
                            }
                            exception = xaE;
                        }
                        ++i;
                    }
                }
                catch (RuntimeException re) {
                    if (!CATEGORY.beLogged(500)) throw new HeuristicMixed("commit of javax.resource.spi.LocalTrancaction fail " + re.toString());
                    CATEGORY.logThrowableT(500, LOCATION, "{0} local resource couldn't commit successfully.", this.toObjectArray(), (Throwable)re);
                    throw new HeuristicMixed("commit of javax.resource.spi.LocalTrancaction fail " + re.toString());
                }
                catch (ResourceException re) {
                    if (!CATEGORY.beLogged(500)) throw new HeuristicMixed("commit of javax.resource.spi.LocalTrancaction fail " + re.toString());
                    CATEGORY.logThrowableT(500, LOCATION, "{0} local resource couldn't commit successfully.", this.toObjectArray(), (Throwable)re);
                    throw new HeuristicMixed("commit of javax.resource.spi.LocalTrancaction fail " + re.toString());
                }
            }
            Object var6_7 = null;
            this.status = 3;
            if (exception == null) return;
            throw new HeuristicMixed("One or more XAResources were not commited because of an XAException in the second commit phase. XAException is: " + exception.getMessage());
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.status = 3;
            if (exception == null) throw throwable;
            throw new HeuristicMixed("One or more XAResources were not commited because of an XAException in the second commit phase. XAException is: " + exception.getMessage());
        }
    }

    public void commit_one_phase() throws HeuristicHazard {
        block15: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "{0} .commit_one_phase()", this.toObjectArray());
            }
            if (this.localTX != null) {
                try {
                    this.localTX.commit();
                }
                catch (RuntimeException e) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.logThrowableT(500, LOCATION, "{0} local resource couldn't commit successfully.", this.toObjectArray(), (Throwable)e);
                    }
                }
                catch (ResourceException e) {
                    if (!CATEGORY.beLogged(500)) break block15;
                    CATEGORY.logThrowableT(500, LOCATION, "{0} local resource couldn't commit successfully.", this.toObjectArray(), (Throwable)e);
                }
            }
        }
        if (this.rmMap != null) {
            if (this.rmMap.getRMCount() != 1) {
                try {
                    this.rmMap.getFirst().commitOnePhase();
                }
                catch (RuntimeException re) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)re);
                    }
                    throw new HeuristicHazard("SAP J2EE ENGINE|TRANSACTION SERVICE| XAException occured during commit_one_phase on an OMG Resource internal message: " + re.getMessage());
                }
                catch (XAException xae) {
                    if (CATEGORY.beLogged(500)) {
                        CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)xae);
                    }
                    throw new HeuristicHazard("SAP J2EE ENGINE|TRANSACTION SERVICE| XAException occured during commit_one_phase on an OMG Resource internal message: " + xae.getMessage());
                }
            } else {
                if (CATEGORY.beLogged(500)) {
                    CATEGORY.logT(500, LOCATION, "{0} commit_one_phase on an OMG Resource is not alowed if there are more than one resource manager.", this.toObjectArray());
                }
                throw new HeuristicHazard("SAP J2EE ENGINE|TRANSACTION SERVICE| commit_one_phase on an OMG Resource is not alowed if there are more than one resource manager");
            }
        }
    }

    public void forget() {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "{0} .forget()", this.toObjectArray());
        }
        if (this.rmMap != null) {
            int i = 0;
            while (i < this.rmMap.getRMCount()) {
                block7: {
                    try {
                        this.rmMap.getResources(i).forget();
                    }
                    catch (RuntimeException re) {
                        if (CATEGORY.beLogged(500)) {
                            CATEGORY.logThrowableT(500, LOCATION, "{0} method XAResource.forget is not successful.", this.toObjectArray(), (Throwable)re);
                        }
                    }
                    catch (XAException xae) {
                        if (!CATEGORY.beLogged(500)) break block7;
                        CATEGORY.logThrowableT(500, LOCATION, "{0} method XAResource.forget is not successful.", this.toObjectArray(), (Throwable)xae);
                    }
                }
                ++i;
            }
        }
    }

    public String toString() {
        if (this.txToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SAP J2EE Engine OTS Transaction : [");
            int i = 8;
            while (i < this.tidBytes.length) {
                buffer.append(Integer.toHexString(this.tidBytes[i]));
                ++i;
            }
            buffer.append("]");
            this.txToString = buffer.toString();
        }
        return this.txToString;
    }

    private static final String objectToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(o.hashCode());
    }

    private Object[] toObjectArray() {
        if (this.txToObjectArray == null) {
            this.txToObjectArray = new Object[1];
            this.txToObjectArray[0] = this.toString();
        }
        return this.txToObjectArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

