/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jts.ots.CosTransactions.impl;

import com.sap.engine.interfaces.transaction.TransactionExtension;
import com.sap.engine.lib.util.LinkedList;
import com.sap.engine.services.ts.Util;
import com.sap.engine.services.ts.jta.impl.TransactionImpl;
import com.sap.engine.services.ts.jta.impl.XidImpl;
import com.sap.engine.services.ts.jts.TransactionServiceImpl;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ControlImplBase;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.SynchronizationOTSWrapper;
import com.sap.tc.logging.Location;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;

public class ControlImpl
extends ControlImplBase {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ControlImpl == null ? (class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ControlImpl = ControlImpl.class$("com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ControlImpl")) : class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ControlImpl));
    private LinkedList omgResources = new LinkedList();
    private TransactionExtension tx = null;
    private PropagationContext pgContext = null;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jts$ots$CosTransactions$impl$ControlImpl;

    public ControlImpl(TransactionExtension txParam) {
        this.tx = txParam;
    }

    public LinkedList getOMGResources() {
        return this.omgResources;
    }

    public Coordinator get_coordinator() throws Unavailable {
        int txStatus;
        block3: {
            txStatus = -1;
            try {
                txStatus = this.tx.getStatus();
            }
            catch (SystemException se) {
                if (!LOCATION.beLogged(500)) break block3;
                LOCATION.traceThrowableT(500, "SystemException in transaction propagation.Coordinator is not available.", (Throwable)se);
            }
        }
        if (txStatus == 0 || txStatus == 1) {
            return this;
        }
        throw new Unavailable();
    }

    public Terminator get_terminator() throws Unavailable {
        int txStatus;
        block3: {
            txStatus = -1;
            try {
                txStatus = this.tx.getStatus();
            }
            catch (SystemException se) {
                if (!LOCATION.beLogged(500)) break block3;
                LOCATION.traceThrowableT(500, "SystemException in transaction propagation.Terminator is not available.", (Throwable)se);
            }
        }
        if (txStatus == 0 || txStatus == 1) {
            return this;
        }
        throw new Unavailable();
    }

    public Status get_status() {
        try {
            return Util.jta2omgStatus(this.tx.getStatus());
        }
        catch (SystemException se) {
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, "SystemException in transaction propagation. Status is not available.", (Throwable)se);
            }
            return null;
        }
    }

    public Status get_parent_status() {
        try {
            return Util.jta2omgStatus(this.tx.getStatus());
        }
        catch (SystemException se) {
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, "SystemException in transaction propagation. Parent status is not available.", (Throwable)se);
            }
            return null;
        }
    }

    public Status get_top_level_status() {
        try {
            return Util.jta2omgStatus(this.tx.getStatus());
        }
        catch (SystemException se) {
            if (LOCATION.beLogged(500)) {
                LOCATION.traceThrowableT(500, "SystemException in transaction propagation. Top level status is not available.", (Throwable)se);
            }
            return null;
        }
    }

    public boolean is_same_transaction(Coordinator tc) {
        if (tc == null) {
            return false;
        }
        return tc.hash_transaction() == this.hash_transaction();
    }

    public boolean is_related_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_ancestor_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_descendant_transaction(Coordinator tc) {
        return false;
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    public int hash_transaction() {
        return this.tx.hashCode();
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public RecoveryCoordinator register_resource(Resource resourceParam) throws Inactive {
        if (!this.tx.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "ControlImpl.register_resource is not successful because the transaction is not alive.");
            }
            throw new Inactive("Could not register resource because the transaction is not alive");
        }
        this.omgResources.add(resourceParam);
        return this;
    }

    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        try {
            if (this.tx.isAlive()) {
                this.tx.registerSynchronization((javax.transaction.Synchronization)new SynchronizationOTSWrapper(sync));
            }
        }
        catch (RollbackException rbe) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.register_synchronization.", (Throwable)rbe);
            }
            throw new TRANSACTION_ROLLEDBACK(rbe.getMessage());
        }
        catch (IllegalStateException ise) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.register_synchronization.", (Throwable)ise);
            }
            throw new Inactive(ise.getMessage());
        }
        catch (SystemException se) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.register_synchronization.", (Throwable)se);
            }
            throw new Inactive(se.getMessage());
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource rr) throws Inactive, NotSubtransaction {
    }

    public void rollback_only() throws Inactive {
        block4: {
            try {
                if (this.tx.getStatus() == 1) {
                    if (LOCATION.beLogged(100)) {
                        LOCATION.logT(100, "ControlImpl.rollback_only. Transactoion is already marked for rollback.");
                    }
                    throw new Inactive();
                }
                this.tx.setRollbackOnly();
            }
            catch (SystemException se) {
                if (!LOCATION.beLogged(100)) break block4;
                LOCATION.traceThrowableT(100, "SystemException in transaction propagation rollback_only.", (Throwable)se);
            }
        }
    }

    public String get_transaction_name() {
        if (!this.tx.isAlive()) {
            return null;
        }
        return this.tx.toString();
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        throw new SubtransactionsUnavailable();
    }

    public PropagationContext get_txcontext() throws Unavailable {
        if (!this.tx.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, " Transaction is not alive in method ControlImpl.get_txcontext.");
            }
            throw new Unavailable();
        }
        if (this.pgContext == null) {
            this.pgContext = new PropagationContext(86400, new TransIdentity((Coordinator)this, (Terminator)this, XidImpl.make_otid(((TransactionImpl)this.tx).getTIDbytes(), 0, 0)), new TransIdentity[0], TransactionServiceImpl.orb.create_any());
        }
        return this.pgContext;
    }

    public void commit(boolean reportHeuristic) throws HeuristicMixed, HeuristicHazard {
        try {
            this.tx.commit();
        }
        catch (IllegalStateException ise) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)ise);
            }
            throw new INVALID_TRANSACTION(ise.getMessage());
        }
        catch (SystemException ise) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)ise);
            }
            if (reportHeuristic) {
                throw new HeuristicHazard();
            }
        }
        catch (RollbackException rbe) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)rbe);
            }
            throw new TRANSACTION_ROLLEDBACK(rbe.getMessage());
        }
        catch (HeuristicRollbackException hrbe) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)hrbe);
            }
            if (reportHeuristic) {
                throw new TRANSACTION_ROLLEDBACK(hrbe.getMessage());
            }
        }
        catch (HeuristicMixedException hme) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)hme);
            }
            if (reportHeuristic) {
                throw new HeuristicMixed();
            }
        }
        catch (SecurityException se) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.commit", (Throwable)se);
            }
            if (reportHeuristic) {
                throw new HeuristicHazard(se.toString());
            }
            throw new INVALID_TRANSACTION(se.toString());
        }
    }

    public void rollback() {
        try {
            this.tx.rollback();
        }
        catch (IllegalStateException ise) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.rollback", (Throwable)ise);
            }
            throw new INVALID_TRANSACTION(ise.getMessage());
        }
        catch (SystemException se) {
            if (LOCATION.beLogged(100)) {
                LOCATION.traceThrowableT(100, "ControlImpl.rollback", (Throwable)se);
            }
            throw new INVALID_TRANSACTION(se.toString());
        }
    }

    public Status replay_completion(Resource resource) throws NotPrepared {
        return this.get_status();
    }

    public TransactionExtension getTransaction() {
        return this.tx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

