/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jta.impl;

import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = -1127902683135265949L;
    private byte[] gtid;
    private byte[] bqual;
    private int hashCode;
    private int formatID = -1;

    public XidImpl(byte[] gtid, byte[] bqual) {
        this.gtid = gtid;
        this.bqual = bqual;
        this.initHashCode();
    }

    public XidImpl(byte[] gtid, byte[] bqual, int formatID) {
        this(gtid, bqual);
        this.formatID = formatID;
    }

    public int getFormatId() {
        if (this.formatID == -1) {
            return 0;
        }
        return this.formatID;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public String toString() {
        String result = "+SAP_J2EE_ENGINE|TRANSACTION_SERVICE|XID-[GTid:";
        int i = 0;
        while (i < this.gtid.length) {
            result = result + Integer.toHexString(this.gtid[i]).toUpperCase();
            ++i;
        }
        result = result + "-Bqual:";
        int i2 = 0;
        while (i2 < this.bqual.length) {
            result = result + Integer.toHexString(this.bqual[i2]).toUpperCase();
            ++i2;
        }
        result = result + "]+";
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl cmp = (XidImpl)obj;
        if (cmp.hashCode != this.hashCode) {
            return false;
        }
        if (this.gtid.length != cmp.gtid.length || this.bqual.length != cmp.bqual.length) {
            return false;
        }
        int i = 0;
        while (i < this.gtid.length) {
            if (this.gtid[i] != cmp.gtid[i]) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.bqual.length) {
            if (this.bqual[i2] != cmp.bqual[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void initHashCode() {
        this.hashCode = 0;
        int i = 0;
        while (i < this.gtid.length) {
            this.hashCode += i;
            this.hashCode ^= this.gtid[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.bqual.length) {
            this.hashCode += i2;
            this.hashCode ^= this.bqual[i2];
            ++i2;
        }
    }

    public static otid_t make_otid(byte[] otidBytes, int formatID, int bqual_length) {
        byte[] extra = new byte[128];
        if (otidBytes.length > 128) {
            System.arraycopy(otidBytes, 0, extra, 0, 128);
        }
        return new otid_t(formatID, bqual_length > 64 ? 64 : bqual_length, otidBytes.length > 128 ? extra : otidBytes);
    }

    public static Xid otidToxid(otid_t from) {
        if (from == null) {
            return null;
        }
        if (from.formatID == -1) {
            return null;
        }
        int L = from.tid.length;
        int gtridLength = L - from.bqual_length <= 64 ? L - from.bqual_length : 64;
        int bqualLength = from.bqual_length <= 64 ? from.bqual_length : 64;
        byte[] gtid = new byte[gtridLength];
        byte[] bqual = new byte[bqualLength];
        System.arraycopy(from.tid, 0, gtid, 0, gtridLength);
        System.arraycopy(from.tid, gtridLength, bqual, 0, bqualLength);
        return new XidImpl(gtid, bqual, from.formatID);
    }

    public otid_t make_otid() {
        int formatId = this.getFormatId();
        int branchqual_length = this.bqual.length;
        byte[] tid = new byte[this.bqual.length + this.gtid.length];
        System.arraycopy(this.gtid, 0, tid, 0, this.gtid.length);
        System.arraycopy(this.bqual, 0, tid, this.gtid.length, this.bqual.length);
        return new otid_t(formatId, branchqual_length, tid);
    }

    public boolean compare(otid_t otid) {
        int bqualLength = otid.bqual_length;
        int gtridLength = otid.tid.length - bqualLength;
        if (bqualLength != this.bqual.length || gtridLength != this.gtid.length) {
            return false;
        }
        byte[] otid_bqual = new byte[bqualLength];
        byte[] otid_gtrid = new byte[gtridLength];
        System.arraycopy(otid.tid, 0, otid_gtrid, 0, gtridLength);
        System.arraycopy(otid.tid, this.gtid.length, otid_bqual, 0, bqualLength);
        int i = 0;
        i = 0;
        while (i < gtridLength) {
            if (otid_gtrid[i] != this.gtid[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < bqualLength) {
            if (otid_bqual[i] != this.bqual[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

