/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jta.impl;

import com.sap.engine.interfaces.resourceset.ResourceSet;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.tc.logging.Location;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public final class UserTransaction
implements javax.transaction.UserTransaction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jta$impl$UserTransaction == null ? (class$com$sap$engine$services$ts$jta$impl$UserTransaction = UserTransaction.class$("com.sap.engine.services.ts.jta.impl.UserTransaction")) : class$com$sap$engine$services$ts$jta$impl$UserTransaction));
    private TransactionManager tManager;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jta$impl$UserTransaction;

    public UserTransaction(TransactionManager tManager) {
        this.tManager = tManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        block4: {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "UserTransaction.begin");
            }
            this.tManager.begin();
            ResourceSet set = TransactionServiceFrame.getResourceSetFactory().getCurrentResourceSet();
            if (set != null) {
                try {
                    set.enlistAll(this.tManager.getTransaction());
                }
                catch (RollbackException rolEx) {
                    if (!LOCATION.beLogged(500)) break block4;
                    LOCATION.traceThrowableT(500, "UserTransaction.begin", (Throwable)rolEx);
                }
            }
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block4: {
            ResourceSet set;
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "UserTransaction.commit");
            }
            if ((set = TransactionServiceFrame.getResourceSetFactory().getCurrentResourceSet()) != null) {
                try {
                    set.delistAll(0x4000000);
                }
                catch (SystemException sysEx) {
                    if (!LOCATION.beLogged(500)) break block4;
                    LOCATION.traceThrowableT(500, "UserTransaction.commit", (Throwable)sysEx);
                }
            }
        }
        this.tManager.commit();
    }

    public int getStatus() throws SystemException {
        return this.tManager.getStatus();
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        block4: {
            ResourceSet set;
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "UserTransaction.rollback");
            }
            if ((set = TransactionServiceFrame.getResourceSetFactory().getCurrentResourceSet()) != null) {
                try {
                    set.delistAll(0x20000000);
                }
                catch (SystemException sysEx) {
                    if (!LOCATION.beLogged(500)) break block4;
                    LOCATION.traceThrowableT(500, "UserTransaction.rollback", (Throwable)sysEx);
                }
            }
        }
        this.tManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "UserTransaction.setRollbackOnly");
        }
        this.tManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "UserTransaction.setTransactionTimeout: " + timeout);
        }
        this.tManager.setTransactionTimeout(timeout);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

