/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jta.impl;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.transaction.TransactionExtension;
import com.sap.engine.interfaces.transaction.TransactionManagerExtension;
import com.sap.engine.services.ts.Log;
import com.sap.engine.services.ts.TransactionContextObject;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ts.exceptions.BaseInvalidTransactionException;
import com.sap.engine.services.ts.exceptions.BaseNotSupportedException;
import com.sap.engine.services.ts.exceptions.BaseSystemException;
import com.sap.engine.services.ts.jta.impl.HollowTimeoutManager;
import com.sap.engine.services.ts.jta.impl.JCATransaction;
import com.sap.engine.services.ts.jta.impl.TransactionImpl;
import com.sap.engine.services.ts.jts.ots.OTSTransaction;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.PropagationContext;

public class TransactionManagerImpl
implements TransactionManagerExtension {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jta$impl$TransactionManagerImpl == null ? (class$com$sap$engine$services$ts$jta$impl$TransactionManagerImpl = TransactionManagerImpl.class$("com.sap.engine.services.ts.jta.impl.TransactionManagerImpl")) : class$com$sap$engine$services$ts$jta$impl$TransactionManagerImpl));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private long init;
    private int cid;
    private int tid = 0;
    private ApplicationServiceContext serviceContext;
    private int txContextID;
    private Object tidLocker = new Object();
    private byte[] staticResult = new byte[16];
    protected static long rollbackTransactionsCount = 0L;
    protected static long commitedTransactionsCount = 0L;
    protected static long timeoutedTransactionsCount = 0L;
    protected static int activeTransactionsCount = 0;
    protected static int suspendedTransactionsCount = 0;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jta$impl$TransactionManagerImpl;

    public TransactionManagerImpl(ApplicationServiceContext asContext, int txContextIDParam) {
        rollbackTransactionsCount = 0L;
        commitedTransactionsCount = 0L;
        timeoutedTransactionsCount = 0L;
        activeTransactionsCount = 0;
        suspendedTransactionsCount = 0;
        this.init = System.currentTimeMillis();
        this.txContextID = txContextIDParam;
        this.serviceContext = asContext;
        this.cid = this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        this.staticResult[0] = (byte)(this.init >> 56);
        this.staticResult[1] = (byte)(this.init >> 48);
        this.staticResult[2] = (byte)(this.init >> 40);
        this.staticResult[3] = (byte)(this.init >> 32);
        this.staticResult[4] = (byte)(this.init >> 24);
        this.staticResult[5] = (byte)(this.init >> 16);
        this.staticResult[6] = (byte)(this.init >> 8);
        this.staticResult[7] = (byte)this.init;
        this.staticResult[8] = (byte)(this.cid >> 24);
        this.staticResult[9] = (byte)(this.cid >> 16);
        this.staticResult[10] = (byte)(this.cid >> 8);
        this.staticResult[11] = (byte)this.cid;
    }

    private byte[] createTXid() {
        byte[] result = new byte[16];
        System.arraycopy(this.staticResult, 0, result, 0, 12);
        int localTid = 0;
        Object object = this.tidLocker;
        synchronized (object) {
            localTid = this.tid++;
        }
        result[12] = (byte)(localTid >> 24);
        result[13] = (byte)(localTid >> 16);
        result[14] = (byte)(localTid >> 8);
        result[15] = (byte)localTid;
        return result;
    }

    public void beginOTStransaction(PropagationContext pgContext) throws NotSupportedException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.beginOTStransaction({0})", new Object[]{Log.objectToString(pgContext)});
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to start transaction in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension txOld = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (txOld != null && txOld.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread already associated with transaction.");
            }
            throw new BaseNotSupportedException("ts_0019");
        }
        OTSTransaction otsTX = new OTSTransaction(pgContext);
        ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = otsTX;
        ++activeTransactionsCount;
    }

    public com.sap.engine.interfaces.transaction.JCATransaction beginJCATransaction(Xid xid, long timeout) throws NotSupportedException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.beginJCATransaction({0}, {1})", new Object[]{Log.objectToString(xid), Long.toString(timeout)});
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to start transaction in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension txOld = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (txOld != null && txOld.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread already associated with transaction.");
            }
            throw new BaseNotSupportedException("ts_0019");
        }
        JCATransaction jcaTX = null;
        if (timeout > 0L) {
            jcaTX = new JCATransaction(xid, true);
            try {
                TransactionServiceFrame.timeoutManager.registerTimeoutListener(jcaTX, timeout * 1000L, 0L);
            }
            catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                if (CATEGORY.beLogged(400)) {
                    CATEGORY.logThrowableT(400, LOCATION, "TransactionManagerImpl.beginJCATransaction timeout service is not started. There is no transaction timeout.", (Throwable)e);
                }
            }
        } else {
            jcaTX = new JCATransaction(xid, false);
        }
        ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = jcaTX;
        ++activeTransactionsCount;
        return jcaTX;
    }

    public void begin() throws NotSupportedException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.begin");
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to start transaction in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionContextObject transactionContext = (TransactionContextObject)tc.getContextObject(this.txContextID);
        int timeout = transactionContext.getTimeout();
        TransactionExtension txOld = (TransactionExtension)transactionContext.transaction;
        if (txOld != null && txOld.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread already associated with transaction.");
            }
            throw new BaseNotSupportedException("ts_0019");
        }
        TransactionImpl tx = null;
        if (timeout > 0) {
            tx = new TransactionImpl(this.createTXid(), true);
            try {
                TransactionServiceFrame.timeoutManager.registerTimeoutListener(tx, (long)timeout * 1000L, 0L);
            }
            catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                if (CATEGORY.beLogged(400)) {
                    CATEGORY.logThrowableT(400, LOCATION, "TransactionManagerImpl.begin timeout service is not started. There is no transaction timeout.", (Throwable)e);
                }
            }
        } else {
            tx = new TransactionImpl(this.createTXid(), false);
        }
        ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = tx;
        ++activeTransactionsCount;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.commit");
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to commit transaction in system(no transaction) thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension tx = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (tx == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread is not associated with transaction.");
            }
            throw new BaseIllegalStateException("ts_0021");
        }
        try {
            tx.commit();
            Object var4_3 = null;
            ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = null;
            throw throwable;
        }
    }

    public int getStatus() throws SystemException {
        TransactionExtension tx = null;
        ThreadContext threadCon = TransactionServiceFrame.threadSystem.getThreadContext();
        if (threadCon == null) {
            return 6;
        }
        try {
            tx = (TransactionExtension)((TransactionContextObject)threadCon.getContextObject((int)this.txContextID)).transaction;
            if (tx != null && tx.isAlive()) {
                return tx.getStatus();
            }
            return 6;
        }
        catch (SystemException ex) {
            LOCATION.traceThrowableT(300, "Unexpected exception", (Throwable)ex);
            return 5;
        }
    }

    public Transaction getTransaction() throws SystemException {
        ThreadContext threadCon = TransactionServiceFrame.threadSystem.getThreadContext();
        if (threadCon == null) {
            return null;
        }
        TransactionExtension tx = (TransactionExtension)((TransactionContextObject)threadCon.getContextObject((int)this.txContextID)).transaction;
        if (tx == null || !tx.isAlive()) {
            return null;
        }
        return tx;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.resume({0})", new Object[]{Log.objectToString(tobj)});
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to resume transaction in system(no transaction) thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension tx = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (tobj == null) {
            return;
        }
        if (!(tobj instanceof TransactionExtension)) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Not valid transaction object for this TransactionManager.");
            }
            throw new BaseInvalidTransactionException("ts_0024", Log.objectToString(tobj));
        }
        if (tx != null && tx.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread already associated with transaction.");
            }
            throw new BaseIllegalStateException("ts_0019");
        }
        ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = tobj;
        ++activeTransactionsCount;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.rollback");
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to rollback transaction in system(no transaction) thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension tx = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (tx == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread is not associated with transaction.");
            }
            throw new BaseIllegalStateException("ts_0021");
        }
        try {
            tx.rollback();
            Object var4_3 = null;
            ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction = null;
            throw throwable;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.setRollbackOnly");
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to set transaction in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionExtension tx = (TransactionExtension)((TransactionContextObject)tc.getContextObject((int)this.txContextID)).transaction;
        if (tx == null || !tx.isAlive()) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Thread is not associated with transaction.");
            }
            throw new BaseIllegalStateException("ts_0021");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.setTransactionTimeout({0})", new Object[]{Integer.toString(seconds)});
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to set transaction timout in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        ((TransactionContextObject)tc.getContextObject(this.txContextID)).setTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        ThreadContext tc;
        if (LOCATION.beLogged(100)) {
            LOCATION.logT(100, "TransactionManagerImpl.suspend");
        }
        if ((tc = TransactionServiceFrame.threadSystem.getThreadContext()) == null) {
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, "Trying to suspend transaction in system thread.");
            }
            throw new BaseSystemException("ts_0018");
        }
        TransactionContextObject transactionContextObject = (TransactionContextObject)tc.getContextObject(this.txContextID);
        Transaction suspendedTx = transactionContextObject.transaction;
        if (suspendedTx == null || !((TransactionExtension)suspendedTx).isAlive()) {
            return null;
        }
        transactionContextObject.transaction = null;
        --activeTransactionsCount;
        ++suspendedTransactionsCount;
        return suspendedTx;
    }

    public long getRollbackTransactionsCount() {
        return rollbackTransactionsCount;
    }

    public long getCommitedTransactionsCount() {
        return commitedTransactionsCount;
    }

    public long getTimedoutTransactionsCount() {
        return timeoutedTransactionsCount;
    }

    public int getActiveTransactionsCount() {
        return activeTransactionsCount;
    }

    public int getSuspendedTransactionsCount() {
        return suspendedTransactionsCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

