/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jta.impl;

import com.sap.engine.lib.util.LinkedList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ResourceList {
    private Xid xid = null;
    private LinkedList resourceList = new LinkedList();
    private boolean marked = false;
    private int prepareStatus = 0;

    public ResourceList(Xid xid) {
        this.xid = xid;
    }

    public void add(Object xaResource) {
        if (this.marked) {
            this.marked = false;
            this.resourceList.removeFirst();
        }
        this.resourceList.add(xaResource);
    }

    public Object getResource(int xaIndex) {
        return this.resourceList.get(xaIndex);
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource.isSameRM((XAResource)this.resourceList.getFirst());
    }

    public int prepare() throws XAException {
        this.prepareStatus = ((XAResource)this.resourceList.getFirst()).prepare(this.xid);
        return this.prepareStatus;
    }

    public void forget() throws XAException {
        ((XAResource)this.resourceList.getFirst()).forget(this.xid);
    }

    public void commitTwoPhase() throws XAException {
        if (this.prepareStatus == 0) {
            ((XAResource)this.resourceList.getFirst()).commit(this.xid, false);
        }
    }

    public void commitOnePhase() throws XAException {
        ((XAResource)this.resourceList.getFirst()).commit(this.xid, true);
    }

    public void rollback() throws XAException {
        ((XAResource)this.resourceList.getFirst()).rollback(this.xid);
    }

    public int xaCount() {
        return this.resourceList.size();
    }

    public void deleteResource(int xaIndex) {
        if (this.resourceList.size() == 1) {
            this.marked = true;
        } else {
            this.resourceList.remove(xaIndex);
        }
    }

    public boolean isMarked() {
        return this.marked;
    }

    public int getPrepareStatus() {
        return this.prepareStatus;
    }

    public void setPrepareStatus(int prepareStatus) {
        this.prepareStatus = prepareStatus;
    }

    public Xid getXid() {
        return this.xid;
    }
}

