/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts.jta.impl;

import com.sap.engine.interfaces.transaction.LocalTxProvider;
import com.sap.engine.lib.util.LinkedList;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.ts.TransactionServiceFrame;
import com.sap.engine.services.ts.exceptions.BaseHeuristicMixedException;
import com.sap.engine.services.ts.exceptions.BaseIllegalStateException;
import com.sap.engine.services.ts.exceptions.BaseRollbackException;
import com.sap.engine.services.ts.exceptions.BaseSystemException;
import com.sap.engine.services.ts.jta.impl.HollowTimeoutManager;
import com.sap.engine.services.ts.jta.impl.TransactionImpl;
import com.sap.engine.services.ts.jts.TransactionServiceImpl;
import com.sap.engine.services.ts.jts.ots.CosTSPortability.impl.SenderReceiverImpl;
import com.sap.engine.services.ts.jts.ots.CosTransactions.impl.ResourceImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Vote;

public class JCATransaction
extends TransactionImpl
implements TimeoutListener,
com.sap.engine.interfaces.transaction.JCATransaction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$jta$impl$JCATransaction == null ? (class$com$sap$engine$services$ts$jta$impl$JCATransaction = JCATransaction.class$("com.sap.engine.services.ts.jta.impl.JCATransaction")) : class$com$sap$engine$services$ts$jta$impl$JCATransaction));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private boolean activeInThread = true;
    private LocalTransaction localTX = null;
    private LocalTxProvider localResourceReference = null;
    private int status = 0;
    private Xid xid = null;
    LinkedList omgResources = null;
    Vote[] voteRes = null;
    long omgResCount = 0L;
    private boolean timeoutListener = false;
    static /* synthetic */ Class class$com$sap$engine$services$ts$jta$impl$JCATransaction;

    public JCATransaction(Xid _xid, boolean _timeoutListener) {
        this.xid = _xid;
        this.timeoutListener = _timeoutListener;
    }

    public boolean getActiveThreadFlag() {
        return this.activeInThread;
    }

    public void enlistLocalResource(LocalTxProvider localRef) throws SystemException {
        if (TransactionServiceFrame.enableLocalResourceInOTS) {
            if (this.localResourceReference != null) {
                throw new BaseSystemException("ts_0035", this.toString());
            }
            this.localResourceReference = localRef;
            this.localTX = (LocalTransaction)localRef.getLocalTransaction();
            try {
                this.localTX.begin();
            }
            catch (ResourceException e) {
                throw new SystemException(e.toString());
            }
        } else {
            throw new BaseSystemException("ts_0026", "ENABLE_LOCAL_RESOURCE_IN_OTS");
        }
    }

    public boolean isEmpty() {
        return this.localTX == null;
    }

    /*
     * Loose catch block
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block37: {
            block34: {
                block35: {
                    int i;
                    block36: {
                        Exception exception;
                        block33: {
                            block32: {
                                if (this.activeInThread) break block34;
                                if (this.status != 2) break block35;
                                this.status = 8;
                                exception = null;
                                if (this.localTX != null) {
                                    this.localTX.commit();
                                }
                                if (this.rmMap == null) break block32;
                                i = 0;
                                while (i < this.rmMap.getRMCount()) {
                                    try {
                                        this.rmMap.getResources(i).commitTwoPhase();
                                    }
                                    catch (RuntimeException re) {
                                        if (CATEGORY.beLogged(500)) {
                                            CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)re);
                                        }
                                        exception = re;
                                    }
                                    catch (XAException xaE) {
                                        if (CATEGORY.beLogged(500)) {
                                            CATEGORY.logThrowableT(500, LOCATION, "{0} xa resource couldn't commit successfully.", this.toObjectArray(), (Throwable)xaE);
                                        }
                                        exception = xaE;
                                    }
                                    ++i;
                                }
                            }
                            Object var6_11 = null;
                            this.status = 3;
                            if (!this.timeoutListener) break block33;
                            try {
                                TransactionServiceFrame.timeoutManager.unregisterTimeoutListener(this);
                            }
                            catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                                LOCATION.traceThrowableT(300, "Timeout service not started", (Throwable)e);
                            }
                        }
                        if (exception != null) {
                            throw new BaseHeuristicMixedException("ts_0007", "XAException", (Throwable)exception);
                        }
                        break block36;
                        {
                            catch (ResourceException re) {
                                throw new BaseHeuristicMixedException("ts_0006", "javax.resource.spi.LocalTrancaction", (Throwable)re);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            this.status = 3;
                            if (this.timeoutListener) {
                                try {
                                    TransactionServiceFrame.timeoutManager.unregisterTimeoutListener(this);
                                }
                                catch (HollowTimeoutManager.TimeOutIsStoppedException e) {
                                    LOCATION.traceThrowableT(300, "Timeout service not started", (Throwable)e);
                                }
                            }
                            if (exception != null) {
                                throw new BaseHeuristicMixedException("ts_0007", "XAException", exception);
                            }
                            throw throwable;
                        }
                    }
                    if (this.txControl != null) {
                        i = 0;
                        while ((long)i < this.omgResCount) {
                            try {
                                if (this.voteRes[i] == Vote.VoteCommit) {
                                    ((Resource)this.omgResources.get(i)).commit();
                                } else if (this.voteRes[i] == Vote.VoteRollback) {
                                    ((Resource)this.omgResources.get(i)).rollback();
                                }
                            }
                            catch (HeuristicMixed hm) {
                                throw new BaseHeuristicMixedException("ts_0016", hm);
                            }
                            catch (NotPrepared np) {
                                throw new BaseHeuristicMixedException("ts_0016", np);
                            }
                            catch (HeuristicRollback hr) {
                                throw new BaseHeuristicMixedException("ts_0016", hr);
                            }
                            catch (HeuristicHazard hh) {
                                throw new BaseHeuristicMixedException("ts_0016", hh);
                            }
                            catch (HeuristicCommit hc) {
                                throw new BaseHeuristicMixedException("ts_0016", hc);
                            }
                            ++i;
                        }
                    }
                    Enumeration enumeration = this.synchronizations.elements();
                    while (enumeration.hasMoreElements()) {
                        try {
                            ((Synchronization)enumeration.nextElement()).afterCompletion(3);
                        }
                        catch (RuntimeException te) {
                            LOCATION.traceThrowableT(300, "Unexpected exception", (Throwable)te);
                        }
                    }
                    if (this.txControl != null) {
                        byte[] tidBytes = new byte[this.xid.getBranchQualifier().length + this.xid.getGlobalTransactionId().length];
                        System.arraycopy(this.xid.getGlobalTransactionId(), 0, tidBytes, 0, this.xid.getGlobalTransactionId().length);
                        System.arraycopy(this.xid.getBranchQualifier(), 0, tidBytes, this.xid.getGlobalTransactionId().length + 1, this.xid.getBranchQualifier().length);
                        ((SenderReceiverImpl)TransactionServiceImpl.getReceiver()).getImportedTx().remove(tidBytes);
                    }
                    break block37;
                }
                super.commit();
                break block37;
            }
            throw new BaseSystemException("ts_0033");
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.activeInThread) {
            throw new BaseSystemException("ts_0033");
        }
        super.rollback();
    }

    public void forget() {
        if (this.activeInThread) {
            this.activeInThread = false;
        }
        int omgResSize = this.txControl.getOMGResources().size();
        LinkedList resources = this.txControl.getOMGResources();
        int i = 0;
        while (i < omgResSize) {
            ((ResourceImpl)((Object)resources.get(i))).forget();
            ++i;
        }
        if (this.rmMap != null) {
            int i2 = 0;
            while (i2 < this.rmMap.getRMCount()) {
                try {
                    this.rmMap.getResources(i2).forget();
                }
                catch (XAException xaE) {
                    LOCATION.traceThrowableT(300, "Unexpected exception", (Throwable)xaE);
                }
                ++i2;
            }
        }
        this.activeInThread = true;
    }

    public int prepare() throws RollbackException, HeuristicMixedException, SystemException {
        if (this.status == 0 && !this.activeInThread) {
            int i;
            if (this.txControl != null) {
                this.omgResources = this.txControl.getOMGResources();
                this.omgResCount = this.omgResources.size();
                this.voteRes = new Vote[this.omgResources.size()];
            }
            if (this.status == 1) {
                this.rollback();
                throw new BaseRollbackException("ts_0001", this.toString());
            }
            if (this.status == 4 || this.status == 9) {
                throw new BaseRollbackException("ts_0002", this.toString());
            }
            if (this.status != 0) {
                throw new BaseIllegalStateException("ts_0003", this.toString());
            }
            RuntimeException befCompl = null;
            Enumeration enumeration = this.synchronizations.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((Synchronization)enumeration.nextElement()).beforeCompletion();
                }
                catch (RuntimeException te) {
                    LOCATION.traceThrowableT(300, "Unexpected exception", (Throwable)te);
                    if (befCompl != null) continue;
                    befCompl = te;
                }
            }
            if (befCompl != null) {
                this.rollback();
                throw new BaseRollbackException("ts_0004", this.toString(), befCompl);
            }
            if (this.status == 1) {
                this.rollback();
                throw new BaseRollbackException("ts_0001", this.toString());
            }
            this.status = 7;
            boolean fatalStatus = false;
            if (this.rmMap != null) {
                i = 0;
                while (i < this.rmMap.getRMCount() && !fatalStatus) {
                    block22: {
                        try {
                            int prepareStatus = this.rmMap.getResources(i).prepare();
                            fatalStatus = prepareStatus != 0 && prepareStatus != 3;
                        }
                        catch (XAException xaE) {
                            fatalStatus = true;
                            if (LOCATION.beLogged(100)) {
                                LOCATION.traceThrowableT(100, "{0} exception  in prepare method of XAResource.", this.toObjectArray(), (Throwable)xaE);
                            }
                        }
                        catch (RuntimeException re) {
                            fatalStatus = true;
                            if (!CATEGORY.beLogged(400)) break block22;
                            CATEGORY.logThrowableT(400, LOCATION, "{0} unexpected exception in xa prepare.", this.toObjectArray(), (Throwable)re);
                        }
                    }
                    ++i;
                }
            }
            if (fatalStatus) {
                this.rollback();
                throw new BaseSystemException("ts_0005", this.toString());
            }
            if (this.txControl != null) {
                i = 0;
                while ((long)i < this.omgResCount) {
                    try {
                        this.voteRes[i] = ((Resource)this.omgResources.get(i)).prepare();
                    }
                    catch (HeuristicMixed hm) {
                        throw new BaseHeuristicMixedException("ts_0015", hm);
                    }
                    catch (HeuristicHazard hh) {
                        throw new BaseHeuristicMixedException("ts_0015", hh);
                    }
                    ++i;
                }
            }
            this.status = 2;
            return 0;
        }
        throw new BaseSystemException("ts_0033");
    }

    public String toString() {
        String result = "SAP J2EE Engine JCA Transaction [";
        int i = 0;
        while (i < this.xid.getGlobalTransactionId().length) {
            result = result + Integer.toHexString(this.xid.getGlobalTransactionId()[i]).toUpperCase();
            ++i;
        }
        result = result + ":";
        int i2 = 0;
        while (i2 < this.xid.getBranchQualifier().length) {
            result = result + Integer.toHexString(this.xid.getBranchQualifier()[i2]).toUpperCase();
            ++i2;
        }
        result = result + "]";
        return result;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 2) {
            throw new BaseIllegalStateException("ts_0012", this.toString());
        }
        if (this.status == 1) {
            throw new BaseRollbackException("ts_0001", this.toString());
        }
        if (this.status != 0) {
            throw new BaseIllegalStateException("ts_0003", this.toString());
        }
        this.synchronizations.addElement(sync);
    }

    public void timeout() {
        if (this.status == 0 || this.status == 1) {
            try {
                this.rollback();
            }
            catch (SystemException sE) {
                LOCATION.traceThrowableT(300, "Unexpected exception", (Throwable)sE);
            }
        }
    }

    public boolean check() {
        return true;
    }

    public synchronized boolean activateInThread() {
        if (this.status == 2 || this.status == 8 || this.status == 9) {
            this.activeInThread = false;
        }
        boolean old = this.activeInThread;
        this.activeInThread = true;
        return old;
    }

    public synchronized void notInThread() {
        if (!this.activeInThread) {
            RuntimeException runtimeException = new RuntimeException(this + " is 'not in thread' and is tried to be marked as 'not in thread'");
        }
        this.activeInThread = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

