/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ts;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.resourceset.ResourceSetFactory;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.ts.TransactionContextObject;
import com.sap.engine.services.ts.TransactionServiceManagementImpl;
import com.sap.engine.services.ts.exceptions.BaseServiceException;
import com.sap.engine.services.ts.exceptions.BaseSystemException;
import com.sap.engine.services.ts.jta.impl.HollowTimeoutManager;
import com.sap.engine.services.ts.jta.impl.TransactionManagerImpl;
import com.sap.engine.services.ts.jta.impl.UserTransaction;
import com.sap.engine.services.ts.jts.TransactionServiceImpl;
import com.sap.engine.services.ts.transaction.TxManager;
import com.sap.engine.services.ts.transaction.TxManagerImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.transaction.ITxManager;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public class TransactionServiceFrame
extends ContainerEventListenerAdapter
implements ApplicationServiceFrame {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ts$TransactionServiceFrame == null ? (class$com$sap$engine$services$ts$TransactionServiceFrame = TransactionServiceFrame.class$("com.sap.engine.services.ts.TransactionServiceFrame")) : class$com$sap$engine$services$ts$TransactionServiceFrame));
    private static final Category CATEGORY = Category.SYS_SERVER;
    private static final int MASK = 228;
    private static final TimeoutManager STOPPED_TIMEOUT_SERVICE;
    public static TimeoutManager timeoutManager;
    private final int DEFAULT_TRANSACTION_TIMEOUT = 86400;
    private int txTimeout = 86400;
    private TransactionManagerImpl tManager = null;
    private UserTransaction userTransaction = null;
    private TransactionServiceImpl corbaTS = null;
    private Context naming = null;
    public static ThreadSystem threadSystem;
    public static int txContextID;
    public static boolean enableLocalResourceInOTS;
    private ApplicationServiceContext serviceContext = null;
    private static ResourceSetFactory resourceSetFactory;
    private Set neededInterfaces = new HashSet(2);
    static /* synthetic */ Class class$com$sap$engine$services$ts$TransactionServiceFrame;

    public TransactionServiceFrame() {
        this.neededInterfaces.add("resourceset_api");
        this.neededInterfaces.add("timeout");
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        this.serviceContext = serviceContext;
        Properties props = serviceContext.getServiceState().getProperties();
        String result = props.getProperty("EnableLocalResourceInOTS");
        if (result != null) {
            boolean bl = enableLocalResourceInOTS = result.equalsIgnoreCase("true") || result.equalsIgnoreCase("enable") || result.equalsIgnoreCase("on") || result.equalsIgnoreCase("yes");
        }
        if ((result = props.getProperty("TransactionTimeout")) != null) {
            this.txTimeout = new Integer(result);
        }
        threadSystem = serviceContext.getCoreContext().getThreadSystem();
        txContextID = threadSystem.registerContextObject("TRANSACTION_CONTEXT_OBJECT", new TransactionContextObject(this.txTimeout));
        this.tManager = new TransactionManagerImpl(serviceContext, txContextID);
        TxManager.setTransactionManager((TransactionManager)this.tManager);
        com.sap.transaction.TxManager.setTxManagerImpl((ITxManager)new TxManagerImpl());
        TransactionServiceManagementImpl tsManagement = new TransactionServiceManagementImpl(this.tManager);
        this.userTransaction = new UserTransaction((TransactionManager)this.tManager);
        TxManager.setUserTransaction(this.userTransaction);
        this.corbaTS = new TransactionServiceImpl(this.tManager);
        try {
            this.naming = new InitialDirContext();
            this.naming.rebind("UserTransaction", (Object)this.userTransaction);
            this.naming.rebind("TransactionManager", (Object)this.tManager);
            this.naming.rebind("TransactionService", (Object)this.corbaTS);
        }
        catch (NamingException ne) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.logThrowableT(500, LOCATION, "Transaction Service cannot getInitialContext. Transaction Service can not start correctly.", (Throwable)ne);
            }
            throw new BaseServiceException("ts_0039", (Throwable)ne);
        }
        serviceContext.getContainerContext().getObjectRegistry().registerInterface(this.tManager);
        serviceContext.getServiceState().registerManagementInterface(tsManagement);
        serviceContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("transactionext", this.tManager);
        serviceContext.getServiceState().registerContainerEventListener(228, this.neededInterfaces, this);
    }

    public void stop() {
        block2: {
            threadSystem.unregisterContextObject("TRANSACTION_CONTEXT_OBJECT");
            this.serviceContext.getServiceState().unregisterManagementInterface();
            this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("transactionext");
            try {
                this.naming.unbind("UserTransaction");
                this.naming.unbind("TransactionManager");
                this.naming.unbind("TransactionService");
            }
            catch (NamingException ne) {
                if (!CATEGORY.beLogged(400)) break block2;
                CATEGORY.logThrowableT(400, LOCATION, "UserTransaction and TransactionManager could not be unbinded during transaction service stoping.", (Throwable)ne);
            }
        }
        this.naming = null;
        this.tManager = null;
        this.userTransaction = null;
        this.corbaTS = null;
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return true;
    }

    public Object getServiceInterface() {
        return this.tManager;
    }

    public static ResourceSetFactory getResourceSetFactory() throws SystemException {
        ResourceSetFactory result = resourceSetFactory;
        if (result == null) {
            if (CATEGORY.beLogged(500)) {
                CATEGORY.logT(500, LOCATION, "Transaction service : Service Connector not available, trying to work without it.");
            }
            throw new BaseSystemException("ts_0040");
        }
        return result;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("resourceset_api")) {
            resourceSetFactory = (ResourceSetFactory)interfaceImpl;
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("resourceset_api")) {
            resourceSetFactory = null;
        }
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if ("timeout".equals(serviceName)) {
            timeoutManager = (TimeoutManager)serviceInterface;
        }
    }

    public void serviceStopped(String serviceName) {
        if ("timeout".equals(serviceName)) {
            timeoutManager = STOPPED_TIMEOUT_SERVICE;
        }
    }

    public static TransactionContextObject getTransactionContextObject() throws SystemException {
        ThreadContext threadCon = threadSystem.getThreadContext();
        if (threadCon == null) {
            throw new SystemException("Transactions cannot be used in system thread");
        }
        return (TransactionContextObject)threadCon.getContextObject(txContextID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        timeoutManager = STOPPED_TIMEOUT_SERVICE = new HollowTimeoutManager();
        threadSystem = null;
        enableLocalResourceInOTS = false;
        resourceSetFactory = null;
    }
}

