/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.timeout;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.services.timeout.PriorityQueue;
import com.sap.engine.services.timeout.TimeoutIntegrityWatcher;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManagementInterface;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.engine.services.timeout.TimeoutNode;
import com.sap.engine.services.timeout.TimeoutResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Properties;

public final class TimeoutManagerImpl
implements TimeoutManager,
TimeoutManagementInterface,
Runnable {
    public static Category category = Category.getCategory((String)"/System/Server");
    public static Location location = Location.getLocation((Class)(class$com$sap$engine$services$timeout$TimeoutManagerImpl == null ? (class$com$sap$engine$services$timeout$TimeoutManagerImpl = TimeoutManagerImpl.class$("com.sap.engine.services.timeout.TimeoutManagerImpl")) : class$com$sap$engine$services$timeout$TimeoutManagerImpl));
    private static final String THREAD_NAME = "Timeout Service Internal Thread";
    private static final double FACTOR = 60000.0;
    private int registeredListenersCount;
    private double estimatedFrequencyPerMinute;
    private ThreadSystem threadSystem;
    private HashMap map;
    private PriorityQueue queue;
    private Thread internalThread;
    private TimeoutIntegrityWatcher integrityWatcher;
    private int threadPriority;
    private boolean work;
    private Object lock = new Object();
    static /* synthetic */ Class class$com$sap$engine$services$timeout$TimeoutManagerImpl;

    TimeoutManagerImpl(Properties properties, ThreadSystem ts) {
        if (properties == null) {
            properties = new Properties();
        }
        this.threadSystem = ts;
        this.map = new HashMap();
        this.queue = new PriorityQueue();
        this.threadPriority = this.readIntProperty(properties, "InternalThreadPriority", Integer.toString(5));
        if (this.threadPriority < 1 || this.threadPriority > 10) {
            category.warningT(location, TimeoutResourceAccessor.formatString(4, new Object[]{new Integer(5)}));
            this.threadPriority = 5;
        }
        this.integrityWatcher = new TimeoutIntegrityWatcher(this.queue, this.threadSystem);
        this.work = true;
        new Thread(this).start();
        location.pathT(TimeoutResourceAccessor.getString(5));
    }

    private final int readIntProperty(Properties properties, String name, String defaultValue) {
        try {
            int tmp = Integer.parseInt(properties.getProperty(name, defaultValue));
            return tmp;
        }
        catch (NumberFormatException nfException) {
            category.warningT(location, TimeoutResourceAccessor.formatString(6, new Object[]{name, defaultValue}));
            return Integer.parseInt(defaultValue);
        }
    }

    void stop(Properties props) {
        Object object = this.lock;
        synchronized (object) {
            this.work = false;
            if (this.internalThread != null) {
                this.internalThread.interrupt();
            }
            this.integrityWatcher.stop();
            this.internalThread = null;
            this.integrityWatcher = null;
            this.threadSystem = null;
            this.map = null;
            this.queue = null;
        }
        location.pathT(TimeoutResourceAccessor.getString(7));
    }

    public void registerTimeoutListener(TimeoutListener listener, long delayTime, long repeatTime) {
        this.register(listener, delayTime, repeatTime, 0L, false, true);
    }

    public void registerTimeoutListener(TimeoutListener listener, long delayTime, long repeatTime, boolean systemThread) {
        this.register(listener, delayTime, repeatTime, 0L, false, systemThread);
    }

    public void registerTimeoutListener(TimeoutListener listener, boolean waitForTimeoutEvent, long delayTime, long repeatTime) {
        this.register(listener, delayTime, repeatTime, 0L, waitForTimeoutEvent, true);
    }

    public void registerTimeoutListener(TimeoutListener listener, boolean waitForTimeoutEvent, long delayTime, long repeatTime, boolean systemThread) {
        this.register(listener, delayTime, repeatTime, 0L, waitForTimeoutEvent, systemThread);
    }

    public void registerTimeoutListener(TimeoutListener listener, long delayTime, long repeatTime, long occurrences) throws IllegalArgumentException {
        this.register(listener, delayTime, repeatTime, occurrences, false, true);
    }

    public void registerTimeoutListener(TimeoutListener listener, long delayTime, long repeatTime, long occurrences, boolean systemThread) {
        this.register(listener, delayTime, repeatTime, occurrences, false, systemThread);
    }

    public void registerTimeoutListener(TimeoutListener listener, boolean waitForTimeoutEvent, long delayTime, long repeatTime, long occurrences) {
        this.register(listener, delayTime, repeatTime, occurrences, waitForTimeoutEvent, true);
    }

    public void registerTimeoutListener(TimeoutListener listener, boolean waitForTimeoutEvent, long delayTime, long repeatTime, long occurrences, boolean systemThread) {
        this.register(listener, delayTime, repeatTime, occurrences, waitForTimeoutEvent, systemThread);
    }

    private final void register(TimeoutListener listener, long delayTime, long repeatTime, long occurrences, boolean waitForTimeoutEvent, boolean systemThread) {
        this.checkForNullTimeoutListener(listener);
        Object object = this.lock;
        synchronized (object) {
            if (this.map.containsKey(listener)) {
                String msg = TimeoutResourceAccessor.getString(13);
                category.warningT(location, msg);
                throw new IllegalArgumentException(msg);
            }
            TimeoutNode node = new TimeoutNode();
            node.work = listener;
            node.delay = delayTime;
            node.repeat = repeatTime;
            node.occurrences = occurrences;
            node.waitForTimeoutEvent = waitForTimeoutEvent;
            node.system = systemThread;
            node.nextCallTime = this.integrityWatcher.getCurrentTimeMillis() + delayTime;
            node.timeoutManager = this;
            node.queuePosition = -1;
            node.isCancel = false;
            node.repeatState = false;
            this.map.put(listener, node);
            ++this.registeredListenersCount;
            if (node.repeat > 0L) {
                this.estimatedFrequencyPerMinute += 1.0 / (double)node.repeat;
            }
            if (this.queue.add(node)) {
                this.lock.notify();
            }
        }
    }

    public void unregisterTimeoutListener(TimeoutListener listener) {
        this.checkForNullTimeoutListener(listener);
        Object object = this.lock;
        synchronized (object) {
            TimeoutNode node = (TimeoutNode)this.map.remove(listener);
            if (node != null) {
                --this.registeredListenersCount;
                if (node.repeat > 0L) {
                    this.estimatedFrequencyPerMinute -= 1.0 / (double)node.repeat;
                }
                if (node.queuePosition >= 0) {
                    if (this.queue.remove(node)) {
                        this.lock.notify();
                    }
                } else {
                    node.isCancel = true;
                }
            }
        }
    }

    public void changeRepeatTime(TimeoutListener listener, long repeatTime) {
        this.checkForNullTimeoutListener(listener);
        if (repeatTime <= 0L) {
            String msg = TimeoutResourceAccessor.getString(9);
            category.warningT(location, msg);
            throw new IllegalArgumentException(msg);
        }
        Object object = this.lock;
        synchronized (object) {
            TimeoutNode node = (TimeoutNode)this.map.get(listener);
            if (node != null && node.repeat > 0L) {
                node.repeat = repeatTime;
            }
        }
    }

    public void changeRepeatTime(TimeoutListener listener, long repeatTime, long occurrences) {
        this.checkForNullTimeoutListener(listener);
        if (repeatTime <= 0L) {
            String msg = TimeoutResourceAccessor.getString(9);
            category.warningT(location, msg);
            throw new IllegalArgumentException(msg);
        }
        if (occurrences < 0L) {
            String msg = TimeoutResourceAccessor.getString(12);
            category.warningT(location, msg);
            throw new IllegalArgumentException(msg);
        }
        Object object = this.lock;
        synchronized (object) {
            TimeoutNode node = (TimeoutNode)this.map.get(listener);
            if (node != null && node.repeat > 0L) {
                node.repeat = repeatTime;
                node.occurrences = occurrences;
            }
        }
    }

    public void refreshTimeout(TimeoutListener listener) {
        this.checkForNullTimeoutListener(listener);
        TimeoutNode node = null;
        Object object = this.lock;
        synchronized (object) {
            node = (TimeoutNode)this.map.get(listener);
            if (node != null) {
                node.nextCallTime = this.integrityWatcher.getCurrentTimeMillis() + (node.repeatState ? node.repeat : node.delay);
                if (node.queuePosition >= 0 && this.queue.recalculate(node)) {
                    this.lock.notify();
                }
            }
        }
    }

    public void run() {
        this.internalThread = Thread.currentThread();
        int priority = Thread.currentThread().getPriority();
        String name = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(THREAD_NAME);
            Thread.currentThread().setPriority(this.threadPriority);
            TimeoutNode node = null;
            long delayTime = 0L;
            while (this.work) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        while (this.queue.isEmpty()) {
                            this.lock.wait();
                        }
                        long currentTime = this.integrityWatcher.getCurrentTimeMillis();
                        while ((node = this.queue.getFirst()) != null && (delayTime = node.nextCallTime - currentTime) <= 0L) {
                            boolean check = node.work.check();
                            if (check) {
                                if (node.waitForTimeoutEvent) {
                                    this.queue.removeFirst();
                                }
                                this.threadSystem.startThread(node, node.system);
                                Thread.yield();
                                if (node.waitForTimeoutEvent) continue;
                                this.processTimeoutNode(node);
                                continue;
                            }
                            this.processTimeoutNode(node);
                        }
                        if (node != null) {
                            this.lock.wait(delayTime);
                        }
                    }
                    catch (InterruptedException iException) {
                        location.traceThrowableT(300, "run()", (Throwable)iException);
                        if (this.work) {
                            location.infoT(TimeoutResourceAccessor.getString(11));
                        }
                        location.infoT(TimeoutResourceAccessor.getString(10));
                    }
                }
            }
            Object var12_10 = null;
            Thread.currentThread().setPriority(priority);
            Thread.currentThread().setName(name);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            Thread.currentThread().setPriority(priority);
            Thread.currentThread().setName(name);
            throw throwable;
        }
    }

    public int getRegisteredListenersCount() {
        return this.registeredListenersCount;
    }

    public int getEstimatedFrequencyPerMinute() {
        return (int)(this.estimatedFrequencyPerMinute * 60000.0);
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    final void processNode(TimeoutNode node) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processTimeoutNode(node)) {
                this.lock.notify();
            }
        }
    }

    private final boolean processTimeoutNode(TimeoutNode node) {
        boolean result = false;
        if (node.isCancel) {
            return false;
        }
        if (node.repeat > 0L && node.occurrences != 1L) {
            if (!node.repeatState) {
                node.repeatState = true;
            }
            if (node.occurrences > 1L) {
                --node.occurrences;
            }
            if (node.waitForTimeoutEvent) {
                node.nextCallTime = this.integrityWatcher.getCurrentTimeMillis() + node.repeat;
                result = this.queue.add(node);
            } else {
                node.nextCallTime += node.repeat;
                result = this.queue.recalculate(node);
            }
        } else {
            this.map.remove(node.work);
            --this.registeredListenersCount;
            if (node.repeat > 0L) {
                this.estimatedFrequencyPerMinute -= 1.0 / (double)node.repeat;
            }
            this.queue.remove(node);
        }
        return result;
    }

    private final void checkForNullTimeoutListener(TimeoutListener listener) {
        if (listener == null) {
            String msg = TimeoutResourceAccessor.getString(8);
            category.warningT(location, msg);
            throw new IllegalArgumentException(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

