/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.timeout;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.services.timeout.PriorityQueue;

final class TimeoutIntegrityWatcher
implements Runnable {
    private static final String THREAD_NAME = "Timeout Service Integrity Watcher Thread";
    private static final long INTERVAL = 1000L;
    private static final long EXPECTED = 1500L;
    private boolean work = false;
    private PriorityQueue queue = null;
    private long beforeWaitTime = 0L;
    private long deltaAccumulation = 0L;
    private Thread integrityThread = null;

    TimeoutIntegrityWatcher(PriorityQueue queue, ThreadSystem threadSystem) {
        this.queue = queue;
        new Thread(this).start();
        this.ensureThreadStart();
    }

    public void run() {
        this.integrityThread = Thread.currentThread();
        int priority = this.integrityThread.getPriority();
        String name = this.integrityThread.getName();
        try {
            this.integrityThread.setPriority(10);
            this.integrityThread.setName(THREAD_NAME);
            TimeoutIntegrityWatcher timeoutIntegrityWatcher = this;
            synchronized (timeoutIntegrityWatcher) {
                this.beforeWaitTime = System.currentTimeMillis();
                this.work = true;
                this.notify();
                while (this.work) {
                    Object var6_5;
                    try {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            var6_5 = null;
                            this.beforeWaitTime = this.accumulateDelta();
                            continue;
                        }
                        var6_5 = null;
                        this.beforeWaitTime = this.accumulateDelta();
                    }
                    catch (Throwable throwable) {
                        var6_5 = null;
                        this.beforeWaitTime = this.accumulateDelta();
                        throw throwable;
                    }
                }
            }
            Object var9_8 = null;
            this.integrityThread.setPriority(priority);
            this.integrityThread.setName(name);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.integrityThread.setPriority(priority);
            this.integrityThread.setName(name);
            throw throwable;
        }
    }

    final synchronized long getCurrentTimeMillis() {
        long currentTime = this.accumulateDelta();
        if (this.deltaAccumulation != 0L) {
            this.queue.recalculateIntervals(this.deltaAccumulation);
            this.deltaAccumulation = 0L;
            this.beforeWaitTime = currentTime;
        }
        return currentTime;
    }

    final void stop() {
        TimeoutIntegrityWatcher timeoutIntegrityWatcher = this;
        synchronized (timeoutIntegrityWatcher) {
            this.work = false;
            this.integrityThread.interrupt();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void ensureThreadStart() {
        TimeoutIntegrityWatcher timeoutIntegrityWatcher = this;
        synchronized (timeoutIntegrityWatcher) {
            while (!this.work) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private final long accumulateDelta() {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beforeWaitTime;
        if ((delta < 0L ? -delta : delta) > 1500L) {
            this.deltaAccumulation += delta;
        }
        return currentTime;
    }
}

