/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.timeout;

import com.sap.engine.services.timeout.TimeoutNode;

final class PriorityQueue {
    private TimeoutNode[] items;
    private int itemsCounter;
    private int maxSize;
    private byte trigger;

    PriorityQueue() {
        this(Integer.MAX_VALUE);
    }

    PriorityQueue(int maxSize) {
        this.maxSize = maxSize < 128 ? 128 : maxSize;
        this.trigger = 0;
        this.itemsCounter = 0;
        this.items = new TimeoutNode[2];
    }

    final boolean isEmpty() {
        return this.itemsCounter == 0;
    }

    final boolean isFull() {
        return this.itemsCounter == this.maxSize;
    }

    final TimeoutNode getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.items[1];
    }

    final TimeoutNode removeFirst() throws IllegalStateException {
        if (this.isEmpty()) {
            throw new IllegalStateException("The Queue is empty.");
        }
        TimeoutNode result = this.items[1];
        this.items[1] = this.items[this.itemsCounter];
        this.items[1].queuePosition = 1;
        this.items[this.itemsCounter--] = null;
        this.adjustQueueDown(1);
        result.queuePosition = -1;
        return result;
    }

    final boolean add(TimeoutNode node) throws IllegalStateException {
        if (this.isFull()) {
            throw new IllegalStateException("The Queue is full.");
        }
        this.setLength(++this.itemsCounter + 1);
        this.items[this.itemsCounter] = node;
        this.items[this.itemsCounter].queuePosition = this.itemsCounter;
        this.adjustQueueUp(this.itemsCounter);
        return node.queuePosition == 1;
    }

    final boolean remove(TimeoutNode node) throws IllegalArgumentException {
        boolean result;
        int pos = node.queuePosition;
        if (pos < 1 || pos > this.itemsCounter) {
            throw new IllegalArgumentException("Illegal TimeoutNode queue position : " + node.queuePosition);
        }
        boolean bl = result = pos == 1;
        if (pos == this.itemsCounter) {
            this.items[this.itemsCounter--] = null;
        } else {
            this.items[pos] = this.items[this.itemsCounter];
            this.items[pos].queuePosition = pos;
            this.items[this.itemsCounter--] = null;
            this.adjustQueueUp(pos);
            this.adjustQueueDown(pos);
        }
        this.trigger = (byte)(this.trigger + 1);
        this.trigger = (byte)(this.trigger % 5);
        if (this.trigger == 0) {
            this.setLength(this.itemsCounter + 1);
        }
        node.queuePosition = -1;
        return result;
    }

    final boolean recalculate(TimeoutNode node) throws IllegalArgumentException {
        int pos = node.queuePosition;
        if (pos < 1 || pos > this.itemsCounter) {
            throw new IllegalArgumentException("Illegal TimeoutNode queue position : " + node.queuePosition);
        }
        boolean result = pos == 1;
        this.adjustQueueUp(pos);
        this.adjustQueueDown(pos);
        if (result && node.queuePosition == 1) {
            result = false;
        }
        return result;
    }

    final void recalculateIntervals(long delta) {
        int i = 1;
        while (i <= this.itemsCounter) {
            this.items[i].nextCallTime += delta;
            ++i;
        }
    }

    private final void adjustQueueUp(int pos) {
        while (pos > 1) {
            int parent = pos >> 1;
            if (this.items[parent].nextCallTime <= this.items[pos].nextCallTime) break;
            this.swap(pos, parent);
            pos = parent;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustQueueDown(int pos) {
        int child;
        while ((child = pos << 1) <= this.itemsCounter) {
            void var2_2;
            if (var2_2 < this.itemsCounter && this.items[var2_2].nextCallTime > this.items[var2_2 + true].nextCallTime) {
                ++var2_2;
            }
            if (this.items[pos].nextCallTime <= this.items[var2_2].nextCallTime) break;
            this.swap(pos, (int)var2_2);
            pos = var2_2;
        }
    }

    private final void swap(int i, int j) {
        TimeoutNode tmp = this.items[i];
        this.items[i] = this.items[j];
        this.items[i].queuePosition = i;
        this.items[j] = tmp;
        this.items[j].queuePosition = j;
    }

    private final void setLength(int newLength) {
        if (newLength < this.items.length >> 1) {
            TimeoutNode[] newItems = new TimeoutNode[newLength];
            System.arraycopy(this.items, 0, newItems, 0, newLength);
            this.items = newItems;
        }
        if (newLength > this.items.length) {
            int newCapacity = this.items.length;
            if (newLength > (newCapacity <<= 1)) {
                newCapacity = newLength;
            }
            if (newCapacity > this.maxSize) {
                newCapacity = this.maxSize;
            }
            TimeoutNode[] newItems = new TimeoutNode[newCapacity];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
    }
}

