/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.keystore;

import com.sap.engine.services.ssl.exception.KeyStoreConnectorException;
import com.sap.engine.services.ssl.exception.SSLConfigurationException;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.ClientSocketFactory;
import com.sap.engine.services.ssl.factory.Credentials;
import com.sap.engine.services.ssl.factory.ServerSocket;
import com.sap.engine.services.ssl.factory.ServerSocketFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class KeyStoreConnector {
    public static final String KV_ALIAS_SSL = "service_ssl";
    public static final String KV_ALIAS_TRUSTED_CA = "TrustedCAs";
    private static final String[] NO_ALIASES = new String[0];
    public static final int MINIMAL_CREDENTIALS_COUNT = 1;
    private static KeyStore credentialsView;
    private static KeyStore thrustedCAsView;
    private static boolean isKeystoreReady;
    private static final String ACTIVE_SOCKETS_NOT_CHECKED = "ssl_keystore_connector_check_active_sockets";
    private static final String SSL_FACTORY_CONFIGURATION_FOUND = "ssl_keystore_connector_factory_configuration_start";
    private static final String ENABLED_SERVER_CREDENTIAL = "ssl_keystore_connector_enabled_credential";
    private static final String INVALID_CONFIGURATION_FILE = "ssl_keystore_connector_invalid_configuration_file";
    private static final String ENABLED_CIPHER_SUITE = "ssl_keystore_connector_enabled_cipher_suite";
    private static final String USED_CIPHER_SUITEs = "ssl_keystore_connector_used_cipher_suites";
    private static final String USED_TRUSTED_CA = "ssl_keystore_connector_used_trusted_CA";
    private static final String SSL_FACTORY_CONFIGURATION_NOT_FOUND = "ssl_keystore_connector_configuration_file_not_found";

    public static void initConnector(KeyStore credentialsKeystoreView, KeyStore thrustedCAsKeystoreView) throws Exception {
        credentialsView = credentialsKeystoreView;
        thrustedCAsView = thrustedCAsKeystoreView;
        KeyStoreConnector.initializeActiveSockets();
        ServerSocketFactory.setKeyStoreIsReady(true);
    }

    public static KeyStore getCredentialsView() throws KeyStoreConnectorException {
        KeyStoreConnector.checkKeystoreStatus();
        return credentialsView;
    }

    private static void checkKeystoreStatus() throws KeyStoreConnectorException {
        int size = 0;
        if (!isKeystoreReady) {
            if (credentialsView == null) {
                throw new KeyStoreConnectorException("ssl_0010");
            }
            try {
                size = credentialsView.size();
                isKeystoreReady = true;
            }
            catch (KeyStoreException ke) {
                throw new KeyStoreConnectorException("ssl_0011", ke);
            }
            if (size < 1) {
                throw new KeyStoreConnectorException("ssl_0012");
            }
        }
    }

    public static synchronized Credentials[] getAvailableCredentials() throws KeyStoreConnectorException {
        Enumeration<String> enumeration = null;
        Credentials[] credentials = null;
        Vector<Credentials> entries = new Vector<Credentials>(10, 10);
        String alias = null;
        KeyStoreConnector.checkKeystoreStatus();
        try {
            enumeration = credentialsView.aliases();
        }
        catch (KeyStoreException ke) {
            throw new KeyStoreConnectorException("ssl_0011", ke);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                alias = enumeration.nextElement();
                try {
                    if (!credentialsView.isKeyEntry(alias)) continue;
                    entries.add(KeyStoreConnector.getCredentials(alias));
                }
                catch (KeyStoreException kse) {
                    throw new KeyStoreConnectorException("ssl_0011", kse);
                }
            }
        }
        credentials = new Credentials[entries.size()];
        int i = 0;
        while (i < credentials.length) {
            credentials[i] = (Credentials)((Object)entries.elementAt(i));
            ++i;
        }
        return credentials;
    }

    public static synchronized Credentials getCredentials(String alias) throws KeyStoreConnectorException {
        KeyStoreConnector.checkKeystoreStatus();
        X509Certificate[] x509chain = null;
        Certificate[] chain = null;
        try {
            chain = credentialsView.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreConnectorException("ssl_0011", e);
        }
        if (chain != null) {
            if (chain instanceof X509Certificate[]) {
                x509chain = (X509Certificate[])chain;
            } else {
                x509chain = new X509Certificate[chain.length];
                System.arraycopy(chain, 0, x509chain, 0, chain.length);
            }
            PrivateKey privateKey = null;
            try {
                privateKey = (PrivateKey)credentialsView.getKey(alias, null);
            }
            catch (KeyStoreException kse) {
                throw new KeyStoreConnectorException("ssl_0011", kse);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new KeyStoreConnectorException("ssl_0013", nsae);
            }
            catch (UnrecoverableKeyException uke) {
                throw new KeyStoreConnectorException("ssl_0013", uke);
            }
            return new Credentials(alias, x509chain, privateKey);
        }
        throw new KeyStoreConnectorException("ssl_0015");
    }

    public static synchronized Credentials[] getCredentials(String[] aliases) throws KeyStoreConnectorException {
        Vector<Credentials> entries = new Vector<Credentials>(10, 10);
        Credentials[] credentials = null;
        KeyStoreConnector.checkKeystoreStatus();
        int i = 0;
        while (i < aliases.length) {
            entries.add(KeyStoreConnector.getCredentials(aliases[i]));
            ++i;
        }
        credentials = new Credentials[entries.size()];
        int i2 = 0;
        while (i2 < credentials.length) {
            credentials[i2] = (Credentials)((Object)entries.elementAt(i2));
            ++i2;
        }
        return credentials;
    }

    public static synchronized Certificate[] getCertificates(String[] aliases) throws KeyStoreConnectorException {
        Vector<Certificate> entries = new Vector<Certificate>(10, 10);
        Certificate certificate = null;
        Certificate[] certificates = null;
        KeyStoreConnector.checkKeystoreStatus();
        int i = 0;
        while (i < aliases.length) {
            if (aliases[i] != null && aliases[i].trim().length() != 0) {
                try {
                    certificate = thrustedCAsView.getCertificate(aliases[i]);
                }
                catch (KeyStoreException e) {
                    throw new KeyStoreConnectorException("ssl_0014", e);
                }
                if (certificate != null) {
                    entries.add(certificate);
                } else {
                    throw new KeyStoreConnectorException("ssl_0014");
                }
            }
            ++i;
        }
        certificates = new Certificate[entries.size()];
        int i2 = 0;
        while (i2 < certificates.length) {
            certificates[i2] = (Certificate)entries.elementAt(i2);
            ++i2;
        }
        return certificates;
    }

    public static synchronized Certificate getCertificate(String alias) throws KeyStoreConnectorException {
        Certificate certificate = null;
        KeyStoreConnector.checkKeystoreStatus();
        try {
            certificate = thrustedCAsView.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreConnectorException("ssl_0011", e);
        }
        return certificate;
    }

    public static String getInformationForActiveSockets() {
        String info = "\n--------------------------------------  active SSL sockets  --------------------------------------\n";
        try {
            ServerSocket socket = null;
            ServerSocketFactory factory = (ServerSocketFactory)ServerSocketFactory.getDefault();
            String[][] sockets = ServerSocketFactory.getActiveServerSockets();
            info = info + "active sockets: " + sockets.length + "\n";
            int i = 0;
            while (i < sockets.length) {
                socket = ServerSocketFactory.getServerSocket(sockets[i][0], Integer.valueOf(sockets[i][1]));
                info = info + socket.toString() + "\n";
                String[] credentials = socket.getCredentials();
                info = info + "credentials {\n";
                int j = 0;
                while (j < credentials.length) {
                    info = info + "  cred: " + credentials[j] + "\n";
                    ++j;
                }
                info = info + "}\n";
                String[] suites = socket.getEnabledCipherSuites();
                info = info + "enabled suites {\n";
                int j2 = 0;
                while (j2 < suites.length) {
                    info = info + "  suit: " + suites[j2] + "\n";
                    ++j2;
                }
                info = info + "}\n";
                ++i;
            }
            info = info + "-----------------------------------------------------------------------------------------------------------------";
            return info;
        }
        catch (Exception e) {
            SSLResourceAccessor.traceThrowable(100, "getInformationForActiveSockets()", e);
            return e.toString();
        }
        catch (NoClassDefFoundError err) {
            SSLResourceAccessor.traceThrowable(100, "getInformationForActiveSockets()", err);
            return err.toString();
        }
    }

    public static void checkActiveSockets() throws SSLConfigurationException {
        ServerSocket socket = null;
        ServerSocketFactory factory = (ServerSocketFactory)ServerSocketFactory.getDefault();
        String[][] sockets = ServerSocketFactory.getActiveServerSockets();
        String[] credentials = new String[]{};
        String[] suites = new String[]{};
        int i = 0;
        while (i < sockets.length) {
            Throwable throwable = null;
            try {
                socket = ServerSocketFactory.getServerSocket(sockets[i][0], Integer.valueOf(sockets[i][1]));
                credentials = socket.getCredentials();
                suites = socket.getEnabledCipherSuites();
            }
            catch (Exception e) {
                SSLResourceAccessor.log(400, e, ACTIVE_SOCKETS_NOT_CHECKED);
            }
            catch (NoClassDefFoundError err) {
                SSLResourceAccessor.traceThrowable(400, ACTIVE_SOCKETS_NOT_CHECKED, null, err);
            }
            if (credentials.length == 0) {
                if (throwable != null) {
                    throw new SSLConfigurationException("ssl_0021", sockets[i], throwable);
                }
                throw new SSLConfigurationException("ssl_0021", sockets[i]);
            }
            if (suites.length == 0) {
                if (throwable != null) {
                    throw new SSLConfigurationException("ssl_0020", sockets[i], throwable);
                }
                throw new SSLConfigurationException("ssl_0020", sockets[i]);
            }
            ++i;
        }
    }

    private static void initializeActiveSockets() throws SSLConfigurationException, KeyStoreConnectorException {
        try {
            int trustedCertificates = 0;
            ServerSocketFactory factory = (ServerSocketFactory)ServerSocketFactory.getDefault();
            String[][] sockets = ServerSocketFactory.getActiveServerSockets();
            Properties properties = factory.getSocketsProperties();
            Credentials[] available = KeyStoreConnector.getAvailableCredentials();
            String[] credentials = new String[available.length];
            int i = 0;
            while (i < credentials.length) {
                credentials[i] = available[i].getAlias();
                ++i;
            }
            if (ServerSocketFactory.getPropertiesLoaded()) {
                String key;
                SSLResourceAccessor.log(300, "", SSL_FACTORY_CONFIGURATION_FOUND);
                boolean propertiesFound = false;
                int count = 0;
                String value = "";
                String[] ciphers = new String[]{};
                int[] types = factory.getAllowedCertificateTypes();
                int i2 = 0;
                while (i2 < types.length) {
                    key = "factory.cert." + types[i2];
                    value = properties.getProperty(key, "");
                    if (!"".equals(value.trim())) {
                        factory.initCredentials(value);
                        ClientSocketFactory defaultClientSocketFactory = (ClientSocketFactory)ClientSocketFactory.getDefault();
                        defaultClientSocketFactory.addCredentials(value);
                        SSLResourceAccessor.log(300, "", ENABLED_SERVER_CREDENTIAL, new String[]{value});
                        propertiesFound = true;
                    }
                    ++i2;
                }
                if (!propertiesFound) {
                    SSLResourceAccessor.log(300, "", INVALID_CONFIGURATION_FILE);
                    factory.addCredentials(credentials);
                    factory.setNeedClientAuth(false);
                    factory.addTrustedCertificates("");
                    int i3 = 0;
                    while (i3 < sockets.length) {
                        ServerSocket socket = ServerSocketFactory.getServerSocket(sockets[i3][0], Integer.valueOf(sockets[i3][1]));
                        socket.addCredentials(credentials);
                        socket.setNeedClientAuth(false);
                        socket.addTrustedCertificates("");
                        ++i3;
                    }
                    return;
                }
                count = 0;
                do {
                    if (!"".equals((value = properties.getProperty(key = "factory.cipher." + count, "")).trim())) {
                        String[] temp = ciphers;
                        ciphers = new String[ciphers.length + 1];
                        System.arraycopy(temp, 0, ciphers, 0, temp.length);
                        ciphers[temp.length] = value;
                        propertiesFound = true;
                        SSLResourceAccessor.log(300, "", ENABLED_CIPHER_SUITE, new String[]{value});
                    } else {
                        SSLResourceAccessor.log(300, "", USED_CIPHER_SUITEs, new String[]{Integer.toString(count)});
                        if (count == 0) {
                            throw new SSLConfigurationException("ssl_0020");
                        }
                    }
                    ++count;
                } while (!"".equals(value));
                factory.setDefaultCipherSuites(ciphers);
                count = 0;
                do {
                    if (!"".equals(value = properties.getProperty(key = "factory.trust." + count, "").trim())) {
                        factory.addTrustedCertificates(new String[]{value}, false);
                        propertiesFound = true;
                        if (value.length() > 0) {
                            ++trustedCertificates;
                        }
                        SSLResourceAccessor.log(300, "", USED_TRUSTED_CA, new String[]{value});
                    }
                    ++count;
                } while (!"".equals(value));
                if (trustedCertificates == 0) {
                    factory.setNeedClientAuth(false);
                } else {
                    value = properties.getProperty("factory.need.auth", "");
                    if ("false".equals(value)) {
                        factory.setNeedClientAuth(false);
                        propertiesFound = true;
                    } else {
                        factory.setNeedClientAuth(true);
                    }
                }
                if (!propertiesFound) {
                    factory.addCredentials(credentials);
                    factory.setNeedClientAuth(false);
                }
                int i4 = 0;
                while (i4 < sockets.length) {
                    int port = Integer.valueOf(sockets[i4][1]);
                    ServerSocket socket = ServerSocketFactory.getServerSocket(sockets[i4][0], port);
                    socket.initialize(false);
                    ++i4;
                }
            } else {
                SSLResourceAccessor.log(300, "", SSL_FACTORY_CONFIGURATION_NOT_FOUND);
                factory.addCredentials(credentials);
                factory.setNeedClientAuth(false);
                factory.addTrustedCertificates("");
                int i5 = 0;
                while (i5 < sockets.length) {
                    ServerSocket socket = ServerSocketFactory.getServerSocket(sockets[i5][0], Integer.valueOf(sockets[i5][1]));
                    socket.addCredentials(credentials);
                    socket.setNeedClientAuth(false);
                    socket.addTrustedCertificates("");
                    ++i5;
                }
            }
        }
        catch (Exception e) {
            throw new SSLConfigurationException("ssl_0022", e);
        }
        catch (NoClassDefFoundError err) {
            throw new SSLConfigurationException("ssl_0022", err);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getCertificates() throws KeyStoreConnectorException {
        aliases = null;
        temp = new ArrayList<String>();
        certificateAliases = KeyStoreConnector.NO_ALIASES;
        KeyStoreConnector.checkKeystoreStatus();
        try {
            aliases = KeyStoreConnector.thrustedCAsView.aliases();
            if (true) ** GOTO lbl21
        }
        catch (KeyStoreException ke) {
            throw new KeyStoreConnectorException("ssl_0011", ke);
        }
        do {
            alias = aliases.nextElement();
            isCertificate = false;
            try {
                isCertificate = KeyStoreConnector.thrustedCAsView.isCertificateEntry(alias);
            }
            catch (KeyStoreException e) {
                throw new KeyStoreConnectorException("ssl_0011", e);
            }
            if (!isCertificate) continue;
            temp.add(alias);
lbl21:
            // 3 sources

        } while (aliases.hasMoreElements());
        certificateAliases = new String[temp.size()];
        i = 0;
        while (i < certificateAliases.length) {
            certificateAliases[i] = (String)temp.get(i);
            ++i;
        }
        return certificateAliases;
    }

    static {
        isKeystoreReady = false;
    }
}

