/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.services.ssl.dispatcher.CertificateExpirationTracker;
import com.sap.engine.services.ssl.dispatcher.DispatcherService;
import com.sap.engine.services.ssl.exception.LoggerPrintStream;
import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.engine.services.ssl.factory.Credentials;
import com.sap.engine.services.ssl.factory.ServerSocket;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import com.sap.engine.services.ssl.util.CipherSuitesUtility;
import com.sap.engine.services.ssl.util.Utility;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SessionManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.rmi.server.RMIServerSocketFactory;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLServerSocketFactory;

public class ServerSocketFactory
extends SSLServerSocketFactory
implements RMIServerSocketFactory {
    private static Vector activeServerSockets;
    private static ServerSocketFactory defaultFactory;
    private Properties properties;
    private SSLServerContext defaultContext;
    private SSLServerContext context;
    private Vector trustedCertificates = new Vector();
    private OutputStream out;
    private File file;
    private static boolean keyStoreIsReady;
    private static boolean propertiesLoaded;
    public static final String CERT_KEY = "factory.cert.";
    public static final String CIPHER_KEY = "factory.cipher.";
    public static final String TRUST_KEY = "factory.trust.";
    public static final String AUTH_KEY = "factory.need.auth";
    public static final String SOCKET_CONFIGURATION = "socketConfiguration.properties";
    private static final String SOCKET_CFG_FILE_NOT_AVAILABLE = "ssl_srv_socket_factory_cfg_file_not_available";
    private static final String SSL_SOCKET_CONFIGURATION_NOT_LOADED = "ssl_srv_socket_factory_socket_cfg_not_loaded";
    private static final String SSL_SOCKET_CFG_FILE_NOT_CREATED = "ssl_srv_socket_factory_cfg_file_not_created";
    private static final String SSL_SOCKET_CONFIGURATION_NOT_SAVED = "ssl_srv_socket_factory_socket_modification_not_stored";
    private static final String UNEXPECTED_CONFIGURATION_PROBLEM = "ssl_srv_socket_factory_socket_update_problem";

    public static final void stop() {
        activeServerSockets = null;
        defaultFactory = null;
        CipherSuitesUtility.stop();
    }

    private static synchronized Vector getActiveSockets() {
        if (activeServerSockets == null) {
            activeServerSockets = new Vector(10, 10);
        }
        return activeServerSockets;
    }

    public ServerSocketFactory() {
        try {
            this.file = DispatcherService.getPersistentContainer().getPersistentEntryFile(SOCKET_CONFIGURATION, false);
            if (this.file == null) {
                ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
                DispatcherService.getPersistentContainer().setPersistentEntryStream(SOCKET_CONFIGURATION, emptyStream, false);
                this.file = DispatcherService.getPersistentContainer().getPersistentEntryFile(SOCKET_CONFIGURATION, false);
            }
        }
        catch (Exception e) {
            SSLResourceAccessor.log(600, e, SOCKET_CFG_FILE_NOT_AVAILABLE);
            SSLResourceAccessor.traceThrowable(600, SOCKET_CFG_FILE_NOT_AVAILABLE, e);
            SSLResourceAccessor.trace(600, "SSL port configuration file not found: " + this.file);
        }
        catch (NoClassDefFoundError e) {
            SSLResourceAccessor.log(600, e, SOCKET_CFG_FILE_NOT_AVAILABLE);
            SSLResourceAccessor.traceThrowable(600, SOCKET_CFG_FILE_NOT_AVAILABLE, e);
            SSLResourceAccessor.trace(600, "SSL port configuration file not found: " + this.file);
        }
        this.getSocketsProperties();
        this.initializeCredentials();
    }

    public void addCredentials(String keystoreAliase) {
        this.addCredentials(new String[]{keystoreAliase});
    }

    public void addCredentials(String[] keystoreAliases) {
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            Credentials[] additional = KeyStoreConnector.getCredentials(keystoreAliases);
            int i = 0;
            while (i < additional.length) {
                this.context.addServerCredentials((KeyAndCert)additional[i]);
                this.defaultContext.addServerCredentials((KeyAndCert)additional[i]);
                this.properties.setProperty(CERT_KEY + additional[i].getCertificateType(), keystoreAliases[i]);
                ++i;
            }
            this.store();
            this.context.setEnabledCipherSuites(CipherSuitesUtility.getAllCipherSuites());
            this.defaultContext.setEnabledCipherSuites(CipherSuitesUtility.getAllCipherSuites());
            this.context.updateCipherSuites();
            this.defaultContext.updateCipherSuites();
        }
        this.writeCipherSuites();
    }

    public void initCredentials(String keystoreAliase) {
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            Credentials additional = KeyStoreConnector.getCredentials(keystoreAliase);
            if (additional != null) {
                this.context.addServerCredentials((KeyAndCert)additional);
                this.defaultContext.addServerCredentials((KeyAndCert)additional);
                this.properties.setProperty(CERT_KEY + additional.getCertificateType(), keystoreAliase);
                this.store();
                this.context.setEnabledCipherSuites(CipherSuitesUtility.getAllCipherSuites());
                this.defaultContext.setEnabledCipherSuites(CipherSuitesUtility.getAllCipherSuites());
                this.context.updateCipherSuites();
                this.defaultContext.updateCipherSuites();
            }
        }
    }

    public void addTrustedCertificates(String alias) {
        this.addTrustedCertificates(new String[]{alias});
    }

    public Vector addTrustedCertificates(String[] aliases) {
        return this.addTrustedCertificates(aliases, true);
    }

    public Vector addTrustedCertificates(String[] aliases, boolean store) {
        int count;
        Vector<String> addedCertificates = new Vector<String>();
        SSLServerContext sSLServerContext = this.context;
        synchronized (sSLServerContext) {
            ChainVerifier chainVerifier = this.context.getChainVerifier();
            count = this.trustedCertificates.size();
            int i = 0;
            while (i < aliases.length) {
                if (aliases[i] == null || aliases[i].trim().length() == 0) {
                    chainVerifier.addTrustedCertificate(null);
                    this.trustedCertificates.add("");
                    addedCertificates.add("");
                } else {
                    Certificate certificate = KeyStoreConnector.getCertificate(aliases[i]);
                    if (!this.trustedCertificates.contains(aliases[i]) && certificate != null && certificate instanceof X509Certificate) {
                        chainVerifier.addTrustedCertificate((X509Certificate)certificate);
                        this.trustedCertificates.add(aliases[i]);
                        addedCertificates.add(aliases[i]);
                    }
                }
                ++i;
            }
        }
        if (store) {
            int i = 0;
            while (i < addedCertificates.size()) {
                this.properties.setProperty(TRUST_KEY + count, (String)addedCertificates.elementAt(i));
                ++i;
                ++count;
            }
            this.store();
        }
        return addedCertificates;
    }

    public java.net.ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(this, port, (SSLServerContext)this.context.clone());
    }

    public java.net.ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new ServerSocket(this, port, backlog, (SSLServerContext)this.context.clone());
    }

    public java.net.ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        return new ServerSocket(this, port, backlog, address, (SSLServerContext)this.context.clone());
    }

    public java.net.ServerSocket createServerSocket(java.net.ServerSocket lower) throws IOException {
        return new ServerSocket(this, lower, (SSLServerContext)this.context.clone());
    }

    public void freeSocket(ServerSocket socket) {
        Vector vector = ServerSocketFactory.getActiveSockets();
        synchronized (vector) {
            if (activeServerSockets.contains(socket)) {
                activeServerSockets.remove(socket);
            }
        }
    }

    public static String[][] getActiveServerSockets() {
        Vector vector = ServerSocketFactory.getActiveSockets();
        synchronized (vector) {
            int length = activeServerSockets.size();
            String[][] sockets = new String[length][2];
            ServerSocket socket = null;
            int i = 0;
            while (i < length) {
                socket = (ServerSocket)activeServerSockets.elementAt(i);
                sockets[i][0] = socket.getInetAddress().getHostAddress();
                sockets[i][1] = "" + socket.getLocalPort();
                ++i;
            }
            String[][] stringArray = sockets;
            return stringArray;
        }
    }

    public int[] getAllowedCertificateTypes() {
        return this.context.getAllowedCertificateTypes();
    }

    public String[] getCredentials() {
        int[] types = this.context.getAllowedCertificateTypes();
        Vector<KeyAndCert> credentials = new Vector<KeyAndCert>(6, 10);
        String[] aliases = null;
        int i = 0;
        while (i < types.length) {
            try {
                credentials.add(this.context.getServerCredentials(types[i]));
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            ++i;
        }
        aliases = new String[credentials.size()];
        int i2 = 0;
        while (i2 < aliases.length) {
            aliases[i2] = ((Credentials)((Object)credentials.elementAt(i2))).getAlias();
            ++i2;
        }
        return aliases;
    }

    public String[] getTrustedCertificates() {
        String[] certificates = new String[this.trustedCertificates.size()];
        int i = 0;
        while (i < certificates.length) {
            certificates[i] = (String)this.trustedCertificates.elementAt(i);
            ++i;
        }
        return certificates;
    }

    public String[] getAvailableCertificates() {
        return KeyStoreConnector.getCertificates();
    }

    public SSLServerContext getContext() {
        return (SSLServerContext)this.context.clone();
    }

    public boolean getNeedClientAuth() {
        return this.context.getRequestClientCertificate();
    }

    public static synchronized javax.net.ServerSocketFactory getDefault() {
        if (defaultFactory == null) {
            defaultFactory = new ServerSocketFactory();
        }
        return defaultFactory;
    }

    public String[] getDefaultCipherSuites() {
        return CipherSuitesUtility.convertToStringArray(this.context.getEnabledCipherSuiteList());
    }

    public static ServerSocket getServerSocket(String host, int port) {
        Vector vector = ServerSocketFactory.getActiveSockets();
        synchronized (vector) {
            int length = activeServerSockets.size();
            ServerSocket socket = null;
            int i = 0;
            while (i < length) {
                socket = (ServerSocket)activeServerSockets.elementAt(i);
                if (socket.getLocalPort() == port && socket.getInetAddress().getHostAddress().equals(host)) {
                    ServerSocket serverSocket = socket;
                    return serverSocket;
                }
                ++i;
            }
        }
        return null;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuitesUtility.convertToStringArray(this.defaultContext.getEnabledCipherSuiteList());
    }

    private void initializeCredentials() {
        this.defaultContext = new SSLServerContext();
        this.context = new SSLServerContext();
        this.defaultContext.setDebugStream((Writer)new LoggerPrintStream());
        this.context.setSessionManager((SessionManager)new JSSESessionManager());
        this.context.setDebugStream((Writer)new LoggerPrintStream());
    }

    public static boolean isKeyStoreReady() {
        return keyStoreIsReady;
    }

    public static boolean getPropertiesLoaded() {
        return propertiesLoaded;
    }

    public void registerSocket(ServerSocket socket) {
        Vector vector = ServerSocketFactory.getActiveSockets();
        synchronized (vector) {
            if (!activeServerSockets.contains(socket)) {
                activeServerSockets.add(socket);
            }
        }
    }

    public void removeCredentials(String keystoreAliase) {
        this.removeCredentials(new String[]{keystoreAliase});
    }

    public void removeCredentials(String[] keystoreAliases) {
        this.setCredentials(Utility.remove(keystoreAliases, this.getCredentials()));
    }

    public void removeTrustedCertificates(String alias) {
        this.removeTrustedCertificates(new String[]{alias});
    }

    public void removeTrustedCertificates(String[] aliases) {
        Certificate[] certificates = KeyStoreConnector.getCertificates(aliases);
        int i = 0;
        while (i < aliases.length) {
            if (aliases[i] == null || aliases[i].trim().length() == 0) {
                this.context.getChainVerifier().removeTrustedCertificate(null);
                this.trustedCertificates.remove("");
            }
            ++i;
        }
        if (certificates != null) {
            SSLServerContext sSLServerContext = this.context;
            synchronized (sSLServerContext) {
                ChainVerifier chainVerifier = this.context.getChainVerifier();
                int i2 = 0;
                while (i2 < certificates.length) {
                    if (certificates[i2] instanceof X509Certificate) {
                        chainVerifier.removeTrustedCertificate((X509Certificate)certificates[i2]);
                        int index = this.trustedCertificates.indexOf(aliases[i2]);
                        this.trustedCertificates.remove(aliases[i2]);
                        if (index >= 0) {
                            Object value;
                            int ind = index;
                            do {
                                value = ((Hashtable)this.properties).remove(TRUST_KEY + ind);
                                ++ind;
                            } while (value != null);
                            while (index < this.trustedCertificates.size()) {
                                this.properties.setProperty(TRUST_KEY + index, (String)this.trustedCertificates.elementAt(index));
                                ++index;
                            }
                            this.store();
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    public void setCredentials(String[] keystoreAliases) {
        SSLServerContext sSLServerContext = this.defaultContext;
        synchronized (sSLServerContext) {
            this.context.clearServerCredentials();
            this.defaultContext.clearServerCredentials();
            this.removeCredentialsFromProperties();
            this.addCredentials(keystoreAliases);
        }
    }

    public void setDefaultCredentials(String[] keystoreAliases) {
        SSLServerContext sSLServerContext = this.defaultContext;
        synchronized (sSLServerContext) {
            this.removeCredentialsFromProperties();
            Credentials[] additional = KeyStoreConnector.getCredentials(keystoreAliases);
            int i = 0;
            while (i < additional.length) {
                this.defaultContext.addServerCredentials((KeyAndCert)additional[i]);
                this.properties.setProperty(CERT_KEY + additional[i].getCertificateType(), keystoreAliases[i]);
                ++i;
            }
            this.store();
            this.defaultContext.setEnabledCipherSuites(CipherSuitesUtility.getAllCipherSuites());
            this.defaultContext.updateCipherSuites();
            this.writeCipherSuites();
        }
    }

    public void setDefaultCipherSuites(String[] suites) {
        this.context.setEnabledCipherSuiteList(CipherSuitesUtility.convertToList(suites));
        this.context.updateCipherSuites();
        this.writeCipherSuites();
    }

    public void setNeedClientAuth(boolean flag) {
        this.context.setRequestClientCertificate(flag);
        this.properties.setProperty(AUTH_KEY, "" + flag);
        this.store();
    }

    public static void setKeyStoreIsReady(boolean ready) {
        keyStoreIsReady = ready;
    }

    public Properties getSocketsProperties() {
        ServerSocketFactory serverSocketFactory = this;
        synchronized (serverSocketFactory) {
            if (this.properties == null) {
                try {
                    this.properties = new Properties();
                    if (this.file.exists()) {
                        this.properties.load(new FileInputStream(this.file));
                        propertiesLoaded = true;
                    } else if (!this.file.createNewFile()) {
                        SSLResourceAccessor.log(600, "", SSL_SOCKET_CFG_FILE_NOT_CREATED);
                    }
                    this.synchVersionOfProperties();
                }
                catch (Exception e) {
                    SSLResourceAccessor.log(600, e, SSL_SOCKET_CONFIGURATION_NOT_LOADED);
                    SSLResourceAccessor.traceThrowable(500, "Unable to load SSL port configuration.", e);
                }
            }
        }
        return this.properties != null ? this.properties : new Properties();
    }

    void store() {
        try {
            this.file.delete();
            this.out = new FileOutputStream(this.file);
            this.properties.store(this.out, "");
            this.out.close();
            DispatcherService.getPersistentContainer().setPersistentEntryFile(SOCKET_CONFIGURATION, this.file, false);
            CertificateExpirationTracker.portsConfigurationChanged();
        }
        catch (Exception e) {
            SSLResourceAccessor.log(600, e, SSL_SOCKET_CONFIGURATION_NOT_SAVED);
            SSLResourceAccessor.traceThrowable(500, "Unable to save SSL port configuration", e);
        }
    }

    private void removeCredentialsFromProperties() {
        int[] types = this.getAllowedCertificateTypes();
        int i = 0;
        while (i < types.length) {
            ((Hashtable)this.properties).remove(CERT_KEY + types[i]);
            ++i;
        }
        this.store();
    }

    private void writeCipherSuites() {
        int count = 0;
        Object value = null;
        do {
            value = ((Hashtable)this.properties).remove(CIPHER_KEY + count);
            ++count;
        } while (value != null);
        String[] cipherSuites = this.getDefaultCipherSuites();
        int i = 0;
        while (i < cipherSuites.length) {
            this.properties.setProperty(CIPHER_KEY + i, cipherSuites[i]);
            ++i;
        }
        this.store();
    }

    private void synchVersionOfProperties() {
        String VERSION = "Version";
        double version = 0.0;
        try {
            version = Double.valueOf(this.properties.getProperty("Version"));
        }
        catch (Exception e) {
            SSLResourceAccessor.traceThrowable(300, "getCurrentVersion():", e);
        }
        if (version < 6.2) {
            try {
                SSLResourceAccessor.trace(600, "Updating socket configuration for the current version.");
                int count = 0;
                int position = 0;
                String key = null;
                String entry = null;
                Object[] keys = ((Hashtable)this.properties).keySet().toArray();
                int i = 0;
                while (i < keys.length) {
                    key = (String)keys[i];
                    position = key.indexOf(".need.auth");
                    if (position >= 0) {
                        count = 0;
                        entry = key.substring(0, position) + ".trust.";
                        while (this.properties.getProperty(entry + count) != null) {
                            if (this.properties.getProperty(entry + count).trim().length() == 0) break;
                            ++count;
                        }
                        if (this.properties.getProperty(entry + count) == null) {
                            this.properties.setProperty(entry + count, "");
                        }
                    }
                    ++i;
                }
                this.properties.setProperty("Version", "6.20");
                this.store();
                SSLResourceAccessor.trace(600, "Successfully updated socket configuration for the current version.");
            }
            catch (Throwable t) {
                SSLResourceAccessor.log(600, t, UNEXPECTED_CONFIGURATION_PROBLEM);
                SSLResourceAccessor.traceThrowable(600, "Unable to update SSL port configuration.", t);
            }
        }
    }

    static {
        keyStoreIsReady = false;
        propertiesLoaded = false;
    }
}

