/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.services.ssl.exception.BaseIOException;
import com.sap.engine.services.ssl.exception.LoggerPrintStream;
import com.sap.engine.services.ssl.exception.SSLConfigurationException;
import com.sap.engine.services.ssl.factory.ClientSocketFactory;
import com.sap.engine.services.ssl.factory.Credentials;
import com.sap.engine.services.ssl.factory.SSLSocket;
import com.sap.engine.services.ssl.factory.ServerSocketFactory;
import com.sap.engine.services.ssl.keystore.KeyStoreConnector;
import com.sap.engine.services.ssl.util.CipherSuitesUtility;
import iaik.security.ssl.SSLServerContext;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;

public class ServerSocket
extends SSLServerSocket {
    private boolean useClientMode = false;
    private boolean isSessionCreationEnabled = true;
    private static InetAddress inetAddress = null;
    private java.net.ServerSocket server = null;
    private ClientSocketFactory socketFactory = null;
    private String host = null;
    private int port;
    private ServerSocketFactory factory = null;
    private String[] trustedCertificates = new String[0];
    private Properties properties = null;
    private SSLServerContext context;
    private boolean newContextSet = false;
    private String certKey;
    private String cipherKey;
    private String trustKey;
    private String authKey;

    protected ServerSocket(ServerSocketFactory factory, int port, SSLServerContext ctx) throws IOException {
        super(port);
        this.host = "localhost";
        this.port = port;
        this.factory = factory;
        factory.registerSocket(this);
        this.context = ctx;
        this.socketFactory = new ClientSocketFactory(this.context);
        this.init();
        try {
            this.initialize(true);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
    }

    protected ServerSocket(ServerSocketFactory factory, int port, int backlog, SSLServerContext ctx) throws IOException {
        super(port, backlog);
        this.host = "localhost";
        this.port = port;
        this.factory = factory;
        factory.registerSocket(this);
        this.context = ctx;
        this.socketFactory = new ClientSocketFactory(this.context);
        this.init();
        try {
            this.initialize(true);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
    }

    protected ServerSocket(ServerSocketFactory factory, int port, int backlog, InetAddress address, SSLServerContext ctx) throws IOException {
        super(port, backlog, address);
        this.host = address.getHostAddress();
        this.port = port;
        this.factory = factory;
        factory.registerSocket(this);
        this.context = ctx;
        this.socketFactory = new ClientSocketFactory(this.context);
        this.init();
        try {
            this.initialize(true);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
    }

    protected ServerSocket(ServerSocketFactory factory, java.net.ServerSocket server, SSLServerContext ctx) throws IOException {
        super(0);
        super.close();
        this.factory = factory;
        this.server = server;
        this.host = server.getInetAddress().getHostAddress();
        this.port = server.getLocalPort();
        factory.registerSocket(this);
        this.context = ctx;
        this.socketFactory = new ClientSocketFactory(this.context);
        this.init();
        try {
            this.initialize(true);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
    }

    public Socket accept() throws IOException {
        Socket socket = null;
        SSLSocket sslSocket = null;
        try {
            socket = this.server == null ? super.accept() : this.server.accept();
            sslSocket = (SSLSocket)this.socketFactory.createSocket(socket, socket.getInetAddress(), socket.getPort(), false);
            sslSocket.init(socket, sslSocket.getSSLContext(), false);
            sslSocket.setEnableSessionCreation(this.isSessionCreationEnabled);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return sslSocket;
    }

    public void addCredentials(String keystoreAlias) {
        this.socketFactory.addCredentials(keystoreAlias);
        this.writeCredentials(keystoreAlias);
        this.writeEnabledCipherSuites();
    }

    public void addCredentials(String[] keystoreAliases) {
        this.socketFactory.addCredentials(keystoreAliases);
        int i = 0;
        while (i < keystoreAliases.length) {
            this.writeCredentials(keystoreAliases[i]);
            ++i;
        }
        this.writeEnabledCipherSuites();
    }

    public void addTrustedCertificates(String alias) {
        String[] stringArray = this.trustedCertificates;
        synchronized (stringArray) {
            int i = 0;
            while (i < this.trustedCertificates.length) {
                if (this.trustedCertificates[i].equals(alias)) {
                    return;
                }
                ++i;
            }
            if (this.socketFactory.addTrustedCertificates(alias, this.trustedCertificates.length == 0)) {
                String[] temp = this.trustedCertificates;
                this.trustedCertificates = new String[this.trustedCertificates.length + 1];
                System.arraycopy(temp, 0, this.trustedCertificates, 0, temp.length);
                this.trustedCertificates[temp.length] = alias;
                String key = this.trustKey + temp.length;
                this.properties.setProperty(key, alias);
                this.factory.store();
            }
        }
    }

    public void addTrustedCertificates(String[] aliases) {
        int i = 0;
        while (i < aliases.length) {
            this.addTrustedCertificates(aliases[i]);
            ++i;
        }
    }

    public void close() throws IOException {
        if (this.server != null) {
            this.server.close();
        } else {
            super.close();
        }
        this.factory.freeSocket(this);
    }

    public String[] getCredentials() {
        return this.socketFactory.getCredentials();
    }

    public String[] getAvailableCertificates() {
        return this.socketFactory.getAvailableCertificates();
    }

    public String[] getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public String[] getEnabledCipherSuites() {
        return this.socketFactory.getEnabledCipherSuites();
    }

    public boolean getEnableSessionCreation() {
        return this.isSessionCreationEnabled;
    }

    public static void setInetAddress(InetAddress address) {
        inetAddress = address;
    }

    public InetAddress getInetAddress() {
        return inetAddress;
    }

    public int getLocalPort() {
        if (this.server != null) {
            return this.server.getLocalPort();
        }
        return super.getLocalPort();
    }

    public boolean getNeedClientAuth() {
        return this.socketFactory.getNeedClientAuth();
    }

    public int getSoTimeout() throws IOException {
        if (this.server != null) {
            return this.server.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void initCredentials(String[] keystoreAliases) {
        int i = 0;
        while (i < keystoreAliases.length) {
            this.initCredentials(keystoreAliases[i]);
            ++i;
        }
    }

    public void initCredentials(String keystoreAliase) {
        this.socketFactory.addCredentials(keystoreAliase);
        this.writeCredentials(keystoreAliase);
    }

    public void removeCredentials(String keystoreAlias) {
        this.socketFactory.removeCredentials(keystoreAlias);
        this.removeCredentialsFromProperties(keystoreAlias);
        this.writeEnabledCipherSuites();
    }

    public void removeCredentials(String[] keystoreAliases) {
        this.socketFactory.removeCredentials(keystoreAliases);
        int i = 0;
        while (i < keystoreAliases.length) {
            this.removeCredentialsFromProperties(keystoreAliases[i]);
            ++i;
        }
        this.writeEnabledCipherSuites();
    }

    public void removeTrustedCertificates(String alias) {
        String[] stringArray = this.trustedCertificates;
        synchronized (stringArray) {
            if (alias == null || alias.trim().length() == 0) {
                this.context.getChainVerifier().removeTrustedCertificate(null);
            }
            int i = 0;
            while (i < this.trustedCertificates.length) {
                if (this.trustedCertificates[i].equals(alias)) {
                    Object value;
                    String[] temp = this.trustedCertificates;
                    this.trustedCertificates = new String[this.trustedCertificates.length - 1];
                    System.arraycopy(temp, 0, this.trustedCertificates, 0, i);
                    System.arraycopy(temp, i + 1, this.trustedCertificates, i, this.trustedCertificates.length - i);
                    int ind = i;
                    String key = this.trustKey;
                    do {
                        value = ((Hashtable)this.properties).remove(key + ind);
                        ++ind;
                    } while (value != null);
                    while (i < this.trustedCertificates.length) {
                        this.properties.setProperty(key + i, this.trustedCertificates[i]);
                        ++i;
                    }
                    this.factory.store();
                    break;
                }
                ++i;
            }
            this.socketFactory.removeTrustedCertificates(alias, this.trustedCertificates.length == 0);
        }
    }

    public void removeTrustedCertificates(String[] aliases) {
        String[] stringArray = this.trustedCertificates;
        synchronized (stringArray) {
            int j = 0;
            while (j < aliases.length) {
                int i = 0;
                while (i < aliases.length) {
                    if (aliases[i] == null || aliases[i].trim().length() == 0) {
                        this.context.getChainVerifier().removeTrustedCertificate(null);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.trustedCertificates.length) {
                    if (this.trustedCertificates[i2].equals(aliases[j])) {
                        Object value;
                        String[] temp = this.trustedCertificates;
                        this.trustedCertificates = new String[this.trustedCertificates.length - 1];
                        System.arraycopy(temp, 0, this.trustedCertificates, 0, i2);
                        System.arraycopy(temp, i2 + 1, this.trustedCertificates, i2, this.trustedCertificates.length - i2);
                        int ind = i2;
                        String key = this.trustKey;
                        do {
                            value = ((Hashtable)this.properties).remove(key + ind);
                            ++ind;
                        } while (value != null);
                        while (i2 < this.trustedCertificates.length) {
                            this.properties.setProperty(key + i2, this.trustedCertificates[i2]);
                            ++i2;
                        }
                        this.factory.store();
                        break;
                    }
                    ++i2;
                }
                ++j;
            }
            this.socketFactory.removeTrustedCertificates(aliases, this.trustedCertificates.length == 0);
        }
    }

    public void setCredentials(String[] keystoreAliases) {
        this.socketFactory.setCredentials(keystoreAliases);
        this.removeCredentialsFromProperties();
        int i = 0;
        while (i < keystoreAliases.length) {
            this.writeCredentials(keystoreAliases[i]);
            ++i;
        }
        this.writeEnabledCipherSuites();
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.socketFactory.setEnabledCipherSuites(suites);
        this.writeEnabledCipherSuites();
    }

    public void setEnableSessionCreation(boolean flag) {
        this.isSessionCreationEnabled = flag;
    }

    public void setNeedClientAuth(boolean flag) {
        this.socketFactory.setNeedClientAuth(flag);
        this.properties.setProperty(this.authKey, "" + flag);
        this.factory.store();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.server != null) {
            this.server.setSoTimeout(timeout);
        } else {
            super.setSoTimeout(timeout);
        }
    }

    public void setUseClientMode(boolean flag) {
        this.useClientMode = flag;
    }

    public String toString() {
        return "SSLServerSocket[host=" + this.host + ",port=" + this.port + "]";
    }

    public void initialize(boolean contextInitialized) {
        boolean propertiesFound = false;
        int trustedCertificates = 0;
        if (ServerSocketFactory.isKeyStoreReady() && ServerSocketFactory.getPropertiesLoaded()) {
            String value;
            int[] types = this.factory.getAllowedCertificateTypes();
            int count = 0;
            String[] ciphers = new String[]{};
            int i = 0;
            while (i < types.length) {
                value = this.properties.getProperty(this.certKey + types[i], "");
                if (!"".equals(value)) {
                    if (!this.newContextSet) {
                        this.newContextSet = true;
                        this.context = new SSLServerContext();
                        this.context.setDebugStream((Writer)new LoggerPrintStream());
                    }
                    this.initCredentials(value);
                    propertiesFound = true;
                }
                ++i;
            }
            do {
                if (!"".equals(value = this.properties.getProperty(this.cipherKey + count, ""))) {
                    if (!this.newContextSet) {
                        this.newContextSet = true;
                        this.context = new SSLServerContext();
                        this.context.setDebugStream((Writer)new LoggerPrintStream());
                    }
                    String[] temp = ciphers;
                    ciphers = new String[ciphers.length + 1];
                    System.arraycopy(temp, 0, ciphers, 0, temp.length);
                    ciphers[temp.length] = value;
                    propertiesFound = true;
                }
                ++count;
            } while (!"".equals(value));
            if (propertiesFound) {
                this.setEnabledCipherSuites(ciphers);
            }
            count = 0;
            trustedCertificates = 0;
            do {
                if ((value = this.properties.getProperty(this.trustKey + count)) != null) {
                    if (!this.newContextSet) {
                        this.newContextSet = true;
                        this.context = new SSLServerContext();
                        this.context.setDebugStream((Writer)new LoggerPrintStream());
                    }
                    this.addTrustedCertificates(value);
                    propertiesFound = true;
                    if (value.trim().length() > 0) {
                        ++trustedCertificates;
                    }
                }
                ++count;
            } while (value != null);
            if (trustedCertificates == 0) {
                this.setNeedClientAuth(false);
            } else {
                value = this.properties.getProperty(this.authKey);
                if (value != null) {
                    if (!this.newContextSet) {
                        this.newContextSet = true;
                        this.context = new SSLServerContext();
                        this.context.setDebugStream((Writer)new LoggerPrintStream());
                    }
                    if ("false".equals(value)) {
                        this.setNeedClientAuth(false);
                        propertiesFound = true;
                    } else {
                        this.setNeedClientAuth(true);
                    }
                }
            }
            if (!propertiesFound) {
                if (contextInitialized) {
                    String[] credentials = this.getCredentials();
                    int i2 = 0;
                    while (i2 < credentials.length) {
                        this.writeCredentials(credentials[i2]);
                        ++i2;
                    }
                    this.writeEnabledCipherSuites();
                    String[] trusted = this.getTrustedCertificates();
                    int i3 = 0;
                    while (i3 < trusted.length) {
                        this.properties.setProperty(this.trustKey + i3, trusted[i3]);
                        ++i3;
                    }
                    this.properties.setProperty(this.authKey, "" + this.getNeedClientAuth());
                    this.factory.store();
                } else {
                    this.initCredentials(this.factory.getCredentials());
                    this.setEnabledCipherSuites(this.factory.getDefaultCipherSuites());
                    this.setNeedClientAuth(this.factory.getNeedClientAuth());
                }
                this.addTrustedCertificates(this.factory.getTrustedCertificates());
            }
        }
    }

    private void init() {
        this.properties = this.factory.getSocketsProperties();
        this.certKey = this.host + ":" + this.port + ".cert.";
        this.cipherKey = this.host + ":" + this.port + ".cipher.";
        this.trustKey = this.host + ":" + this.port + ".trust.";
        this.authKey = this.host + ":" + this.port + ".need.auth";
    }

    private void writeEnabledCipherSuites() throws SSLConfigurationException {
        Object value;
        String[] cipherSuites = this.getEnabledCipherSuites();
        if (cipherSuites.length == 0) {
            throw new SSLConfigurationException("ssl_0020");
        }
        int index = 0;
        do {
            value = ((Hashtable)this.properties).remove(this.cipherKey + index);
            ++index;
        } while (value != null);
        int i = 0;
        while (i < cipherSuites.length) {
            this.properties.setProperty(this.cipherKey + i, cipherSuites[i]);
            ++i;
        }
        this.factory.store();
    }

    private void writeCredentials(String keystoreAlias) {
        Credentials certificate = KeyStoreConnector.getCredentials(keystoreAlias);
        this.properties.setProperty(this.certKey + certificate.getCertificateType(), keystoreAlias);
        this.factory.store();
    }

    private void removeCredentialsFromProperties(String keystoreAlias) {
        Credentials credentials = KeyStoreConnector.getCredentials(keystoreAlias);
        ((Hashtable)this.properties).remove(this.certKey + credentials.getCertificateType());
        this.factory.store();
    }

    private void removeCredentialsFromProperties() {
        int[] types = this.factory.getAllowedCertificateTypes();
        int i = 0;
        while (i < types.length) {
            ((Hashtable)this.properties).remove(this.certKey + types[i]);
            ++i;
        }
        this.factory.store();
    }

    public String[] getSupportedProtocols() {
        return CipherSuitesUtility.convertToStringArray(CipherSuitesUtility.getAllCipherSuites());
    }

    public String[] getEnabledProtocols() {
        return CipherSuitesUtility.convertToStringArray(this.context.getEnabledCipherSuites());
    }

    public void setEnabledProtocols(String[] protocols) {
        this.context.setEnabledCipherSuiteList(CipherSuitesUtility.convertToList(protocols));
    }

    public void setWantClientAuth(boolean flag) {
    }

    public boolean getWantClientAuth() {
        return false;
    }
}

