/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.frame.cluster.transport.TransportFactory;
import com.sap.engine.services.ssl.exception.BaseIOException;
import com.sap.engine.services.ssl.factory.ClientSocketFactory;
import com.sap.engine.services.ssl.factory.ServerSocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class SSLTransportFactory
implements TransportFactory {
    private TransportFactory base = null;
    private static ClientSocketFactory clientSocketFactory = null;
    private static ServerSocketFactory serverSocketFactory = null;

    public static final synchronized void stop() {
        if (clientSocketFactory != null) {
            ClientSocketFactory.stop();
        }
        if (serverSocketFactory != null) {
            ServerSocketFactory.stop();
        }
    }

    public SSLTransportFactory() {
    }

    public SSLTransportFactory(TransportFactory base) {
        this.base = base;
    }

    public void setFactory(TransportFactory factory) {
        this.base = factory;
    }

    protected synchronized ClientSocketFactory getClientSocketFactory() throws IOException {
        try {
            if (clientSocketFactory == null) {
                clientSocketFactory = (ClientSocketFactory)ClientSocketFactory.getDefault();
            }
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return clientSocketFactory;
    }

    public ServerSocket getServerSocket(int port, int accSize, String bindAddr) throws IOException {
        ServerSocket result = null;
        try {
            this.getServerSocketFactory();
            result = serverSocketFactory.createServerSocket(this.base.getServerSocket(port, accSize, bindAddr));
        }
        catch (IOException io_e) {
            throw BaseIOException.wrapException(io_e);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return result;
    }

    public ServerSocket getServerSocket(int port, int accSize) throws IOException {
        ServerSocket result = null;
        try {
            this.getServerSocketFactory();
            result = serverSocketFactory.createServerSocket(this.base.getServerSocket(port, accSize));
        }
        catch (IOException io_e) {
            throw BaseIOException.wrapException(io_e);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return result;
    }

    public ServerSocket getServerSocket(int port) throws IOException {
        ServerSocket result = null;
        try {
            this.getServerSocketFactory();
            result = serverSocketFactory.createServerSocket(this.base.getServerSocket(port));
        }
        catch (IOException io_e) {
            throw BaseIOException.wrapException(io_e);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return result;
    }

    private synchronized void getServerSocketFactory() throws IOException {
        if (serverSocketFactory == null) {
            try {
                serverSocketFactory = (ServerSocketFactory)ServerSocketFactory.getDefault();
            }
            catch (NoClassDefFoundError e) {
                throw BaseIOException.wrapException(e);
            }
            catch (Exception exc) {
                throw BaseIOException.wrapException(exc);
            }
        }
    }

    public Socket getSocket(String host, int port, Properties props) throws IOException {
        return this.getSocket(host, port);
    }

    public Socket getSocket(String host, int port) throws IOException {
        Socket socket = null;
        try {
            this.getClientSocketFactory();
            socket = clientSocketFactory.createSocket(this.base.getSocket(host, port), host, port, false);
        }
        catch (IOException io_e) {
            throw BaseIOException.wrapException(io_e);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return socket;
    }
}

