/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.factory;

import com.sap.engine.frame.cluster.transport.TransportFactory;
import com.sap.engine.services.ssl.exception.BaseIOException;
import com.sap.engine.services.ssl.factory.ClientSocketFactory;
import com.sap.engine.services.ssl.factory.SSLTransportFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class SSLHttpTransportFactory
extends SSLTransportFactory
implements TransportFactory {
    private static String ProxyHost = null;
    private static int ProxyPort = 0;
    private String RemoteHost = null;
    private int RemotePort = 0;
    static byte[] crlf_byte = new byte[]{13, 10};
    static String crlf = new String(crlf_byte);
    private static String ProxyRequest = null;

    public SSLHttpTransportFactory() {
    }

    public SSLHttpTransportFactory(TransportFactory base) {
        super(base);
    }

    public Socket getSocket(String host, int port, Properties props) throws IOException {
        this.RemoteHost = host;
        this.RemotePort = port;
        if (ProxyRequest == null) {
            ProxyRequest = "CONNECT " + this.RemoteHost + ":" + this.RemotePort + " HTTP/1.0" + crlf + crlf;
        }
        this.RemoteHost = props.getProperty("Host");
        this.RemotePort = Integer.parseInt(props.getProperty("Port"));
        ProxyHost = props.getProperty("HTTP_Host", host);
        ProxyPort = Integer.parseInt(props.getProperty("HTTP_Port", String.valueOf(port)));
        return this.getSocket(host, port);
    }

    public Socket getSocket(String host, int port) throws IOException {
        Socket socket = null;
        try {
            ClientSocketFactory clientSocketFactory = this.getClientSocketFactory();
            Socket s = new Socket(ProxyHost, ProxyPort);
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            out.writeBytes(ProxyRequest);
            out.flush();
            String response = br.readLine();
            if (response.indexOf("200") == -1) {
                throw new IOException("HTTP Proxy doesn't support CONNECT Directive or Proxy is not Setup");
            }
            socket = clientSocketFactory.createSocket(s, ProxyHost, ProxyPort, false);
        }
        catch (IOException io_e) {
            throw BaseIOException.wrapException(io_e);
        }
        catch (Exception e) {
            throw BaseIOException.wrapException(e);
        }
        return socket;
    }

    public ServerSocket getServerSocket(int a, int b, String v) throws IOException {
        return null;
    }
}

