/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.exception;

import com.sap.engine.services.ssl.exception.SSLResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;

public class KeyStoreConnectorException
extends SecurityException
implements IBaseException {
    public static final String KEYSTORE_IS_NOT_INITIALIZED = "ssl_0010";
    public static final String KEYSTORE_CANNOT_BE_BROWSED = "ssl_0011";
    public static final String SERVER_IDENTITY_NOT_FOUND = "ssl_0012";
    public static final String KEYSTORE_ENTRY_CANNOT_BE_CONSTRUCTED = "ssl_0013";
    public static final String MISSING_CERTIFICATE = "ssl_0014";
    public static final String MISSING_CERTIFICATE_CHAIN = "ssl_0015";
    private BaseExceptionInfo info = null;

    public KeyStoreConnectorException(String key) {
        super(key);
        this.info = new BaseExceptionInfo(SSLResourceAccessor.category, 500, SSLResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SSLResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
    }

    public KeyStoreConnectorException(String key, Object[] args) {
        super(key);
        this.info = new BaseExceptionInfo(SSLResourceAccessor.category, 500, SSLResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SSLResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, null);
    }

    public KeyStoreConnectorException(String key, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(SSLResourceAccessor.category, 500, SSLResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SSLResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
    }

    public KeyStoreConnectorException(String key, Object[] args, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(SSLResourceAccessor.category, 500, SSLResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(SSLResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
    }

    public Throwable initCause(Throwable throwable) {
        if (this.info != null) {
            return this.info.initCause(throwable);
        }
        return throwable;
    }

    public Throwable getCause() {
        if (this.info != null) {
            return this.info.getCause();
        }
        return null;
    }

    public String getMessage() {
        if (this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return this.info.getLocalizedMessage();
    }

    public LocalizableText getLocalizableMessage() {
        return this.info.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.info.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.info.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(TimeZone zone) {
        return this.info.getLocalizedMessage(zone);
    }

    public String getLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getLocalizedMessage(locale, zone);
    }

    public String getNestedLocalizedMessage() {
        return this.info.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale locale) {
        return this.info.getNestedLocalizedMessage(locale);
    }

    public String getNestedLocalizedMessage(TimeZone zone) {
        return this.info.getNestedLocalizedMessage(zone);
    }

    public String getNestedLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getNestedLocalizedMessage(locale, zone);
    }

    public void finallyLocalize() {
        this.info.finallyLocalize();
    }

    public void finallyLocalize(Locale locale) {
        this.info.finallyLocalize(locale);
    }

    public void finallyLocalize(TimeZone zone) {
        this.info.finallyLocalize(zone);
    }

    public void finallyLocalize(Locale locale, TimeZone zone) {
        this.info.finallyLocalize(locale, zone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.info.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.info.printStackTrace();
    }

    public void printStackTrace(PrintStream stream) {
        this.info.printStackTrace(stream);
    }

    public void printStackTrace(PrintWriter writer) {
        this.info.printStackTrace(writer);
    }

    public void setLogSettings(Category category, int i, Location location) {
        this.info.setLogSettings(category, i, location);
    }

    public void log() {
        this.info.log();
    }

    public void trace(int level, Location location) {
        this.info.trace(level, location);
    }

    private Object writeReplace() {
        StringWriter stringWriter = new StringWriter();
        this.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return new SecurityException(stringWriter.toString());
    }
}

