/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.services.ssl.admin.DispatcherRuntimeControl;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import com.sap.engine.services.ssl.admin.NonEditableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Configuration
implements ActionListener,
ListSelectionListener {
    private boolean first_call = true;
    private DispatcherRuntimeControl control;
    private JPanel socketPane;
    private JRadioButton newSocketsButton;
    private JRadioButton activeSocketsButton;
    private JScrollPane tablePane;
    private JTable table;
    private NonEditableModel tableModel;

    public Configuration(DispatcherRuntimeControl control) {
        this.control = control;
        this.socketPane = new JPanel(new GridBagLayout());
        this.socketPane.setAutoscrolls(true);
        this.socketPane.setEnabled(false);
        this.socketPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Configuration "));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.newSocketsButton = new JRadioButton("New Sockets", true);
        this.activeSocketsButton = new JRadioButton("Active Sockets", false);
        this.newSocketsButton.addActionListener(this);
        this.activeSocketsButton.addActionListener(this);
        buttonGroup.add(this.newSocketsButton);
        buttonGroup.add(this.activeSocketsButton);
        this.socketPane.add((Component)this.newSocketsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.socketPane.add((Component)this.activeSocketsButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePane = new JScrollPane();
        this.tableModel = new NonEditableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.tablePane.getViewport().add(this.table);
        this.socketPane.add((Component)this.tablePane, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.table.setEnabled(false);
        this.table.clearSelection();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.activeSocketsButton.isSelected()) {
            this.table.setEnabled(true);
            this.table.setRowSelectionInterval(0, 0);
        }
        if (this.newSocketsButton.isSelected()) {
            this.table.setEnabled(false);
            this.table.clearSelection();
            this.control.onAction("", 0, 1);
        }
    }

    private String getServerHost() {
        return this.table.getValueAt(this.table.getSelectedRow(), 0).toString();
    }

    private int getServerPort() {
        return Integer.parseInt(this.table.getValueAt(this.table.getSelectedRow(), 1).toString());
    }

    public JPanel getSocketPane() {
        return this.socketPane;
    }

    public void refresh() {
        Object[][] data = null;
        try {
            data = this.control.getRuntime().getActiveServerSockets();
            if (this.first_call && data.length == 0) {
                int i = 0;
                while (i < 5 && data.length == 0) {
                    try {
                        Configuration configuration = this;
                        synchronized (configuration) {
                            this.wait(1000L);
                        }
                        data = this.control.getRuntime().getActiveServerSockets();
                    }
                    catch (InterruptedException ie) {
                        data = this.control.getRuntime().getActiveServerSockets();
                    }
                    ++i;
                }
            }
            this.tableModel.setData(data);
            this.control.onAction("", 0, 2);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh SSL configuration.", e);
        }
        if (data != null && data.length > 0) {
            try {
                int index = -1;
                int i = 0;
                while (i < data.length) {
                    if ("443".equals(data[i][1])) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) {
                    int i2 = 0;
                    while (i2 < data.length) {
                        if (((String)data[i2][1]).endsWith("1")) {
                            index = i2;
                            break;
                        }
                        ++i2;
                    }
                }
                if (index < 0) {
                    index = 0;
                }
                this.control.onAction((String)data[index][0], new Integer((String)data[index][1]), 1);
                this.activeSocketsButton.setSelected(true);
                this.table.setEnabled(true);
                this.table.getSelectionModel().setSelectionInterval(index, index);
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to refresh SSL configuration.", e);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            this.control.onAction(this.getServerHost(), this.getServerPort(), 1);
        }
    }
}

