/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ssl.admin;

import com.sap.engine.gui.CListDialog;
import com.sap.engine.services.ssl.admin.DispatcherRuntimeControl;
import com.sap.engine.services.ssl.admin.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class Certificates
implements ActionListener {
    private DispatcherRuntimeControl control;
    private String host = "";
    private int port = 0;
    private JPanel certificatePane;
    private JList enabledList;
    private JButton enableButton;
    private JButton disableButton;
    private CListDialog supportedCertsDlg;

    public Certificates(DispatcherRuntimeControl control) {
        this.control = control;
        this.supportedCertsDlg = new CListDialog(null, "Available Credentials");
        this.supportedCertsDlg.setSize(new Dimension(400, 300));
        this.supportedCertsDlg.setTitle(" Credentials ");
        this.certificatePane = new JPanel(new BorderLayout());
        JTextArea textArea = new JTextArea("Choose default credentials that will be used in handshake. Different credentials are needed for enabling of different cipher suites. Choose keys first.");
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.setLineWrap(true);
        textArea.setEnabled(false);
        textArea.setBackground(this.certificatePane.getBackground());
        textArea.setDisabledTextColor(this.certificatePane.getForeground());
        this.certificatePane.add((Component)textArea, "North");
        JPanel temp = new JPanel(new BorderLayout());
        this.enabledList = new JList(new Vector());
        JScrollPane enabledListPane = new JScrollPane();
        enabledListPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Enabled Credential "));
        enabledListPane.getViewport().add(this.enabledList);
        temp.add((Component)enabledListPane, "Center");
        JPanel buttonPane = new JPanel(new GridBagLayout());
        this.enableButton = new JButton("Add");
        this.enableButton.addActionListener(this);
        buttonPane.add((Component)this.enableButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.disableButton = new JButton("Remove");
        this.disableButton.addActionListener(this);
        buttonPane.add((Component)this.disableButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttonPane.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        temp.add((Component)buttonPane, "East");
        this.certificatePane.add((Component)temp, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        boolean changed = false;
        if (e.getSource() == this.enableButton) {
            if (this.supportedCertsDlg.showDialog()) {
                Object[] values = this.supportedCertsDlg.getSelected();
                String[] stringValues = new String[values.length];
                int i = 0;
                while (i < values.length) {
                    stringValues[i] = values[i].toString();
                    ++i;
                }
                try {
                    this.control.getRuntime().addCredentials(this.host, this.port, stringValues);
                    changed = true;
                }
                catch (Exception exc) {
                    ExceptionHandler.error("Unable to add credentials to port configuration.", exc);
                }
            }
        } else if (e.getSource() == this.disableButton) {
            Object[] values = this.enabledList.getSelectedValues();
            String[] stringValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].toString();
                ++i;
            }
            try {
                this.control.getRuntime().removeCredentials(this.host, this.port, stringValues);
                changed = true;
            }
            catch (Exception exc) {
                ExceptionHandler.error("Unable to remove credentials from port configuration.", exc);
            }
        }
        if (changed) {
            this.control.onAction(this.host, this.port, 3);
        }
    }

    public void getProperties(String name) {
        JOptionPane.showMessageDialog(this.certificatePane, name, "Properties", -1);
    }

    public JPanel getCertificatePane() {
        return this.certificatePane;
    }

    public void refresh(String host, int port) {
        try {
            String[] credentials = this.control.getRuntime().getCredentials(host, port);
            this.enabledList.setListData(credentials);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh port configuration.", e);
        }
    }

    public void refreshAvailableList(String host, int port) {
        try {
            this.supportedCertsDlg.initList(this.control.getRuntime().getSupportedCredentials(host, port));
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to refresh port configuration.", e);
        }
    }

    public void setServerSocket(String host, int port) {
        this.host = host;
        this.port = port;
    }
}

