/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.services.httpserver.interfaces.ErrorData;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.SecuritySessionException;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ServletContextImpl;
import com.sap.engine.services.servlets_jsp.server.runtime.context.SessionServletContext;
import com.sap.engine.services.servlets_jsp.server.security.HttpCallbackHandlerImpl;
import com.sap.engine.services.servlets_jsp.server.security.HttpRequestClientInfoImpl;
import com.sap.tc.logging.Location;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PutProtectionFilter
implements Filter {
    private static final String UPLOAD_ROLE_NAME = "$SAP_J2EE_Engine_Upload";
    private ApplicationContext applicationContext = null;
    private SessionServletContext sessionServletContext = null;
    private SecurityContext securityContext = null;
    private AuthenticationContext authenticationContext = null;
    private boolean isInitialized = true;
    private String errorMessage = null;
    private String additionalErrorMessage = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$servlet$PutProtectionFilter == null ? (class$com$sap$engine$services$servlets_jsp$server$servlet$PutProtectionFilter = PutProtectionFilter.class$("com.sap.engine.services.servlets_jsp.server.servlet.PutProtectionFilter")) : class$com$sap$engine$services$servlets_jsp$server$servlet$PutProtectionFilter));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$servlet$PutProtectionFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.applicationContext = ((ServletContextImpl)filterConfig.getServletContext()).getApplicationContext();
        this.sessionServletContext = this.applicationContext.getSessionServletContext();
        this.securityContext = this.sessionServletContext.getAppSecurityContext();
        this.authenticationContext = this.securityContext.getAuthenticationContext();
        this.ensureUploadRoleCreated();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequestFacade unwrappedRequest = FilterUtils.unWrapRequest(request);
        HttpServletResponseFacade unwrappedResponse = FilterUtils.unWrapResponse(response);
        if (!this.isInitialized) {
            unwrappedResponse.sendError(503, this.errorMessage, this.additionalErrorMessage, true);
            return;
        }
        String user = unwrappedRequest.getRemoteUser();
        if (user == null && !this.doLogin(unwrappedRequest, unwrappedResponse)) {
            ErrorData errorData = unwrappedRequest.getHttpParameters().getErrorData();
            if (errorData == null) {
                unwrappedResponse.sendError(500, "Unable to login user.", "Internal error in user verification. Error data not found.", true);
            } else {
                unwrappedResponse.sendError(errorData.getErrorCode(), errorData.getMainMessage(), errorData.getAdditionalMessage(), true);
            }
        }
        if (this.checkUploadPermissions()) {
            filterChain.doFilter(request, response);
        } else {
            unwrappedResponse.sendError(403, "You are not authorized to upload the resource " + unwrappedRequest.getRequestURIinternal(), "Please, contact the server administrator to assign you permissions", true);
        }
    }

    public void destroy() {
    }

    private boolean checkUploadPermissions() {
        try {
            return this.securityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(UPLOAD_ROLE_NAME).isCallerInRole();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void ensureUploadRoleCreated() {
        if (this.authenticationContext == null || this.authenticationContext.getLoginModules() == null || this.authenticationContext.getLoginModules().length == 0) {
            this.isInitialized = false;
            this.errorMessage = "Http upload is not allowed for this resource.";
            this.additionalErrorMessage = "Authentication mechanism not specified. Login configuration not found for this web application.";
            Log.getCategory(2).logWarning(this.currentLocation, "Http upload for this web application will not be possible. To enable it specify login-config for your application.", this.applicationContext.getAliasName());
            return;
        }
        SecurityRoleContext secRoleContext = this.securityContext.getAuthorizationContext().getSecurityRoleContext();
        SecurityRole secRole = secRoleContext.getSecurityRole(UPLOAD_ROLE_NAME);
        if (secRole == null) {
            try {
                secRole = secRoleContext.addSecurityRole(UPLOAD_ROLE_NAME);
            }
            catch (Exception e) {
                Log.getCategory(2).logWarning(this.currentLocation, "Error occured in creating the security role $SAP_J2EE_Engine_Upload for upload permissions.", this.applicationContext.getAliasName());
            }
        }
    }

    private boolean doLogin(HttpServletRequestFacade requestFacade, HttpServletResponseFacade responseFacade) throws IOException {
        HttpRequestClientInfoImpl loginInfo = new HttpRequestClientInfoImpl(requestFacade.getHttpParameters(), this.applicationContext);
        try {
            this.authenticationContext.getLoginContext(new Subject(), new HttpCallbackHandlerImpl(loginInfo)).login();
            ApplicationSession applicationSession = (ApplicationSession)requestFacade.getHttpParameters().getApplicationSession();
            if (applicationSession == null) {
                applicationSession = this.sessionServletContext.createSession(requestFacade.getHttpParameters());
            }
            try {
                this.sessionServletContext.getPolicyDomain().registerNewSession(applicationSession);
            }
            catch (SecuritySessionException e) {
                this.sessionServletContext.getPolicyDomain().joinSession(applicationSession);
            }
            boolean responseGenerated = loginInfo.generate(false, null);
            if (responseGenerated) {
                return false;
            }
        }
        catch (LoginException e) {
            boolean responseGenerated = loginInfo.generate(true, e.getMessage());
            if (responseGenerated) {
                return false;
            }
            if (loginInfo.isPasswordExpired()) {
                requestFacade.getHttpParameters().redirect(loginInfo.getPasswordChangeLoginPage().getBytes());
                return false;
            }
            responseFacade.sendError(401, "You must be authorized to upload the requested resource.", e.toString(), true);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

