/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.ServletNotFoundException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebServletException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebUnavailableException;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletResponseFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ServletContextImpl;
import com.sap.engine.services.servlets_jsp.server.security.PrivilegedActionImpl;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvokerServlet
extends HttpServlet {
    private static final String INVOKE_BY_CLASSNAME_KEY = "InvokeByClassName";
    private Class SERVLET_INTERFACE = null;
    private ApplicationContext scf = null;
    private boolean invokeByClassName = false;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$servlet$InvokerServlet == null ? (class$com$sap$engine$services$servlets_jsp$server$servlet$InvokerServlet = InvokerServlet.class$("com.sap.engine.services.servlets_jsp.server.servlet.InvokerServlet")) : class$com$sap$engine$services$servlets_jsp$server$servlet$InvokerServlet));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$servlet$InvokerServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.scf = ((ServletContextImpl)servletConfig.getServletContext()).getApplicationContext();
        this.invokeByClassName = "true".equalsIgnoreCase(servletConfig.getInitParameter(INVOKE_BY_CLASSNAME_KEY));
        if (!this.invokeByClassName) {
            Log.getCategory(1).logWarning(this.currentLocation, "The servlet " + this.getServletName() + " will not invoke servlets requested by class name. " + "To switch this feature on edit the initial parameter " + this.invokeByClassName + " into global-web.xml file.", this.scf.getAliasName());
        }
        try {
            this.SERVLET_INTERFACE = Class.forName("javax.servlet.Servlet");
        }
        catch (ClassNotFoundException e) {
            Log.getCategory(4).logFatal(this.currentLocation, "Cannot load class javax.servlet.Servlet.", e, this.scf.getAliasName());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block27: {
            Servlet srv;
            Subject subject;
            String servletName;
            boolean isIncluded;
            String pathInfo;
            HttpServletRequestFacade requestUnwrapped;
            block26: {
                int indx;
                requestUnwrapped = FilterUtils.unWrapRequest((ServletRequest)request);
                HttpServletResponseFacade responseUnwrapped = FilterUtils.unWrapResponse((ServletResponse)response);
                pathInfo = (String)request.getAttribute("com.inqmy.include.path_info");
                request.removeAttribute("com.inqmy.include.path_info");
                isIncluded = responseUnwrapped.getIncluded();
                if (pathInfo == null) {
                    pathInfo = request.getPathInfo();
                    if (pathInfo == null) {
                        throw new ServletNotFoundException(ServletNotFoundException.Requested_resource_not_found, new Object[]{request.getRequestURI()});
                    }
                    indx = pathInfo.indexOf(";");
                    if (indx > 0) {
                        pathInfo = pathInfo.substring(0, indx);
                    }
                }
                indx = pathInfo.indexOf(47, 1);
                servletName = null;
                if (indx < 0) {
                    servletName = pathInfo.charAt(0) == '/' ? pathInfo.substring(1) : pathInfo;
                    pathInfo = null;
                } else {
                    servletName = pathInfo.charAt(0) == '/' ? pathInfo.substring(1, indx) : pathInfo.substring(0, indx);
                    pathInfo = pathInfo.substring(indx);
                }
                subject = this.scf.getSubject(servletName);
                srv = null;
                if (!this.scf.getWebComponents().containsServletByClass(servletName)) {
                    try {
                        srv = this.scf.getWebComponents().getServlet(servletName);
                    }
                    catch (WebUnavailableException e) {
                        throw e;
                    }
                    catch (UnavailableException e) {
                        throw new WebUnavailableException("servlet_jsp_0046", e.getUnavailableSeconds(), new Object[]{servletName}, e);
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (IOException io) {
                        if (this.canLoadServlet(servletName, responseUnwrapped)) break block26;
                        return;
                    }
                }
            }
            if (srv == null) {
                srv = this.scf.getWebComponents().getServletByClass(servletName);
            }
            if (!isIncluded) {
                requestUnwrapped.setServletPath("/servlet/" + servletName);
                requestUnwrapped.setPathInfo(pathInfo);
            }
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("Invoking Servlet <" + servletName + ">, servlet class is <" + srv.getClass().getName() + ">.", this.scf.getAliasName());
            }
            try {
                if (subject == null) {
                    if (srv instanceof SingleThreadModel) {
                        Servlet e = srv;
                        synchronized (e) {
                            srv.service((ServletRequest)request, (ServletResponse)response);
                            break block27;
                        }
                    }
                    srv.service((ServletRequest)request, (ServletResponse)response);
                    break block27;
                }
                if (srv instanceof SingleThreadModel) {
                    Subject.doAs(subject, new PrivilegedActionImpl(srv, (ServletRequest)request, (ServletResponse)response, true));
                } else {
                    Subject.doAs(subject, new PrivilegedActionImpl(srv, (ServletRequest)request, (ServletResponse)response, false));
                }
            }
            catch (UnavailableException e) {
                srv.destroy();
                this.scf.getWebComponents().addServletByClass(servletName);
                if (e.isPermanent()) {
                    this.scf.getWebComponents().setServletUnavailable(servletName, -1L);
                } else {
                    this.scf.getWebComponents().setServletUnavailable(servletName, System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000));
                }
                throw new WebUnavailableException("servlet_jsp_0046", e.getUnavailableSeconds(), new Object[]{servletName}, e);
            }
            catch (PrivilegedActionException pe) {
                throw new WebServletException("servlet_jsp_0043", new Object[]{srv.getServletConfig().getServletName()}, pe);
            }
        }
    }

    private boolean canLoadServlet(String servletName, HttpServletResponseFacade responseUnwrapped) throws IOException {
        if (!this.invokeByClassName) {
            responseUnwrapped.sendError(403, "A servlet with class <i>[" + servletName + "]</i> cannot be loaded!", "You can invoke the servlet only using its servlet name.  To load the servlet by its class, please, edit the initial parameter InvokeByClassName of the servlet " + this.getServletName() + " in global-web.xml file.", true);
            return false;
        }
        Class<?> servletClass = null;
        try {
            servletClass = Class.forName(servletName, true, this.scf.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            responseUnwrapped.sendError(404, "A servlet with class [" + servletName + "] is not found!", e.toString(), true);
            return false;
        }
        if (this.SERVLET_INTERFACE == null) {
            responseUnwrapped.sendError(403, "Class javax.servlet.Servlet is not found.");
            return false;
        }
        if (!this.SERVLET_INTERFACE.isAssignableFrom(servletClass)) {
            responseUnwrapped.sendError(403, "A servlet with class [" + servletName + "] is not found!", "The class [" + servletName + "] is not a valid servlet.", true);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

