/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.ServletAndJspLock;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebIOException;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileDeployer {
    private static final String UPDATE_LOCK = "_web_container_update_lock_";
    private ConfigurationHandler handler = null;

    public FileDeployer(ConfigurationHandler handler) throws IOException {
        if (handler == null) {
            throw new WebIOException("servlet_jsp_0025");
        }
        this.handler = handler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadFileInApplication(String fileName, String entry, String appName) throws IOException {
        long fileId = -1L;
        byte[] crc = null;
        boolean isNewFile = false;
        String uploadedFileLockName = appName + '/' + entry;
        Configuration config = null;
        try {
            Configuration cfg = SBasic.deployCommunicator.startRuntimeChanges(appName, false);
            config = cfg.getSubConfiguration("servlet_jsp");
            config = config.getSubConfiguration("update");
        }
        catch (DeploymentException e) {
            throw new WebIOException("servlet_jsp_0272", (Throwable)((Object)e));
        }
        catch (ConfigurationException e) {
            throw new WebIOException("servlet_jsp_0265", (Throwable)((Object)e));
        }
        try {
            block56: {
                try {
                    try {
                        SBasic.servletAndJspLock.lock(UPDATE_LOCK);
                    }
                    catch (LockException e) {
                        throw new WebIOException("servlet_jsp_0273", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e));
                    }
                    catch (TechnicalLockException e) {
                        throw new WebIOException("servlet_jsp_0273", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e));
                    }
                    try {
                        fileId = this.findFileidInConfig(config, entry);
                    }
                    catch (ConfigurationException e) {
                        SBasic.servletAndJspLock.unlock(UPDATE_LOCK);
                        throw new WebIOException("servlet_jsp_0267", new Object[]{entry}, (Throwable)((Object)e));
                    }
                    if (fileId != -1L) break block56;
                    try {
                        String fileCounter = (String)config.getConfigEntry("FILE_COUNTER");
                        fileId = Long.parseLong(fileCounter);
                    }
                    catch (ConfigurationException e) {
                        SBasic.servletAndJspLock.unlock(UPDATE_LOCK);
                        throw new WebIOException("servlet_jsp_0267", new Object[]{"FILE_COUNTER"}, (Throwable)((Object)e));
                    }
                    try {
                        config.modifyConfigEntry("FILE_COUNTER", "" + (fileId + 1L));
                    }
                    catch (ConfigurationException e) {
                        SBasic.servletAndJspLock.unlock(UPDATE_LOCK);
                        throw new WebIOException("servlet_jsp_0267", new Object[]{"FILE_COUNTER"}, (Throwable)((Object)e));
                    }
                    isNewFile = true;
                }
                catch (OutOfMemoryError t) {
                    throw t;
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    try {
                        SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
                        throw new WebIOException("servlet_jsp_0274", t);
                    }
                    catch (RemoteException re) {
                        throw new WebIOException("servlet_jsp_0276", t);
                    }
                }
            }
            Object var15_28 = null;
        }
        catch (Throwable throwable) {
            Object var15_29 = null;
            try {
                SBasic.servletAndJspLock.unlock(UPDATE_LOCK);
                throw throwable;
            }
            catch (TechnicalLockException e) {
                try {
                    SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
                    throw new WebIOException("servlet_jsp_0275", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e));
                }
                catch (RemoteException re) {
                    throw new WebIOException("servlet_jsp_0276", new WebIOException("servlet_jsp_0275", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e)));
                }
            }
        }
        try {}
        catch (TechnicalLockException e) {
            try {}
            catch (RemoteException re) {
                throw new WebIOException("servlet_jsp_0276", new WebIOException("servlet_jsp_0275", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e)));
            }
            SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new WebIOException("servlet_jsp_0275", new Object[]{UPDATE_LOCK}, (Throwable)((Object)e));
        }
        SBasic.servletAndJspLock.unlock(UPDATE_LOCK);
        try {
            try {
                block58: {
                    try {
                        SBasic.servletAndJspLock.lock(uploadedFileLockName);
                    }
                    catch (LockException e) {
                        throw new WebIOException("servlet_jsp_0273", new Object[]{uploadedFileLockName}, (Throwable)((Object)e));
                    }
                    catch (TechnicalLockException e) {
                        throw new WebIOException("servlet_jsp_0273", new Object[]{uploadedFileLockName}, (Throwable)((Object)e));
                    }
                    try {
                        if (isNewFile) {
                            config.addConfigEntry("" + fileId, entry);
                        } else {
                            config.modifyConfigEntry("" + fileId, entry);
                        }
                    }
                    catch (ConfigurationException e) {
                        throw new WebIOException("servlet_jsp_0268", new Object[]{"" + fileId}, (Throwable)((Object)e));
                    }
                    try {
                        if (isNewFile) {
                            try {
                                crc = HashUtils.generateFileHash(entry, new FileInputStream(fileName));
                            }
                            catch (IOException io) {
                                throw new WebIOException("servlet_jsp_0269", new Object[]{entry}, io);
                            }
                            config.addFileAsStream("#" + fileId, new FileInputStream(fileName));
                            config.addConfigEntry("$" + fileId, crc);
                            break block58;
                        }
                        try {
                            crc = HashUtils.generateFileHash(entry, new FileInputStream(fileName));
                        }
                        catch (IOException io) {
                            throw new WebIOException("servlet_jsp_0269", new Object[]{entry}, io);
                        }
                        config.updateFileAsStream("#" + fileId, new FileInputStream(fileName));
                        config.modifyConfigEntry("$" + fileId, crc);
                    }
                    catch (ConfigurationException e) {
                        throw new WebIOException("servlet_jsp_0268", new Object[]{"" + fileId}, (Throwable)((Object)e));
                    }
                }
                Object var19_39 = null;
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                try {
                    SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
                    throw new WebIOException("servlet_jsp_0274", t);
                }
                catch (RemoteException re) {
                    throw new WebIOException("servlet_jsp_0276", t);
                }
            }
        }
        catch (Throwable throwable) {
            Object var19_40 = null;
            try {
                SBasic.servletAndJspLock.unlock(uploadedFileLockName);
                throw throwable;
            }
            catch (TechnicalLockException e) {
                try {
                    SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
                    throw new WebIOException("servlet_jsp_0275", new Object[]{uploadedFileLockName}, (Throwable)((Object)e));
                }
                catch (RemoteException re) {
                    throw new WebIOException("servlet_jsp_0276", new WebIOException("servlet_jsp_0275", new Object[]{uploadedFileLockName}, (Throwable)((Object)e)));
                }
            }
        }
        try {}
        catch (TechnicalLockException e) {
            try {}
            catch (RemoteException re) {
                throw new WebIOException("servlet_jsp_0276", new WebIOException("servlet_jsp_0275", new Object[]{uploadedFileLockName}, (Throwable)((Object)e)));
            }
            SBasic.deployCommunicator.rollbackRuntimeChanges(appName);
            throw new WebIOException("servlet_jsp_0275", new Object[]{uploadedFileLockName}, (Throwable)((Object)e));
        }
        SBasic.servletAndJspLock.unlock(uploadedFileLockName);
        try {
            SBasic.deployCommunicator.makeRuntimeChanges(appName, false);
            return isNewFile;
        }
        catch (RemoteException e) {
            throw new WebIOException("servlet_jsp_0277", e);
        }
    }

    /*
     * Loose catch block
     */
    public boolean uploadFileInAlias(String fileName, String entry, String hostName, String aliasName) throws IOException {
        boolean isNew;
        block44: {
            isNew = false;
            long fileId = -1L;
            byte[] crc = null;
            Configuration config = null;
            try {
                config = this.openAliasConfiguration(hostName, aliasName);
            }
            catch (ConfigurationException e) {
                throw new WebIOException("servlet_jsp_0265", (Throwable)((Object)e));
            }
            SBasic.servletAndJspLock.lock(ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK);
            try {
                fileId = this.findFileidInConfig(config, entry);
            }
            catch (ConfigurationException e) {
                throw new WebIOException("servlet_jsp_0267", new Object[]{entry}, (Throwable)((Object)e));
            }
            if (fileId == -1L) {
                try {
                    String fileCounter = (String)config.getConfigEntry("FILE_COUNTER");
                    fileId = Long.parseLong(fileCounter);
                }
                catch (ConfigurationException e) {
                    throw new WebIOException("servlet_jsp_0267", new Object[]{"FILE_COUNTER"}, (Throwable)((Object)e));
                }
                try {
                    config.modifyConfigEntry("FILE_COUNTER", "" + (fileId + 1L));
                }
                catch (ConfigurationException e) {
                    throw new WebIOException("servlet_jsp_0268", new Object[]{"FILE_COUNTER"}, (Throwable)((Object)e));
                }
                isNew = true;
            }
            try {
                if (isNew) {
                    config.addConfigEntry("" + fileId, entry);
                } else {
                    config.modifyConfigEntry("" + fileId, entry);
                }
            }
            catch (ConfigurationException e) {
                throw new WebIOException("servlet_jsp_0268", new Object[]{"" + fileId}, (Throwable)((Object)e));
            }
            try {
                if (isNew) {
                    try {
                        crc = HashUtils.generateFileHash(entry, new FileInputStream(fileName));
                    }
                    catch (IOException io) {
                        throw new WebIOException("servlet_jsp_0269", new Object[]{entry}, io);
                    }
                    config.addFileAsStream("#" + fileId, new FileInputStream(fileName));
                    config.addConfigEntry("$" + fileId, crc);
                    break block44;
                }
                try {
                    crc = HashUtils.generateFileHash(entry, new FileInputStream(fileName));
                }
                catch (IOException io) {
                    throw new WebIOException("servlet_jsp_0269", new Object[]{entry}, io);
                }
                config.updateFileAsStream("#" + fileId, new FileInputStream(fileName));
                config.modifyConfigEntry("$" + fileId, crc);
            }
            catch (ConfigurationException e) {
                throw new WebIOException("servlet_jsp_0268", new Object[]{"#" + fileId}, (Throwable)((Object)e));
            }
        }
        try {
            this.handler.commit();
        }
        catch (ConfigurationException e) {
            throw new WebIOException("servlet_jsp_0270", new Object[]{entry}, (Throwable)((Object)e));
        }
        Object var16_20 = null;
        this.handler.closeAllConfigurations();
        Object var19_22 = null;
        try {
            SBasic.servletAndJspLock.unlock(ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK);
        }
        catch (TechnicalLockException e) {
            throw new WebIOException("servlet_jsp_0275", new Object[]{ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK}, (Throwable)((Object)e));
        }
        {
            catch (ConfigurationException e) {
                throw new WebIOException("servlet_jsp_0271", (Throwable)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            try {
                SBasic.servletAndJspLock.unlock(ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK);
            }
            catch (TechnicalLockException e) {
                throw new WebIOException("servlet_jsp_0275", new Object[]{ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK}, (Throwable)((Object)e));
            }
            throw throwable;
        }
        {
            catch (WebIOException io) {
                try {
                    this.handler.rollback();
                }
                catch (ConfigurationException ex) {
                    throw new WebIOException("servlet_jsp_0266", new Object[]{ex}, io);
                }
                throw io;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                try {
                    this.handler.rollback();
                }
                catch (ConfigurationException ex) {
                    throw new WebIOException("servlet_jsp_0266", new Object[]{ex}, t);
                }
                throw new WebIOException("servlet_jsp_0274", t);
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            this.handler.closeAllConfigurations();
            Object var19_24 = null;
            try {
                SBasic.servletAndJspLock.unlock(ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK);
            }
            catch (TechnicalLockException e) {
                throw new WebIOException("servlet_jsp_0275", new Object[]{ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK}, (Throwable)((Object)e));
            }
            {
                catch (ConfigurationException e) {
                    throw new WebIOException("servlet_jsp_0271", (Throwable)((Object)e));
                }
            }
            catch (Throwable throwable2) {
                Object var19_25 = null;
                try {
                    SBasic.servletAndJspLock.unlock(ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK);
                }
                catch (TechnicalLockException e) {
                    throw new WebIOException("servlet_jsp_0275", new Object[]{ServletAndJspLock.HTTP_UPLOADED_FILES_LOCK}, (Throwable)((Object)e));
                }
                throw throwable2;
            }
            throw throwable;
        }
        return isNew;
    }

    private long findFileidInConfig(Configuration config, String entry) throws ConfigurationException {
        Map fileEntries = config.getAllFileEntries();
        if (fileEntries.isEmpty()) {
            fileEntries = config.getAllConfigEntries();
            if (fileEntries.isEmpty()) {
                config.addConfigEntry("FILE_COUNTER", "1");
            }
        } else {
            Set keySet = fileEntries.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String nextFilename = (String)iter.next();
                String fsId = nextFilename.substring(1);
                String path = (String)config.getConfigEntry(fsId);
                if (!entry.equals(path)) continue;
                return Long.parseLong(fsId);
            }
        }
        return -1L;
    }

    private Configuration openAliasConfiguration(String hostName, String aliasName) throws ConfigurationLockedException, ConfigurationException {
        Configuration config = null;
        try {
            config = this.handler.openConfiguration("HttpAliases", 1);
        }
        catch (NameNotFoundException ex) {
            config = this.handler.createRootConfiguration("HttpAliases");
        }
        try {
            config = config.getSubConfiguration(hostName);
        }
        catch (NameNotFoundException ex) {
            config = config.createSubConfiguration(hostName);
        }
        try {
            return config.getSubConfiguration(aliasName);
        }
        catch (NameNotFoundException ex) {
            return config.createSubConfiguration(aliasName);
        }
    }
}

