/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.servlet;

import com.sap.engine.lib.text.FastDateFormat;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.Responses;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.httpserver.server.hosts.HostProperties;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.lib.FilterUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.client.HttpServletRequestFacade;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ServletContextImpl;
import com.sap.engine.services.servlets_jsp.server.servlet.StaticFilesCache;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultServlet
extends HttpServlet {
    private static final Locale loc = Locale.US;
    private static final TimeZone localZone = TimeZone.getDefault();
    private static final FastDateFormat listFormat = new FastDateFormat("dd-MMM-yyyy HH:mm", localZone, loc, false);
    private ApplicationContext scf = null;
    private StaticFilesCache staticFilesCache = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$servlet$DefaultServlet == null ? (class$com$sap$engine$services$servlets_jsp$server$servlet$DefaultServlet = DefaultServlet.class$("com.sap.engine.services.servlets_jsp.server.servlet.DefaultServlet")) : class$com$sap$engine$services$servlets_jsp$server$servlet$DefaultServlet));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$servlet$DefaultServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.scf = ((ServletContextImpl)servletConfig.getServletContext()).getApplicationContext();
        this.staticFilesCache = new StaticFilesCache(1);
    }

    public void service(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        HttpServletRequestFacade requestUnwrapped = FilterUtils.unWrapRequest((ServletRequest)httpservletrequest);
        HostProperties hostProperties = requestUnwrapped.getHttpParameters().getHostProperties();
        String requestURI = null;
        requestURI = requestUnwrapped.getHttpParameters().getRequest().getRequestLine().isEncoded() ? requestUnwrapped.getHttpParameters().getRequest().getRequestLine().getUrlDecoded().toStringUTF8() : requestUnwrapped.getHttpParameters().getRequest().getRequestLine().getUrlDecoded().toString();
        requestURI = new String(ParseUtils.separatorsToFS((String)requestURI));
        MessageBytes aliasName = requestUnwrapped.getHttpParameters().getRequestPathMappings().getAliasName();
        if ((aliasName = new MessageBytes(ParseUtils.separatorsToFS((String)aliasName.toString()))) != null && !aliasName.equals("/") && requestURI.startsWith("/" + aliasName.toString()) && !(requestURI = requestURI.substring(aliasName.length() + 1)).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        if (this.staticFilesCache.replyFromCache(httpservletrequest, httpservletresponse, this.scf.getServletContext(), requestUnwrapped.getHttpParameters(), hostProperties)) {
            return;
        }
        String aliasValue = requestUnwrapped.getHttpParameters().getRequestPathMappings().getAliasValue();
        if (aliasValue == null) {
            FilterUtils.unWrapResponse((ServletResponse)httpservletresponse).sendError(500, "Alias value not found.");
            return;
        }
        aliasValue = new String(ParseUtils.separatorsToFS((String)aliasValue));
        String realPath = aliasValue + requestURI;
        File f = new File(realPath = ParseUtils.canonicalize((String)realPath));
        if (!f.exists()) {
            httpservletresponse.sendError(404, "The requested file " + requestURI + " does not exist.");
            return;
        }
        String canonicalPath = new String(ParseUtils.separatorsToFS((String)f.getCanonicalPath()));
        byte[] canonicalPathBytes = canonicalPath.getBytes();
        if (!canonicalPath.startsWith(aliasValue)) {
            httpservletresponse.sendError(404, "The requested file " + requestURI + " does not exist.");
            return;
        }
        if (!ByteArrayUtils.equalsBytes((byte[])canonicalPathBytes, (byte[])realPath.getBytes())) {
            httpservletresponse.sendError(404, "The requested file " + requestURI + " does not exist.");
            return;
        }
        if (!aliasValue.endsWith("/")) {
            aliasValue = aliasValue + "/";
        }
        if (ByteArrayUtils.startsWithIgnoreCase((byte[])canonicalPathBytes, (byte[])(aliasValue + "META-INF").getBytes()) || ByteArrayUtils.startsWithIgnoreCase((byte[])canonicalPathBytes, (byte[])(aliasValue + "WEB-INF").getBytes())) {
            httpservletresponse.sendError(404, "Directories WEB-INF and META-INF are not allowed for browsing.");
            return;
        }
        if (requestUnwrapped.getHttpParameters().getRequest().getRequestLine().getHttpMajorVersion() == 0 || requestUnwrapped.getHttpParameters().getRequest().getRequestLine().getHttpMajorVersion() == 1 && requestUnwrapped.getHttpParameters().getRequest().getRequestLine().getHttpMinorVersion() == 0) {
            httpservletresponse.setDateHeader("Expires", System.currentTimeMillis() + requestUnwrapped.getHttpParameters().getHttpProperties().getCacheValidationTime() * 1000L);
        } else {
            httpservletresponse.setHeader("Cache-Control", requestUnwrapped.getHttpParameters().getHttpProperties().getCacheValidationTimeString());
        }
        if (!f.isDirectory()) {
            this.returnFile(new MessageBytes(requestURI.getBytes()), f, requestUnwrapped.getHttpParameters(), httpservletresponse, httpservletrequest);
        } else if (f.isDirectory()) {
            String reqURI = "/" + aliasName + requestURI;
            if (!reqURI.endsWith("/")) {
                httpservletresponse.sendRedirect(reqURI + "/");
                return;
            }
            this.returnDirectory(f, reqURI, realPath, hostProperties, requestUnwrapped, httpservletresponse);
        }
    }

    private void returnFile(MessageBytes fileName, File f, HttpParameters httpParameters, HttpServletResponse httpservletresponse, HttpServletRequest httpservletrequest) throws IOException {
        boolean isEncoded = httpParameters.getRequest().isGzipEncoding();
        String type = this.scf.getServletContext().getMimeType(f.getName());
        if (type == null) {
            type = f.getName();
            if (type.indexOf(".") > 0) {
                type = type.substring(type.lastIndexOf(46) + 1);
            }
            type = httpParameters.getMimeMappings().getMimeType(type);
        }
        if (type != null) {
            httpservletresponse.setContentType(type.replace('/', '/').replace('\\', '/'));
        } else {
            httpservletresponse.setContentType("content/unknown");
        }
        ServletOutputStream servletOutputStream = null;
        PrintWriter printWriter = null;
        try {
            servletOutputStream = httpservletresponse.getOutputStream();
        }
        catch (IllegalStateException ie) {
            if (type.startsWith("text")) {
                printWriter = httpservletresponse.getWriter();
            }
            throw ie;
        }
        int fileLength = (int)f.length();
        boolean willCache = this.staticFilesCache.willAddToCache(httpParameters, fileLength);
        byte[] cacheEntry = null;
        int cacheEntryOff = 0;
        if (willCache) {
            cacheEntry = new byte[fileLength];
        }
        httpservletresponse.setContentLength(fileLength);
        if (servletOutputStream != null) {
            RandomAccessFile fin = new RandomAccessFile(f, "r");
            byte[] buff = new byte[8192];
            int i = 0;
            long start = 0L;
            long finish = f.length() - 1L;
            int readed = 0;
            String s = httpservletrequest.getHeader("Range");
            int flen = (int)f.length();
            if (s != null && (s = s.toUpperCase()).indexOf("BYTES") > -1) {
                s = s.substring(s.indexOf("=") + 1).trim();
                i = s.indexOf("-");
                String s1 = s.substring(0, i);
                String s2 = s.substring(i + 1);
                if (i == 0) {
                    finish = flen - 1;
                    start = finish - (long)new Integer(s2).intValue();
                } else if (i == s.length() - 1) {
                    start = new Integer(s1).intValue();
                    finish = flen - 1;
                } else {
                    start = new Integer(s1).intValue();
                    finish = new Integer(s2).intValue();
                }
                if (finish > (long)flen) {
                    finish = flen - 1;
                }
                if (start <= finish) {
                    fin.seek(start);
                    httpservletresponse.setStatus(206);
                    httpservletresponse.setHeader("Content-Range", "bytes " + start + "-" + finish + "/" + flen);
                }
            }
            long length = (int)(finish - start + 1L);
            while (length > 0L && (readed = fin.read(buff, 0, length > (long)buff.length ? buff.length : (int)length)) != -1) {
                servletOutputStream.write(buff, 0, readed);
                if (willCache) {
                    System.arraycopy(buff, 0, cacheEntry, cacheEntryOff, i);
                    cacheEntryOff += i;
                }
                length -= (long)readed;
            }
            if (willCache) {
                boolean hasConnection = !httpParameters.getResponse().isPersistentConnection();
                this.staticFilesCache.addToCache(cacheEntry, fileName, isEncoded, f, hasConnection);
            }
            fin.close();
        } else {
            FileInputStream fin = new FileInputStream(f);
            cacheEntry = this.toWriter(fin, printWriter, willCache, cacheEntry);
            if (willCache) {
                boolean hasConnection = !httpParameters.getResponse().isPersistentConnection();
                this.staticFilesCache.addToCache(cacheEntry, fileName, isEncoded, f, hasConnection);
            }
            fin.close();
        }
    }

    private void returnDirectory(File f, String reqURI, String realPath, HostProperties desc, HttpServletRequestFacade requestUnwrapped, HttpServletResponse httpservletresponse) throws IOException {
        ArrayObject welcomeFiles = this.scf.getWebApplicationConfiguration().getWelcomeFiles();
        int i = 0;
        while (i < welcomeFiles.size()) {
            String fileName = new String((byte[])welcomeFiles.elementAt(i));
            if (new File(realPath + (realPath.endsWith(File.separator) ? "" : File.separator) + fileName).exists()) {
                httpservletresponse.sendRedirect(reqURI + fileName);
                return;
            }
            ++i;
        }
        String startPage = desc.getStartPage();
        if (startPage != null && reqURI.equals("/") && !startPage.trim().equals("") && new File(realPath + (realPath.endsWith(File.separator) ? "" : File.separator) + startPage).exists()) {
            httpservletresponse.sendRedirect(reqURI + startPage);
            return;
        }
        String[] welcome = requestUnwrapped.getHttpParameters().getHttpProperties().getInfernames();
        int i2 = 0;
        while (i2 < welcome.length) {
            if (new File(realPath + (realPath.endsWith(File.separator) ? "" : File.separator) + welcome[i2]).exists()) {
                httpservletresponse.sendRedirect(reqURI + welcome[i2]);
                return;
            }
            ++i2;
        }
        if (!desc.isList()) {
            httpservletresponse.sendError(403, "You are not authorized to view the content of the requested directory.");
            return;
        }
        ServletOutputStream servletOutputStream = null;
        PrintWriter printWriter = null;
        try {
            servletOutputStream = httpservletresponse.getOutputStream();
        }
        catch (IllegalStateException ie) {
            printWriter = httpservletresponse.getWriter();
        }
        this.listDirectory(f, servletOutputStream, printWriter, requestUnwrapped);
    }

    private void listDirectory(File file, ServletOutputStream outStream, PrintWriter printWriter, HttpServletRequestFacade requestUnwrapped) throws IOException {
        HttpParameters request = requestUnwrapped.getHttpParameters();
        File[] files = file.listFiles();
        boolean flag = false;
        if (request.getRequestPathMappings().getAliasName() != null) {
            String pth = request.getHostProperties().getAliasValue(request.getRequestPathMappings().getAliasName().toString());
            if (pth != null && pth.equals(file.toString().replace(File.separatorChar, '/'))) {
                flag = true;
            }
        } else if (request.getHostProperties().getRootDir().equals(file.toString().replace(File.separatorChar, '/'))) {
            flag = true;
        }
        String parrentDirectory = requestUnwrapped.getRequestURI();
        byte[] tmpBytes = Responses.getDirectoryHead((byte[])SBasic.version, (String)requestUnwrapped.getRequestURI(), flag ? null : parrentDirectory.substring(0, parrentDirectory.substring(0, parrentDirectory.length() - 1).lastIndexOf(47) + 1));
        this.writeDirectoryList(outStream, printWriter, tmpBytes);
        int i = 0;
        while (i < files.length) {
            if (!flag || !files[i].getName().equalsIgnoreCase("META-INF") && !files[i].getName().equalsIgnoreCase("WEB-INF")) {
                int size;
                byte[] dateArr = new byte[17];
                listFormat.getDate(dateArr, 0, files[i].lastModified());
                tmpBytes = files[i].isDirectory() ? Responses.getDirectoryLine((String)files[i].getName(), (String)new String(dateArr)) : ((size = (int)files[i].length()) == 0 ? Responses.getFileLine((String)files[i].getName(), (String)Responses.getZero(), (String)new String(dateArr)) : (size < 1024 ? Responses.getFileLine((String)files[i].getName(), (String)(size / 100 > 0 ? "0." + size / 100 : "0.1"), (String)new String(dateArr)) : Responses.getFileLine((String)files[i].getName(), (String)("" + (size /= 1024)), (String)new String(dateArr))));
                this.writeDirectoryList(outStream, printWriter, tmpBytes);
            }
            ++i;
        }
        this.writeDirectoryList(outStream, printWriter, Responses.getTableEnd());
    }

    private byte[] toWriter(FileInputStream fileInputStream, PrintWriter writer, boolean willCache, byte[] cacheEntry) throws IOException {
        InputStreamReader reader = new InputStreamReader(fileInputStream);
        int cacheEntryOff = 0;
        try {
            char[] buffer = new char[4096];
            int len = buffer.length;
            while ((len = reader.read(buffer)) != -1) {
                if (willCache) {
                    System.arraycopy(buffer, 0, cacheEntry, cacheEntryOff, len);
                    cacheEntryOff += len;
                }
                writer.write(buffer, 0, len);
                writer.flush();
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                reader.close();
            }
            catch (IOException t) {
                Log.getCategory(2).logError(this.currentLocation, "Cannot close a file input stream.", t, "");
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException t) {
            Log.getCategory(2).logError(this.currentLocation, "Cannot close a file input stream.", t, "");
        }
        return cacheEntry;
    }

    private void writeDirectoryList(ServletOutputStream outStream, PrintWriter printWriter, byte[] messByte) throws IOException {
        if (outStream != null) {
            outStream.write(messByte);
            outStream.flush();
        } else {
            printWriter.write(new String(messByte));
            printWriter.flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

