/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security.policy;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.services.servlets_jsp.server.SBasic;

public class SecuritySessionWrapper {
    private static int securityObjectId = -1;
    private SecuritySession securitySession = null;
    private ArrayObject httpSessions = new ArrayObject(2, 2);

    protected SecuritySessionWrapper() {
        SecurityContextObject security = SecuritySessionWrapper.getSecurityContext();
        this.securitySession = security.getSession();
    }

    protected SecuritySessionWrapper(SecuritySession securitySession) {
        this.securitySession = securitySession;
    }

    public String getUserName() {
        return this.securitySession.getPrincipal().getName();
    }

    public void joinThread() {
        SecurityContextObject security = SecuritySessionWrapper.getSecurityContext();
        security.setSession(this.securitySession);
    }

    public static SecuritySessionWrapper getSecuritySessionIfAny() {
        SecuritySession securitySession = null;
        SecurityContextObject security = SecuritySessionWrapper.getSecurityContext();
        if (security != null && !security.isAuthenticationPending()) {
            securitySession = security.getSession();
        }
        if (securitySession == null || securitySession.getAuthenticationConfiguration() == null) {
            return null;
        }
        return new SecuritySessionWrapper(securitySession);
    }

    public void registerListener(SessionListener sessionListener) {
        if (!this.httpSessions.contains(sessionListener)) {
            this.httpSessions.add(sessionListener);
            this.securitySession.registerListener(sessionListener);
        }
    }

    public void unregisterListener(SessionListener sessionListener) {
        if (this.httpSessions.contains(sessionListener)) {
            this.httpSessions.remove(sessionListener);
            this.securitySession.unregisterListener(sessionListener);
        }
    }

    public boolean isExpired() {
        return this.httpSessions.size() == 0;
    }

    public void logout() {
        this.securitySession.setExpirationPeriod(0L);
    }

    private static SecurityContextObject getSecurityContext() {
        ThreadContext localTC = SBasic.threadSystem.getThreadContext();
        if (securityObjectId == -1) {
            securityObjectId = localTC.getContextObjectId("security");
        }
        return (SecurityContextObject)((Object)localTC.getContextObject(securityObjectId));
    }
}

