/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PrivilegedActionImpl
implements PrivilegedExceptionAction {
    private static final int INIT = 0;
    private static final int SERVICE = 1;
    private static final int DESTROY = 2;
    private Servlet srv = null;
    private ServletRequest sreq = null;
    private ServletResponse sres = null;
    private boolean isSynchronized;
    private ServletConfig servletConfig = null;
    private int type = 1;

    public PrivilegedActionImpl(Servlet srv, ServletRequest sreq, ServletResponse sres, boolean isSynchronized) {
        this.srv = srv;
        this.sreq = sreq;
        this.sres = sres;
        this.isSynchronized = isSynchronized;
        this.type = 1;
    }

    public PrivilegedActionImpl(Servlet srv, ServletConfig sci) {
        this.srv = srv;
        this.servletConfig = sci;
        this.type = 0;
    }

    public PrivilegedActionImpl(Servlet srv) {
        this.srv = srv;
        this.type = 2;
    }

    public Object run() throws ServletException, IOException {
        switch (this.type) {
            case 0: {
                this.srv.init(this.servletConfig);
                break;
            }
            case 1: {
                if (this.isSynchronized) {
                    Servlet servlet = this.srv;
                    synchronized (servlet) {
                        this.srv.service(this.sreq, this.sres);
                        break;
                    }
                }
                this.srv.service(this.sreq, this.sres);
                break;
            }
            case 2: {
                this.srv.destroy();
            }
        }
        return null;
    }
}

