/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.security;

import com.sap.engine.services.httpserver.interfaces.ErrorData;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.servlets_jsp.security.HttpRequestClientInfo;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.security.HttpRequestClientInfoImpl;
import com.sap.engine.services.servlets_jsp.server.security.OriginalRequestClientInfoImpl;
import java.io.IOException;

public class ChangePasswordModule {
    private static final String sap_j_security_check_original_request = "sap_j_security_check_original_request";
    private static final String sap_j_security_check = "sap_j_security_check";
    private static final String j_sap_current_password = "j_sap_current_password";
    private static final String j_sap_password = "j_sap_password";
    private static final String passwordChangeNoNeed = "Request for changing user password can't be accomplished.";
    private String loginPageURL = "/ChangePassword";
    private String errorPageURL = "/ChangePassword?error=true";
    private ApplicationSession session = null;

    public void prepareChangePassword(HttpRequestClientInfoImpl clientInfo, HttpParameters httpParameters, ApplicationContext scf) {
        ApplicationSession applicationSession = (ApplicationSession)httpParameters.getApplicationSession();
        if (applicationSession == null) {
            applicationSession = scf.getSessionServletContext().createSession(httpParameters);
        }
        this.initPages(httpParameters, applicationSession, scf);
        OriginalRequestClientInfoImpl originalRequest = new OriginalRequestClientInfoImpl(clientInfo, scf.getSessionServletContext());
        applicationSession.putSecurityValue(sap_j_security_check, scf.getSessionServletContext().encodeURL(httpParameters.getRequest().getRequestLine().getFullUrl().toString(), httpParameters.getRequestPathMappings().getAliasName(), httpParameters, applicationSession));
        applicationSession.putSecurityValue(sap_j_security_check_original_request, originalRequest);
    }

    public HttpRequestClientInfo willChangePasswordRequest(HttpRequestClientInfoImpl newClientInfo, HttpParameters httpParameters, ApplicationContext scf) throws IOException {
        ApplicationSession session = (ApplicationSession)httpParameters.getApplicationSession();
        if (session == null) {
            httpParameters.setErrorData(new ErrorData(403, passwordChangeNoNeed, "The server hasn't forced you to change your password or the session is lost."));
            return null;
        }
        OriginalRequestClientInfoImpl originalRequest = (OriginalRequestClientInfoImpl)session.getSecurityValue(sap_j_security_check_original_request);
        if (originalRequest == null) {
            httpParameters.setErrorData(new ErrorData(403, passwordChangeNoNeed, "The server hasn't forced you to change your password or the session is lost."));
            return null;
        }
        this.session = session;
        this.initPages(httpParameters, session, scf);
        String pass = newClientInfo.getParameter(j_sap_password);
        if (pass != null) {
            originalRequest.setNewPassword(pass.toCharArray());
            pass = newClientInfo.getParameter(j_sap_current_password);
            originalRequest.setPassword(pass.toCharArray());
        }
        originalRequest.setNewRequest(newClientInfo);
        return originalRequest;
    }

    public String getErrorPage() {
        return this.errorPageURL;
    }

    public String getLoginPage() {
        return this.loginPageURL;
    }

    public String getURL() {
        String url = (String)this.session.removeSecurityValue(sap_j_security_check);
        this.session.removeSecurityValue(sap_j_security_check_original_request);
        return url;
    }

    private void initPages(HttpParameters httpParameters, ApplicationSession applicationSession, ApplicationContext scf) {
        String alias = httpParameters.getRequestPathMappings().getAliasName().toString();
        if (httpParameters.getRequestPathMappings().getZoneName() != null && !httpParameters.getRequestPathMappings().isZoneExactAlias()) {
            alias = alias + httpParameters.getHttpProperties().getZoneSeparator() + httpParameters.getRequestPathMappings().getZoneName();
        }
        this.loginPageURL = "/" + alias + this.loginPageURL;
        this.errorPageURL = "/" + alias + this.errorPageURL;
        this.loginPageURL = scf.getSessionServletContext().getChangePasswordLoginPage() != null ? "/" + alias + "/" + scf.getSessionServletContext().getChangePasswordLoginPage() : "/" + alias + this.loginPageURL;
        this.errorPageURL = scf.getSessionServletContext().getChangePasswordErrorPage() != null ? "/" + alias + "/" + scf.getSessionServletContext().getChangePasswordErrorPage() : "/" + alias + this.errorPageURL;
        this.errorPageURL = scf.getSessionServletContext().encodeURL(this.errorPageURL, httpParameters.getRequestPathMappings().getAliasName(), httpParameters, applicationSession);
        this.loginPageURL = scf.getSessionServletContext().encodeURL(this.loginPageURL, httpParameters.getRequestPathMappings().getAliasName(), httpParameters, applicationSession);
    }
}

