/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.context;

import com.sap.engine.interfaces.webservices.server.management.WSClientReferencedStructure;
import com.sap.engine.interfaces.webservices.server.management.exception.WSBaseException;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.lib.util.HashMapObjectObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.httpserver.lib.ResponseCodes;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.util.SortUtils;
import com.sap.engine.services.servlets_jsp.descriptor.CookieConfig;
import com.sap.engine.services.servlets_jsp.descriptor.ErrorPage;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.MIMEMapping;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletMapping;
import com.sap.engine.services.servlets_jsp.descriptor.TagLib;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.descriptor.xml.AdditionalWebDescrDocument;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebResourceAccessor;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebWarningException;
import com.sap.engine.services.servlets_jsp.server.lib.StringUtils;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.InitialDirContext;
import org.omg.CORBA.ORB;
import org.w3c.dom.Document;

public class WebApplicationConfig {
    private ApplicationContext servletContextFacade = null;
    private String displayName = null;
    private FilterDescriptor[] filters = null;
    private String[] listeners = null;
    private ErrorPage[] errorPages = null;
    private String domainName = null;
    private LoginConfig loginConfig = null;
    private ComponentReference[] componentRefs = null;
    private EJBeanLocalReference[] ejbLocalRefs = null;
    private EJBeanReference[] ejbRefs = null;
    private SecurityRoles[] secRoles = null;
    private SecurityConstraints[] secConstraints = null;
    private HashMapIntObject responseCodeToMessage = new HashMapIntObject();
    private String changePasswordLoginPage = null;
    private String changePasswordErrorPage = null;
    private final ArrayObject welcomeFiles = new ArrayObject();
    private boolean urlSessionTracking = false;
    private int failOverAlertTimeout = -1;
    private byte[] failOverAlertMessage = null;
    private int sessionTimeout = -1;
    private int maxSessions = -1;
    private boolean getRequestURLClientMode = false;
    private TagLib[] tagLibs = null;
    private HashMapObjectObject servletArgs = new HashMapObjectObject();
    private HashMapObjectObject servletClasses = new HashMapObjectObject();
    private HashMapObjectObject servletToRoles = new HashMapObjectObject();
    private HashMapObjectObject servletRunAs = new HashMapObjectObject();
    private String[][] all = null;
    private String failOverEnableFromDescriptor = "disable";
    private int failOverEnableIntFromDescriptor = 0;
    private WebCookieConfig sessionCookieConfig = null;
    private WebCookieConfig applicationCookieConfig = null;
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebApplicationConfig == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebApplicationConfig = WebApplicationConfig.class$("com.sap.engine.services.servlets_jsp.server.runtime.context.WebApplicationConfig")) : class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebApplicationConfig));
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$context$WebApplicationConfig;

    public WebApplicationConfig(ApplicationContext servletContextFacade) {
        this.servletContextFacade = servletContextFacade;
        this.sessionCookieConfig = new WebCookieConfig(servletContextFacade.getAliasName(), 2);
        this.applicationCookieConfig = new WebCookieConfig(servletContextFacade.getAliasName(), 3);
    }

    public void parse(InputStream xmlFile, InputStream additonalXmlFile, Vector warnings, boolean isGlobal) throws DeploymentException {
        WebDeploymentDescriptor webDesc = null;
        webDesc = isGlobal ? this.loadXml(xmlFile, additonalXmlFile, "global-web.xml", "web-j2ee-engine.xml") : this.loadXml(xmlFile, additonalXmlFile, "web.xml", "web-j2ee-engine.xml");
        Context subContext = this.createNamingContexts();
        this.bindEJBReferences(webDesc, isGlobal, subContext, warnings);
        this.bindServiceReferneces(webDesc.getServerComponentRefs(), subContext, isGlobal);
        this.bindEnvEntries(webDesc, subContext);
        this.bindResourceReferences(webDesc, subContext);
        this.bindResourceEnvReferences(webDesc, subContext);
        if (!isGlobal) {
            this.bindWebServicesReferences(subContext);
        }
        try {
            this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/ORB", ORB.init((String[])new String[0], null));
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot bind ORB.", e, this.servletContextFacade.getAliasName());
        }
        if (webDesc.getDisplayName() != null) {
            this.displayName = webDesc.getDisplayName();
        }
        this.urlSessionTracking = webDesc.getURLSessionTracking();
        this.maxSessions = webDesc.getMaxSessions();
        this.initServletContextParams(webDesc);
        this.initResponseCodes(webDesc);
        this.initWelcomeFiles(webDesc);
        this.initTagLibs(webDesc);
        this.initFilters(webDesc);
        this.initListeners(webDesc);
        this.initErrorPages(webDesc);
        this.initMimeMappings(webDesc);
        this.initSessionTimeout(webDesc);
        if (webDesc.getLoginConfig() != null) {
            this.loginConfig = webDesc.getLoginConfig();
        }
        if (webDesc.getSecurityPolicyDomain() != null) {
            this.domainName = webDesc.getSecurityPolicyDomain();
        }
        if (this.domainName == null || this.domainName.length() == 0) {
            this.domainName = this.servletContextFacade.getAliasName();
            this.domainName = this.domainName.replace('/', '*').replace('\\', '*');
        }
        this.initPasswordChangePages(webDesc);
        this.initSecurityRoles(webDesc);
        this.initSecurityConstraints(webDesc);
        this.initProtectedAreas(isGlobal);
        this.servletContextFacade.getWebMappings().addFilterMapping(webDesc.getFilterMappings());
        this.initServletMappings(webDesc);
        this.initServlets(webDesc);
        this.initFailOver(webDesc);
        this.initCookieConfigs(webDesc.getCookieConfig());
        this.initGetRequestURLMode(webDesc.getGetRequestURLMode());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[][] getAllServlets() {
        return this.all;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public HashMapObjectObject getServletArguments() {
        return this.servletArgs;
    }

    public HashMapObjectObject getServletClasses() {
        return this.servletClasses;
    }

    public HashMapObjectObject getServletRoles(String servletName) {
        return (HashMapObjectObject)this.servletToRoles.get(servletName);
    }

    public String getRunAsRoleName(String servletName) {
        return (String)this.servletRunAs.get(servletName);
    }

    public ArrayObject getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.secRoles;
    }

    public SecurityConstraints[] getSecurityConstraints() {
        return this.secConstraints;
    }

    public String getChangePasswordLoginPage() {
        return this.changePasswordLoginPage;
    }

    public String getChangePasswordErrorPage() {
        return this.changePasswordErrorPage;
    }

    public boolean isURLSessionTracking() {
        return this.urlSessionTracking;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public int getFailOverAlertTimeout() {
        return this.failOverAlertTimeout;
    }

    public byte[] getFailOverAlertMessage() {
        return this.failOverAlertMessage;
    }

    public WebCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public WebCookieConfig getApplicationCookieConfig() {
        return this.applicationCookieConfig;
    }

    public TagLib[] getTagLibs() {
        return this.tagLibs;
    }

    public FilterDescriptor[] getFilters() {
        return this.filters;
    }

    public String[] getListeners() {
        return this.listeners;
    }

    public ErrorPage[] getErrorPages() {
        return this.errorPages;
    }

    public String getFailOverEnable() {
        return this.failOverEnableFromDescriptor;
    }

    public int getFailOverEnableInt() {
        return this.failOverEnableIntFromDescriptor;
    }

    public boolean getRequestURLClientMode() {
        return this.getRequestURLClientMode;
    }

    protected void setFailOverEnable(String failover) {
        this.failOverEnableFromDescriptor = failover;
        if ("disable".equals(failover)) {
            this.failOverEnableIntFromDescriptor = 0;
        } else if ("on_request".equals(failover)) {
            this.failOverEnableIntFromDescriptor = 1;
        } else if ("on_attribute".equals(failover)) {
            this.failOverEnableIntFromDescriptor = 2;
        }
    }

    private void bindServiceReferneces(ComponentReference[] newComponentRefs, Context subContext, boolean isGlobal) {
        if (this.componentRefs == null) {
            this.componentRefs = newComponentRefs;
        } else {
            Vector<ComponentReference> componentRefsVector = new Vector<ComponentReference>(this.componentRefs.length + newComponentRefs.length);
            int i = 0;
            while (i < this.componentRefs.length) {
                componentRefsVector.add(this.componentRefs[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < newComponentRefs.length) {
                componentRefsVector.add(newComponentRefs[i2]);
                ++i2;
            }
            ComponentReference[] returnComponentRefs = new ComponentReference[componentRefsVector.size()];
            int i3 = 0;
            while (i3 < componentRefsVector.size()) {
                returnComponentRefs[i3] = (ComponentReference)componentRefsVector.elementAt(i3);
                ++i3;
            }
            this.componentRefs = returnComponentRefs;
        }
        if (this.componentRefs != null && !isGlobal) {
            int k = 0;
            while (k < this.componentRefs.length) {
                try {
                    this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + this.componentRefs[k].getName(), new Reference(this.componentRefs[k].getJndiName(), "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
                }
                catch (NamingException e) {
                    Log.getCategory(1).logError(this.currentLocation, "Cannot bind component reference <" + this.componentRefs[k].getName() + ">.", e, this.servletContextFacade.getAliasName());
                }
                ++k;
            }
        }
    }

    private void bindEnvEntries(WebDeploymentDescriptor webDesc, Context subContext) {
        EnvironmentEntry[] envEntry = webDesc.getEnvEntries();
        if (envEntry != null) {
            int i = 0;
            while (i < envEntry.length) {
                try {
                    if (envEntry[i].getEntryValue() != null) {
                        this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + envEntry[i].getEntryName(), envEntry[i].getEntryValue());
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.getCategory(1).logError(this.currentLocation, "Error in binding the environment entry " + envEntry[i].getEntryName() + ".", e, this.servletContextFacade.getAliasName());
                }
                ++i;
            }
        }
        try {
            this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/UserTransaction", new Reference("UserTransaction", "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot bind UserTransaction.", e, this.servletContextFacade.getAliasName());
        }
    }

    private void bindResourceReferences(WebDeploymentDescriptor webDesc, Context subContext) {
        ResourceReference[] resources = webDesc.getResReferences();
        if (resources != null) {
            String resourceType = null;
            String resourceName = null;
            int k = 0;
            while (k < resources.length) {
                resourceType = resources[k].getResourceType();
                resourceName = resources[k].getResourceLink();
                if (resourceName == null) {
                    resourceName = resources[k].getResourceName();
                }
                if (resourceType.equals("javax.sql.DataSource") || resourceType.equals("javax.jms.QueueConnectionFactory") || resourceType.equals("javax.jms.TopicConnectionFactory") || resourceType.equals("javax.resource.cci.ConnectionFactory")) {
                    Reference ref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
                    ref.add(new StringRefAddr("res-type", resourceType));
                    ref.add(new StringRefAddr("res-name", resourceName));
                    if (resources[k].getResourceAuthorization() == 2) {
                        ref.add(new StringRefAddr("res-auth", "Container"));
                    } else {
                        ref.add(new StringRefAddr("res-auth", "Application"));
                    }
                    if (resources[k].getResourceSharingScope() == 1) {
                        ref.add(new StringRefAddr("sharing-scope", "Unshareable"));
                    } else {
                        ref.add(new StringRefAddr("sharing-scope", "Shareable"));
                    }
                    if (!resources[k].isTransactional()) {
                        ref.add(new StringRefAddr("tx-support", "false"));
                    }
                    try {
                        this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + resources[k].getResourceName(), ref);
                    }
                    catch (NamingException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Cannot bind resource " + resources[k].getResourceName() + ".", e, this.servletContextFacade.getAliasName());
                    }
                } else if (resourceType.equals("javax.mail.Session")) {
                    try {
                        this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + resources[k].getResourceName(), new Reference("java:comp/env/mail/MailSession", "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
                    }
                    catch (NamingException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Cannot bind resource " + resources[k].getResourceName() + ".", e, this.servletContextFacade.getAliasName());
                    }
                } else if (resourceType.equals("java.net.URL")) {
                    try {
                        this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + resources[k].getResourceName(), new URL(resources[k].getResourceLink()));
                    }
                    catch (MalformedURLException muex) {
                        Log.getCategory(1).logError(this.currentLocation, "Error while binding resource " + resources[k].getResourceName(), muex, this.servletContextFacade.getAliasName());
                        this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.RESOURCE_IN_WEB_APPLICATION_WILL_NOT_BE_USED_REASON_IS, new Object[]{resources[k].getResourceName(), this.servletContextFacade.getAliasName(), muex.toString()}).toString());
                    }
                    catch (NamingException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Cannot bind resource " + resources[k].getResourceName() + ".", e, this.servletContextFacade.getAliasName());
                    }
                } else {
                    this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNRECOGNIZED_RESOURCETYPE_IN_WEB_APPLICATION_IT_WILL_BE_IGNORED, new Object[]{resourceType, this.servletContextFacade.getAliasName()}).toString());
                }
                ++k;
            }
        }
    }

    private void bindResourceEnvReferences(WebDeploymentDescriptor webDesc, Context subContext) {
        ResourceEnvReference[] resourcesEnv = webDesc.getResEnvReferences();
        if (resourcesEnv != null) {
            String resourceEnvType = null;
            String jndiName = null;
            int k = 0;
            while (k < resourcesEnv.length) {
                resourceEnvType = resourcesEnv[k].getType();
                jndiName = resourcesEnv[k].getJndiName();
                if (jndiName == null) {
                    jndiName = resourcesEnv[k].getName();
                }
                if (resourceEnvType.equals("javax.jms.Queue")) {
                    jndiName = "jmsQueues/" + jndiName;
                } else if (resourceEnvType.equals("javax.jms.Topic")) {
                    jndiName = "jmsTopics/" + jndiName;
                } else {
                    this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.UNRECOGNIZED_RESOURCEENVTYPE_IN_WEB_APPLICATION_IT_WILL_BE_IGNORED, new Object[]{resourceEnvType, this.servletContextFacade.getAliasName()}).toString());
                }
                try {
                    this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + resourcesEnv[k].getName(), new Reference(jndiName, "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
                }
                catch (NamingException e) {
                    Log.getCategory(1).logError(this.currentLocation, "Cannot bind environment resource " + resourcesEnv[k].getName() + ".", e, this.servletContextFacade.getAliasName());
                }
                ++k;
            }
        }
    }

    private void bind(Context root, String name, Object obj) throws NamingException {
        String s;
        Context ic = root;
        Context current = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                current = (Context)ic.lookup(s);
            }
            catch (Exception e) {
                try {
                    current = ic.createSubcontext(s);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)ic.lookup(s);
                }
            }
            ic = current;
        }
        ic.rebind("+/" + s, obj);
    }

    private void createSubcontext(Context root, String name) throws NamingException {
        Context current = root;
        String temp = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            try {
                current = (Context)current.lookup(temp);
            }
            catch (NamingException ne) {
                try {
                    current = current.createSubcontext(temp);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)current.lookup(temp);
                }
            }
        }
    }

    private void initProtectedAreas(boolean isGlobal) {
        if (isGlobal) {
            return;
        }
        if (this.secConstraints == null) {
            return;
        }
        Vector<SecurityConstraints> vectorSecConstraints = new Vector<SecurityConstraints>();
        int exactPathIndex = 0;
        boolean defaultMapping = false;
        int i = 0;
        while (i < this.secConstraints.length) {
            WebResourceCollection[] webCollection = this.secConstraints[i].getWebResourceCollections();
            int j = 0;
            while (j < webCollection.length) {
                String[] urlPattern = webCollection[j].getUrlPattern();
                int k = 0;
                while (k < urlPattern.length) {
                    SecurityConstraints newSecConstraints = new SecurityConstraints();
                    WebResourceCollection newWebCollection = new WebResourceCollection();
                    newWebCollection.setWebResourceName(webCollection[j].getWebResourceName());
                    newWebCollection.setDescription(webCollection[j].getDescription());
                    newWebCollection.setHttpMethod(webCollection[j].getHttpMethod());
                    try {
                        urlPattern[k] = WebApplicationConfig.canonicalizeMapping(urlPattern[k], this.servletContextFacade);
                    }
                    catch (DeploymentException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Error during canonicalize mapping ", (Throwable)((Object)e), this.servletContextFacade.getAliasName());
                        this.servletContextFacade.addWarning(e.getMessage());
                    }
                    if (!(urlPattern[k].startsWith("*.") || this.servletContextFacade.isDefault() || urlPattern[k].startsWith("/"))) {
                        urlPattern[k] = "/".concat(urlPattern[k]);
                    }
                    newWebCollection.addUrlPattern(urlPattern[k]);
                    newSecConstraints.setAuthorityConstraints(this.secConstraints[i].getAuthConstraints());
                    newSecConstraints.setUserDataConstraints(this.secConstraints[i].getUserConstr());
                    newSecConstraints.setWebCollections(new WebResourceCollection[]{newWebCollection});
                    String pattern = newSecConstraints.getWebResourceCollections()[0].getUrlPattern()[0];
                    if (pattern.equals("/" + this.servletContextFacade.getAliasName() + "/")) {
                        defaultMapping = true;
                        vectorSecConstraints.add(newSecConstraints);
                    } else if (pattern.indexOf("*") == -1) {
                        vectorSecConstraints.add(exactPathIndex++, newSecConstraints);
                    } else if (pattern.endsWith("/*")) {
                        int tempIndex = -1;
                        tempIndex = exactPathIndex;
                        while (tempIndex < vectorSecConstraints.size()) {
                            String tempUrl = ((SecurityConstraints)vectorSecConstraints.get(tempIndex)).getWebResourceCollections()[0].getUrlPattern()[0];
                            if (tempUrl.compareTo(pattern) < 0) break;
                            ++tempIndex;
                        }
                        vectorSecConstraints.add(tempIndex, newSecConstraints);
                    } else if (defaultMapping) {
                        vectorSecConstraints.add(vectorSecConstraints.size() - 1, newSecConstraints);
                    } else {
                        vectorSecConstraints.add(newSecConstraints);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.secConstraints = new SecurityConstraints[vectorSecConstraints.size()];
        int i2 = 0;
        while (i2 < vectorSecConstraints.size()) {
            this.secConstraints[i2] = (SecurityConstraints)vectorSecConstraints.elementAt(i2);
            ++i2;
        }
    }

    private static String canonicalizeMapping(String urlPattern, ApplicationContext servletContextFacade) throws DeploymentException {
        if (urlPattern.indexOf("*.") != -1 || urlPattern.equals("/")) {
            return urlPattern;
        }
        String result = null;
        StringTokenizer pathCanonize = new StringTokenizer(urlPattern, "/");
        while (pathCanonize.hasMoreTokens()) {
            String token = pathCanonize.nextToken();
            if (token.equals("..")) {
                if (result == null || result.equals("")) {
                    throw new WebDeploymentException(WebDeploymentException.INVALID_URL_PATTERN_IN_DEPLOYMENT_DESCRIPTOR_FOR_WEBAPPLICATION, new Object[]{urlPattern, servletContextFacade.getAliasName()});
                }
                result = result.substring(0, result.lastIndexOf("/"));
                continue;
            }
            if (token.equals(".")) continue;
            result = result == null ? "/" + token : result + "/" + token;
        }
        return result;
    }

    private WebDeploymentDescriptor loadXml(InputStream xmlFile, InputStream additonalXmlFile, String xmlFileName, String additonalXmlFileName) throws WebDeploymentException {
        Document parsed;
        StandardDOMParser parser;
        WebDeploymentDescriptor webDesc = null;
        try {
            WebDescriptorDocument doc = new WebDescriptorDocument();
            parser = new StandardDOMParser();
            if (SBasic.webContainerProperties.validateDescriptors()) {
                parser.setValidation(true);
            } else {
                parser.setValidation(false);
                parser.setReadDTD(false);
            }
            parsed = parser.parse(xmlFile);
            webDesc = doc.loadDescriptorFromDocument(parsed);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(1).logError(this.currentLocation, "Error in parsing " + xmlFileName + "!", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_READ_XML_OR_ERROR_IN_XML_FOR_WEB_APPLICATION, new Object[]{xmlFileName, this.servletContextFacade.getAliasName()}, e);
        }
        if (additonalXmlFile != null) {
            try {
                AdditionalWebDescrDocument addDoc = new AdditionalWebDescrDocument();
                parser = new StandardDOMParser();
                if (SBasic.webContainerProperties.validateDescriptors()) {
                    parser.setValidation(true);
                } else {
                    parser.setValidation(false);
                    parser.setReadDTD(false);
                }
                parsed = parser.parse(additonalXmlFile);
                addDoc.loadDescriptorFromDocument(parsed, webDesc);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                Log.getCategory(1).logError(this.currentLocation, "Parsing " + additonalXmlFileName + " of " + this.servletContextFacade.getAliasName() + " web application in non-validation mode failed!", e, this.servletContextFacade.getAliasName());
                throw new WebDeploymentException(WebDeploymentException.CANNOT_READ_XML_OR_ERROR_IN_XML_FOR_WEB_APPLICATION, new Object[]{additonalXmlFileName, this.servletContextFacade.getAliasName()}, e);
            }
        }
        Thread.currentThread().setContextClassLoader(this.servletContextFacade.getClassLoader());
        if (webDesc == null) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_LOAD_DESCRIPTOR_FOR_WEBXML_FOR_WEB_APPLICATION, new Object[]{this.servletContextFacade.getAliasName()});
        }
        return webDesc;
    }

    private Context createNamingContexts() throws WebDeploymentException {
        InitialDirContext ctx = null;
        Properties props = new Properties();
        ((Hashtable)props).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)props).put("Replicate", "false");
        ((Hashtable)props).put("domain", "true");
        try {
            ctx = new InitialDirContext(props);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            Log.getCategory(4).logError(this.currentLocation, "Can't create a naming context.", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
        }
        Context subContext = null;
        try {
            subContext = (Context)ctx.lookup("webContainer/applications");
        }
        catch (NamingException nex) {
            try {
                try {
                    subContext = ctx.createSubcontext("/webContainer/applications");
                }
                catch (NameAlreadyBoundException nabe) {
                    subContext = (Context)ctx.lookup("webContainer/applications");
                }
            }
            catch (NamingException e) {
                Log.getCategory(1).logError(this.currentLocation, "Cannot create the root context for the web applications.", e, this.servletContextFacade.getAliasName());
                throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
            }
        }
        try {
            try {
                ctx.lookup("webContainer/applications/" + this.servletContextFacade.getApplicationName());
            }
            catch (NameNotFoundException nex) {
                this.createSubcontext(subContext, this.servletContextFacade.getApplicationName());
            }
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot create the root context of the application " + this.servletContextFacade.getAliasName() + ".", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
        }
        try {
            subContext = (Context)ctx.lookup("webContainer/applications/" + this.servletContextFacade.getApplicationName());
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot create the root context of the application " + this.servletContextFacade.getApplicationName() + ".", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
        }
        try {
            this.createSubcontext(subContext, this.servletContextFacade.getAliasForDirectory());
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot create the root context of the application " + this.servletContextFacade.getAliasName() + ".", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
        }
        try {
            this.createSubcontext(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env");
        }
        catch (NamingException e) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot create java:comp/env context of the application " + this.servletContextFacade.getAliasName() + ".", e, this.servletContextFacade.getAliasName());
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_NAMING_CONTEXT_ORBIND);
        }
        return subContext;
    }

    private void initFailOver(WebDeploymentDescriptor webDesc) {
        if (webDesc.getFailOverMessage() != null) {
            this.failOverAlertMessage = ("<HEAD>\n  <SCRIPT LANGUAGE=JavaScript>\n      <!--Begin Cloaking\n        var ExtraWindow\n        function LaunchWindow(name) {\n          ExtraWindow = window.open(\"warning.html\", name, 'width=300', 'height=200')\n        }\n        function KillWindow(name) {\n          ExtraWindow.close()\n        }\n      -->\n  </SCRIPT>\n</HEAD>\n<BODY ONLOAD=\"window.alert('" + StringUtils.escapeJavaCharacters(webDesc.getFailOverMessage()) + "')\">\n</BODY>\n").getBytes();
        }
        if (webDesc.getFailOverMessageTimeout() != -1) {
            this.failOverAlertTimeout = webDesc.getFailOverMessageTimeout();
        }
    }

    private void initResponseCodes(WebDeploymentDescriptor webDesc) {
        HashMapIntObject responseCodeToMessageTemp = webDesc.getResponseStatus();
        if (responseCodeToMessageTemp != null) {
            int[] keys = responseCodeToMessageTemp.getAllKeys();
            int i = 0;
            while (i < keys.length) {
                this.responseCodeToMessage.put(keys[i], responseCodeToMessageTemp.get(keys[i]));
                ++i;
            }
            ResponseCodes.setClientMessages((String)this.servletContextFacade.getAliasName(), (HashMapIntObject)this.responseCodeToMessage);
        }
    }

    private void initWelcomeFiles(WebDeploymentDescriptor webDesc) {
        String[] welcomeFile = webDesc.getWelcomeFileList();
        if (welcomeFile != null) {
            int i = 0;
            while (i < welcomeFile.length) {
                if (welcomeFile[i] != null) {
                    this.welcomeFiles.addElement(welcomeFile[i].trim().getBytes());
                }
                ++i;
            }
        }
    }

    private void initTagLibs(WebDeploymentDescriptor webDesc) {
        if (this.tagLibs == null) {
            this.tagLibs = webDesc.getTagLib();
        } else if (webDesc.getTagLib() != null) {
            TagLib[] tagLibsTmp = new TagLib[webDesc.getTagLib().length + this.tagLibs.length];
            System.arraycopy(this.tagLibs, 0, tagLibsTmp, 0, this.tagLibs.length);
            System.arraycopy(webDesc.getTagLib(), 0, tagLibsTmp, this.tagLibs.length, webDesc.getTagLib().length);
        }
    }

    private void initFilters(WebDeploymentDescriptor webDesc) {
        if (this.filters == null) {
            this.filters = webDesc.getFilters();
        } else if (webDesc.getFilters() != null) {
            FilterDescriptor[] filtersTmp = new FilterDescriptor[webDesc.getFilters().length + this.filters.length];
            System.arraycopy(this.filters, 0, filtersTmp, 0, this.filters.length);
            System.arraycopy(webDesc.getFilters(), 0, filtersTmp, this.filters.length, webDesc.getFilters().length);
            this.filters = new FilterDescriptor[filtersTmp.length];
            System.arraycopy(filtersTmp, 0, this.filters, 0, filtersTmp.length);
        }
    }

    private void initServlets(WebDeploymentDescriptor webDesc) {
        ServletDescriptor[] servletDesc = webDesc.getServlets();
        if (servletDesc == null) {
            return;
        }
        int i = 0;
        while (i < servletDesc.length) {
            this.initServlet(servletDesc[i]);
            ++i;
        }
        if (this.all != null) {
            String[][] newAll = new String[servletDesc.length][3];
            int i2 = 0;
            while (i2 < servletDesc.length) {
                this.initRunAs(servletDesc[i2]);
                String isJsp = servletDesc[i2].getJspFile();
                if (isJsp != null) {
                    if (!isJsp.startsWith("/")) {
                        isJsp = "/" + isJsp;
                    }
                    this.servletContextFacade.getWebComponents().addJsp(servletDesc[i2].getServletName(), isJsp);
                    newAll[i2][0] = "" + servletDesc[i2].getLoadOnStartUp();
                    newAll[i2][1] = servletDesc[i2].getServletName();
                    newAll[i2][2] = isJsp;
                } else {
                    this.servletContextFacade.getWebComponents().addServlet(servletDesc[i2].getServletName());
                    newAll[i2][0] = "" + servletDesc[i2].getLoadOnStartUp();
                    newAll[i2][1] = servletDesc[i2].getServletName();
                    newAll[i2][2] = servletDesc[i2].getServletClass();
                }
                ++i2;
            }
            String[][] oldAll = (String[][])this.all.clone();
            this.all = new String[oldAll.length + newAll.length][3];
            int i3 = 0;
            while (i3 < oldAll.length) {
                int j = 0;
                while (j < oldAll[i3].length) {
                    this.all[i3][j] = oldAll[i3][j];
                    ++j;
                }
                ++i3;
            }
            int index = oldAll.length;
            int i4 = 0;
            while (i4 < newAll.length) {
                int j = 0;
                while (j < newAll[i4].length) {
                    this.all[i4 + index][j] = newAll[i4][j];
                    ++j;
                }
                ++i4;
            }
            SortUtils.sort((String[][])this.all);
        } else {
            this.all = new String[servletDesc.length][3];
            int i5 = 0;
            while (i5 < servletDesc.length) {
                this.initRunAs(servletDesc[i5]);
                String jspFile = servletDesc[i5].getJspFile();
                if (jspFile != null) {
                    if (!jspFile.startsWith("/")) {
                        jspFile = "/" + jspFile;
                    }
                    this.servletContextFacade.getWebComponents().addJsp(servletDesc[i5].getServletName(), jspFile);
                    this.all[i5][0] = "" + servletDesc[i5].getLoadOnStartUp();
                    this.all[i5][1] = servletDesc[i5].getServletName();
                    this.all[i5][2] = jspFile;
                } else {
                    this.servletContextFacade.getWebComponents().addServlet(servletDesc[i5].getServletName());
                    this.all[i5][0] = "" + servletDesc[i5].getLoadOnStartUp();
                    this.all[i5][1] = servletDesc[i5].getServletName();
                    this.all[i5][2] = servletDesc[i5].getServletClass();
                }
                ++i5;
            }
        }
    }

    private void initServlet(ServletDescriptor servletDescriptor) {
        HashMapObjectObject tmp = new HashMapObjectObject();
        SecurityRoleReference[] roleReferences = servletDescriptor.getRoleReferences();
        if (roleReferences != null) {
            int p = 0;
            while (p < roleReferences.length) {
                if (roleReferences[p].getRoleLink() == null) {
                    Log.getCategory(1).logWarning(this.currentLocation, "Incorrect servlet tag for servlet " + servletDescriptor.getServletName() + "." + " Incorrect role refernece. Please specify a valid role link.", this.servletContextFacade.getAliasName());
                } else {
                    tmp.put(roleReferences[p].getRoleName(), roleReferences[p].getRoleLink());
                }
                ++p;
            }
        }
        if (servletDescriptor.getServletName() == null) {
            Log.getCategory(1).logWarning(this.currentLocation, "Incorrect servlet tag. Servlet name is not specified.", this.servletContextFacade.getAliasName());
            return;
        }
        this.servletToRoles.put(servletDescriptor.getServletName(), tmp);
        if (servletDescriptor.getServletClass() == null && servletDescriptor.getJspFile() == null) {
            Log.getCategory(1).logWarning(this.currentLocation, "Incorrect servlet tag for servlet " + servletDescriptor.getServletName() + "." + " Please specify class name or jsp file.", this.servletContextFacade.getAliasName());
            return;
        }
        ContextParam[] params = servletDescriptor.getInitParams();
        Hashtable<String, String> paramsH = new Hashtable<String, String>();
        if (params != null) {
            int j = 0;
            while (j < params.length) {
                if (params[j] != null) {
                    if (params[j].getParamName() == null || params[j].getParamValue() == null) {
                        Log.getCategory(1).logWarning(this.currentLocation, "Incorrect parameters of the servlet " + servletDescriptor.getServletName() + ". Parameter name or value is null.", this.servletContextFacade.getAliasName());
                    } else {
                        paramsH.put(params[j].getParamName().trim(), params[j].getParamValue().trim());
                    }
                }
                ++j;
            }
        }
        if (servletDescriptor.getServletClass() != null) {
            this.servletClasses.put(servletDescriptor.getServletName().trim(), servletDescriptor.getServletClass().trim());
            this.servletArgs.put(servletDescriptor.getServletName().trim(), paramsH);
        } else {
            this.servletArgs.put(servletDescriptor.getServletName().trim(), paramsH);
        }
    }

    private void initRunAs(ServletDescriptor servletDescriptor) {
        String name = servletDescriptor.getServletName();
        if (servletDescriptor.getRunAs() != null && this.secRoles != null) {
            String roleName = servletDescriptor.getRunAs().getSecurityRoleName();
            int m = 0;
            while (m < this.secRoles.length) {
                if (roleName.equals(this.secRoles[m].getName())) {
                    this.servletRunAs.put(name, this.secRoles[m].getName());
                    return;
                }
                ++m;
            }
            Log.getCategory(1).logWarning(this.currentLocation, "Incorrect run-as tag for servlet " + name + ". User-role is not specified.", this.servletContextFacade.getAliasName());
        }
    }

    private void initListeners(WebDeploymentDescriptor webDesc) {
        if (this.listeners == null) {
            this.listeners = webDesc.getListeners();
        } else if (webDesc.getListeners() != null) {
            String[] listenersTmp = new String[webDesc.getListeners().length + this.listeners.length];
            System.arraycopy(this.listeners, 0, listenersTmp, 0, this.listeners.length);
            System.arraycopy(webDesc.getListeners(), 0, listenersTmp, this.listeners.length, webDesc.getListeners().length);
            this.listeners = new String[listenersTmp.length];
            System.arraycopy(listenersTmp, 0, this.listeners, 0, listenersTmp.length);
        }
    }

    private void initErrorPages(WebDeploymentDescriptor webDesc) {
        if (this.errorPages == null) {
            this.errorPages = webDesc.getErrorPage();
        } else if (webDesc.getErrorPage() != null) {
            ErrorPage[] errorPagesTmp = new ErrorPage[webDesc.getErrorPage().length + this.errorPages.length];
            System.arraycopy(this.errorPages, 0, errorPagesTmp, 0, this.errorPages.length);
            System.arraycopy(webDesc.getErrorPage(), 0, errorPagesTmp, this.errorPages.length, webDesc.getErrorPage().length);
            this.errorPages = new ErrorPage[errorPagesTmp.length];
            System.arraycopy(errorPagesTmp, 0, this.errorPages, 0, errorPagesTmp.length);
        }
    }

    private void initMimeMappings(WebDeploymentDescriptor webDesc) {
        MIMEMapping[] mimeMapping = webDesc.getMIMEMapping();
        if (mimeMapping != null) {
            int i = 0;
            while (i < mimeMapping.length) {
                if (mimeMapping[i].getExtension() != null && mimeMapping[i].getMIMEType() != null) {
                    this.servletContextFacade.addMimeType(mimeMapping[i].getExtension().trim(), mimeMapping[i].getMIMEType().trim());
                }
                ++i;
            }
        }
    }

    private void initSessionTimeout(WebDeploymentDescriptor webDesc) {
        this.sessionTimeout = webDesc.getSessionTimeout();
        this.sessionTimeout = this.sessionTimeout > 0 ? (this.sessionTimeout *= 60) : -1;
    }

    private void initServletContextParams(WebDeploymentDescriptor webDesc) {
        ContextParam[] contextParams = webDesc.getContextParams();
        if (contextParams != null) {
            int i = 0;
            while (i < contextParams.length) {
                if (contextParams[i].getParamName() != null && contextParams[i].getParamValue() != null) {
                    this.servletContextFacade.addInitParameter(contextParams[i].getParamName().trim(), contextParams[i].getParamValue().trim());
                }
                ++i;
            }
        }
    }

    private void initServletMappings(WebDeploymentDescriptor webDesc) {
        ServletMapping[] servletMapping = webDesc.getServletMapping();
        if (servletMapping != null) {
            int i = 0;
            while (i < servletMapping.length) {
                if (servletMapping[i].getURLPattern() != null && servletMapping[i].getServletName() != null) {
                    try {
                        this.servletContextFacade.getWebMappings().addMapping(WebApplicationConfig.canonicalizeMapping(servletMapping[i].getURLPattern().trim(), this.servletContextFacade), servletMapping[i].getServletName().trim());
                    }
                    catch (DeploymentException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Incorrect servlet mapping found: " + servletMapping[i].getURLPattern() + ".", (Throwable)((Object)e), this.servletContextFacade.getAliasName());
                    }
                }
                ++i;
            }
        }
    }

    private void initCookieConfigs(CookieConfig[] cookieConfigs) {
        if (cookieConfigs == null) {
            return;
        }
        int i = 0;
        while (i < cookieConfigs.length) {
            if (cookieConfigs[i] != null) {
                if (cookieConfigs[i].getType() == null) {
                    Log.getCategory(1).logWarning(this.currentLocation, "Incorrect cookie-config tag. The subtag type must have a value.", this.servletContextFacade.getAliasName());
                } else if (cookieConfigs[i].getType().equals("SESSION")) {
                    this.initCookie(this.sessionCookieConfig, cookieConfigs[i]);
                } else if (cookieConfigs[i].getType().equals("APPLICATION")) {
                    this.initCookie(this.applicationCookieConfig, cookieConfigs[i]);
                } else {
                    Log.getCategory(1).logWarning(this.currentLocation, "Incorrect cookie-config tag. The subtag type must have value SESSION or APPLICATION. The value is " + cookieConfigs[i].getType() + ".", this.servletContextFacade.getAliasName());
                }
            }
            ++i;
        }
    }

    private void initGetRequestURLMode(String getRequestURLMode) {
        this.getRequestURLClientMode = "CLIENT".equalsIgnoreCase(getRequestURLMode);
    }

    private void initCookie(WebCookieConfig cookie, CookieConfig config) {
        if (config.getPath() != null) {
            if (config.getPath().equals("NONE")) {
                cookie.setPath((byte)1, config.getPath());
            } else if (config.getPath().equals("APPLICATION")) {
                cookie.setPath((byte)4, config.getPath());
            } else if (config.getPath().equals("SERVER")) {
                cookie.setPath((byte)2, config.getPath());
            } else {
                cookie.setPath((byte)8, config.getPath());
            }
        }
        if (config.getDomain() != null) {
            if (config.getDomain().equals("NONE")) {
                cookie.setDomain((byte)1, config.getDomain());
            } else if (config.getDomain().equals("SERVER")) {
                cookie.setDomain((byte)2, config.getDomain());
            } else {
                cookie.setDomain((byte)8, config.getDomain());
            }
        }
        cookie.setMaxAgen(config.getMaxAge());
    }

    private void initPasswordChangePages(WebDeploymentDescriptor webDesc) {
        if (webDesc.getAuthentication() != null && webDesc.getAuthentication().getChangePasswordPage() != null) {
            this.changePasswordLoginPage = webDesc.getAuthentication().getChangePasswordPage();
        }
        if (webDesc.getAuthentication() != null && webDesc.getAuthentication().getChangePasswordErrorPage() != null) {
            this.changePasswordErrorPage = webDesc.getAuthentication().getChangePasswordErrorPage();
        }
    }

    private void initSecurityRoles(WebDeploymentDescriptor webDesc) {
        SecurityRoles[] secRolesTemp = webDesc.getSecRoles();
        Vector<SecurityRoles> secRolesVector = new Vector<SecurityRoles>();
        if (this.secRoles == null) {
            if (secRolesTemp != null) {
                this.secRoles = secRolesTemp;
            }
        } else if (this.secRoles != null && secRolesTemp != null) {
            int i = 0;
            while (i < this.secRoles.length) {
                secRolesVector.add(this.secRoles[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < secRolesTemp.length) {
                if (!secRolesVector.contains(secRolesTemp[i2])) {
                    secRolesVector.add(secRolesTemp[i2]);
                }
                ++i2;
            }
            this.secRoles = new SecurityRoles[secRolesVector.size()];
            int i3 = 0;
            while (i3 < secRolesVector.size()) {
                this.secRoles[i3] = (SecurityRoles)secRolesVector.elementAt(i3);
                ++i3;
            }
        }
    }

    private void initSecurityConstraints(WebDeploymentDescriptor webDesc) {
        SecurityConstraints[] secConstraintsTemp = webDesc.getSecConstraints();
        Vector<SecurityConstraints> secConstraintsVector = new Vector<SecurityConstraints>();
        if (this.secConstraints == null) {
            this.secConstraints = secConstraintsTemp;
        } else if (this.secConstraints != null && secConstraintsTemp != null) {
            int i = 0;
            while (i < secConstraintsTemp.length) {
                secConstraintsVector.add(secConstraintsTemp[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.secConstraints.length) {
                if (!this.contains(secConstraintsVector, this.secConstraints[i2])) {
                    secConstraintsVector.add(this.secConstraints[i2]);
                }
                ++i2;
            }
            this.secConstraints = new SecurityConstraints[secConstraintsVector.size()];
            int i3 = 0;
            while (i3 < secConstraintsVector.size()) {
                this.secConstraints[i3] = (SecurityConstraints)secConstraintsVector.elementAt(i3);
                ++i3;
            }
        }
    }

    private boolean contains(Vector secConstraintsVector, SecurityConstraints securityConstraints) {
        int i = 0;
        while (i < secConstraintsVector.size()) {
            if (securityConstraints.equalsByWebResources((SecurityConstraints)secConstraintsVector.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void bindEJBReferences(WebDeploymentDescriptor webDesc, boolean isGlobal, Context subContext, Vector warnings) {
        EJBeanReference[] ejbRefsTemp = webDesc.getEjbRefs();
        Vector<EJBeanReference> ejbRefsVector = new Vector<EJBeanReference>();
        if (this.ejbRefs == null) {
            if (ejbRefsTemp != null) {
                this.ejbRefs = ejbRefsTemp;
            }
        } else if (this.ejbRefs != null && ejbRefsTemp != null) {
            int i = 0;
            while (i < this.ejbRefs.length) {
                ejbRefsVector.add(this.ejbRefs[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < ejbRefsTemp.length) {
                if (!ejbRefsVector.contains(ejbRefsTemp[i2])) {
                    ejbRefsVector.add(ejbRefsTemp[i2]);
                }
                ++i2;
            }
            this.ejbRefs = new EJBeanReference[ejbRefsVector.size()];
            int i3 = 0;
            while (i3 < ejbRefsVector.size()) {
                this.ejbRefs[i3] = (EJBeanReference)ejbRefsVector.elementAt(i3);
                ++i3;
            }
        }
        if (this.ejbRefs != null && !isGlobal) {
            String realBeanName = null;
            int k = 0;
            while (k < this.ejbRefs.length) {
                if (this.ejbRefs[k] != null) {
                    realBeanName = this.ejbRefs[k].getReferenceJndiLink();
                    if (realBeanName == null) {
                        if (SBasic.ejbManager != null) {
                            try {
                                realBeanName = SBasic.ejbManager.resolveEjbRef(this.servletContextFacade.getApplicationName(), warnings, this.ejbRefs[k].getReferenceJndiLink(), this.ejbRefs[k].getReferenceEjbLink(), this.ejbRefs[k].getHomeInterfaceName(), this.ejbRefs[k].getRemoteInterfaceName(), this.ejbRefs[k].getReferenceName());
                            }
                            catch (OutOfMemoryError e) {
                                throw e;
                            }
                            catch (ThreadDeath e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                Log.getCategory(1).logError(this.currentLocation, "Can't get the name of the EJBean for " + this.ejbRefs[k] + ".", e, this.servletContextFacade.getAliasName());
                            }
                        }
                        if (realBeanName == null) {
                            realBeanName = this.ejbRefs[k].getReferenceEjbLink();
                            this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.EJBREF_WITH_EJBREFNAME_OF_WEB_APPLICATION_CANNOT_BE_BOUND_CORRECT, new Object[]{this.ejbRefs[k].getReferenceName(), this.servletContextFacade.getAliasName()}).toString());
                        }
                    }
                    try {
                        if (this.ejbRefs[k].getReferenceName() == null) {
                            this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.EJBREFNAME_IS_NOT_SPECIFIED_IN_ONE_OF_EJBREF_TAGS_IN_DESCRIPTOR_FOR_WEB_APPLICATION_OBJECT_WILL_NOT_BE_BOUND, new Object[]{this.servletContextFacade.getAliasName()}).toString());
                        } else {
                            this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + this.ejbRefs[k].getReferenceName(), new Reference(realBeanName, "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
                        }
                    }
                    catch (NamingException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Cannot bind reference <" + this.ejbRefs[k].getReferenceName() + "> for bean <" + realBeanName + ">.", e, this.servletContextFacade.getAliasName());
                    }
                }
                ++k;
            }
        }
        EJBeanLocalReference[] ejbLocalRefsTemp = webDesc.getEjbLocalRefs();
        Vector<EJBeanLocalReference> ejbLocalRefsVector = new Vector<EJBeanLocalReference>();
        if (this.ejbLocalRefs == null) {
            if (ejbLocalRefsTemp != null) {
                this.ejbLocalRefs = ejbLocalRefsTemp;
            }
        } else if (this.ejbLocalRefs != null && ejbLocalRefsTemp != null) {
            int i = 0;
            while (i < this.ejbLocalRefs.length) {
                ejbLocalRefsVector.add(this.ejbLocalRefs[i]);
                ++i;
            }
            int i4 = 0;
            while (i4 < ejbLocalRefsTemp.length) {
                if (!ejbLocalRefsVector.contains(ejbLocalRefsTemp[i4])) {
                    ejbLocalRefsVector.add(ejbLocalRefsTemp[i4]);
                }
                ++i4;
            }
            this.ejbLocalRefs = new EJBeanLocalReference[ejbLocalRefsVector.size()];
            int i5 = 0;
            while (i5 < ejbLocalRefsVector.size()) {
                this.ejbLocalRefs[i5] = (EJBeanLocalReference)ejbLocalRefsVector.elementAt(i5);
                ++i5;
            }
        }
        if (this.ejbLocalRefs != null && !isGlobal) {
            String realBeanName = null;
            int k = 0;
            while (k < this.ejbLocalRefs.length) {
                if (this.ejbLocalRefs[k] != null) {
                    realBeanName = this.ejbLocalRefs[k].getReferenceJndiLink();
                    if (realBeanName == null) {
                        if (SBasic.ejbManager != null) {
                            try {
                                realBeanName = SBasic.ejbManager.resolveEjbLocalRef(this.servletContextFacade.getApplicationName(), warnings, this.ejbLocalRefs[k].getReferenceJndiLink(), this.ejbLocalRefs[k].getReferenceEjbLink(), this.ejbLocalRefs[k].getLocalHomeInterfaceName(), this.ejbLocalRefs[k].getLocalInterfaceName(), this.ejbLocalRefs[k].getReferenceName());
                            }
                            catch (OutOfMemoryError e) {
                                throw e;
                            }
                            catch (ThreadDeath e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                Log.getCategory(1).logError(this.currentLocation, "Can't get the name of the EJBean for " + this.ejbLocalRefs[k] + ".", e, this.servletContextFacade.getAliasName());
                            }
                        }
                        if (realBeanName == null) {
                            realBeanName = this.ejbLocalRefs[k].getReferenceEjbLink();
                            this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.EJBREF_WITH_EJBREFNAME_OF_WEB_APPLICATION_CANNOT_BE_BOUND_CORRECT, new Object[]{this.ejbLocalRefs[k].getReferenceName(), this.servletContextFacade.getAliasName()}).toString());
                        }
                    }
                    try {
                        this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + this.ejbLocalRefs[k].getReferenceName(), new Reference(realBeanName, "com.sap.engine.services.jndi.ComponentObjectFactory", ""));
                    }
                    catch (NamingException e) {
                        Log.getCategory(1).logError(this.currentLocation, "Cannot bind local reference <" + this.ejbLocalRefs[k].getReferenceName() + "> for bean <" + realBeanName + ">.", e, this.servletContextFacade.getAliasName());
                    }
                }
                ++k;
            }
        }
    }

    private void bindWebServicesReferences(Context subContext) {
        if (SBasic.wsManager == null) {
            return;
        }
        WSClientReferencedStructure[] referencedStructure = null;
        try {
            referencedStructure = SBasic.wsManager.getWSClientReferencedObjects(this.servletContextFacade.getApplicationName());
        }
        catch (WSBaseException ws) {
            Log.getCategory(1).logError(this.currentLocation, "Cannot bind web services clients for application " + this.servletContextFacade.getApplicationName() + ".", ws, this.servletContextFacade.getAliasName());
            this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_BIND_WEB_SERVICES_CLIENTS_FOR_APPLICATION_ERROR_IS, new Object[]{this.servletContextFacade.getApplicationName(), ws.toString()}).toString());
            return;
        }
        if (referencedStructure == null || referencedStructure.length == 0) {
            return;
        }
        int i = 0;
        while (i < referencedStructure.length) {
            if (referencedStructure[i].getContextRoot().equals(this.servletContextFacade.getAliasName())) {
                try {
                    this.bind(subContext, this.servletContextFacade.getAliasForDirectory() + "/java:comp/env/" + referencedStructure[i].getJndiLinkName(), referencedStructure[i].getReferencedObject());
                }
                catch (NamingException ne) {
                    Log.getCategory(1).logError(this.currentLocation, "Cannot bind web services client " + referencedStructure[i].getJndiLinkName() + " for application " + this.servletContextFacade.getAliasName(), ne, this.servletContextFacade.getAliasName());
                    this.servletContextFacade.addWarning(new LocalizableTextFormatter((ResourceAccessor)WebResourceAccessor.getResourceAccessor(), WebWarningException.CANNOT_BIND_WEB_SERVICES_CLIENTS_FOR_APPLICATION_ERROR_IS, new Object[]{referencedStructure[i].getJndiLinkName(), this.servletContextFacade.getApplicationName(), ne.toString()}).toString());
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

