/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime.context;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.httpserver.interfaces.ErrorData;
import com.sap.engine.services.httpserver.interfaces.HttpParameters;
import com.sap.engine.services.httpserver.interfaces.client.Request;
import com.sap.engine.services.httpserver.lib.CookieParser;
import com.sap.engine.services.httpserver.lib.CookieUtils;
import com.sap.engine.services.httpserver.lib.HttpCookie;
import com.sap.engine.services.httpserver.lib.ParseUtils;
import com.sap.engine.services.httpserver.lib.ProtocolParser;
import com.sap.engine.services.httpserver.lib.WebCookieConfig;
import com.sap.engine.services.httpserver.lib.util.Ascii;
import com.sap.engine.services.httpserver.lib.util.ByteArrayUtils;
import com.sap.engine.services.httpserver.lib.util.MessageBytes;
import com.sap.engine.services.servlets_jsp.descriptor.LoginConfig;
import com.sap.engine.services.servlets_jsp.descriptor.SecurityConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.UserDataConstraints;
import com.sap.engine.services.servlets_jsp.descriptor.WebResourceCollection;
import com.sap.engine.services.servlets_jsp.security.HttpRequestClientInfo;
import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.SBasic;
import com.sap.engine.services.servlets_jsp.server.ServletsAndJspServerFrame;
import com.sap.engine.services.servlets_jsp.server.exceptions.NewApplicationSessionException;
import com.sap.engine.services.servlets_jsp.server.exceptions.SecuritySessionException;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebDeploymentException;
import com.sap.engine.services.servlets_jsp.server.lib.Constants;
import com.sap.engine.services.servlets_jsp.server.runtime.client.ApplicationSession;
import com.sap.engine.services.servlets_jsp.server.runtime.context.ApplicationContext;
import com.sap.engine.services.servlets_jsp.server.runtime.context.WebApplicationConfig;
import com.sap.engine.services.servlets_jsp.server.security.ChangePasswordModule;
import com.sap.engine.services.servlets_jsp.server.security.HttpCallbackHandlerImpl;
import com.sap.engine.services.servlets_jsp.server.security.HttpRequestClientInfoImpl;
import com.sap.engine.services.servlets_jsp.server.security.LazyLoginContext;
import com.sap.engine.services.servlets_jsp.server.security.PrivilegedFillSubject;
import com.sap.engine.services.servlets_jsp.server.security.policy.PolicyDomain;
import com.sap.tc.logging.Location;
import iaik.security.random.SecRandom;
import java.io.IOException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class SessionServletContext {
    private String aliasName = null;
    private String contextNameInternalUse = null;
    private int sessionTimeout = -1;
    private SecurityContext appSecurityContext = null;
    private AuthenticationContext authenticationContext = null;
    private LoginConfig loginConfig = null;
    private String realmName = null;
    private String authType = null;
    private SecurityConstraints[] secConstraints = null;
    private SecurityRoles[] secRoles = null;
    private String aplicationCookieName = null;
    private String formLoginErrorPage = null;
    private String formLoginLoginPage = null;
    private String changePasswordLoginPage = null;
    private String changePasswordErrorPage = null;
    private int failOverEnableInt = 0;
    private PolicyDomain policyDomain = null;
    private ApplicationContext servletContextFacade = null;
    private Hashtable session = new Hashtable();
    private int securityObjectId = -1;
    private SecureRandom random = SecRandom.getDefault();
    public Object sessionIdSynchObject = new Object();
    public ConcurrentHashMapObjectObject sessionIDlocks = new ConcurrentHashMapObjectObject();
    private Location currentLocation = Location.getLocation((Class)(class$com$sap$engine$services$servlets_jsp$server$runtime$context$SessionServletContext == null ? (class$com$sap$engine$services$servlets_jsp$server$runtime$context$SessionServletContext = SessionServletContext.class$("com.sap.engine.services.servlets_jsp.server.runtime.context.SessionServletContext")) : class$com$sap$engine$services$servlets_jsp$server$runtime$context$SessionServletContext));
    private static final int LOGON_OK = 1;
    private static final int LOGON_FAILED_GENERATED = 2;
    private static final int LOGON_FAILED_NOT_GENERATED = 3;
    static /* synthetic */ Class class$com$sap$engine$services$servlets_jsp$server$runtime$context$SessionServletContext;

    public SessionServletContext(String aliasName, String contextNameInternalUse, String aliasForSecurity, ApplicationContext servletContextFacade, SecurityContext securityContext, WebApplicationConfig webApplicationConfig, String aplicationCookieName) throws DeploymentException {
        this.aliasName = aliasName;
        this.contextNameInternalUse = contextNameInternalUse;
        this.servletContextFacade = servletContextFacade;
        this.sessionTimeout = webApplicationConfig.getSessionTimeout();
        this.loginConfig = webApplicationConfig.getLoginConfig();
        this.secConstraints = webApplicationConfig.getSecurityConstraints();
        this.secRoles = webApplicationConfig.getSecurityRoles();
        this.aplicationCookieName = aplicationCookieName;
        if (this.loginConfig != null) {
            this.realmName = this.loginConfig.getRealmName();
            if (this.realmName == null) {
                this.realmName = aliasName;
            }
            if (this.loginConfig.getFormLogin() != null) {
                this.formLoginErrorPage = this.loginConfig.getFormLogin().getErrorPage();
                if (this.formLoginErrorPage != null) {
                    this.formLoginErrorPage = ParseUtils.canonicalize((String)this.formLoginErrorPage).replace('\\', '/');
                    if (!this.formLoginErrorPage.startsWith("/")) {
                        this.formLoginErrorPage = '/' + this.formLoginErrorPage;
                    }
                }
                this.formLoginLoginPage = this.loginConfig.getFormLogin().getLoginPage();
                if (this.formLoginLoginPage != null) {
                    this.formLoginLoginPage = ParseUtils.canonicalize((String)this.formLoginLoginPage).replace('\\', '/');
                    if (!this.formLoginLoginPage.startsWith("/")) {
                        this.formLoginLoginPage = '/' + this.formLoginLoginPage;
                    }
                }
            }
        }
        this.changePasswordLoginPage = webApplicationConfig.getChangePasswordLoginPage();
        this.changePasswordErrorPage = webApplicationConfig.getChangePasswordErrorPage();
        this.failOverEnableInt = webApplicationConfig.getFailOverEnableInt();
        this.appSecurityContext = securityContext.getPolicyConfigurationContext(servletContextFacade.getApplicationName() + "*" + aliasForSecurity);
        if (this.appSecurityContext == null) {
            throw new WebDeploymentException(WebDeploymentException.CANNOT_GET_APPLICATION_SECURITY_CONTEXT_FOR_WEB_APPLICATION, new Object[]{this.getAliasName()}, null);
        }
        this.authenticationContext = this.appSecurityContext.getAuthenticationContext();
        if (this.authenticationContext != null) {
            String temp = this.authenticationContext.getProperty("auth_method");
            this.authType = temp != null ? ((temp = temp.toUpperCase()).equals("BASIC") ? "BASIC" : (temp.equals("FORM") ? "FORM" : (temp.equals("DIGEST") ? "DIGEST" : (temp.equals("CLIENT_CERT") || temp.toUpperCase().equals("CLIENT-CERT") ? "CLIENT_CERT" : "APPLICATION")))) : "APPLICATION";
        }
        this.policyDomain = SBasic.webContainerPolicy.createDomain(webApplicationConfig.getDomainName(), aliasName);
        this.random.nextLong();
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public String getContextNameInternalUse() {
        return this.contextNameInternalUse;
    }

    public Hashtable getSession() {
        return this.session;
    }

    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    public SecurityContext getAppSecurityContext() {
        return this.appSecurityContext;
    }

    public PolicyDomain getPolicyDomain() {
        return this.policyDomain;
    }

    public String getLoginRealmName() {
        return this.realmName;
    }

    public String getAuthType() {
        return this.authType;
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.secRoles;
    }

    public String getFormLoginLoginPage() {
        return this.formLoginLoginPage;
    }

    public String getFormLoginErrorPage() {
        return this.formLoginErrorPage;
    }

    public String getChangePasswordLoginPage() {
        return this.changePasswordLoginPage;
    }

    public String getChangePasswordErrorPage() {
        return this.changePasswordErrorPage;
    }

    public String getApplicationCookieEncoded(String zone, String zoneSeparator, int dispatcherId) {
        if ("sapj2ee_".equals(this.servletContextFacade.getHttpProvider().getHttpProperties().getLoadBalancingCookiePrefix())) {
            if (zone == null || zone.length() == 0) {
                return ";" + this.aplicationCookieName + SBasic.serverId;
            }
            return ";" + this.aplicationCookieName + zoneSeparator + zone + SBasic.serverId;
        }
        String instanceName = SBasic.getInstanceName();
        if (instanceName == null) {
            instanceName = "J2EE" + dispatcherId;
        }
        if (zone == null || zone.length() == 0) {
            return ";" + this.aplicationCookieName + "=(" + instanceName + ")" + SBasic.serverId;
        }
        return ";" + CookieParser.app_cookie_prefix + zone + "=(" + instanceName + ")" + SBasic.serverId;
    }

    public String getApplicationCookieName() {
        return this.aplicationCookieName;
    }

    public byte checkUser(HttpParameters httpParameters, MessageBytes requestURI) throws IOException {
        boolean isLoginOrErrorPage;
        if (requestURI.endsWith("/sap_j_security_check")) {
            return this.doPasswordChange(httpParameters);
        }
        if (this.isChangePassPage(requestURI)) {
            return 0;
        }
        SecurityConstraints secConstrain = this.findMapping(requestURI, httpParameters.getRequest().getRequestLine().getMethod());
        if (this.loginConfig == null && this.getAuthType() == null) {
            if (secConstrain != null) {
                if (secConstrain.getAuthConstraints() != null) {
                    httpParameters.setErrorData(new ErrorData(500, "Application configuration error.", "Cannot perform access control without an authenticated principal. Authentication method not specified in the application descriptor."));
                    return 8;
                }
                if (secConstrain.getUserConstr() != null) {
                    this.checkUserDataConstr(httpParameters, secConstrain.getUserConstr());
                }
            } else if (httpParameters.getRequestPathMappings().getServletName() != null && !this.doCrossApplicationLogin(httpParameters)) {
                this.startLazyLogin(httpParameters);
            }
            return 0;
        }
        if (this.doCrossApplicationLogin(httpParameters)) {
            if (secConstrain == null) {
                return 0;
            }
            if (this.checkUserDataConstr(httpParameters, secConstrain.getUserConstr())) {
                return 0;
            }
            return this.doCheckPermissions(httpParameters, secConstrain);
        }
        if ("FORM".equals(this.getAuthType()) && (isLoginOrErrorPage = this.checkLoginErrorPage(requestURI))) {
            if (secConstrain != null) {
                this.checkUserDataConstr(httpParameters, secConstrain.getUserConstr());
            }
            return 0;
        }
        if (secConstrain != null && this.checkUserDataConstr(httpParameters, secConstrain.getUserConstr())) {
            return 0;
        }
        int logon = this.doLogin(httpParameters, requestURI, secConstrain);
        if (logon == 1) {
            if (httpParameters.getErrorData() != null) {
                return 8;
            }
            if (secConstrain == null) {
                return 0;
            }
            return this.doCheckPermissions(httpParameters, secConstrain);
        }
        if (logon == 2) {
            if (httpParameters.getErrorData() != null) {
                return 8;
            }
            return 2;
        }
        return 0;
    }

    public static boolean isSessionCompatible(HttpParameters httpParameters, String value) {
        if (value.startsWith("(")) {
            int endBracket = value.indexOf(")");
            if (endBracket == -1) {
                return false;
            }
            String boxNameInCookie = value.substring(1, endBracket);
            String instanceName = SBasic.getInstanceName();
            if (instanceName == null) {
                instanceName = "J2EE" + httpParameters.getRequest().getDispatcherId();
            }
            if (!instanceName.equals(boxNameInCookie)) {
                // empty if block
            }
            value = value.substring(endBracket + 1);
        }
        int end = value.indexOf("DB");
        if (value.startsWith("ID") && end != -1) {
            String clusterId = value.substring(2, end);
            try {
                Integer.decode(clusterId);
            }
            catch (Exception e) {
                return false;
            }
        } else {
            return false;
        }
        return value.endsWith("End");
    }

    public void addApplicationCookie(HttpParameters httpParameters) {
        String instanceId;
        String aplicationCookieNameZoneEncoded = this.aplicationCookieName;
        if (httpParameters.getRequestPathMappings().getZoneName() != null && httpParameters.getRequestPathMappings().getZoneName().length() != 0) {
            aplicationCookieNameZoneEncoded = CookieParser.app_cookie_prefix + httpParameters.getRequestPathMappings().getZoneName();
        }
        ArrayObject cooks = httpParameters.getRequest().getCookies(this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking());
        boolean appCookieInRequest = false;
        int i = 0;
        while (cooks != null && i < cooks.size()) {
            HttpCookie httpCookie = (HttpCookie)cooks.elementAt(i);
            if (httpCookie.getName().equals(aplicationCookieNameZoneEncoded) && httpCookie.getValue().startsWith("(") && httpCookie.getValue().indexOf(41) > 0) {
                instanceId = httpCookie.getValue().substring(1, httpCookie.getValue().indexOf(41));
                if ("sapj2ee_".equals(this.servletContextFacade.getHttpProvider().getHttpProperties().getLoadBalancingCookiePrefix())) {
                    if (SBasic.serverId == Ascii.asciiArrToIntNoException((byte[])httpCookie.getValue().getBytes(), (int)0, (int)httpCookie.getValue().length())) {
                        appCookieInRequest = true;
                        break;
                    }
                } else {
                    String currentInstanceId = SBasic.getInstanceName();
                    if (currentInstanceId == null) {
                        currentInstanceId = "J2EE" + httpParameters.getRequest().getDispatcherId();
                    }
                    if (instanceId.equals(currentInstanceId) && SBasic.serverId == Ascii.asciiArrToIntNoException((byte[])httpCookie.getValue().getBytes(), (int)(httpCookie.getValue().indexOf(41) + 1), (int)(httpCookie.getValue().length() - httpCookie.getValue().indexOf(41) - 1))) {
                        appCookieInRequest = true;
                        break;
                    }
                }
            }
            ++i;
        }
        if (!appCookieInRequest && !httpParameters.isSetApplicationCookie()) {
            String cookieValue = null;
            if ("sapj2ee_".equals(this.servletContextFacade.getHttpProvider().getHttpProperties().getLoadBalancingCookiePrefix())) {
                cookieValue = "" + SBasic.serverId;
            } else {
                instanceId = SBasic.getInstanceName();
                if (instanceId == null) {
                    instanceId = "J2EE" + httpParameters.getRequest().getDispatcherId();
                }
                cookieValue = "(" + instanceId + ")" + SBasic.serverId;
            }
            this.addCookie(CookieParser.createCookie((String)aplicationCookieNameZoneEncoded, (String)cookieValue, (String)httpParameters.getRequest().getHost(), (WebCookieConfig)this.servletContextFacade.getWebApplicationConfiguration().getApplicationCookieConfig()), httpParameters);
            httpParameters.setApplicationCookie(true);
        }
    }

    public String encodeURL(String url, MessageBytes alias, HttpParameters httpParameters, ApplicationSession applicationSession) {
        ArrayObject cookies;
        if (!this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking() && (cookies = httpParameters.getRequest().getCookies(this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking())) != null && cookies.size() > 0) {
            return ProtocolParser.makeAbsolute((String)url, (MessageBytes)alias, (Request)httpParameters.getRequest());
        }
        int ind = url.indexOf(63);
        String params = "";
        if (ind > -1) {
            params = url.substring(ind);
            url = url.substring(0, ind);
        }
        if ((ind = url.indexOf(59)) == -1) {
            return ProtocolParser.makeAbsolute((String)(url + ";jsessionid=" + applicationSession.getId() + this.encodeApplicationCookies("", httpParameters.getRequestPathMappings().getZoneName(), httpParameters.getHttpProperties().getZoneSeparator(), httpParameters.getRequest().getDispatcherId()) + params), (MessageBytes)alias, (Request)httpParameters.getRequest());
        }
        String encoded = url.substring(ind);
        url = url.substring(0, ind);
        if (!encoded.startsWith(";jsessionid=")) {
            return ProtocolParser.makeAbsolute((String)(url + ";jsessionid=" + applicationSession.getId() + this.encodeApplicationCookies(encoded, httpParameters.getRequestPathMappings().getZoneName(), httpParameters.getHttpProperties().getZoneSeparator(), httpParameters.getRequest().getDispatcherId()) + params), (MessageBytes)alias, (Request)httpParameters.getRequest());
        }
        ind = (encoded = encoded.substring(";jsessionid=".length())).indexOf(59);
        if (ind == -1) {
            return ProtocolParser.makeAbsolute((String)(url + ";jsessionid=" + applicationSession.getId() + this.encodeApplicationCookies("", httpParameters.getRequestPathMappings().getZoneName(), httpParameters.getHttpProperties().getZoneSeparator(), httpParameters.getRequest().getDispatcherId()) + params), (MessageBytes)alias, (Request)httpParameters.getRequest());
        }
        encoded = encoded.substring(ind);
        return ProtocolParser.makeAbsolute((String)(url + ";jsessionid=" + applicationSession.getId() + this.encodeApplicationCookies(encoded, httpParameters.getRequestPathMappings().getZoneName(), httpParameters.getHttpProperties().getZoneSeparator(), httpParameters.getRequest().getDispatcherId()) + params), (MessageBytes)alias, (Request)httpParameters.getRequest());
    }

    private String encodeApplicationCookies(String encodedOld, String zone, String zoneSeparator, int dispatcherId) {
        String thisAppCookieName = null;
        thisAppCookieName = zone == null || zone.length() == 0 ? ";" + this.aplicationCookieName + "=" : ";" + CookieParser.app_cookie_prefix + zone + "=";
        if ("sapj2ee_".equals(this.servletContextFacade.getHttpProvider().getHttpProperties().getLoadBalancingCookiePrefix())) {
            if (encodedOld.indexOf(thisAppCookieName) > -1) {
                if (encodedOld.indexOf(thisAppCookieName + SBasic.serverId) == -1) {
                    int ind = encodedOld.indexOf(thisAppCookieName);
                    int endInd = encodedOld.indexOf(59, ind + 1);
                    if (endInd == -1) {
                        encodedOld = encodedOld.substring(0, ind);
                        encodedOld = encodedOld + thisAppCookieName + SBasic.serverId;
                    } else {
                        encodedOld = encodedOld.substring(0, ind) + thisAppCookieName + SBasic.serverId + encodedOld.substring(endInd);
                    }
                }
            } else {
                encodedOld = thisAppCookieName + SBasic.serverId + encodedOld;
            }
        } else {
            String instanceName = SBasic.getInstanceName();
            if (instanceName == null) {
                instanceName = "J2EE" + dispatcherId;
            }
            if (encodedOld.indexOf(thisAppCookieName) > -1) {
                if (encodedOld.indexOf(thisAppCookieName + "(" + instanceName + ")" + SBasic.serverId) == -1) {
                    int ind = encodedOld.indexOf(thisAppCookieName);
                    int endInd = encodedOld.indexOf(59, ind + 1);
                    if (endInd == -1) {
                        encodedOld = encodedOld.substring(0, ind);
                        encodedOld = encodedOld + thisAppCookieName + "(" + instanceName + ")" + SBasic.serverId;
                    } else {
                        encodedOld = encodedOld.substring(0, ind) + thisAppCookieName + "(" + instanceName + ")" + SBasic.serverId + encodedOld.substring(endInd);
                    }
                }
            } else {
                encodedOld = thisAppCookieName + "(" + instanceName + ")" + SBasic.serverId + encodedOld;
            }
        }
        return encodedOld;
    }

    public void serializeSession(String sessionId, HttpParameters httpParameters) throws PersistentStorageException {
        if (sessionId != null) {
            ApplicationSession appSession = this.getSession(httpParameters, sessionId);
            if (SBasic.failoverPersistentStorage != null) {
                if (Log.isTracing()) {
                    Log.getLocation(7).traceInfo("ApplicationSession.serializeSession [" + sessionId + "] in application [" + this.getAliasName() + "].", this.getAliasName());
                }
                SBasic.failoverPersistentStorage.serializeSession(this.getAliasName(), sessionId, appSession, appSession.getMaxInactiveInterval() * 1000);
            } else {
                Log.getCategory(4).logError(this.currentLocation, "Cannot serialized session. Failover service is currently no available", this.servletContextFacade.getAliasName());
            }
        }
    }

    public Subject getSubject(String roleName) {
        Subject runAsSubject = new Subject();
        UserContext userCtx = this.appSecurityContext.getUserStoreContext().getActiveUserStore().getUserContext();
        SecurityRole role = this.appSecurityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(roleName);
        if (role == null) {
            return null;
        }
        String userName = role.getRunAsIdentity(true);
        if (userName != null) {
            UserInfo user = this.appSecurityContext.getUserStoreContext().getActiveUserStore().getUserContext().getUserInfo(userName);
            if (user == null) {
                Log.getCategory(2).logError(this.currentLocation, "Cannot get user for " + role.getName() + " security role.", this.servletContextFacade.getAliasName());
                return null;
            }
            AccessController.doPrivileged(new PrivilegedFillSubject(userCtx, user, runAsSubject));
            return runAsSubject;
        }
        Log.getCategory(2).logError(this.currentLocation, "Cannot get user name for " + role.getName() + " security role.", this.servletContextFacade.getAliasName());
        return null;
    }

    private byte doPasswordChange(HttpParameters httpParameters) throws IOException {
        ChangePasswordModule passwordModule = new ChangePasswordModule();
        HttpRequestClientInfo originalRequest = passwordModule.willChangePasswordRequest(new HttpRequestClientInfoImpl(httpParameters, this.servletContextFacade), httpParameters, this.servletContextFacade);
        if (originalRequest == null) {
            return 8;
        }
        try {
            String newUrl;
            this.authenticationContext.getLoginContext(new Subject(), new HttpCallbackHandlerImpl(originalRequest)).login();
            ApplicationSession applicationSession = (ApplicationSession)httpParameters.getApplicationSession();
            try {
                this.policyDomain.registerNewSession(applicationSession);
            }
            catch (SecuritySessionException e) {
                this.policyDomain.joinSession(applicationSession);
            }
            String url = passwordModule.getURL();
            if (url == null) {
                httpParameters.setErrorData(new ErrorData(403, "Incorrect password change request.", "The server hasn't forced you to change your password or the session is lost."));
                return 8;
            }
            String urlOnly = url;
            int qInd = -1;
            qInd = urlOnly.indexOf(63);
            if (qInd > -1) {
                urlOnly = urlOnly.substring(0, qInd);
            }
            if ((qInd = urlOnly.indexOf(59)) > -1) {
                urlOnly = urlOnly.substring(0, qInd);
            }
            if (this.loginConfig != null && "FORM".equals(this.getAuthType()) && urlOnly.endsWith("/j_security_check") && (newUrl = (String)applicationSession.removeSecurityValue("j_security_check")) != null) {
                url = newUrl;
            }
            httpParameters.redirect(url.getBytes());
        }
        catch (LoginException e) {
            httpParameters.redirect(passwordModule.getErrorPage().getBytes());
        }
        return 2;
    }

    private boolean doCrossApplicationLogin(HttpParameters httpParameters) {
        HttpCookie sessionCookie = httpParameters.getRequest().getSessionCookie(this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking());
        ApplicationSession applicationSession = (ApplicationSession)httpParameters.getApplicationSession();
        if (sessionCookie != null && this.policyDomain.canJoinSession(sessionCookie.getValue())) {
            if (applicationSession == null) {
                applicationSession = this.createSession(httpParameters);
            }
            this.policyDomain.joinSession(applicationSession);
            return true;
        }
        return false;
    }

    private int doLogin(HttpParameters httpParameters, MessageBytes requestURI, SecurityConstraints secConstrain) throws IOException {
        block14: {
            boolean isLoginAction = false;
            if (secConstrain == null) {
                int semi = requestURI.indexOf(';');
                byte[] reqUrl = null;
                if (semi == -1) {
                    semi = requestURI.length();
                }
                if (!ByteArrayUtils.endsWith((byte[])(reqUrl = requestURI.getBytes(0, semi)), (byte[])Constants.j_security_check)) {
                    this.startLazyLogin(httpParameters);
                    return 1;
                }
                isLoginAction = true;
            }
            if (isLoginAction || secConstrain != null && secConstrain.getAuthConstraints() != null) {
                HttpRequestClientInfoImpl loginInfo = new HttpRequestClientInfoImpl(httpParameters, this.servletContextFacade);
                try {
                    this.authenticationContext.getLoginContext(new Subject(), new HttpCallbackHandlerImpl(loginInfo)).login();
                    ApplicationSession applicationSession = (ApplicationSession)httpParameters.getApplicationSession();
                    if (applicationSession == null) {
                        applicationSession = this.createSession(httpParameters);
                    }
                    try {
                        this.policyDomain.registerNewSession(applicationSession);
                    }
                    catch (SecuritySessionException e) {
                        this.policyDomain.joinSession(applicationSession);
                    }
                    boolean responseGenerated = loginInfo.generate(false, null);
                    if (responseGenerated) {
                        return 2;
                    }
                    break block14;
                }
                catch (LoginException e) {
                    boolean responseGenerated;
                    String eMsg = e.getMessage();
                    if (eMsg == null && (eMsg = e.toString()) == null) {
                        eMsg = "Login error.";
                    }
                    if (responseGenerated = loginInfo.generate(true, eMsg)) {
                        return 2;
                    }
                    if (loginInfo.isPasswordExpired()) {
                        httpParameters.redirect(loginInfo.getPasswordChangeLoginPage().getBytes());
                        return 2;
                    }
                    if (loginInfo.isRequiredCertificateChain()) {
                        return 3;
                    }
                    break block14;
                }
            }
            this.startLazyLogin(httpParameters);
        }
        return 1;
    }

    private boolean checkLoginErrorPage(MessageBytes requestURI) {
        String logPage = this.getFormLoginLoginPage();
        String errPage = this.getFormLoginErrorPage();
        int qi = logPage.indexOf(63);
        if (qi > -1) {
            logPage = logPage.substring(0, qi);
        }
        if ((qi = errPage.indexOf(63)) > -1) {
            errPage = errPage.substring(0, qi);
        }
        return requestURI.equals(logPage) || requestURI.equals(errPage);
    }

    private void startLazyLogin(HttpParameters httpParameters) {
        if (!SBasic.webContainerProperties.delayAuthentication()) {
            return;
        }
        ThreadContext localTC = SBasic.threadSystem.getThreadContext();
        if (this.securityObjectId == -1) {
            this.securityObjectId = localTC.getContextObjectId("security");
        }
        if (this.securityObjectId != -1) {
            SecurityContextObject securityContext = (SecurityContextObject)((Object)localTC.getContextObject(this.securityObjectId));
            securityContext.delayAuthentication(new LazyLoginContext(this.servletContextFacade, httpParameters));
        }
    }

    private byte doCheckPermissions(HttpParameters httpParameters, SecurityConstraints secConstrain) {
        if (this.checkRoles(httpParameters, secConstrain)) {
            return 0;
        }
        httpParameters.setErrorData(new ErrorData(403, "You are not authorized to view the requested resource.", "No details available"));
        return 8;
    }

    private boolean checkRoles(HttpParameters httpParameters, SecurityConstraints secConstraints) {
        if (secConstraints == null) {
            return true;
        }
        if (secConstraints.getAuthConstraints() == null) {
            return true;
        }
        String[] roles = secConstraints.getAuthConstraints().getRoleNames();
        if (roles == null) {
            return false;
        }
        if (this.secRoles == null) {
            return false;
        }
        int l = 0;
        while (l < roles.length) {
            int n = 0;
            while (n < this.secRoles.length) {
                if ((roles[l].equals(this.secRoles[n].getRoleName()) || roles[l].equals("*")) && this.chekRoleToPid(this.secRoles[n].getRoleName())) {
                    httpParameters.setProtected(true);
                    return true;
                }
                ++n;
            }
            ++l;
        }
        return false;
    }

    private SecurityConstraints findMapping(MessageBytes url, byte[] command) {
        if (this.secConstraints == null) {
            return null;
        }
        String requestURI = url.toString();
        if (requestURI.indexOf("?") > -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf("?"));
        }
        if (requestURI.indexOf(";") > -1) {
            requestURI = requestURI.substring(0, requestURI.indexOf(";"));
        }
        char[] commandChars = new char[command.length];
        int c = 0;
        while (c < command.length) {
            commandChars[c] = (char)(command[c] & 0xFF);
            ++c;
        }
        String cmdStr = new String(commandChars);
        String longestPathMapping = null;
        SecurityConstraints longestPathConstraints = null;
        SecurityConstraints extensionConstraints = null;
        SecurityConstraints defaultServletConstraints = null;
        boolean prefixFound = false;
        int i = 0;
        while (i < this.secConstraints.length) {
            WebResourceCollection[] webCollection = this.secConstraints[i].getWebResourceCollections();
            int j = 0;
            while (j < webCollection.length) {
                block23: {
                    String[] urlPattern;
                    block22: {
                        urlPattern = webCollection[j].getUrlPattern();
                        String[] met = webCollection[j].getHttpMethod();
                        if (met.length <= 0) break block22;
                        boolean httpMethodFind = false;
                        int m = 0;
                        while (m < met.length) {
                            if (cmdStr.equals(met[m])) {
                                httpMethodFind = true;
                                break;
                            }
                            ++m;
                        }
                        if (!httpMethodFind) break block23;
                    }
                    int k = 0;
                    while (k < urlPattern.length) {
                        if (urlPattern[k].endsWith("/*")) {
                            if (requestURI.startsWith(urlPattern[k].substring(0, urlPattern[k].length() - 2))) {
                                prefixFound = true;
                                if (longestPathMapping == null || longestPathMapping.length() < urlPattern[k].length()) {
                                    longestPathMapping = urlPattern[k];
                                    longestPathConstraints = this.secConstraints[i];
                                }
                            }
                        } else if (!prefixFound && urlPattern[k].indexOf("*.") == 0 && requestURI.endsWith(urlPattern[k].substring(1))) {
                            extensionConstraints = this.secConstraints[i];
                        } else {
                            if (urlPattern[k].equals(requestURI) || requestURI.endsWith("/") && requestURI.equals(urlPattern[k] + "/")) {
                                return this.secConstraints[i];
                            }
                            if (!prefixFound && urlPattern[k].length() == 1 && urlPattern[k].equals("/")) {
                                defaultServletConstraints = this.secConstraints[i];
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (extensionConstraints == null && longestPathConstraints == null) {
            return defaultServletConstraints;
        }
        if (longestPathConstraints != null) {
            return longestPathConstraints;
        }
        return extensionConstraints;
    }

    private boolean checkUserDataConstr(HttpParameters httpParameters, UserDataConstraints usrDataConstr) {
        String transport;
        if (usrDataConstr != null && !httpParameters.getRequest().getRequestLine().isSecure() && (transport = usrDataConstr.getTransport()) != null && (transport.equals("CONFIDENTIAL") || transport.equals("INTEGRAL"))) {
            httpParameters.getResponse().setSchemeHttps();
            return true;
        }
        return false;
    }

    public ApplicationSession getSession(HttpParameters httpParameters, String value) {
        String strValue = value;
        if (!this.session.containsKey(value)) {
            int end;
            int hostNameEnd;
            if (value.startsWith("(") && (hostNameEnd = value.indexOf(")")) > -1) {
                value = value.substring(hostNameEnd + 1);
            }
            if (value.startsWith("ID") && (end = value.indexOf("DB")) != -1) {
                try {
                    this.lookupSession(strValue);
                    this.invalidateRemoteSession(httpParameters, strValue);
                    ApplicationSession appSession = (ApplicationSession)this.getSession().get(strValue);
                    if (appSession != null) {
                        httpParameters.setDebugRequest(this.servletContextFacade.initializeDebugInfo(httpParameters, appSession));
                    }
                }
                catch (NumberFormatException ne) {
                    return null;
                }
            }
        }
        return (ApplicationSession)this.getSession().get(strValue);
    }

    public ApplicationSession createSession(HttpParameters httpParameters) {
        ApplicationSession applicationSession;
        block26: {
            applicationSession = null;
            if (this.isForbiddenNewApplicationSession()) {
                throw new NewApplicationSessionException(NewApplicationSessionException.CANNOT_CREATE_A_NEW_APPLICATIO_SESSION_BECAUSE_MAX_NUMBER_OF_SESSIONS_HAS_BEEN_REACHED);
            }
            HttpCookie sCookie = httpParameters.getRequest().getSessionCookie(this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking());
            if (sCookie != null && SessionServletContext.isSessionCompatible(httpParameters, sCookie.getValue())) {
                Object object;
                this.invalidateRemoteSession(httpParameters, sCookie.getValue());
                boolean createSession = false;
                Object object2 = this.sessionIdSynchObject;
                synchronized (object2) {
                    boolean bl = createSession = this.sessionIDlocks.get(sCookie.getValue()) == null;
                    if (createSession) {
                        if (this.getSession().get(sCookie.getValue()) != null) {
                            createSession = false;
                        } else {
                            this.sessionIDlocks.put(sCookie.getValue(), new Object());
                        }
                    } else {
                        boolean sleep = true;
                        while (sleep) {
                            try {
                                this.sessionIdSynchObject.wait(60000L);
                            }
                            catch (Exception e) {
                                Log.getCategory(2).logError(this.currentLocation, "Error in synchronizing the creation of http session " + sCookie.getValue() + ".", e, this.aliasName);
                            }
                            sleep = this.sessionIDlocks.contains(sCookie.getValue());
                        }
                    }
                }
                try {
                    this.addApplicationCookie(httpParameters);
                    if (createSession) {
                        applicationSession = new ApplicationSession(sCookie.getValue(), this.sessionTimeout, httpParameters.getRequest().getClientIP(), this.getAliasName());
                        this.getSession().put(sCookie.getValue(), applicationSession);
                        httpParameters.setDebugRequest(this.servletContextFacade.initializeDebugInfo(httpParameters, applicationSession));
                    } else {
                        applicationSession = (ApplicationSession)this.getSession().get(sCookie.getValue());
                    }
                    httpParameters.setApplicationSession((Object)applicationSession);
                    Object var10_10 = null;
                    if (!createSession) break block26;
                    object = this.sessionIdSynchObject;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (createSession) {
                        Object object3 = this.sessionIdSynchObject;
                        synchronized (object3) {
                            try {
                                this.sessionIDlocks.remove(sCookie.getValue());
                                this.sessionIdSynchObject.notifyAll();
                            }
                            catch (Exception e) {
                                Log.getCategory(2).logError(this.currentLocation, "Error in synchronizing the creation of http session " + sCookie.getValue() + ".", e, this.aliasName);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (object) {
                    try {
                        this.sessionIDlocks.remove(sCookie.getValue());
                        this.sessionIdSynchObject.notifyAll();
                    }
                    catch (Exception e) {
                        Log.getCategory(2).logError(this.currentLocation, "Error in synchronizing the creation of http session " + sCookie.getValue() + ".", e, this.aliasName);
                    }
                }
            }
            HttpCookie cok = null;
            if (!httpParameters.isSetSessionCookie()) {
                cok = CookieParser.createSessionCookie((String)this.generateSessionID(httpParameters), (String)httpParameters.getRequest().getHost(), (WebCookieConfig)this.servletContextFacade.getWebApplicationConfiguration().getSessionCookieConfig());
                this.addCookie(cok, httpParameters);
                httpParameters.setSessionCookie(true);
            }
            this.addApplicationCookie(httpParameters);
            applicationSession = new ApplicationSession(cok.getValue(), this.sessionTimeout, httpParameters.getRequest().getClientIP(), this.getAliasName());
            httpParameters.setApplicationSession((Object)applicationSession);
            this.getSession().put(cok.getValue(), httpParameters.getApplicationSession());
            httpParameters.setDebugRequest(this.servletContextFacade.initializeDebugInfo(httpParameters, applicationSession));
        }
        return applicationSession;
    }

    public String generateSessionID(HttpParameters httpParameters) {
        String sessionId = SBasic.getInstanceName();
        if (sessionId == null) {
            sessionId = "J2EE" + httpParameters.getRequest().getDispatcherId();
        }
        sessionId = "(" + sessionId + ")";
        long rand = this.random.nextLong();
        if (rand < 0L) {
            rand = -rand;
        }
        sessionId = sessionId + "ID" + SBasic.serverId + "DB" + (int)(System.currentTimeMillis() & Integer.MAX_VALUE) + (rand & Integer.MAX_VALUE) + "End";
        return sessionId;
    }

    public void invalidateRemoteSession(HttpParameters httpParameters, String sessionId) {
        ArrayObject appCookies = httpParameters.getRequest().getApplicationCookies(this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking());
        int i = 0;
        while (appCookies != null && i < appCookies.size()) {
            String nextCookie = ((HttpCookie)appCookies.elementAt(i)).getName();
            if (httpParameters.getRequestPathMappings().getZoneName() == null && nextCookie.equals(this.aplicationCookieName)) {
                this.sendInvalidateRemoteSessionRequest(sessionId, ((HttpCookie)appCookies.elementAt(i)).getValue());
            } else if (httpParameters.getRequestPathMappings().getZoneName() != null && nextCookie.equals(CookieParser.app_cookie_prefix + httpParameters.getRequestPathMappings().getZoneName())) {
                this.sendInvalidateRemoteSessionRequest(sessionId, ((HttpCookie)appCookies.elementAt(i)).getValue());
            }
            ++i;
        }
    }

    private void sendInvalidateRemoteSessionRequest(String sessionId, String serverIdStr) {
        int serverId = -1;
        if (serverIdStr.startsWith("(") && serverIdStr.indexOf(41) > 0) {
            try {
                serverId = new Integer(serverIdStr.substring(serverIdStr.indexOf(41) + 1));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        try {
            serverId = new Integer(serverIdStr);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (ServletsAndJspServerFrame.clusterContext.getClusterMonitor().getParticipant(serverId) == null || ServletsAndJspServerFrame.clusterContext.getClusterMonitor().getCurrentParticipant().getClusterId() == serverId) {
            return;
        }
        try {
            byte[] msg = new byte[this.aliasName.length() + 1 + sessionId.length()];
            System.arraycopy(this.aliasName.getBytes(), 0, msg, 0, this.aliasName.length());
            msg[this.aliasName.length()] = 47;
            System.arraycopy(sessionId.getBytes(), 0, msg, this.aliasName.length() + 1, sessionId.length());
            MessageAnswer messageAnswer = ServletsAndJspServerFrame.clusterContext.getMessageContext().sendAndWaitForAnswer(serverId, 1, msg, 0, msg.length, 60000L);
            Log.getLocation(4).traceInfo("Invalidate session message to server node [" + serverId + "] for session [" + sessionId + "] was sent. The answer is: [" + new String(messageAnswer.getMessage(), messageAnswer.getOffset(), messageAnswer.getLength()) + "].", null);
        }
        catch (ClusterException e) {
            Log.getCategory(2).logWarning(this.currentLocation, "Cannot send message for http session invalidation to server node [" + serverId + "] for session [" + sessionId + "].", (Throwable)((Object)e), null);
        }
    }

    private void addCookie(HttpCookie cok, HttpParameters httpParameters) {
        int index;
        if (this.servletContextFacade.getWebApplicationConfiguration().isURLSessionTracking()) {
            return;
        }
        MessageBytes cook = new MessageBytes(CookieUtils.getCookieHeader((HttpCookie)cok));
        if (cook.charAt((index = cook.indexOf(':')) + 1) == ' ' || cook.charAt(index + 1) == '\t') {
            httpParameters.getResponse().getHeaders().addHeader(cook.getBytes(0, index), cook.getBytes(index + 2));
        } else {
            httpParameters.getResponse().getHeaders().addHeader(cook.getBytes(0, index), cook.getBytes(index + 1));
        }
    }

    public boolean lookupSession(String sessionId) {
        try {
            ApplicationSession applicationSession = null;
            if (0 != this.failOverEnableInt) {
                try {
                    if (SBasic.failoverPersistentStorage != null) {
                        applicationSession = (ApplicationSession)SBasic.failoverPersistentStorage.readSession(this.getAliasName(), sessionId, this.servletContextFacade.getClassLoader());
                    } else {
                        Log.getCategory(4).logError(this.currentLocation, "Cannot read sessions. Failover service is currently not available.", this.servletContextFacade.getAliasName());
                    }
                }
                catch (Exception ex) {
                    Log.getCategory(4).logError(this.currentLocation, "Cannot read sessions for fail over.", ex, this.aliasName);
                }
            }
            if (applicationSession == null) {
                return true;
            }
            applicationSession.sessionDeserialized();
            this.getSession().put(sessionId, applicationSession);
            Thread currentThread = Thread.currentThread();
            ClassLoader threadLoader = currentThread.getContextClassLoader();
            ResourceContext resourceContext = null;
            try {
                currentThread.setContextClassLoader(this.servletContextFacade.getClassLoader());
                resourceContext = this.servletContextFacade.enterResourceContext();
                this.servletContextFacade.getWebEvents().sessionsDidActivate(this.getSession());
                Object var7_10 = null;
                currentThread.setContextClassLoader(threadLoader);
                this.servletContextFacade.exitResourceContext(resourceContext);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                currentThread.setContextClassLoader(threadLoader);
                this.servletContextFacade.exitResourceContext(resourceContext);
                throw throwable;
            }
        }
        catch (ThreadDeath tde) {
            throw tde;
        }
        catch (OutOfMemoryError o) {
            throw o;
        }
        catch (Throwable _) {
            Log.getCategory(2).logError(this.currentLocation, "Error in looking up session [" + sessionId + "].", _, this.aliasName);
        }
        return false;
    }

    public boolean chekRoleToPid(String roleName) {
        try {
            return this.appSecurityContext.getAuthorizationContext().getSecurityRoleContext().getSecurityRole(roleName).isCallerInRole();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isForbiddenNewApplicationSession() {
        int max = -1;
        max = this.servletContextFacade.getWebApplicationConfiguration().getMaxSessions();
        return max > -1 && this.getSession().size() >= max;
    }

    private boolean isChangePassPage(MessageBytes requestURI) {
        String errPage;
        String logPage = this.changePasswordLoginPage;
        if (logPage != null) {
            int qi = -1;
            qi = logPage.indexOf(63);
            if (qi > -1) {
                logPage = logPage.substring(0, qi);
            }
            if (!logPage.startsWith("/") && !logPage.startsWith("\\")) {
                logPage = "/" + logPage;
            }
        }
        if ((errPage = this.changePasswordErrorPage) != null) {
            int qi = -1;
            qi = errPage.indexOf(63);
            if (qi > -1) {
                errPage = errPage.substring(0, qi);
            }
            if (!errPage.startsWith("/") && !errPage.startsWith("\\")) {
                errPage = "/" + errPage;
            }
        }
        return requestURI.equals(logPage) || requestURI.equals(errPage);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

