/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.servlets_jsp.server.runtime;

import com.sap.engine.services.servlets_jsp.server.Log;
import com.sap.engine.services.servlets_jsp.server.exceptions.WebServletException;
import com.sap.engine.services.servlets_jsp.server.security.PrivilegedActionImpl;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;

public class FilterChainImpl
implements FilterChain {
    private Vector filters = new Vector();
    private Enumeration enFilters = null;
    private Servlet servlet = null;
    private Subject subject = null;

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.enFilters == null) {
            this.enFilters = this.filters.elements();
        }
        if (this.enFilters.hasMoreElements()) {
            Filter filter = (Filter)this.enFilters.nextElement();
            if (Log.isTracing()) {
                Log.getLocation(4).traceInfo("Invoking filter " + filter, "");
            }
            filter.doFilter(request, response, (FilterChain)this);
            return;
        }
        this.runServlet(request, response);
    }

    public void addFilter(Filter filter) {
        if (filter == null) {
            return;
        }
        this.filters.add(filter);
    }

    protected void setFilters(Vector filterConfig) {
        if (this.enFilters == null && filterConfig != null) {
            this.filters = filterConfig;
        }
    }

    public int countFilters() {
        return this.filters.size();
    }

    public void setServlet(Servlet srv, Subject subject) {
        this.servlet = srv;
        this.subject = subject;
    }

    private void runServlet(ServletRequest sreq, ServletResponse sres) throws ServletException, IOException {
        if (this.subject == null) {
            if (this.servlet instanceof SingleThreadModel) {
                Servlet servlet = this.servlet;
                synchronized (servlet) {
                    this.servlet.service(sreq, sres);
                }
            } else {
                this.servlet.service(sreq, sres);
            }
        } else {
            try {
                if (this.servlet instanceof SingleThreadModel) {
                    Subject.doAs(this.subject, new PrivilegedActionImpl(this.servlet, sreq, sres, true));
                } else {
                    Subject.doAs(this.subject, new PrivilegedActionImpl(this.servlet, sreq, sres, false));
                }
            }
            catch (PrivilegedActionException e) {
                throw new WebServletException("servlet_jsp_0036", new Object[]{this.servlet.getServletConfig().getServletName()}, e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FilterChainImpl[");
        int i = 0;
        while (i < this.filters.size()) {
            sb.append("filter=");
            sb.append(this.filters.elementAt(i));
            sb.append("; ");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

